/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.ber.variants;

import de.mrjulsen.crn.block.blockentity.AdvancedDisplayBlockEntity;
import de.mrjulsen.crn.block.display.properties.TrainDestinationExtendedSettings;
import de.mrjulsen.crn.client.ber.AdvancedDisplayRenderInstance;
import de.mrjulsen.crn.client.ber.variants.AbstractAdvancedDisplayRenderer;
import de.mrjulsen.crn.client.lang.CustomLanguage;
import de.mrjulsen.mcdragonlib.client.ber.BERGraphics;
import de.mrjulsen.mcdragonlib.client.ber.BERLabel;
import de.mrjulsen.mcdragonlib.util.ColorUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class BERTrainDestinationDetailed
implements AbstractAdvancedDisplayRenderer<TrainDestinationExtendedSettings> {
    private final Component TEXT_OUT_OF_SERVICE = CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.not_in_service");
    private final Component TEXT_DO_NOT_BOARD = CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.do_not_board");
    private final BERLabel outOfServiceLabel = new BERLabel(this.TEXT_OUT_OF_SERVICE).setPos(3.0f, 6.0f).setScale(0.5f, 0.25f).setYScale(0.5f).setCentered(true).setScrollingSpeed(2.0f);
    private final BERLabel trainLineLabel = new BERLabel().setScale(0.5f, 0.3f).setYScale(0.5f).setMaxWidth(12.0f, BERLabel.BoundsHitReaction.IGNORE);
    private final BERLabel destinationLabel = new BERLabel().setScale(0.5f, 0.25f).setYScale(0.5f).setCentered(true).setScrollingSpeed(2.0f);
    private final BERLabel viaLabel = new BERLabel((Component)CustomLanguage.translate("gui.createrailwaysnavigator.via").withStyle(ChatFormatting.ITALIC)).setScale(0.35f, 0.35f).setYScale(0.35f);
    private final BERLabel stopoversLabel = new BERLabel().setScale(0.35f, 0.35f).setYScale(0.35f).setScrollingSpeed(2.0f);

    @Override
    public void renderTick(float deltaTime) {
        this.outOfServiceLabel.renderTick();
        this.trainLineLabel.renderTick();
        this.destinationLabel.renderTick();
        this.viaLabel.renderTick();
        this.stopoversLabel.renderTick();
    }

    @Override
    public void render(BERGraphics<AdvancedDisplayBlockEntity> graphics, float partialTick, AdvancedDisplayRenderInstance parent, int light, boolean backSide) {
        if (((AdvancedDisplayBlockEntity)graphics.blockEntity()).getTrainData() == null || ((AdvancedDisplayBlockEntity)graphics.blockEntity()).getTrainData().getState().isIrregular()) {
            this.outOfServiceLabel.render(graphics, light);
            return;
        }
        this.trainLineLabel.render(graphics, light);
        this.destinationLabel.render(graphics, light);
        this.viaLabel.render(graphics, light);
        this.stopoversLabel.render(graphics, light);
    }

    @Override
    public void update(Level level, BlockPos pos, BlockState state, AdvancedDisplayBlockEntity blockEntity, AdvancedDisplayRenderInstance parent, AdvancedDisplayBlockEntity.EUpdateReason reason) {
        if (blockEntity.getTrainData() == null || blockEntity.getTrainData().getState().isIrregular()) {
            this.outOfServiceLabel.setMaxWidth((float)(blockEntity.getXSizeScaled() * 16 - 6), BERLabel.BoundsHitReaction.SCALE_SCROLL).setColor(0xFF000000 | ((TrainDestinationExtendedSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF).setText(blockEntity.getTrainData() != null && blockEntity.getTrainData().getState().shouldNotBoard() ? this.TEXT_DO_NOT_BOARD : this.TEXT_OUT_OF_SERVICE);
            return;
        }
        this.updateContent(blockEntity);
    }

    private void updateContent(AdvancedDisplayBlockEntity blockEntity) {
        TrainDestinationExtendedSettings settings = (TrainDestinationExtendedSettings)this.getDisplaySettings(blockEntity);
        byte width = settings.getTrainNameWidth();
        this.trainLineLabel.setPos(3.0f, 4.0f).setText((Component)(width == 0 ? TextUtils.empty() : TextUtils.text((String)blockEntity.getTrainData().getTrainData().getName()).withStyle(ChatFormatting.BOLD))).setMaxWidth(settings.isFullTrainNameWidth() ? (float)(blockEntity.getXSizeScaled() * 16 - 6) : (float)(settings.isAutoTrainNameWidth() ? 12 : Math.min(((TrainDestinationExtendedSettings)this.getDisplaySettings(blockEntity)).getTrainNameWidth(), blockEntity.getXSizeScaled() * 16 - 6)), settings.isAutoTrainNameWidth() ? BERLabel.BoundsHitReaction.IGNORE : BERLabel.BoundsHitReaction.SCALE_SCROLL).setCentered(settings.isFullTrainNameWidth());
        if (settings.showLineColor() && blockEntity.getTrainData().getTrainData().hasColor()) {
            this.trainLineLabel.setBackground(0xFF000000 | blockEntity.getTrainData().getTrainData().getColor() & 0xFFFFFF, false).setColor(ColorUtils.brightnessDependingFontColor((int)blockEntity.getTrainData().getTrainData().getColor(), (int)-1118482, (int)-15658735));
        } else {
            this.trainLineLabel.setBackground(0, false).setColor(0xFF000000 | settings.getFontColor() & 0xFFFFFF);
        }
        this.destinationLabel.setPos((settings.isAutoTrainNameWidth() ? this.trainLineLabel.getTextWidth() : (float)width) + 5.0f, 4.0f).setMaxWidth((float)(blockEntity.getXSizeScaled() * 16) - this.destinationLabel.getX() - 3.0f, BERLabel.BoundsHitReaction.SCALE_SCROLL).setText((Component)(settings.isFullTrainNameWidth() ? TextUtils.empty() : TextUtils.text((String)(blockEntity.getTrainData().getCurrentStop().isPresent() ? blockEntity.getTrainData().getCurrentStop().get().getDestination() : "")))).setColor(0xFF000000 | ((TrainDestinationExtendedSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF);
        this.viaLabel.setPos(3.0f, 10.0f).setColor(0xFF000000 | ((TrainDestinationExtendedSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF);
        this.stopoversLabel.setPos(this.viaLabel.getTextWidth() + 5.0f, 10.0f).setMaxWidth((float)(blockEntity.getXSizeScaled() * 16) - this.stopoversLabel.getX() - 3.0f, BERLabel.BoundsHitReaction.SCALE_SCROLL).setText((Component)TextUtils.concat((Component)TextUtils.text((String)" \u25cf "), blockEntity.getTrainData().getStopovers().stream().map(x -> TextUtils.text((String)x.getRealTimeStation().tagName())).toList())).setColor(0xFF000000 | ((TrainDestinationExtendedSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF);
    }
}

