/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.screen;

import com.simibubi.create.content.trains.station.NoShadowFontWrapper;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.widget.ScrollInput;
import com.simibubi.create.foundation.gui.widget.SelectionScrollInput;
import de.mrjulsen.crn.Constants;
import de.mrjulsen.crn.block.AbstractAdvancedSidedDisplayBlock;
import de.mrjulsen.crn.block.blockentity.AdvancedDisplayBlockEntity;
import de.mrjulsen.crn.block.display.properties.AdvancedDisplaySettingsData;
import de.mrjulsen.crn.block.display.properties.IDisplaySettings;
import de.mrjulsen.crn.block.properties.EDisplayType;
import de.mrjulsen.crn.block.properties.ESide;
import de.mrjulsen.crn.client.AdvancedDisplaysRegistry;
import de.mrjulsen.crn.client.CRNGui;
import de.mrjulsen.crn.client.gui.CreateDynamicWidgets;
import de.mrjulsen.crn.client.gui.ModGuiIcons;
import de.mrjulsen.crn.client.gui.screen.GlobalSettingsScreen;
import de.mrjulsen.crn.client.gui.widgets.DLCreateIconButton;
import de.mrjulsen.crn.client.gui.widgets.DLCreateSelectionScrollInput;
import de.mrjulsen.crn.client.gui.widgets.IconSlotWidget;
import de.mrjulsen.crn.client.gui.widgets.ModernVerticalScrollBar;
import de.mrjulsen.crn.client.gui.widgets.modular.GuiBuilderContext;
import de.mrjulsen.crn.client.gui.widgets.modular.ModularWidgetBuilder;
import de.mrjulsen.crn.client.gui.widgets.modular.ModularWidgetContainer;
import de.mrjulsen.crn.network.packets.cts.AdvancedDisplayUpdatePacket;
import de.mrjulsen.mcdragonlib.client.gui.DLScreen;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLAbstractImageButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLAbstractScrollBar;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLCheckBox;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLIconButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLTooltip;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLWidgetContainer;
import de.mrjulsen.mcdragonlib.client.render.DynamicGuiRenderer;
import de.mrjulsen.mcdragonlib.client.render.GuiIcons;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiAreaDefinition;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.config.ECachingPriority;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.data.Cache;
import de.mrjulsen.mcdragonlib.data.Clipboard;
import de.mrjulsen.mcdragonlib.data.INBTSerializable;
import de.mrjulsen.mcdragonlib.net.BaseNetworkPacket;
import de.mrjulsen.mcdragonlib.net.DLNetworkManager;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.createmod.catnip.gui.element.ScreenElement;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class AdvancedDisplaySettingsScreen
extends DLScreen {
    private static boolean advancedSettingsExpanded = false;
    private static final MutableComponent title = TextUtils.translate((String)"gui.createrailwaysnavigator.advanced_display_settings.title");
    private static final int GUI_WIDTH = 212;
    private static final int DEFAULT_ICON_BUTTON_WIDTH = 18;
    private static final int DEFAULT_ICON_BUTTON_HEIGHT = 18;
    private static final CreateDynamicWidgets.FooterSize headerSize = CreateDynamicWidgets.FooterSize.DEFAULT;
    private static final CreateDynamicWidgets.FooterSize footerSize = CreateDynamicWidgets.FooterSize.SMALL;
    private static final int BASIC_GUI_HEIGHT = headerSize.size() + footerSize.size() + 76 + 5 + 18;
    private static final int EXTENDED_GUI_HEIGHT = 220;
    private final Font shadowlessFont;
    private final ItemStack renderedItem;
    private final Level level;
    private final BlockPos pos;
    private AdvancedDisplaysRegistry.DisplayTypeResourceKey typeKey;
    private EDisplayType type;
    private IDisplaySettings settings;
    private final boolean canBeDoubleSided;
    private boolean doubleSided;
    private ScrollInput infoTypeInput;
    private ScrollInput displayTypeInput;
    private DLCreateIconButton globalSettingsButton;
    private final MutableComponent tooltipGlobalSettings = TextUtils.translate((String)"gui.createrailwaysnavigator.navigator.global_settings.tooltip");
    private final MutableComponent tooltipDisplayType = TextUtils.translate((String)"gui.createrailwaysnavigator.advanced_display_settings.display_type");
    private final MutableComponent tooltipInfoType = TextUtils.translate((String)"gui.createrailwaysnavigator.advanced_display_settings.info_type");
    private final MutableComponent textDoubleSided = TextUtils.translate((String)"gui.createrailwaysnavigator.advanced_display_settings.double_sided");
    private int guiLeft;
    private int guiTop;
    private GuiAreaDefinition workingArea;
    private DLCreateIconButton backButton;
    private ModularWidgetContainer commonSettingsContainer;
    private ModularWidgetContainer advancedSettingsContainer;
    private final Cache<List<AdvancedDisplaysRegistry.DisplayTypeResourceKey>> displayTypes = new Cache(() -> AdvancedDisplaysRegistry.getAllOfTypeAsKey(this.type), ECachingPriority.ALWAYS);
    private final AdvancedDisplayBlockEntity blockEntity;

    private static final int guiHeight() {
        return advancedSettingsExpanded ? 220 : BASIC_GUI_HEIGHT;
    }

    private final MutableComponent textAdvancedSettings(int maxWidth) {
        Font font = Minecraft.getInstance().font;
        MutableComponent comp = TextUtils.translate((String)"gui.createrailwaysnavigator.advanced_display_settings.advanced_settings").withStyle(ChatFormatting.BOLD);
        MutableComponent ellipsisText = TextUtils.text((String)"...").withStyle(ChatFormatting.BOLD);
        boolean tooWide = font.width((FormattedText)comp) + font.width((FormattedText)ellipsisText) > maxWidth;
        return tooWide ? TextUtils.text((String)(font.substrByWidth((FormattedText)comp, maxWidth - font.width((FormattedText)ellipsisText)).getString() + "...")).withStyle(ChatFormatting.BOLD) : comp;
    }

    public AdvancedDisplaySettingsScreen(AdvancedDisplayBlockEntity blockEntity) {
        super((Component)title);
        this.blockEntity = blockEntity;
        this.settings = blockEntity.getSettings();
        this.shadowlessFont = new NoShadowFontWrapper(Minecraft.getInstance().font);
        this.pos = blockEntity.getBlockPos();
        this.level = blockEntity.getLevel();
        this.type = blockEntity.getDisplayType().category();
        this.typeKey = blockEntity.getDisplayType();
        this.renderedItem = new ItemStack((ItemLike)blockEntity.getBlockState().getBlock());
        this.canBeDoubleSided = blockEntity.getBlockState().getBlock() instanceof AbstractAdvancedSidedDisplayBlock;
        this.doubleSided = !this.canBeDoubleSided || blockEntity.getBlockState().getValue(AbstractAdvancedSidedDisplayBlock.SIDE) == ESide.BOTH;
    }

    public void onClose() {
        DLNetworkManager.sendToServer((BaseNetworkPacket)new AdvancedDisplayUpdatePacket(this.level, this.pos, this.typeKey, this.doubleSided, this.settings));
        super.onClose();
    }

    private void reinit() {
        this.clearWidgets();
        this.setFocused(null);
        this.init();
        this.triggerImmediateNarration(false);
    }

    protected void init() {
        super.init();
        this.displayTypeInput = null;
        this.infoTypeInput = null;
        this.guiLeft = this.width / 2 - 106;
        this.guiTop = this.height / 2 - AdvancedDisplaySettingsScreen.guiHeight() / 2;
        this.workingArea = new GuiAreaDefinition(this.guiLeft + 1, this.guiTop + headerSize.size(), 210, AdvancedDisplaySettingsScreen.guiHeight() - headerSize.size() - footerSize.size());
        ModernVerticalScrollBar scrollBar = new ModernVerticalScrollBar((Screen)this, 0, 0, 0, GuiAreaDefinition.empty());
        this.commonSettingsContainer = (ModularWidgetContainer)this.addRenderableWidget((GuiEventListener)new ModularWidgetContainer(this, this.workingArea.getX() + 2, this.workingArea.getY() + 1, this.workingArea.getWidth() - 4, 76, (w, builder) -> {
            builder.addLine("type", line -> {
                IconSlotWidget icon = line.add(new IconSlotWidget(line.getCurrentX(), line.y() + 2, this.type.getIcon().getAsSprite(16, 16)));
                this.displayTypeInput = line.add(new DLCreateSelectionScrollInput(this, line.getCurrentX() + 6, line.getY() + 2, line.getRemainingWidth() - 6, 18).setRenderArrow(true).forOptions(Arrays.stream(EDisplayType.values()).map(x -> TextUtils.translate((String)x.getValueTranslationKey("createrailwaysnavigator"))).toList()).setState((int)this.type.getId()).titled(this.tooltipDisplayType).calling(i -> {
                    this.type = EDisplayType.getTypeById(i);
                    icon.setIcon(this.type.getIcon().getAsSprite(16, 16));
                    this.displayTypes.clear();
                    this.displayTypeInput.addHint(TextUtils.translate((String)this.type.getValueInfoTranslationKey("createrailwaysnavigator")));
                    DLUtils.doIfNotNull((Object)((SelectionScrollInput)this.infoTypeInput), x -> {
                        x.setState(0);
                        x.forOptions(((List)this.displayTypes.get()).stream().map(a -> TextUtils.translate((String)a.getTranslationKey())).toList());
                        x.onChanged();
                    });
                }).addHint(TextUtils.translate((String)this.type.getValueInfoTranslationKey("createrailwaysnavigator"))));
                this.displayTypeInput.onChanged();
            });
            builder.addLine("variant", line -> {
                line.add(new IconSlotWidget(line.getCurrentX(), line.y() + 2, ModGuiIcons.VERY_DETAILED.getAsSprite(16, 16)));
                this.infoTypeInput = line.add(new DLCreateSelectionScrollInput(this, line.getCurrentX() + 6, line.getY() + 2, line.getRemainingWidth() - 6, 18).setRenderArrow(true).forOptions(((List)this.displayTypes.get()).stream().map(x -> TextUtils.translate((String)x.getTranslationKey())).toList()).setState(((List)this.displayTypes.get()).indexOf(this.typeKey))).titled(this.tooltipInfoType).calling(i -> {
                    this.typeKey = (AdvancedDisplaysRegistry.DisplayTypeResourceKey)((List)this.displayTypes.get()).get((int)i);
                    IDisplaySettings oldSettings = this.settings;
                    this.settings = this.blockEntity.getDisplayType().equals(this.typeKey) ? this.blockEntity.getSettings() : AdvancedDisplaysRegistry.createSettings(this.typeKey);
                    this.settings.onChangeSettings(oldSettings);
                    DLUtils.doIfNotNull((Object)((Object)this.advancedSettingsContainer), ModularWidgetContainer::build);
                });
                this.infoTypeInput.onChanged();
            });
            builder.addLine("double_sided", line -> {
                line.add(new IconSlotWidget(line.getCurrentX(), line.y() + 2, ModGuiIcons.DOUBLE_SIDED.getAsSprite(16, 16)));
                line.add(new DLCheckBox((int)(line.getCurrentX() + 6), (int)(line.getY() + 2), (int)(line.getRemainingWidth() - 6), (String)this.textDoubleSided.getString(), (boolean)this.doubleSided, (Consumer<DLCheckBox>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$init$9(de.mrjulsen.mcdragonlib.client.gui.widgets.DLCheckBox ), (Lde/mrjulsen/mcdragonlib/client/gui/widgets/DLCheckBox;)V)((AdvancedDisplaySettingsScreen)this))).active = this.canBeDoubleSided;
            });
        }, (DLAbstractScrollBar<?>)scrollBar, 18, 18, 4, 4));
        this.addRenderableWidget((GuiEventListener)scrollBar);
        final AdvancedDisplaySettingsScreen screen = this;
        DLIconButton copyBtn = null;
        DLIconButton pasteBtn = null;
        DLIconButton resetBtn = null;
        if (advancedSettingsExpanded) {
            ModernVerticalScrollBar advancedSettingsScrollBar = new ModernVerticalScrollBar((Screen)this, 0, 0, 0, GuiAreaDefinition.empty());
            this.advancedSettingsContainer = (ModularWidgetContainer)this.addRenderableWidget((GuiEventListener)new ModularWidgetContainer(this, this.workingArea.getX() + 2, this.commonSettingsContainer.y() + this.commonSettingsContainer.height() + 3 + 18, this.workingArea.getWidth() - 4, this.workingArea.getHeight() - 2 - this.commonSettingsContainer.height() - 3 - 18, (w, builder) -> this.settings.buildGui(new GuiBuilderContext((ModularWidgetBuilder)builder, (ModularWidgetContainer)((Object)w))), (DLAbstractScrollBar<?>)advancedSettingsScrollBar, 18, 18, 0, 4));
            advancedSettingsScrollBar.setScrollArea(GuiAreaDefinition.of((DLWidgetContainer)this.advancedSettingsContainer));
            this.addRenderableWidget((GuiEventListener)advancedSettingsScrollBar);
            copyBtn = (DLIconButton)this.addRenderableWidget((GuiEventListener)new DLIconButton(this, DLAbstractImageButton.ButtonType.DEFAULT, DynamicGuiRenderer.AreaStyle.FLAT, ModGuiIcons.COPY.getAsSprite(16, 16), this.workingArea.getX() + this.workingArea.getWidth() - 2 - 18, this.commonSettingsContainer.y() + this.commonSettingsContainer.height() + 3, (Component)TextUtils.empty(), b -> Clipboard.put(AdvancedDisplaySettingsData.class, (INBTSerializable)new AdvancedDisplaySettingsData(this.typeKey, this.settings, this.doubleSided))){

                public void renderFrontLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
                    super.renderFrontLayer(graphics, mouseX, mouseY, partialTicks);
                    if (!this.isMouseSelected()) {
                        return;
                    }
                    GuiUtils.renderTooltip((Screen)screen, (AbstractWidget)this, List.of(Constants.TEXT_COPY), (int)(screen.width() / 3), (Graphics)graphics, (int)mouseX, (int)mouseY);
                }
            });
            copyBtn.setBackColor(0);
            pasteBtn = (DLIconButton)this.addRenderableWidget((GuiEventListener)new DLIconButton(this, DLAbstractImageButton.ButtonType.DEFAULT, DynamicGuiRenderer.AreaStyle.FLAT, ModGuiIcons.PASTE.getAsSprite(16, 16), copyBtn.x() - 18, copyBtn.y(), (Component)TextUtils.empty(), b -> Clipboard.get(AdvancedDisplaySettingsData.class).ifPresent(x -> {
                this.typeKey = x.getKey();
                this.type = x.getKey().category();
                this.settings = x.getSettings();
                this.doubleSided = x.isDoubleSided();
                this.reinit();
            })){

                public void renderFrontLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
                    super.renderFrontLayer(graphics, mouseX, mouseY, partialTicks);
                    if (!this.isMouseSelected()) {
                        return;
                    }
                    GuiUtils.renderTooltip((Screen)screen, (AbstractWidget)this, List.of(Constants.TEXT_PASTE), (int)(screen.width() / 3), (Graphics)graphics, (int)mouseX, (int)mouseY);
                }
            });
            pasteBtn.setBackColor(0);
            resetBtn = (DLIconButton)this.addRenderableWidget((GuiEventListener)new DLIconButton(this, DLAbstractImageButton.ButtonType.DEFAULT, DynamicGuiRenderer.AreaStyle.FLAT, ModGuiIcons.REFRESH.getAsSprite(16, 16), pasteBtn.x() - 18, pasteBtn.y(), (Component)TextUtils.empty(), b -> {
                this.settings = AdvancedDisplaysRegistry.createSettings(this.typeKey);
                DLUtils.doIfNotNull((Object)((Object)this.advancedSettingsContainer), ModularWidgetContainer::build);
            }){

                public void renderFrontLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
                    super.renderFrontLayer(graphics, mouseX, mouseY, partialTicks);
                    if (!this.isMouseSelected()) {
                        return;
                    }
                    GuiUtils.renderTooltip((Screen)screen, (AbstractWidget)this, List.of(Constants.TEXT_RESET), (int)(screen.width() / 3), (Graphics)graphics, (int)mouseX, (int)mouseY);
                }
            });
            resetBtn.setBackColor(0);
        }
        DLIconButton expandCollapseBtn = (DLIconButton)this.addRenderableWidget((GuiEventListener)new DLIconButton(DLAbstractImageButton.ButtonType.DEFAULT, DynamicGuiRenderer.AreaStyle.FLAT, (advancedSettingsExpanded ? GuiIcons.ARROW_DOWN : GuiIcons.ARROW_RIGHT).getAsSprite(16, 16), this.workingArea.getX() + 2, this.commonSettingsContainer.y() + this.commonSettingsContainer.height() + 3, this.workingArea.getWidth() - 4 - (advancedSettingsExpanded ? copyBtn.width() + pasteBtn.width() + resetBtn.width() : 0), 18, (Component)TextUtils.empty(), b -> {
            advancedSettingsExpanded = !advancedSettingsExpanded;
            this.reinit();
        }));
        expandCollapseBtn.setMessage((Component)this.textAdvancedSettings(expandCollapseBtn.width() - 16 - 6));
        expandCollapseBtn.setTextAlignment(EAlignment.LEFT);
        expandCollapseBtn.setBackColor(0);
        expandCollapseBtn.setFontColor(-1);
        this.backButton = (DLCreateIconButton)this.addRenderableWidget((GuiEventListener)new DLCreateIconButton(this.guiLeft + 212 - 7 - 18, this.guiTop + AdvancedDisplaySettingsScreen.guiHeight() - 6 - 18, 18, 18, (ScreenElement)AllIcons.I_CONFIRM));
        this.backButton.withCallback(() -> this.onClose());
        DLCreateIconButton helpButton = (DLCreateIconButton)this.addRenderableWidget((GuiEventListener)new DLCreateIconButton(this, this.guiLeft + 212 - 17 - 36, this.guiTop + AdvancedDisplaySettingsScreen.guiHeight() - 6 - 18, 18, 18, (ScreenElement)ModGuiIcons.HELP.getAsCreateIcon()){

            public void onClick(double mouseX, double mouseY) {
                super.onClick(mouseX, mouseY);
                Util.getPlatform().openUri("https://github.com/MisterJulsen/Create-Train-Navigator/wiki/Advanced-Displays");
            }
        });
        this.addTooltip(DLTooltip.of((FormattedText)Constants.TEXT_HELP).assignedTo((AbstractWidget)helpButton));
        AdvancedDisplaySettingsScreen instance = this;
        this.globalSettingsButton = (DLCreateIconButton)this.addRenderableWidget((GuiEventListener)new DLCreateIconButton(this, this.guiLeft + 7, this.guiTop + AdvancedDisplaySettingsScreen.guiHeight() - 6 - 18, 18, 18, (ScreenElement)ModGuiIcons.SETTINGS.getAsCreateIcon(), (Screen)instance){
            final /* synthetic */ Screen val$instance;
            {
                this.val$instance = screen;
                super(arg0, arg1, arg2, arg3, arg4);
            }

            public void onClick(double mouseX, double mouseY) {
                super.onClick(mouseX, mouseY);
                DLScreen.setScreen((DLScreen)new GlobalSettingsScreen(this.val$instance));
            }
        });
        this.addTooltip(DLTooltip.of((FormattedText)this.tooltipGlobalSettings).assignedTo((AbstractWidget)this.globalSettingsButton));
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void renderMainLayer(Graphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.renderBlurredBackground(pPartialTick);
        this.renderMenuBackground(graphics.graphics());
        CreateDynamicWidgets.renderWindow(graphics, this.guiLeft, this.guiTop, 212, AdvancedDisplaySettingsScreen.guiHeight(), CreateDynamicWidgets.ContainerColor.PURPLE, CreateDynamicWidgets.BarColor.GOLD, CreateDynamicWidgets.BarColor.GRAY, headerSize.size(), footerSize.size(), false);
        CreateDynamicWidgets.renderVerticalSeparator(graphics, this.guiLeft + 212 - 31, this.guiTop + AdvancedDisplaySettingsScreen.guiHeight() - footerSize.size() + 2, footerSize.size() - 4, CreateDynamicWidgets.BarColor.GRAY);
        GuiUtils.drawTexture((ResourceLocation)CRNGui.GUI, (Graphics)graphics, (int)(this.guiLeft + 212 - 3), (int)(this.guiTop + AdvancedDisplaySettingsScreen.guiHeight() - footerSize.size() / 2 - 9), (int)11, (int)18, (int)0, (int)12, (int)11, (int)18, (int)64, (int)64);
        int commonHeight = this.commonSettingsContainer.getHeight() + 4;
        CreateDynamicWidgets.renderContainer(graphics, this.workingArea.getX(), this.workingArea.getY() - 1, this.workingArea.getWidth(), commonHeight, CreateDynamicWidgets.ContainerColor.PURPLE);
        CreateDynamicWidgets.renderContainer(graphics, this.workingArea.getX(), this.workingArea.getY() - 2 + commonHeight, this.workingArea.getWidth(), this.workingArea.getHeight() - commonHeight + 3, CreateDynamicWidgets.ContainerColor.GRAY);
        GuiUtils.drawString((Graphics)graphics, (Font)this.shadowlessFont, (int)(this.guiLeft + 6), (int)(this.guiTop + 4), (FormattedText)title, (int)-12566464, (EAlignment)EAlignment.LEFT, (boolean)false);
        super.renderMainLayer(graphics, pMouseX, pMouseY, pPartialTick);
        ((GuiGameElement.GuiRenderBuilder)GuiGameElement.of((ItemStack)this.renderedItem).at((float)(this.guiLeft + 212 + 11), (float)(this.guiTop + AdvancedDisplaySettingsScreen.guiHeight() - 48), -200.0f)).scale(4.0).render(graphics.graphics());
    }

    private /* synthetic */ void lambda$init$9(DLCheckBox box) {
        this.doubleSided = box.isChecked();
    }
}

