/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.screen;

import de.mrjulsen.crn.Constants;
import de.mrjulsen.crn.client.gui.CreateDynamicWidgets;
import de.mrjulsen.crn.client.gui.ModGuiIcons;
import de.mrjulsen.crn.client.gui.screen.AbstractNavigatorScreen;
import de.mrjulsen.crn.client.gui.widgets.AbstractFlyoutWidget;
import de.mrjulsen.crn.client.gui.widgets.DLCreateIconButton;
import de.mrjulsen.crn.client.gui.widgets.ModStationSuggestions;
import de.mrjulsen.crn.client.gui.widgets.ModernVerticalScrollBar;
import de.mrjulsen.crn.client.gui.widgets.TransferOwnershipWidget;
import de.mrjulsen.crn.client.gui.widgets.flyouts.FlyoutConfirmDialog;
import de.mrjulsen.crn.client.gui.widgets.flyouts.FlyoutPlayerList;
import de.mrjulsen.crn.client.gui.widgets.options.DLOptionsList;
import de.mrjulsen.crn.client.gui.widgets.options.DataListContainer;
import de.mrjulsen.crn.client.gui.widgets.options.NewEntryWidget;
import de.mrjulsen.crn.client.gui.widgets.options.OptionEntry;
import de.mrjulsen.crn.client.gui.widgets.options.SimpleDataListNewEntry;
import de.mrjulsen.crn.data.StationTag;
import de.mrjulsen.crn.data.storage.GlobalSettingsClient;
import de.mrjulsen.crn.registry.ModAccessorTypes;
import de.mrjulsen.crn.util.Lock;
import de.mrjulsen.crn.util.Owner;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLAbstractScrollBar;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLContextMenu;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLContextMenuItem;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLEditBox;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLIconButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLTooltip;
import de.mrjulsen.mcdragonlib.client.gui.widgets.IDragonLibWidget;
import de.mrjulsen.mcdragonlib.client.render.Sprite;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiAreaDefinition;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.data.Pair;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.MathUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.accessor.DataAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.createmod.catnip.gui.element.ScreenElement;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;

public class StationTagSettingsScreen
extends AbstractNavigatorScreen {
    private static final int DEFAULT_ICON_BUTTON_WIDTH = 18;
    private static final int DEFAULT_ICON_BUTTON_HEIGHT = 18;
    private DLOptionsList viewer;
    private DLEditBox searchBox;
    private final MutableComponent tooltipDeleteTag = TextUtils.translate((String)"gui.createrailwaysnavigator.station_tags.delete_tag");
    private final MutableComponent textStationName = TextUtils.translate((String)"gui.createrailwaysnavigator.station_tags.hint.station_name");
    private final MutableComponent textPlatformName = TextUtils.translate((String)"gui.createrailwaysnavigator.station_tags.hint.platform");
    private ModStationSuggestions destinationSuggestions;
    private StationTag selectedTag;
    private String searchText = "";
    private final List<String> stationNames = new ArrayList<String>();

    public StationTagSettingsScreen(Screen lastScreen) {
        super(lastScreen, (Component)TextUtils.translate((String)"gui.createrailwaysnavigator.station_tags.title").append((Component)(GlobalSettingsClient.modificationsAllowed() ? TextUtils.empty() : TextUtils.text((String)" ").append(Constants.TEXT_READ_ONLY).withStyle(ChatFormatting.DARK_RED))), CreateDynamicWidgets.BarColor.GRAY);
    }

    public void tick() {
        super.tick();
        DLUtils.doIfNotNull((Object)this.destinationSuggestions, x -> {
            x.tick();
            if (!this.destinationSuggestions.getEditBox().canConsumeInput()) {
                this.clearSuggestions();
            }
        });
    }

    public void onClose() {
        Minecraft.getInstance().setScreen(this.lastScreen);
    }

    public void reload() {
        this.clearWidgets();
        this.init();
    }

    @Override
    protected void init() {
        super.init();
        DataAccessor.getFromServer(null, ModAccessorTypes.GET_ALL_STATION_NAMES, names -> {
            this.stationNames.clear();
            this.stationNames.addAll((Collection<String>)names);
        });
        DLCreateIconButton helpButton = (DLCreateIconButton)this.addRenderableWidget((GuiEventListener)new DLCreateIconButton(this, this.guiLeft + 240 - 18 - 8, this.guiTop + 223, 18, 18, (ScreenElement)ModGuiIcons.HELP.getAsCreateIcon()){

            public void onClick(double mouseX, double mouseY) {
                super.onClick(mouseX, mouseY);
                Util.getPlatform().openUri("https://github.com/MisterJulsen/Create-Train-Navigator/wiki/Station-Tags");
            }
        });
        this.addTooltip(DLTooltip.of((FormattedText)Constants.TEXT_HELP).assignedTo((AbstractWidget)helpButton));
        int dy = CreateDynamicWidgets.FooterSize.DEFAULT.size() + 1;
        this.searchBox = (DLEditBox)this.addRenderableWidget((GuiEventListener)new DLEditBox(this.font, this.guiLeft + 4, this.guiTop + dy + 1, 232, 16, (Component)TextUtils.empty()){

            public boolean keyPressed(int code, int p_keyPressed_2_, int p_keyPressed_3_) {
                if (code == 257) {
                    StationTagSettingsScreen.this.searchText = this.getValue();
                    StationTagSettingsScreen.this.reload();
                    return true;
                }
                return super.keyPressed(code, p_keyPressed_2_, p_keyPressed_3_);
            }
        });
        this.searchBox.setValue(this.searchText);
        this.searchBox.withHint(DragonLib.TEXT_SEARCH);
        ModernVerticalScrollBar scrollBar = new ModernVerticalScrollBar((Screen)this, this.guiLeft + 240 - 8, this.guiTop + (dy += 18), 247 - dy - CreateDynamicWidgets.FooterSize.SMALL.size() - 1, null);
        this.viewer = new DLOptionsList((Screen)this, this.guiLeft + 3, this.guiTop + dy, 234, 247 - dy - CreateDynamicWidgets.FooterSize.SMALL.size() - 1, (DLAbstractScrollBar<?>)scrollBar);
        this.addRenderableWidget((GuiEventListener)this.viewer);
        this.addRenderableWidget((GuiEventListener)scrollBar);
        DataAccessor.getFromServer(null, ModAccessorTypes.GET_ALL_STATION_TAGS, tgs -> {
            List tags = tgs.stream().sorted((a, b) -> a.getTagName().get().compareToIgnoreCase(b.getTagName().get())).toList();
            for (StationTag tag : tags) {
                if (!tag.getTagName().get().toLowerCase(Locale.ROOT).contains(this.searchText.toLowerCase(Locale.ROOT))) continue;
                StationTag stationTag = tag;
                OptionEntry<DataListContainer> opt = this.viewer.addOption(option -> {
                    GuiAreaDefinition workspace = option.getContentSpace();
                    DataListContainer<StationTag, Map.Entry> cont = new DataListContainer<StationTag, Map.Entry>((OptionEntry<?>)option, workspace.getX(), workspace.getY(), workspace.getWidth(), stationTag, tg -> tg.getAllStations().entrySet().stream().sorted((a, b) -> ((String)a.getKey()).compareToIgnoreCase((String)b.getKey())).iterator(), (data, entryWidget) -> {
                        if (stationTag.getOwner().isAllowed() && GlobalSettingsClient.modificationsAllowed()) {
                            entryWidget.addDeleteButton((btn, tg, entry, refreshAction) -> {
                                FlyoutConfirmDialog<GuiEventListener> dlg = new FlyoutConfirmDialog<GuiEventListener>(this, AbstractFlyoutWidget.FlyoutPointer.RIGHT, () -> GlobalSettingsClient.removeStationTagEntry(tag.getId(), (String)entry.getKey(), newTag -> newTag.ifPresent(a -> refreshAction.accept(newTag))), x$0 -> this.addRenderableWidget((GuiEventListener)x$0), arg_0 -> ((StationTagSettingsScreen)this).removeWidget(arg_0));
                                dlg.setYOffset((int)(-scrollBar.getScrollValue()));
                                dlg.open((IDragonLibWidget)btn);
                            });
                        }
                        entryWidget.addDataSection(40, entry -> ((StationTag.StationInfo)entry.getValue()).platform(), EAlignment.RIGHT, stationTag.getOwner().isAllowed() && GlobalSettingsClient.modificationsAllowed() ? (tg, entry, newValue, refreshAction) -> {
                            if (!newValue.isBlank() && !((StationTag.StationInfo)entry.getValue()).platform().equals(newValue)) {
                                GlobalSettingsClient.updateStationTagEntry(tg.getId(), (String)entry.getKey(), new StationTag.StationInfo(newValue), newTag -> newTag.ifPresent(a -> refreshAction.accept(newTag)));
                            }
                        } : null);
                        return (String)data.getKey();
                    }, (BiConsumer<StationTag, SimpleDataListNewEntry<StationTag, Map.Entry>>)(stationTag.getOwner().isAllowed() && GlobalSettingsClient.modificationsAllowed() ? (data, entryWidget) -> {
                        entryWidget.addAddButton(ModGuiIcons.ADD.getAsSprite(16, 16), List.of(Constants.TEXT_ADD), (btn, tg, inputValues, refreshAction) -> {
                            String name = (String)((Supplier)inputValues.get((Object)"name")).get();
                            String platform = (String)((Supplier)inputValues.get((Object)"platform")).get();
                            if (name == null || platform == null || name.isBlank() || platform.isBlank()) {
                                return false;
                            }
                            GlobalSettingsClient.addStationTagEntry(tg.getId(), name, new StationTag.StationInfo(platform), newTag -> newTag.ifPresent(a -> refreshAction.accept(newTag)));
                            return true;
                        });
                        entryWidget.editNameEditBox(box -> {
                            box.setResponder(b -> this.updateEditorSubwidgets((EditBox)box, (StationTag)data));
                            box.setMaxLength(32);
                        });
                        entryWidget.setNameEditBoxTooltip(box -> this.textStationName);
                        entryWidget.addDataSection(40, "platform", (Component)this.textPlatformName, box -> box.setMaxLength(8));
                    } : null), self -> option.notifyContentSizeChanged());
                    cont.setPadding(3, 0, 3, 18);
                    cont.setFilter((entry, searchText) -> ((String)entry.getKey()).toLowerCase(Locale.ROOT).contains(((String)searchText.get()).toLowerCase(Locale.ROOT)));
                    cont.setBordered(false);
                    return cont;
                }, (Component)TextUtils.text((String)tag.getTagName().get()), (Component)TextUtils.empty(), (a, b) -> OptionEntry.expandOrCollapse(a), stationTag.getOwner().isAllowed() && GlobalSettingsClient.modificationsAllowed() ? str -> {
                    if (!str.isBlank() && !str.equals(stationTag.getTagName().get())) {
                        GlobalSettingsClient.updateStationTagNameData(stationTag.getId(), str, () -> {});
                        return true;
                    }
                    return false;
                } : null);
                if (GlobalSettingsClient.modificationsAllowed()) {
                    if (stationTag.getOwner().isAllowed()) {
                        opt.addAdditionalButton(ModGuiIcons.DELETE.getAsSprite(16, 16), List.of(this.tooltipDeleteTag), (entry, btn) -> {
                            FlyoutConfirmDialog<GuiEventListener> dlg = new FlyoutConfirmDialog<GuiEventListener>(this, AbstractFlyoutWidget.FlyoutPointer.UP, () -> GlobalSettingsClient.deleteStationTag(((StationTag)((DataListContainer)((Object)((Object)((Object)((Object)entry.getContentContainer()))))).getData()).getId(), () -> this.reload()), x$0 -> this.addRenderableWidget((GuiEventListener)x$0), arg_0 -> ((StationTagSettingsScreen)this).removeWidget(arg_0));
                            dlg.setYOffset((int)(-scrollBar.getScrollValue()));
                            dlg.open((IDragonLibWidget)btn);
                        });
                    }
                    DLIconButton btnPermissions = opt.addAdditionalButton(stationTag.getOwner().get().getIcon(), stationTag.getOwner().asText(new Owner((Player)Minecraft.getInstance().player)), (entry, btn) -> {
                        if (!stationTag.getOwner().isAllowed()) {
                            return;
                        }
                        GlobalSettingsClient.updateStationTagPermissions(new Lock.PermissionsUpdateData(((StationTag)((DataListContainer)((Object)((Object)((Object)entry.getContentContainer())))).getData()).getId(), null, (Lock.LockState)stationTag.getOwner().get().next(), null), a -> a.ifPresent(x -> {
                            stationTag.getOwner().set(x.getOwner().get());
                            stationTag.getOwner().updateTrusted(x.getOwner().getTrusted());
                            btn.setSprite(x.getOwner().get().getIcon());
                            entry.updateTooltipOf((DLIconButton)btn, x.getOwner().asText(new Owner((Player)Minecraft.getInstance().player)));
                        }));
                    });
                    if (stationTag.getOwner().isAdmin()) {
                        btnPermissions.setMenu(new DLContextMenu(() -> GuiAreaDefinition.of((AbstractWidget)btnPermissions), () -> new DLContextMenuItem.Builder().add(new DLContextMenuItem.ContextMenuItemData((Component)TextUtils.translate((String)"gui.createrailwaysnavigator.lock.trusted_players"), Sprite.empty(), true, b -> {
                            FlyoutPlayerList<GuiEventListener> flyout = new FlyoutPlayerList<GuiEventListener>(this, this::updateEditorSubwidgetsOnlinePlayers, stationTag.getOwner().getTrusted(), x$0 -> this.addRenderableWidget((GuiEventListener)x$0), w -> {
                                GlobalSettingsClient.updateStationTagPermissions(new Lock.PermissionsUpdateData(stationTag.getId(), null, null, ((FlyoutPlayerList)((Object)((Object)((Object)((Object)w))))).getPlayerList().getPlayers()), $ -> GlobalSettingsClient.getStationTags(res -> this.reload()));
                                this.removeWidget((GuiEventListener)w);
                            });
                            flyout.setYOffset((int)(-scrollBar.getScrollValue()));
                            flyout.open((IDragonLibWidget)btnPermissions);
                        }, null)).add(new DLContextMenuItem.ContextMenuItemData((Component)TextUtils.translate((String)"gui.createrailwaysnavigator.lock.transfer_ownership"), Sprite.empty(), true, b -> this.addRenderableWidget((GuiEventListener)new TransferOwnershipWidget<GuiEventListener>(this, stationTag.getOwner().getOwner().orElse(null), newOwner -> GlobalSettingsClient.updateStationTagPermissions(new Lock.PermissionsUpdateData(stationTag.getId(), (Owner)newOwner, null, null), $ -> GlobalSettingsClient.getStationTags(res -> this.reload())), x$0 -> this.addRenderableWidget((GuiEventListener)x$0), arg_0 -> ((StationTagSettingsScreen)this).removeWidget(arg_0))), null))));
                    }
                }
                opt.setTooltip(List.of(TextUtils.text((String)stationTag.getTagName().get()), TextUtils.translate((String)"gui.createrailwaysnavigator.station_tags.summary", (Object[])new Object[]{TextUtils.text((String)String.valueOf(stationTag.getAllStationNames().size())).withStyle(ChatFormatting.GREEN)}).withStyle(ChatFormatting.GRAY), TextUtils.translate((String)"gui.createrailwaysnavigator.common.last_edited", (Object[])new Object[]{stationTag.getLastEditor().map(x -> x.name().isBlank() ? TextUtils.translate((String)"gui.createrailwaysnavigator.common.unknown").withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC) : TextUtils.text((String)x.name()).withStyle(ChatFormatting.GREEN)).orElse(TextUtils.text((String)"Server").withStyle(ChatFormatting.GREEN)), TextUtils.text((String)stationTag.getLastEditedTimeFormatted()).withStyle(ChatFormatting.GREEN)}).withStyle(ChatFormatting.GRAY)));
            }
            if (GlobalSettingsClient.modificationsAllowed()) {
                this.viewer.addRenderableWidget(new NewEntryWidget((Screen)this, () -> Pair.of((Object)(-this.viewer.getXScrollOffset()), (Object)(-this.viewer.getYScrollOffset())), val -> {
                    GlobalSettingsClient.createStationTag(val, new Owner((Player)Minecraft.getInstance().player), tag -> this.reload());
                    return true;
                }, 0, 0, this.viewer.getContentWidth()));
            }
        });
    }

    public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderNavigatorBackground(graphics, mouseX, mouseY, partialTicks);
        int y = CreateDynamicWidgets.FooterSize.DEFAULT.size() - 1;
        int h = 247 - y - CreateDynamicWidgets.FooterSize.SMALL.size();
        CreateDynamicWidgets.renderContainer(graphics, this.guiLeft + 1, this.guiTop + y, 238, h + 1, CreateDynamicWidgets.ContainerColor.PURPLE);
        super.renderMainLayer(graphics, mouseX, mouseY, partialTicks);
    }

    public void renderFrontLayer(Graphics graphics, int mouseX, int mouseY, float partialTick) {
        super.renderFrontLayer(graphics, mouseX, mouseY, partialTick);
        DLUtils.doIfNotNull((Object)this.destinationSuggestions, x -> {
            graphics.poseStack().pushPose();
            graphics.poseStack().translate(-this.viewer.getXScrollOffset(), -this.viewer.getYScrollOffset(), 0.0);
            x.render(graphics.graphics(), (int)((double)mouseX + this.viewer.getXScrollOffset()), (int)((double)mouseY + this.viewer.getYScrollOffset()));
            graphics.poseStack().popPose();
        });
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.destinationSuggestions != null && this.destinationSuggestions.mouseScrolled(mouseX + this.viewer.getXScrollOffset(), mouseY + this.viewer.getYScrollOffset(), MathUtils.clamp((double)scrollY, (double)-1.0, (double)1.0))) {
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.destinationSuggestions != null && this.destinationSuggestions.mouseClicked(mouseX + this.viewer.getXScrollOffset(), mouseY + this.viewer.getYScrollOffset(), button)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private void clearSuggestions() {
        if (this.destinationSuggestions != null) {
            this.destinationSuggestions.getEditBox().setSuggestion("");
        }
        this.destinationSuggestions = null;
    }

    public void updateEditorSubwidgetsOnlinePlayers(DLEditBox field, Collection<Owner> src, Collection<Owner> list) {
        this.updateEditorSubwidgetsInternal(field, this.getViablePlayers(src, list));
    }

    public void updateEditorSubwidgets(EditBox field, StationTag tag) {
        this.clearSuggestions();
        this.selectedTag = tag;
        this.destinationSuggestions = new ModStationSuggestions(Minecraft.getInstance(), (Screen)this, field, this.font, this.getViableStations(this.stationNames, field), field.getHeight() + 2 + field.getY());
        this.destinationSuggestions.setAllowSuggestions(true);
        this.destinationSuggestions.updateCommandInfo();
    }

    private void updateEditorSubwidgetsInternal(DLEditBox field, List<String> data) {
        this.clearSuggestions();
        this.destinationSuggestions = new ModStationSuggestions(Minecraft.getInstance(), (Screen)this, (EditBox)field, this.font, data, field.getHeight() + 2 + field.getY());
        this.destinationSuggestions.setAllowSuggestions(true);
        this.destinationSuggestions.updateCommandInfo();
    }

    private List<String> getViableStations(Collection<String> src, EditBox field) {
        return src.stream().distinct().filter(x -> !this.selectedTag.contains((String)x)).sorted((a, b) -> a.compareTo((String)b)).toList();
    }

    private List<String> getViablePlayers(Collection<Owner> src, Collection<Owner> list) {
        return src.stream().distinct().filter(x -> !list.contains(x)).map(Owner::name).toList();
    }
}

