/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.screen;

import de.mrjulsen.crn.client.gui.CreateDynamicWidgets;
import de.mrjulsen.crn.client.gui.screen.AbstractNavigatorScreen;
import de.mrjulsen.crn.client.gui.widgets.ModernVerticalScrollBar;
import de.mrjulsen.crn.client.gui.widgets.RouteDetailsViewer;
import de.mrjulsen.crn.data.navigation.ClientRoute;
import de.mrjulsen.crn.data.navigation.ClientRoutePart;
import de.mrjulsen.crn.event.ModCommonEvents;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLAbstractScrollBar;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class TrainJourneyScreen
extends AbstractNavigatorScreen {
    private final ClientRoute route;
    private final ClientRoutePart part;
    private RouteDetailsViewer viewer;

    public TrainJourneyScreen(Screen lastScreen, ClientRoute route, UUID trainId) {
        super(lastScreen, (Component)TextUtils.translate((String)"gui.createrailwaysnavigator.journey_info.title"), CreateDynamicWidgets.BarColor.GOLD);
        this.route = route;
        this.part = route.getClientParts().stream().filter(x -> x.getTrainId().equals(trainId)).findFirst().orElse(route.getFirstClientPart());
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void onClose() {
        Minecraft.getInstance().setScreen(this.lastScreen);
    }

    @Override
    protected void init() {
        super.init();
        int dy = CreateDynamicWidgets.FooterSize.DEFAULT.size() + 32;
        ModernVerticalScrollBar scrollBar = new ModernVerticalScrollBar((Screen)this, this.guiLeft + 240 - 8, this.guiTop + dy, 247 - dy - CreateDynamicWidgets.FooterSize.SMALL.size() - 1, null);
        this.viewer = new RouteDetailsViewer((Screen)this, this.guiLeft + 3, this.guiTop + dy, 234, 247 - dy - CreateDynamicWidgets.FooterSize.SMALL.size() - 1, (DLAbstractScrollBar<?>)scrollBar);
        this.viewer.setShowTrainDetails(false);
        this.viewer.setCanExpandCollapse(false);
        this.viewer.setInitialExpanded(true);
        this.viewer.setShowJourney(true);
        this.addRenderableWidget((GuiEventListener)this.viewer);
        this.addRenderableWidget((GuiEventListener)scrollBar);
        this.viewer.displayPart(this.route, x -> x == this.part);
    }

    public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderNavigatorBackground(graphics, mouseX, mouseY, partialTicks);
        int y = CreateDynamicWidgets.FooterSize.DEFAULT.size() - 1;
        CreateDynamicWidgets.renderContainer(graphics, this.guiLeft + 1, this.guiTop + y, 238, 32, CreateDynamicWidgets.ContainerColor.BLUE);
        GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)(this.guiLeft + 8), (int)(this.guiTop + y + 7), (FormattedText)TextUtils.translate((String)"gui.createrailwaysnavigator.journey_info.date", (Object[])new Object[]{ModCommonEvents.getPhysicalLevel().dayTime() / 24000L}), (int)-1, (EAlignment)EAlignment.LEFT, (boolean)false);
        GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)(this.guiLeft + 8), (int)(this.guiTop + y + 18), (FormattedText)TextUtils.translate((String)"gui.createrailwaysnavigator.journey_info.train", (Object[])new Object[]{this.part.getFirstStop().getTrainDisplayName(), this.part.getFirstStop().getTrainId().toString().split("-")[0], this.part.getFirstStop().getDisplayTitle()}), (int)-1, (EAlignment)EAlignment.LEFT, (boolean)false);
        CreateDynamicWidgets.renderContainer(graphics, this.guiLeft + 1, this.guiTop + (y += 31), 238, 247 - y - CreateDynamicWidgets.FooterSize.SMALL.size() + 1, CreateDynamicWidgets.ContainerColor.GOLD);
        super.renderMainLayer(graphics, mouseX, mouseY, partialTicks);
    }
}

