/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.widgets.routedetails;

import de.mrjulsen.crn.Constants;
import de.mrjulsen.crn.client.gui.screen.ScheduleBoardScreen;
import de.mrjulsen.crn.config.ModClientConfig;
import de.mrjulsen.crn.data.navigation.ClientRoutePart;
import de.mrjulsen.crn.data.train.ClientTrainStop;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.client.gui.DLScreen;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLButton;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.TimeUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class RoutePartEntryWidget
extends DLButton {
    protected static final ResourceLocation GUI = ResourceLocation.fromNamespaceAndPath((String)"createrailwaysnavigator", (String)"textures/gui/widgets.png");
    protected static final int GUI_TEXTURE_WIDTH = 256;
    protected static final int GUI_TEXTURE_HEIGHT = 256;
    protected static final int ENTRY_WIDTH = 225;
    private final ClientRoutePart part;
    private final ClientTrainStop stop;
    private final TrainStopType type;
    private boolean valid;

    public RoutePartEntryWidget(Screen parent, ClientRoutePart part, ClientTrainStop stop, int pX, int pY, int width, TrainStopType type, boolean valid) {
        super(pX, pY, width, type.h, (Component)TextUtils.empty(), b -> DLScreen.setScreen((DLScreen)new ScheduleBoardScreen(parent, stop.getRealTimeStationTag())));
        this.part = part;
        this.stop = stop;
        this.type = type;
        this.valid = valid;
    }

    public void setValid(boolean b) {
        this.valid = b;
    }

    public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTick) {
        GuiUtils.drawTexture((ResourceLocation)GUI, (Graphics)graphics, (int)this.x(), (int)this.y(), (int)225, (int)this.height(), (int)0, (int)this.type.v, (int)225, (int)this.height(), (int)256, (int)256);
        this.renderData(graphics, this.y() + this.type.dy);
        if (this.isMouseSelected()) {
            GuiUtils.fill((Graphics)graphics, (int)(this.x() + 24), (int)(this.y() + this.type.dy - 1), (int)199, (int)20, (int)0x22FFFFFF);
        }
    }

    protected void renderData(Graphics graphics, int y) {
        float scale = 0.75f;
        String platformText = this.stop.getRealTimeStationTag().info().platform();
        String nameText = this.stop.getRealTimeStationTag().tagName();
        int maxStationNameWidth = 130 - this.font.width(platformText) - 6;
        if (this.font.width(nameText) > maxStationNameWidth) {
            GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)(this.x() + 80), (int)(y + 5), (FormattedText)TextUtils.text((String)this.font.substrByWidth((FormattedText)TextUtils.text((String)this.stop.getRealTimeStationTag().tagName()), maxStationNameWidth).getString()).append(Constants.ELLIPSIS_STRING), (int)-1, (EAlignment)EAlignment.LEFT, (boolean)false);
        } else {
            GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)(this.x() + 80), (int)(y + 5), (String)nameText, (int)-1, (EAlignment)EAlignment.LEFT, (boolean)false);
        }
        GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)(this.x() + 213), (int)(y + 5), (String)platformText, (int)-1, (EAlignment)EAlignment.RIGHT, (boolean)false);
        graphics.poseStack().pushPose();
        graphics.poseStack().scale(0.75f, 0.75f, 1.0f);
        int precision = (Integer)ModClientConfig.REALTIME_PRECISION_THRESHOLD.get();
        if (this.type == TrainStopType.TRANSIT) {
            graphics.poseStack().translate((float)(this.x() + 28) / 0.75f, (float)(y + 2) / 0.75f, 0.0f);
            GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)0, (int)0, (FormattedText)TextUtils.text((String)TimeUtils.parseTime((long)(this.stop.getScheduledArrivalTime() + DragonLib.daytimeShift()), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get()))).withStyle(this.valid ? ChatFormatting.RESET : ChatFormatting.STRIKETHROUGH), (int)(this.valid ? -1 : -48574), (EAlignment)EAlignment.LEFT, (boolean)false);
            GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)0, (int)12, (FormattedText)TextUtils.text((String)TimeUtils.parseTime((long)(this.stop.getScheduledDepartureTime() + DragonLib.daytimeShift()), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get()))).withStyle(this.valid ? ChatFormatting.RESET : ChatFormatting.STRIKETHROUGH), (int)(this.valid ? -1 : -48574), (EAlignment)EAlignment.LEFT, (boolean)false);
            if (this.stop.shouldRenderRealTime() && !this.part.isCancelled() && this.valid) {
                GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)30, (int)0, (String)TimeUtils.parseTime((long)(this.stop.getScheduledArrivalTime() + this.stop.getArrivalTimeDeviation() / (long)precision * (long)precision + DragonLib.daytimeShift()), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get())), (int)(this.stop.isArrivalDelayed() ? -48574 : -15013281), (EAlignment)EAlignment.LEFT, (boolean)false);
                GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)30, (int)12, (String)TimeUtils.parseTime((long)(this.stop.getScheduledDepartureTime() + this.stop.getDepartureTimeDeviation() / (long)precision * (long)precision + DragonLib.daytimeShift()), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get())), (int)(this.stop.isDepartureDelayed() ? -48574 : -15013281), (EAlignment)EAlignment.LEFT, (boolean)false);
            }
        } else {
            graphics.poseStack().translate((float)(this.x() + 28) / 0.75f, (float)(y + 6) / 0.75f, 0.0f);
            GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)0, (int)0, (FormattedText)TextUtils.text((String)TimeUtils.parseTime((long)((this.type == TrainStopType.START ? this.stop.getScheduledDepartureTime() : this.stop.getScheduledArrivalTime()) + DragonLib.daytimeShift()), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get()))).withStyle(this.valid ? ChatFormatting.RESET : ChatFormatting.STRIKETHROUGH), (int)(this.valid ? -1 : -48574), (EAlignment)EAlignment.LEFT, (boolean)false);
            if (this.stop.shouldRenderRealTime() && !this.part.isCancelled() && this.valid) {
                long realTime = this.type == TrainStopType.START ? this.stop.getScheduledDepartureTime() + this.stop.getDepartureTimeDeviation() / (long)precision * (long)precision : this.stop.getScheduledArrivalTime() + this.stop.getArrivalTimeDeviation() / (long)precision * (long)precision;
                GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)30, (int)0, (String)TimeUtils.parseTime((long)(realTime + DragonLib.daytimeShift()), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get())), (int)((this.type == TrainStopType.START ? this.stop.isDepartureDelayed() : this.stop.isArrivalDelayed()) ? -48574 : -15013281), (EAlignment)EAlignment.LEFT, (boolean)false);
            }
        }
        graphics.poseStack().popPose();
    }

    public static enum TrainStopType {
        START(48, 24, 4),
        TRANSIT(72, 21, 1),
        END(122, 33, 11);

        private int v;
        private int h;
        private int dy;

        private TrainStopType(int v, int h, int dy) {
            this.v = v;
            this.h = h;
            this.dy = dy;
        }
    }
}

