/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data;

import de.mrjulsen.crn.CreateRailwaysNavigator;
import de.mrjulsen.crn.config.ModCommonConfig;
import de.mrjulsen.crn.data.TrainCategory;
import de.mrjulsen.crn.data.storage.GlobalSettings;
import de.mrjulsen.crn.data.storage.RecentSearchQueries;
import de.mrjulsen.crn.event.ModCommonEvents;
import de.mrjulsen.crn.exceptions.RuntimeSideException;
import de.mrjulsen.crn.registry.ModAccessorTypes;
import de.mrjulsen.crn.util.EDepartureBoardTrainFilter;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.TimeUtils;
import de.mrjulsen.mcdragonlib.util.accessor.DataAccessor;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.storage.LevelResource;

public class UserSettings {
    private static final String FILENAME = "crn_usersettings_";
    private static final int VERSION = 1;
    private static final String NBT_VERSION = "Version";
    private static final String NBT_DEPARTURE_IN = "DepartureIn";
    private static final String NBT_TRANSFER_TIME = "TransferTime";
    private static final String NBT_TRAIN_CATEGORIES = "ExcludedTrainCategories";
    private static final String NBT_SAVED_ROUTES = "SavedRoutes";
    private static final String NBT_SEARCH_DEPARTURE_TIME = "SearchDepartureIn";
    private static final String NBT_SEARCH_TRAIN_CATEGORIES = "SearchExcludedTrainCategories";
    private static final String NBT_RECENT_SEARCH_QUERIES = "RecentSearchQueries";
    private static final String NBT_DEPARTURE_TRAIN_FILTER = "DepartureBoardTrainFilter";
    private static final Map<UUID, UserSettings> settingsInstances = new LinkedHashMap<UUID, UserSettings>();
    private final Collection<UserSetting<?>> allSettings = new ArrayList();
    private final UUID owner;
    private final boolean readOnly;
    public final UserSetting<Integer> navigationDepartureInTicks = this.registerSetting(new UserSetting<Integer>(() -> 0, "DepartureIn", (nbt, val, name) -> nbt.putInt(name, val.intValue()), (nbt, name) -> nbt.getInt(name), val -> TimeUtils.parseDurationShort((long)val.intValue())));
    public final UserSetting<Integer> navigationTransferTime = this.registerSetting(new UserSetting<Integer>(() -> 1000, "TransferTime", (nbt, val, name) -> nbt.putInt(name, val.intValue()), (nbt, name) -> nbt.getInt(name), val -> TimeUtils.parseDurationShort((long)val.intValue())));
    public final UserSetting<Set<UUID>> navigationExcludedTrainCategories = this.registerSetting(new UserSetting<Set>(() -> new HashSet(), "ExcludedTrainCategories", (nbt, val, name) -> {
        ListTag list = new ListTag();
        list.addAll(val.stream().map(x -> StringTag.valueOf((String)x.toString())).toList());
        nbt.put(name, (Tag)list);
    }, (nbt, name) -> nbt.getList(name, 8).stream().filter(x -> GlobalSettings.hasInstance() ? GlobalSettings.getInstance().trainCategoryExists(UserSettings.deserializeUuidString(x.getAsString())) : true).map(x -> UserSettings.deserializeUuidString(x.getAsString())).collect(Collectors.toSet()), val -> val.isEmpty() ? TextUtils.translate((String)"gui.createrailwaysnavigator.search_options.train_categories.all").getString() : TextUtils.translate((String)"gui.createrailwaysnavigator.search_options.train_categories.excluded", (Object[])new Object[]{val.size()}).getString()));
    public final UserSetting<Set<CompoundTag>> savedRoutes = this.registerSetting(new UserSetting<Set>(() -> new HashSet(), "SavedRoutes", (nbt, val, name) -> {
        ListTag list = new ListTag();
        list.addAll((Collection)val);
        nbt.put(name, (Tag)list);
    }, (nbt, name) -> nbt.getList(name, 10).stream().map(x -> (CompoundTag)x).collect(Collectors.toSet()), val -> TextUtils.translate((String)"gui.createrailwaysnavigator.saved_routes.saved", (Object[])new Object[]{val.size()}).getString()));
    public final UserSetting<Integer> searchDepartureInTicks = this.registerSetting(new UserSetting<Integer>(() -> 0, "SearchDepartureIn", (nbt, val, name) -> nbt.putInt(name, val.intValue()), (nbt, name) -> nbt.getInt(name), val -> TimeUtils.parseDurationShort((long)val.intValue())));
    public final UserSetting<Set<UUID>> searchExcludedTrainCaegories = this.registerSetting(new UserSetting<Set>(() -> new HashSet(), "SearchExcludedTrainCategories", (nbt, val, name) -> {
        ListTag list = new ListTag();
        list.addAll(val.stream().map(x -> StringTag.valueOf((String)x.toString())).toList());
        nbt.put(name, (Tag)list);
    }, (nbt, name) -> nbt.getList(name, 8).stream().filter(x -> GlobalSettings.hasInstance() ? GlobalSettings.getInstance().trainCategoryExists(UserSettings.deserializeUuidString(x.getAsString())) : true).map(x -> UserSettings.deserializeUuidString(x.getAsString())).collect(Collectors.toSet()), val -> val.isEmpty() ? TextUtils.translate((String)"gui.createrailwaysnavigator.search_options.train_categories.all").getString() : TextUtils.translate((String)"gui.createrailwaysnavigator.search_options.train_categories.excluded", (Object[])new Object[]{val.size()}).getString()));
    public final UserSetting<EDepartureBoardTrainFilter> searchTrainFilter = this.registerSetting(new UserSetting<EDepartureBoardTrainFilter>(() -> EDepartureBoardTrainFilter.ARRIVAL_AND_DEPARTURE, "DepartureBoardTrainFilter", (nbt, val, name) -> nbt.putByte(name, val.getIndex()), (nbt, name) -> EDepartureBoardTrainFilter.getByIndex(nbt.getByte(name)), val -> TextUtils.translate((String)val.getValueTranslationKey("createrailwaysnavigator")).getString()));
    public final UserSetting<RecentSearchQueries> recentSearchQueries = this.registerSetting(new UserSetting<RecentSearchQueries>(() -> new RecentSearchQueries(), "RecentSearchQueries", (nbt, val, name) -> nbt.put(name, (Tag)val.toNbt()), (nbt, name) -> RecentSearchQueries.fromNbt(nbt.getCompound(name)), val -> String.valueOf(val.size())));

    public UserSettings(UUID playerId, boolean readOnly) {
        this.owner = playerId;
        this.readOnly = readOnly;
    }

    public UUID getOwnerId() {
        return this.owner;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    private void checkReadOnly() {
        if (this.isReadOnly()) {
            throw new IllegalAccessError("This instance of the user settings is read-only!");
        }
    }

    private static UUID deserializeUuidString(String str) {
        try {
            return UUID.fromString(str);
        }
        catch (Exception e) {
            return TrainCategory.genMD5Uuid(str);
        }
    }

    private static void update(UserSettings settings) {
        if (settingsInstances.containsKey(settings.getOwnerId())) {
            settingsInstances.get(settings.getOwnerId()).checkReadOnly();
        }
        settingsInstances.put(settings.getOwnerId(), settings);
    }

    protected <T extends UserSetting<?>> T registerSetting(T setting) {
        this.allSettings.add(setting);
        return setting;
    }

    public static UserSettings getSettingsFor(UUID playerId, boolean readOnly) {
        return settingsInstances.computeIfAbsent(playerId, x -> UserSettings.load(x, readOnly));
    }

    public final void clientSave(Runnable andThen) throws RuntimeSideException {
        if (Platform.getEnvironment() == Env.SERVER) {
            throw new RuntimeSideException(true);
        }
        this.checkReadOnly();
        DataAccessor.getFromServer((Object)this, ModAccessorTypes.SAVE_USER_SETTINGS, $ -> DLUtils.doIfNotNull((Object)andThen, x -> x.run()));
    }

    public final synchronized void save() throws RuntimeSideException {
        if (!ModCommonEvents.hasServer()) {
            throw new RuntimeSideException(false);
        }
        this.checkReadOnly();
        UserSettings.update(this);
        CompoundTag nbt = this.toNbt();
        try {
            NbtIo.writeCompressed((CompoundTag)nbt, (Path)ModCommonEvents.getCurrentServer().get().getWorldPath(new LevelResource("data/crn_usersettings_" + String.valueOf(this.getOwnerId()) + ".nbt")));
            if (((Boolean)ModCommonConfig.ADVANCED_LOGGING.get()).booleanValue()) {
                CreateRailwaysNavigator.LOGGER.info("Saved user settings.");
            }
        }
        catch (IOException e) {
            CreateRailwaysNavigator.LOGGER.error("Unable to save user settings.", (Throwable)e);
        }
    }

    public static UserSettings load(UUID playerId, boolean readOnly) throws RuntimeSideException {
        if (!ModCommonEvents.hasServer()) {
            throw new RuntimeSideException(false);
        }
        Path settingsPath = ModCommonEvents.getCurrentServer().get().getWorldPath(new LevelResource("data/crn_usersettings_" + String.valueOf(playerId) + ".nbt"));
        if (settingsPath.toFile().exists()) {
            try {
                return UserSettings.fromNbt(NbtIo.readCompressed((Path)settingsPath, (NbtAccounter)NbtAccounter.unlimitedHeap()), playerId, readOnly);
            }
            catch (IOException e) {
                CreateRailwaysNavigator.LOGGER.error("Cannot load user settings for player: " + String.valueOf(playerId), (Throwable)e);
            }
        }
        return new UserSettings(playerId, readOnly);
    }

    public final CompoundTag toNbt() {
        CompoundTag nbt = new CompoundTag();
        this.allSettings.forEach(x -> x.serialize(nbt));
        nbt.putInt(NBT_VERSION, 1);
        return nbt;
    }

    public static final UserSettings fromNbt(CompoundTag nbt, UUID playerId, boolean readOnly) {
        UserSettings settings = new UserSettings(playerId, readOnly);
        int version = nbt.getInt(NBT_VERSION);
        settings.allSettings.forEach(x -> x.deserialize(nbt));
        return settings;
    }

    public static class UserSetting<T> {
        private T value;
        private final String serializationName;
        private final Supplier<T> defaultValue;
        private final ISerializationContext<T> serializer;
        private final BiFunction<CompoundTag, String, T> deserializer;
        private final Function<T, String> stringRepresentation;

        public UserSetting(Supplier<T> defaultValue, String serializationName, ISerializationContext<T> serializer, BiFunction<CompoundTag, String, T> deserializer, Function<T, String> stringRepresentation) {
            this.defaultValue = defaultValue;
            this.serializer = serializer;
            this.serializationName = serializationName;
            this.deserializer = deserializer;
            this.stringRepresentation = stringRepresentation;
            this.value = defaultValue.get();
        }

        public T getValue() {
            return this.value;
        }

        public void setValue(T value) {
            this.value = value;
        }

        public void setToDefault() {
            this.value = this.getDefault();
        }

        public T getDefault() {
            return this.defaultValue.get();
        }

        private void serialize(CompoundTag nbt) {
            this.serializer.execute(nbt, this.value, this.getSerializationName());
        }

        private T deserialize(CompoundTag nbt) {
            this.value = this.deserializer.apply(nbt, this.getSerializationName());
            return this.value;
        }

        private String getSerializationName() {
            return this.serializationName;
        }

        public String toString() {
            return this.stringRepresentation.apply(this.value);
        }
    }

    @FunctionalInterface
    private static interface ISerializationContext<T> {
        public void execute(CompoundTag var1, T var2, String var3);
    }
}

