/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data.schedule.condition;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.schedule.ScheduleEntry;
import com.simibubi.create.content.trains.schedule.condition.ScheduledDelay;
import com.simibubi.create.content.trains.schedule.condition.TimedWaitCondition;
import com.simibubi.create.content.trains.schedule.destination.DestinationInstruction;
import com.simibubi.create.content.trains.schedule.destination.ScheduleInstruction;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import de.mrjulsen.crn.api.IPredictableWaitCondition;
import de.mrjulsen.crn.client.ClientWrapper;
import de.mrjulsen.crn.data.ETimeSource;
import de.mrjulsen.crn.data.schedule.INavigationExtension;
import de.mrjulsen.crn.data.schedule.condition.IDelayedWaitCondition;
import de.mrjulsen.crn.data.schedule.instruction.PrioritizedDestinationInstruction;
import de.mrjulsen.crn.data.train.DepartureHistory;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.data.Pair;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import dev.architectury.utils.GameInstance;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class TrainSeparationCondition
extends ScheduledDelay
implements IDelayedWaitCondition,
IPredictableWaitCondition {
    @Deprecated
    public static final String NBT_TIME = "Value";
    @Deprecated
    public static final String NBT_TIME_UNIT = "TimeUnit";
    public static final String NBT_TICKS = "Ticks";
    public static final String NBT_TRAIN_FILTER = "TrainFilter";
    public static final String NBT_TIME_SOURCE = "TimeSource";

    public TrainSeparationCondition() {
        this.data.putByte(NBT_TRAIN_FILTER, DepartureHistory.ETrainFilter.ANY.getIndex());
        this.data.putInt(NBT_TICKS, 100);
        this.data.putByte(NBT_TIME_SOURCE, ETimeSource.REAL_LIFE.getIndex());
    }

    public net.createmod.catnip.data.Pair<ItemStack, Component> getSummary() {
        return net.createmod.catnip.data.Pair.of((Object)ItemStack.EMPTY, (Object)TextUtils.translate((String)("createrailwaysnavigator.schedule.condition." + this.getId().getPath() + ".title"), (Object[])new Object[]{this.formatTime(true)}));
    }

    public ItemStack getSecondLineIcon() {
        return new ItemStack((ItemLike)Items.OBSERVER);
    }

    public int totalWaitTicks() {
        return 0;
    }

    private int getSeparationTime() {
        if (this.data.contains(NBT_TICKS)) {
            return this.data.getInt(NBT_TICKS);
        }
        return 0;
    }

    protected Component formatTime(boolean compact) {
        int remainingTicks = this.getSeparationTime();
        switch (this.getTimeSource()) {
            case IN_GAME: {
                int[] t = TrainSeparationCondition.toInGameTime(remainingTicks);
                if (compact) {
                    return TextUtils.text((String)String.format("%d:%02d:%02d", t[2], t[1], t[0]));
                }
                return TextUtils.text((String)String.format("%dd %dh %dm", t[2], t[1], t[0]));
            }
        }
        int[] t = TrainSeparationCondition.toRealLifeTime(remainingTicks);
        if (compact) {
            return TextUtils.text((String)String.format("%d:%02d,%02d", t[2], t[1], t[0]));
        }
        return TextUtils.text((String)String.format("%dm %ds %dt", t[2], t[1], t[0]));
    }

    public List<Component> getTitleAs(String type) {
        return ImmutableList.of((Object)TextUtils.translate((String)("createrailwaysnavigator.schedule." + type + "." + this.getId().getPath())), (Object)TextUtils.translate((String)("createrailwaysnavigator.schedule." + type + "." + this.getId().getPath() + ".description"), (Object[])new Object[]{this.formatTime(false), TextUtils.translate((String)this.getTimeSource().getValueTranslationKey("createrailwaysnavigator")).getString()}).withStyle(ChatFormatting.DARK_AQUA), (Object)TextUtils.translate((String)this.getTrainFilter().getValueTranslationKey("createrailwaysnavigator")).withStyle(ChatFormatting.AQUA));
    }

    public boolean tickCompletion(Level level, Train train, CompoundTag context) {
        ScheduleEntry entry = (ScheduleEntry)train.runtime.getSchedule().entries.get(train.runtime.currentEntry);
        ((INavigationExtension)train.navigation).addDelayedWaitCondition((Pair<IDelayedWaitCondition, IDelayedWaitCondition.DelayedWaitConditionContext>)Pair.of((Object)this, (Object)new IDelayedWaitCondition.DelayedWaitConditionContext(level, train, context, train.getCurrentStation(), entry)));
        return true;
    }

    @Override
    public boolean runDelayed(IDelayedWaitCondition.DelayedWaitConditionContext context) {
        int delayValue = this.getSeparationTime();
        long lastDepartureTimestamp = Long.MIN_VALUE;
        ScheduleEntry entry = context.scheduleEntry();
        ScheduleInstruction scheduleInstruction = entry.instruction;
        if (scheduleInstruction instanceof PrioritizedDestinationInstruction) {
            PrioritizedDestinationInstruction instruction = (PrioritizedDestinationInstruction)scheduleInstruction;
            stationName = instruction.getFilters();
            lastDepartureTimestamp = stationName.stream().mapToLong(x -> DepartureHistory.getLatestDepartureFor(this.getTrainFilter(), context.train(), x)).max().orElse(0L);
        } else {
            stationName = entry.instruction;
            if (stationName instanceof DestinationInstruction) {
                DestinationInstruction instruction = (DestinationInstruction)stationName;
                stationName = instruction.getFilter();
                lastDepartureTimestamp = DepartureHistory.getLatestDepartureFor(this.getTrainFilter(), context.train(), (String)stationName);
            }
        }
        if (GameInstance.getServer() != null && lastDepartureTimestamp + (long)delayValue < GameInstance.getServer().overworld().getGameTime()) {
            DepartureHistory.updateDepartures(context.station().name, context.train());
            return true;
        }
        return false;
    }

    public ResourceLocation getId() {
        return ResourceLocation.fromNamespaceAndPath((String)"createrailwaysnavigator", (String)"train_separation");
    }

    public DepartureHistory.ETrainFilter getTrainFilter() {
        return DepartureHistory.ETrainFilter.getByIndex(this.data.getByte(NBT_TRAIN_FILTER));
    }

    public ETimeSource getTimeSource() {
        return ETimeSource.getByIndex(this.data.getByte(NBT_TIME_SOURCE));
    }

    public void initConfigurationWidgets(ModularGuiLineBuilder builder) {
        ClientWrapper.initTimingAdjustmentGui(this, builder);
    }

    @Override
    public long waitUntil(long worldTime) {
        return worldTime + (long)this.totalWaitTicks();
    }

    public static int[] toRealLifeTime(int ticks) {
        int t = ticks;
        int m = t / 1200;
        int s = (t %= 1200) / 20;
        return new int[]{t %= 20, s, m};
    }

    public static int[] toInGameTime(int ticks) {
        int t = ticks;
        int d = (int)((long)t / DragonLib.ticksPerDay());
        t = (int)((long)t % DragonLib.ticksPerDay());
        int h = (int)((long)t / DragonLib.ticksPerIngameHour());
        t = (int)((long)t % DragonLib.ticksPerIngameHour());
        int m = (int)((long)t / (DragonLib.ticksPerIngameHour() / 60L));
        return new int[]{m, h, d};
    }

    public static int toTicksFromRealLife(int[] t) {
        return t[2] * TimedWaitCondition.TimeUnit.MINUTES.ticksPer + t[1] * TimedWaitCondition.TimeUnit.SECONDS.ticksPer + t[0];
    }

    public static int toTicksFromInGame(int[] t) {
        return (int)((long)t[2] * DragonLib.ticksPerDay() + (long)t[1] * DragonLib.ticksPerIngameHour() + (long)t[0] * (DragonLib.ticksPerIngameHour() / 60L));
    }
}

