/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.mixin;

import de.mrjulsen.crn.block.AbstractAdvancedDisplayBlock;
import de.mrjulsen.crn.block.blockentity.AdvancedDisplayBlockEntity;
import de.mrjulsen.crn.block.display.properties.BasicDisplaySettings;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={DyeItem.class})
public abstract class ItemMixin
extends Item {
    public ItemMixin(Item.Properties properties) {
        super(properties);
    }

    public DyeItem self() {
        return (DyeItem)this;
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos pos;
        Level level = context.getLevel();
        BlockState state = level.getBlockState(pos = context.getClickedPos());
        Block block = state.getBlock();
        if (block instanceof AbstractAdvancedDisplayBlock) {
            AbstractAdvancedDisplayBlock block2 = (AbstractAdvancedDisplayBlock)block;
            AdvancedDisplayBlockEntity blockEntity = ((AdvancedDisplayBlockEntity)level.getBlockEntity(pos)).getController();
            DyeColor dye = this.self().getDyeColor();
            level.playSound(null, pos, SoundEvents.DYE_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
            int dyeColor = dye == DyeColor.ORANGE ? -26368 : dye.getTextColor();
            blockEntity.applyToAll(be -> be.getSettingsAs(BasicDisplaySettings.class).ifPresent(x -> {
                if (context.getPlayer().isShiftKeyDown()) {
                    x.setBackColor(dyeColor);
                } else {
                    x.setFontColor(dyeColor);
                }
                be.notifyUpdate();
            }));
            if (level.isClientSide) {
                blockEntity.getRenderer().update(level, pos, state, (BlockEntity)blockEntity, (Object)AdvancedDisplayBlockEntity.EUpdateReason.LAYOUT_CHANGED);
            }
            return InteractionResult.SUCCESS;
        }
        return super.useOn(context);
    }
}

