/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.network.packets.cts;

import de.mrjulsen.crn.block.AbstractAdvancedSidedDisplayBlock;
import de.mrjulsen.crn.block.blockentity.AdvancedDisplayBlockEntity;
import de.mrjulsen.crn.block.display.properties.IDisplaySettings;
import de.mrjulsen.crn.block.properties.ESide;
import de.mrjulsen.crn.client.AdvancedDisplaysRegistry;
import de.mrjulsen.mcdragonlib.net.BaseNetworkPacket;
import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class AdvancedDisplayUpdatePacket
extends BaseNetworkPacket<AdvancedDisplayUpdatePacket> {
    private BlockPos pos;
    private AdvancedDisplaysRegistry.DisplayTypeResourceKey key;
    private boolean doubleSided;
    private IDisplaySettings settings;

    public AdvancedDisplayUpdatePacket() {
    }

    public AdvancedDisplayUpdatePacket(Level level, BlockPos pos, AdvancedDisplaysRegistry.DisplayTypeResourceKey key, boolean doubleSided, IDisplaySettings settings) {
        this.pos = pos;
        this.key = key;
        this.doubleSided = doubleSided;
        this.settings = settings;
        this.apply(level, this);
    }

    protected AdvancedDisplayUpdatePacket(BlockPos pos, AdvancedDisplaysRegistry.DisplayTypeResourceKey key, boolean doubleSided, IDisplaySettings settings) {
        this.pos = pos;
        this.key = key;
        this.doubleSided = doubleSided;
        this.settings = settings;
    }

    public void encode(AdvancedDisplayUpdatePacket packet, RegistryFriendlyByteBuf buffer) {
        CompoundTag k = new CompoundTag();
        packet.key.toNbt(k);
        buffer.writeBlockPos(packet.pos);
        buffer.writeNbt((Tag)k);
        buffer.writeBoolean(packet.doubleSided);
        buffer.writeNbt((Tag)packet.settings.serializeNbt());
    }

    public AdvancedDisplayUpdatePacket decode(RegistryFriendlyByteBuf buffer) {
        BlockPos pos = buffer.readBlockPos();
        AdvancedDisplaysRegistry.DisplayTypeResourceKey key = AdvancedDisplaysRegistry.DisplayTypeResourceKey.fromNbt(buffer.readNbt());
        boolean doubleSided = buffer.readBoolean();
        IDisplaySettings settings = AdvancedDisplaysRegistry.createSettings(key);
        settings.deserializeNbt(buffer.readNbt());
        return new AdvancedDisplayUpdatePacket(pos, key, doubleSided, settings);
    }

    private void apply(Level level, AdvancedDisplayUpdatePacket packet) {
        BlockEntity blockEntity;
        if (level.isLoaded(packet.pos) && (blockEntity = level.getBlockEntity(packet.pos)) instanceof AdvancedDisplayBlockEntity) {
            AdvancedDisplayBlockEntity blockEntity2 = (AdvancedDisplayBlockEntity)blockEntity;
            blockEntity2.applyToAll(be -> {
                be.setDisplayType(packet.key, packet.settings);
                if (level.getBlockState(be.getBlockPos()).getBlock() instanceof AbstractAdvancedSidedDisplayBlock) {
                    BlockState state = level.getBlockState(be.getBlockPos());
                    state = (BlockState)state.setValue(AbstractAdvancedSidedDisplayBlock.SIDE, (Comparable)((Object)(packet.doubleSided ? ESide.BOTH : ESide.FRONT)));
                    level.setBlockAndUpdate(be.getBlockPos(), state);
                }
                be.notifyUpdate();
            });
        }
    }

    public void handle(AdvancedDisplayUpdatePacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        contextSupplier.get().queue(() -> {
            Player player = ((NetworkManager.PacketContext)contextSupplier.get()).getPlayer();
            if (player != null) {
                Level level = player.level();
                this.apply(level, packet);
            }
        });
    }
}

