/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.registry;

import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.station.GlobalStation;
import de.mrjulsen.crn.CRNPlatformSpecific;
import de.mrjulsen.crn.CreateRailwaysNavigator;
import de.mrjulsen.crn.client.ClientWrapper;
import de.mrjulsen.crn.data.NearestTrackStationResult;
import de.mrjulsen.crn.data.StationTag;
import de.mrjulsen.crn.data.TagName;
import de.mrjulsen.crn.data.TrainCategory;
import de.mrjulsen.crn.data.TrainLine;
import de.mrjulsen.crn.data.UserSettings;
import de.mrjulsen.crn.data.navigation.ClientRoute;
import de.mrjulsen.crn.data.navigation.ClientRoutePart;
import de.mrjulsen.crn.data.navigation.NavigatableGraph;
import de.mrjulsen.crn.data.navigation.Route;
import de.mrjulsen.crn.data.navigation.RoutePart;
import de.mrjulsen.crn.data.storage.GlobalSettings;
import de.mrjulsen.crn.data.storage.GlobalSettingsClient;
import de.mrjulsen.crn.data.train.ClientTrainStop;
import de.mrjulsen.crn.data.train.DepartureHistory;
import de.mrjulsen.crn.data.train.ScheduleSection;
import de.mrjulsen.crn.data.train.TrainData;
import de.mrjulsen.crn.data.train.TrainListener;
import de.mrjulsen.crn.data.train.TrainPrediction;
import de.mrjulsen.crn.data.train.TrainStop;
import de.mrjulsen.crn.data.train.TrainUtils;
import de.mrjulsen.crn.data.train.portable.NextConnectionsDisplayData;
import de.mrjulsen.crn.data.train.portable.TrainDisplayData;
import de.mrjulsen.crn.debug.TrainDebugData;
import de.mrjulsen.crn.network.packets.stc.ServerErrorPacket;
import de.mrjulsen.crn.registry.data.NextConnectionsRequestData;
import de.mrjulsen.crn.util.Lock;
import de.mrjulsen.crn.util.Owner;
import de.mrjulsen.mcdragonlib.data.Pair;
import de.mrjulsen.mcdragonlib.net.BaseNetworkPacket;
import de.mrjulsen.mcdragonlib.net.DLNetworkManager;
import de.mrjulsen.mcdragonlib.util.accessor.DataAccessorType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public final class ModAccessorTypes {
    public static final DataAccessorType<String, StationTag, StationTag> GET_STATION_TAG = DataAccessorType.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"createrailwaysnavigator", (String)"get_station_tag"), (DataAccessorType)DataAccessorType.Builder.create((in, nbt) -> nbt.putString("Data", in), nbt -> nbt.getString("Data"), (player, in, temp, nbt, iteration) -> {
        nbt.put("Data", (Tag)GlobalSettings.getInstance().getOrCreateStationTagFor((String)in).toNbt());
        return false;
    }, (hasMore, previousData, iteration, nbt) -> StationTag.fromNbt(nbt.getCompound("Data"), null)));
    public static final DataAccessorType<TagName, StationTag, StationTag> GET_STATION_TAG_BY_TAG_NAME = DataAccessorType.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"createrailwaysnavigator", (String)"get_station_tag_by_tag_name"), (DataAccessorType)DataAccessorType.Builder.create((in, nbt) -> nbt.putString("Data", in.get()), nbt -> TagName.of(nbt.getString("Data")), (player, in, temp, nbt, iteration) -> {
        nbt.put("Data", (Tag)GlobalSettings.getInstance().getOrCreateStationTagFor((TagName)in).toNbt());
        return false;
    }, (hasMore, previousData, iteration, nbt) -> StationTag.fromNbt(nbt.getCompound("Data"), null)));
    public static final DataAccessorType<GlobalSettingsClient.CreateStationTagData, Optional<StationTag>, Optional<StationTag>> CREATE_STATION_TAG = DataAccessorType.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"createrailwaysnavigator", (String)"create_station_tag"), (DataAccessorType)DataAccessorType.Builder.create((in, nbt) -> {
        nbt.putString("Name", in.name());
        if (in.owner() != null) {
            nbt.put("Owner", (Tag)in.owner().toNbt());
        }
    }, nbt -> new GlobalSettingsClient.CreateStationTagData(nbt.getString("Name"), nbt.contains("Owner") ? Owner.fromNbt(nbt.getCompound("Owner")) : null), (player, in, temp, nbt, iteration) -> {
        if (!GlobalSettings.modificationsAllowed(player)) {
            return false;
        }
        nbt.put("Data", (Tag)GlobalSettings.getInstance().createOrGetStationTag(TagName.of(in.name()), in.owner()).toNbt());
        return false;
    }, (hasMore, data, iteration, nbt) -> Optional.ofNullable(nbt.contains("Data") ? StationTag.fromNbt(nbt.getCompound("Data"), null) : null)));
    public static final DataAccessorType<StationTag, Void, Void> REGISTER_STATION_TAG = DataAccessorType.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"createrailwaysnavigator", (String)"register_station_tag"), (DataAccessorType)DataAccessorType.Builder.createEmptyResponse((in, nbt) -> nbt.put("Data", (Tag)in.toNbt()), nbt -> StationTag.fromNbt(nbt.getCompound("Data"), null), (player, in, temp, nbt, iteration) -> {
        if (!GlobalSettings.modificationsAllowed(player)) {
            return false;
        }
        in.updateLastEdited(player);
        GlobalSettings.getInstance().registerStationTag((StationTag)in);
        return false;
    }));
    public static final DataAccessorType<UUID, Void, Void> DELETE_STATION_TAG = DataAccessorType.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"createrailwaysnavigator", (String)"delete_station_tag"), (DataAccessorType)DataAccessorType.Builder.createEmptyResponse((in, nbt) -> nbt.putUUID("Data", in), nbt -> nbt.getUUID("Data"), (player, in, temp, nbt, iteration) -> {
        GlobalSettings.getInstance().getStationTag((UUID)in).ifPresent(x -> {
            if (!x.getOwner().isAllowed(new Owner(player)) || !GlobalSettings.modificationsAllowed(player)) {
                return;
            }
            GlobalSettings.getInstance().removeStationTag((UUID)in);
        });
        return false;
    }));
    public static final DataAccessorType<GlobalSettingsClient.UpdateStationTagNameData, Void, Void> UPDATE_STATION_TAG_NAME = DataAccessorType.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"createrailwaysnavigator", (String)"update_station_tag_name"), (DataAccessorType)DataAccessorType.Builder.createEmptyResponse((in, nbt) -> {
        nbt.putUUID("Id", in.tagId());
        nbt.putString("Name", in.name());
    }, nbt -> new GlobalSettingsClient.UpdateStationTagNameData(nbt.getUUID("Id"), nbt.getString("Name")), (player, in, temp, nbt, iteration) -> {
        GlobalSettings.getInstance().getStationTag(in.tagId()).ifPresent(x -> {
            if (!x.getOwner().isAllowed(new Owner(player)) || !GlobalSettings.modificationsAllowed(player)) {
                return;
            }
            x.updateLastEdited(player);
            x.setName(TagName.of(in.name()));
        });
        return false;
    }));
    public static final DataAccessorType<Lock.PermissionsUpdateData, Optional<StationTag>, Optional<StationTag>> UPDATE_STATION_TAG_PERMISSIONS = DataAccessorType.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"createrailwaysnavigator", (String)"update_station_tag_permissions"), (DataAccessorType)DataAccessorType.Builder.create((in, nbt) -> nbt.put("Data", (Tag)in.toNbt()), nbt -> Lock.PermissionsUpdateData.fromNbt(nbt.getCompound("Data")), (player, in, temp, nbt, iteration) -> {
        GlobalSettings.getInstance().getStationTag(in.id()).ifPresent(tag -> {
            if (!tag.getOwner().isAdmin(new Owner(player)) || !GlobalSettings.modificationsAllowed(player)) {
                return;
            }
            if (in.state() != null) {
                tag.getOwner().set(in.state());
            }
            if (in.trusted() != null) {
                tag.getOwner().updateTrusted(in.trusted());
            }
            if (in.newOwner() != null) {
                tag.getOwner().setOwner(in.newOwner());
                tag.getOwner().addTrusted(new Owner(player));
            }
            nbt.put("Data", (Tag)tag.toNbt());
        });
        return false;
    }, (hasMore, data, iteration, nbt) -> Optional.ofNullable(nbt.contains("Data") ? StationTag.fromNbt(nbt.getCompound("Data"), null) : null)));
    public static final DataAccessorType<GlobalSettingsClient.AddStationTagEntryData, Optional<StationTag>, Optional<StationTag>> ADD_STATION_TAG_ENTRY = DataAccessorType.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"createrailwaysnavigator", (String)"add_station_tag_entry"), (DataAccessorType)DataAccessorType.Builder.create((in, nbt) -> {
        nbt.putUUID("Id", in.tagId());
        nbt.putString("Name", in.station());
        nbt.put("Info", (Tag)in.info().toNbt());
    }, nbt -> new GlobalSettingsClient.AddStationTagEntryData(nbt.getUUID("Id"), nbt.getString("Name"), StationTag.StationInfo.fromNbt(nbt.getCompound("Info"))), (player, in, temp, nbt, iteration) -> {
        GlobalSettings.getInstance().getStationTag(in.tagId()).ifPresent(x -> {
            if (!x.getOwner().isAllowed(new Owner(player)) || !GlobalSettings.modificationsAllowed(player)) {
                return;
            }
            x.add(in.station(), in.info());
            x.updateLastEdited(player);
            nbt.put("Data", (Tag)x.toNbt());
        });
        return false;
    }, (hasMore, data, iteration, nbt) -> Optional.ofNullable(nbt.contains("Data") ? StationTag.fromNbt(nbt.getCompound("Data"), null) : null)));
    public static final DataAccessorType<GlobalSettingsClient.AddStationTagEntryData, Optional<StationTag>, Optional<StationTag>> UPDATE_STATION_TAG_ENTRY = DataAccessorType.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"createrailwaysnavigator", (String)"update_station_tag_entry"), (DataAccessorType)DataAccessorType.Builder.create((in, nbt) -> {
        nbt.putUUID("Id", in.tagId());
        nbt.putString("Name", in.station());
        nbt.put("Info", (Tag)in.info().toNbt());
    }, nbt -> new GlobalSettingsClient.AddStationTagEntryData(nbt.getUUID("Id"), nbt.getString("Name"), StationTag.StationInfo.fromNbt(nbt.getCompound("Info"))), (player, in, temp, nbt, iteration) -> {
        GlobalSettings.getInstance().getStationTag(in.tagId()).ifPresent(x -> {
            if (!x.getOwner().isAllowed(new Owner(player)) || !GlobalSettings.modificationsAllowed(player)) {
                return;
            }
            x.updateInfoForStation(in.station(), in.info());
            x.updateLastEdited(player);
            nbt.put("Data", (Tag)x.toNbt());
        });
        return false;
    }, (hasMore, data, iteration, nbt) -> Optional.ofNullable(nbt.contains("Data") ? StationTag.fromNbt(nbt.getCompound("Data"), null) : null)));
    public static final DataAccessorType<GlobalSettingsClient.RemoveStationTagEntryData, Optional<StationTag>, Optional<StationTag>> REMOVE_STATION_TAG_ENTRY = DataAccessorType.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"createrailwaysnavigator", (String)"remove_station_tag_entry"), (DataAccessorType)DataAccessorType.Builder.create((in, nbt) -> {
        nbt.putUUID("Id", in.tagId());
        nbt.putString("Name", in.station());
    }, nbt -> new GlobalSettingsClient.RemoveStationTagEntryData(nbt.getUUID("Id"), nbt.getString("Name")), (player, in, temp, nbt, iteration) -> {
        GlobalSettings.getInstance().getStationTag(in.tagId()).ifPresent(x -> {
            if (!x.getOwner().isAllowed(new Owner(player)) || !GlobalSettings.modificationsAllowed(player)) {
                return;
            }
            x.remove(in.station());
            x.updateLastEdited(player);
            nbt.put("Data", (Tag)x.toNbt());
        });
        return false;
    }, (hasMore, data, iteration, nbt) -> Optional.ofNullable(nbt.contains("Data") ? StationTag.fromNbt(nbt.getCompound("Data"), null) : null)));
    public static final DataAccessorType<Void, Collection<StationTag>, Collection<StationTag>> GET_ALL_STATION_TAGS = DataAccessorType.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"createrailwaysnavigator", (String)"get_all_station_tags"), (DataAccessorType)DataAccessorType.Builder.createNoInputChunked((player, in, temp, nbt, iteration) -> {
        Queue tags;
        if (temp.getFirst() == null) {
            temp.setFirst(new ConcurrentLinkedQueue(GlobalSettings.getInstance().getAllStationTags().stream().sorted((a, b) -> a.getTagName().get().compareToIgnoreCase(b.getTagName().get())).toList()));
        }
        if ((tags = (Queue)temp.getFirst()).isEmpty()) {
            return false;
        }
        for (int i = 0; i < 64 && !tags.isEmpty(); ++i) {
            StationTag tag = (StationTag)tags.poll();
            nbt.put("Data" + i, (Tag)tag.toNbt());
        }
        return !tags.isEmpty();
    }, (hasMore, list, iteration, nbt) -> {
        if (list == null) {
            list = new ArrayList();
        }
        ArrayList l = list;
        nbt.getAllKeys().forEach(x -> l.add(StationTag.fromNbt(nbt.getCompound(x), null)));
        return l;
    }, chunks -> chunks));
    public static final DataAccessorType<Boolean, Collection<StationTag>, Collection<StationTag>> GET_ALL_STATIONS_AS_TAGS = DataAccessorType.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"createrailwaysnavigator", (String)"get_all_stations_as_tags"), (DataAccessorType)DataAccessorType.Builder.createChunked((in, nbt) -> nbt.putBoolean("Data", in.booleanValue()), nbt -> nbt.getBoolean("Data"), (player, in, temp, nbt, iteration) -> {
        Queue tags;
        if (temp.getFirst() == null) {
            temp.setFirst(new ConcurrentLinkedQueue<StationTag>(TrainUtils.getAllStations().stream().filter(x -> in == false || !GlobalSettings.getInstance().isStationBlacklisted((GlobalStation)x)).map(x -> GlobalSettings.getInstance().getOrCreateStationTagFor((GlobalStation)x)).distinct().sorted((a, b) -> a.getTagName().get().compareToIgnoreCase(b.getTagName().get())).toList()));
        }
        if ((tags = (Queue)temp.getFirst()).isEmpty()) {
            return false;
        }
        for (int i = 0; i < 64 && !tags.isEmpty(); ++i) {
            nbt.put("Data" + i, (Tag)((StationTag)tags.poll()).toNbt());
        }
        return !tags.isEmpty();
    }, (hasMore, list, iteration, nbt) -> {
        if (list == null) {
            list = new ArrayList();
        }
        ArrayList l = list;
        nbt.getAllKeys().forEach(x -> l.add(StationTag.fromNbt(nbt.getCompound(x), null)));
        return l;
    }, chunks -> chunks));
    public static final DataAccessorType<Void, List<TrainCategory>, List<TrainCategory>> GET_ALL_TRAIN_CATEGORIES = DataAccessorType.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"createrailwaysnavigator", (String)"get_all_train_categories"), (DataAccessorType)DataAccessorType.Builder.createNoInputChunked((player, in, temp, nbt, iteration) -> {
        Queue tags;
        if (temp.getFirst() == null) {
            temp.setFirst(new ConcurrentLinkedQueue<TrainCategory>((Collection<TrainCategory>)GlobalSettings.getInstance().getAllTrainCategories()));
        }
        if ((tags = (Queue)temp.getFirst()).isEmpty()) {
            return false;
        }
        for (int i = 0; i < 64 && !tags.isEmpty(); ++i) {
            nbt.put("Data" + i, (Tag)((TrainCategory)tags.poll()).toNbt());
        }
        return !tags.isEmpty();
    }, (hasMore, list, iteration, nbt) -> {
        if (list == null) {
            list = new ArrayList();
        }
        ArrayList l = list;
        nbt.getAllKeys().forEach(x -> l.add(TrainCategory.fromNbt(nbt.getCompound(x))));
        return l;
    }, chunks -> chunks));
    public static final DataAccessorType<UUID, Void, Void> DELETE_TRAIN_CATEGORY = DataAccessorType.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"createrailwaysnavigator", (String)"delete_train_category"), (DataAccessorType)DataAccessorType.Builder.createEmptyResponse((in, nbt) -> nbt.putUUID("Data", in), nbt -> nbt.getUUID("Data"), (player, in, temp, nbt, iteration) -> {
        GlobalSettings.getInstance().getTrainCategory((UUID)in).ifPresent(x -> {
            if (!x.getOwner().isAllowed(new Owner(player)) || !GlobalSettings.modificationsAllowed(player)) {
                return;
            }
            GlobalSettings.getInstance().removeTrainCategory((UUID)in);
        });
        return false;
    }));
    public static final DataAccessorType<UUID, Optional<TrainCategory>, Optional<TrainCategory>> GET_TRAIN_CATEGORY = DataAccessorType.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"createrailwaysnavigator", (String)"get_train_category"), (DataAccessorType)DataAccessorType.Builder.create((in, nbt) -> nbt.putUUID("Data", in), nbt -> nbt.getUUID("Data"), (player, in, temp, nbt, iteration) -> {
        GlobalSettings.getInstance().getTrainCategory((UUID)in).ifPresent(x -> nbt.put("Data", (Tag)x.toNbt()));
        return false;
    }, (hasMore, data, iteration, nbt) -> Optional.ofNullable(nbt.contains("Data") ? TrainCategory.fromNbt(nbt.getCompound("Data")) : null)));
    public static final DataAccessorType<GlobalSettingsClient.UpdateTrainCategoryColorData, Void, Void> UPDATE_TRAIN_CATEGORY_COLOR = DataAccessorType.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"createrailwaysnavigator", (String)"update_train_category_color"), (DataAccessorType)DataAccessorType.Builder.createEmptyResponse((in, nbt) -> {
        nbt.putUUID("Id", in.id());
        nbt.putInt("Color", in.color());
    }, nbt -> new GlobalSettingsClient.UpdateTrainCategoryColorData(nbt.getUUID("Id"), nbt.getInt("Color")), (player, in, temp, nbt, iteration) -> {
        GlobalSettings.getInstance().getTrainCategory(in.id()).ifPresent(x -> {
            if (!x.getOwner().isAllowed(new Owner(player)) || !GlobalSettings.modificationsAllowed(player)) {
                return;
            }
            x.setColor(in.color());
        });
        return false;
    }));
    public static final DataAccessorType<GlobalSettingsClient.UpdateTrainCategoryNameData, Optional<TrainCategory>, Optional<TrainCategory>> UPDATE_TRAIN_CATEGORY_NAME = DataAccessorType.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"createrailwaysnavigator", (String)"update_train_category_name"), (DataAccessorType)DataAccessorType.Builder.create((in, nbt) -> {
        nbt.putUUID("Id", in.id());
        nbt.putString("Name", in.name());
    }, nbt -> new GlobalSettingsClient.UpdateTrainCategoryNameData(nbt.getUUID("Id"), nbt.getString("Name")), (player, in, temp, nbt, iteration) -> {
        GlobalSettings.getInstance().getTrainCategory(in.id()).ifPresent(x -> {
            if (!x.getOwner().isAllowed(new Owner(player)) || !GlobalSettings.modificationsAllowed(player)) {
                return;
            }
            x.setName(in.name());
            nbt.put("Data", (Tag)x.toNbt());
        });
        return false;
    }, (hasMore, data, iteration, nbt) -> Optional.ofNullable(nbt.contains("Data") ? TrainCategory.fromNbt(nbt.getCompound("Data")) : null)));
    public static final DataAccessorType<String, Optional<TrainCategory>, Optional<TrainCategory>> CREATE_TRAIN_CATEGORY = DataAccessorType.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"createrailwaysnavigator", (String)"create_train_category"), (DataAccessorType)DataAccessorType.Builder.create((in, nbt) -> nbt.putString("Data", in), nbt -> nbt.getString("Data"), (player, in, temp, nbt, iteration) -> {
        if (!GlobalSettings.modificationsAllowed(player)) {
            return false;
        }
        TrainCategory category = GlobalSettings.getInstance().createOrGetTrainCategory((String)in, new Owner(player));
        nbt.put("Data", (Tag)category.toNbt());
        return false;
    }, (hasMore, data, iteration, nbt) -> Optional.ofNullable(nbt.contains("Data") ? TrainCategory.fromNbt(nbt.getCompound("Data")) : null)));
    public static final DataAccessorType<Lock.PermissionsUpdateData, Optional<TrainCategory>, Optional<TrainCategory>> UPDATE_TRAIN_CATEGORY_PERMISSIONS = DataAccessorType.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"createrailwaysnavigator", (String)"update_train_category_permissions"), (DataAccessorType)DataAccessorType.Builder.create((in, nbt) -> nbt.put("Data", (Tag)in.toNbt()), nbt -> Lock.PermissionsUpdateData.fromNbt(nbt.getCompound("Data")), (player, in, temp, nbt, iteration) -> {
        GlobalSettings.getInstance().getTrainCategory(in.id()).ifPresent(tag -> {
            if (!tag.getOwner().isAdmin(new Owner(player)) || !GlobalSettings.modificationsAllowed(player)) {
                return;
            }
            if (in.state() != null) {
                tag.getOwner().set(in.state());
            }
            if (in.trusted() != null) {
                tag.getOwner().updateTrusted(in.trusted());
            }
            if (in.newOwner() != null) {
                tag.getOwner().setOwner(in.newOwner());
                tag.getOwner().addTrusted(new Owner(player));
            }
            nbt.put("Data", (Tag)tag.toNbt());
        });
        return false;
    }, (hasMore, data, iteration, nbt) -> Optional.ofNullable(nbt.contains("Data") ? TrainCategory.fromNbt(nbt.getCompound("Data")) : null)));
    public static final DataAccessorType<String, Collection<String>, Collection<String>> ADD_STATION_TO_BLACKLIST = DataAccessorType.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"createrailwaysnavigator", (String)"add_station_to_blacklist"), (DataAccessorType)DataAccessorType.Builder.createChunked((in, nbt) -> nbt.putString("Data", in), nbt -> nbt.getString("Data"), (player, in, temp, nbt, iteration) -> {
        if (!GlobalSettings.modificationsAllowed(player)) {
            return false;
        }
        if (temp.getFirst() == null) {
            GlobalSettings.getInstance().blacklistStation((String)in);
            temp.setFirst(new ConcurrentLinkedQueue<String>((Collection<String>)GlobalSettings.getInstance().getAllBlacklistedStations()));
        }
        Queue tags = (Queue)temp.getFirst();
        for (int i = 0; i < 256 && !tags.isEmpty(); ++i) {
            nbt.putString("Data" + i, (String)tags.poll());
        }
        return !tags.isEmpty();
    }, (hasMore, list, iteration, nbt) -> {
        if (list == null) {
            list = new ArrayList();
        }
        ArrayList l = list;
        nbt.getAllKeys().forEach(x -> l.add(nbt.getString(x)));
        return l;
    }, chunks -> chunks));
    public static final DataAccessorType<String, Collection<String>, Collection<String>> REMOVE_STATION_FROM_BLACKLIST = DataAccessorType.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"createrailwaysnavigator", (String)"remove_station_from_blacklist"), (DataAccessorType)DataAccessorType.Builder.createChunked((in, nbt) -> nbt.putString("Data", in), nbt -> nbt.getString("Data"), (player, in, temp, nbt, iteration) -> {
        if (!GlobalSettings.modificationsAllowed(player)) {
            return false;
        }
        if (temp.getFirst() == null) {
            GlobalSettings.getInstance().removeStationFromBlacklist((String)in);
            temp.setFirst(new ConcurrentLinkedQueue<String>((Collection<String>)GlobalSettings.getInstance().getAllBlacklistedStations()));
        }
        Queue tags = (Queue)temp.getFirst();
        for (int i = 0; i < 256 && !tags.isEmpty(); ++i) {
            nbt.putString("Data" + i, (String)tags.poll());
        }
        return !tags.isEmpty();
    }, (hasMore, list, iteration, nbt) -> {
        if (list == null) {
            list = new ArrayList();
        }
        ArrayList l = list;
        nbt.getAllKeys().forEach(x -> l.add(nbt.getString(x)));
        return l;
    }, chunks -> chunks));
    public static final DataAccessorType<Void, List<String>, List<String>> GET_BLACKLISTED_STATIONS = DataAccessorType.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"createrailwaysnavigator", (String)"get_blacklisted_stations"), (DataAccessorType)DataAccessorType.Builder.createNoInputChunked((player, in, temp, nbt, iteration) -> {
        if (temp.getFirst() == null) {
            temp.setFirst(new ConcurrentLinkedQueue<String>((Collection<String>)GlobalSettings.getInstance().getAllBlacklistedStations()));
        }
        Queue tags = (Queue)temp.getFirst();
        for (int i = 0; i < 256 && !tags.isEmpty(); ++i) {
            nbt.putString("Data" + i, (String)tags.poll());
        }
        return !tags.isEmpty();
    }, (hasMore, list, iteration, nbt) -> {
        if (list == null) {
            list = new ArrayList();
        }
        ArrayList l = list;
        nbt.getAllKeys().forEach(x -> l.add(nbt.getString(x)));
        return l;
    }, chunks -> chunks));
    public static final DataAccessorType<String, Collection<String>, Collection<String>> ADD_TRAIN_TO_BLACKLIST = DataAccessorType.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"createrailwaysnavigator", (String)"add_train_to_blacklist"), (DataAccessorType)DataAccessorType.Builder.createChunked((in, nbt) -> nbt.putString("Data", in), nbt -> nbt.getString("Data"), (player, in, temp, nbt, iteration) -> {
        if (!GlobalSettings.modificationsAllowed(player)) {
            return false;
        }
        if (temp.getFirst() == null) {
            GlobalSettings.getInstance().blacklistTrain((String)in);
            temp.setFirst(new ConcurrentLinkedQueue<String>((Collection<String>)GlobalSettings.getInstance().getAllBlacklistedTrains()));
        }
        Queue tags = (Queue)temp.getFirst();
        for (int i = 0; i < 256 && !tags.isEmpty(); ++i) {
            nbt.putString("Data" + i, (String)tags.poll());
        }
        return !tags.isEmpty();
    }, (hasMore, list, iteration, nbt) -> {
        if (list == null) {
            list = new ArrayList();
        }
        ArrayList l = list;
        nbt.getAllKeys().forEach(x -> l.add(nbt.getString(x)));
        return l;
    }, chunks -> chunks));
    public static final DataAccessorType<String, Collection<String>, Collection<String>> REMOVE_TRAIN_FROM_BLACKLIST = DataAccessorType.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"createrailwaysnavigator", (String)"remove_train_from_blacklist"), (DataAccessorType)DataAccessorType.Builder.createChunked((in, nbt) -> nbt.putString("Data", in), nbt -> nbt.getString("Data"), (player, in, temp, nbt, iteration) -> {
        if (!GlobalSettings.modificationsAllowed(player)) {
            return false;
        }
        if (temp.getFirst() == null) {
            GlobalSettings.getInstance().removeTrainFromBlacklist((String)in);
            temp.setFirst(new ConcurrentLinkedQueue<String>((Collection<String>)GlobalSettings.getInstance().getAllBlacklistedTrains()));
        }
        Queue tags = (Queue)temp.getFirst();
        for (int i = 0; i < 256 && !tags.isEmpty(); ++i) {
            nbt.putString("Data" + i, (String)tags.poll());
        }
        return !tags.isEmpty();
    }, (hasMore, list, iteration, nbt) -> {
        if (list == null) {
            list = new ArrayList();
        }
        ArrayList l = list;
        nbt.getAllKeys().forEach(x -> l.add(nbt.getString(x)));
        return l;
    }, chunks -> chunks));
    public static final DataAccessorType<Void, List<String>, List<String>> GET_BLACKLISTED_TRAINS = DataAccessorType.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"createrailwaysnavigator", (String)"get_blacklisted_trains"), (DataAccessorType)DataAccessorType.Builder.createNoInputChunked((player, in, temp, nbt, iteration) -> {
        if (temp.getFirst() == null) {
            temp.setFirst(new ConcurrentLinkedQueue<String>((Collection<String>)GlobalSettings.getInstance().getAllBlacklistedTrains()));
        }
        Queue tags = (Queue)temp.getFirst();
        for (int i = 0; i < 256 && !tags.isEmpty(); ++i) {
            nbt.putString("Data" + i, (String)tags.poll());
        }
        return !tags.isEmpty();
    }, (hasMore, list, iteration, nbt) -> {
        if (list == null) {
            list = new ArrayList();
        }
        ArrayList l = list;
        nbt.getAllKeys().forEach(x -> l.add(nbt.getString(x)));
        return l;
    }, chunks -> chunks));
    public static final DataAccessorType<UUID, ClientRoutePart.TrainRealTimeData, ClientRoutePart.TrainRealTimeData> UPDATE_REALTIME = DataAccessorType.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"createrailwaysnavigator", (String)"update_realtime"), (DataAccessorType)DataAccessorType.Builder.create((in, nbt) -> nbt.putUUID("Data", in), nbt -> nbt.getUUID("Data"), (player, in, temp, nbt, iteration) -> {
        TrainListener.getTrainData(in).ifPresent(data -> {
            List<TrainPrediction> predictions = data.getPredictions();
            HashMap<Integer, ClientTrainStop.TrainStopRealTimeData> values = new HashMap<Integer, ClientTrainStop.TrainStopRealTimeData>();
            for (TrainPrediction prediction : predictions) {
                ClientTrainStop.TrainStopRealTimeData realTimeData = new ClientTrainStop.TrainStopRealTimeData(prediction.getStationTag().getClientTag(prediction.getTargetedStationName()), prediction.getEntryIndex(), prediction.scheduled().arrivalTime(), prediction.scheduled().departureTime(), prediction.realTime().arrivalTime(), prediction.realTime().departureTime(), (int)prediction.realTime().arrivalIn(), prediction.getCurrentCycle());
                values.put(realTimeData.entryIndex(), realTimeData);
            }
            nbt.put("Data", (Tag)ClientRoutePart.TrainRealTimeData.createServer(data.getSessionId(), values, data.getStatus(), data.isCancelled()).toNbt());
        });
        return false;
    }, (hasMore, previousData, iteration, nbt) -> nbt.contains("Data") ? ClientRoutePart.TrainRealTimeData.fromNbt(nbt.getCompound("Data")) : null));
    public static final DataAccessorType<UUID, UserSettings, UserSettings> GET_USER_SETTINGS = DataAccessorType.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"createrailwaysnavigator", (String)"get_user_settings"), (DataAccessorType)DataAccessorType.Builder.create((in, nbt) -> nbt.putUUID("Data", in), nbt -> nbt.getUUID("Data"), (player, in, temp, nbt, iteration) -> {
        nbt.put("Data", (Tag)UserSettings.getSettingsFor(in, false).toNbt());
        nbt.putUUID("Id", in);
        return false;
    }, (hasMore, list, iteration, nbt) -> UserSettings.fromNbt(nbt.getCompound("Data"), nbt.getUUID("Id"), false)));
    public static final DataAccessorType<UserSettings, Void, Void> SAVE_USER_SETTINGS = DataAccessorType.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"createrailwaysnavigator", (String)"save_user_settings"), (DataAccessorType)DataAccessorType.Builder.createEmptyResponse((in, nbt) -> {
        nbt.put("Data", (Tag)in.toNbt());
        nbt.putUUID("Id", in.getOwnerId());
    }, nbt -> UserSettings.fromNbt(nbt.getCompound("Data"), nbt.getUUID("Id"), false), (player, in, temp, nbt, iteration) -> {
        in.save();
        return false;
    }));
    public static final DataAccessorType<BlockPos, NearestTrackStationResult, NearestTrackStationResult> GET_NEAREST_STATION = DataAccessorType.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"createrailwaysnavigator", (String)"get_nearest_station"), (DataAccessorType)DataAccessorType.Builder.create((in, nbt) -> {
        nbt.putInt("x", in.getX());
        nbt.putInt("y", in.getY());
        nbt.putInt("z", in.getZ());
    }, nbt -> new BlockPos(nbt.getInt("x"), nbt.getInt("y"), nbt.getInt("z")), (player, in, temp, nbt, iteration) -> {
        NearestTrackStationResult result = NearestTrackStationResult.empty();
        try {
            result = TrainUtils.getNearestTrackStation(player.level(), (Vec3i)in);
        }
        catch (Exception e) {
            CreateRailwaysNavigator.LOGGER.error("Error while trying to find nearest track station.", (Throwable)e);
            DLNetworkManager.sendToPlayer((ServerPlayer)((ServerPlayer)player), (BaseNetworkPacket)new ServerErrorPacket(e.getMessage()));
        }
        nbt.put("Data", (Tag)result.toNbt());
        return false;
    }, (hasMore, list, iteration, nbt) -> NearestTrackStationResult.fromNbt(nbt.getCompound("Data"))));
    public static final DataAccessorType<UUID, TrainDisplayData, TrainDisplayData> GET_TRAIN_DISPLAY_DATA_FROM_SERVER = DataAccessorType.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"createrailwaysnavigator", (String)"get_train_display_data"), (DataAccessorType)DataAccessorType.Builder.create((in, nbt) -> nbt.putUUID("Data", in), nbt -> nbt.getUUID("Data"), (player, in, temp, nbt, iteration) -> {
        Optional<Train> trainOpt = TrainUtils.getTrain(in);
        if (!trainOpt.isPresent() || !TrainUtils.isTrainUsable(trainOpt.get()) || GlobalSettings.getInstance().isTrainBlacklisted(trainOpt.get())) {
            nbt.put("Data", (Tag)TrainDisplayData.empty().toNbt());
            return false;
        }
        nbt.put("Data", (Tag)TrainDisplayData.of(trainOpt.get()).toNbt());
        return false;
    }, (hasMore, list, iteration, nbt) -> TrainDisplayData.fromNbt(nbt.getCompound("Data"))));
    public static final DataAccessorType<NextConnectionsRequestData, NextConnectionsDisplayData, NextConnectionsDisplayData> GET_NEXT_CONNECTIONS_DISPLAY_DATA = DataAccessorType.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"createrailwaysnavigator", (String)"get_next_connections_display_data"), (DataAccessorType)DataAccessorType.Builder.create((in, nbt) -> nbt.put("Data", (Tag)in.toNbt()), nbt -> NextConnectionsRequestData.fromNbt(nbt.getCompound("Data")), (player, in, temp, nbt, iteration) -> {
        nbt.put("Data", (Tag)NextConnectionsDisplayData.at(in.stationName(), in.selfTrainId()).toNbt());
        return false;
    }, (hasMore, list, iteration, nbt) -> NextConnectionsDisplayData.fromNbt(nbt.getCompound("Data"))));
    public static final DataAccessorType<Void, Collection<String>, Collection<String>> GET_ALL_TRAIN_NAMES = DataAccessorType.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"createrailwaysnavigator", (String)"get_all_train_names"), (DataAccessorType)DataAccessorType.Builder.createNoInputChunked((player, in, temp, nbt, iteration) -> {
        if (temp.getFirst() == null) {
            temp.setFirst(new ConcurrentLinkedQueue<String>(TrainUtils.getTrains(false).stream().map(x -> x.name.getString()).toList()));
        }
        Queue tags = (Queue)temp.getFirst();
        for (int i = 0; i < 256 && !tags.isEmpty(); ++i) {
            nbt.putString("Data" + i, (String)tags.poll());
        }
        return !tags.isEmpty();
    }, (hasMore, list, iteration, nbt) -> {
        if (list == null) {
            list = new ArrayList();
        }
        ArrayList l = list;
        nbt.getAllKeys().forEach(x -> l.add(nbt.getString(x)));
        return l;
    }, chunks -> chunks));
    public static final DataAccessorType<Void, Collection<String>, Collection<String>> GET_ALL_STATION_NAMES = DataAccessorType.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"createrailwaysnavigator", (String)"get_all_station_names"), (DataAccessorType)DataAccessorType.Builder.createNoInputChunked((player, in, temp, nbt, iteration) -> {
        if (temp.getFirst() == null) {
            temp.setFirst(new ConcurrentLinkedQueue<String>(TrainUtils.getAllStations().stream().map(x -> x.name).toList()));
        }
        Queue tags = (Queue)temp.getFirst();
        for (int i = 0; i < 256 && !tags.isEmpty(); ++i) {
            nbt.putString("Data" + i, (String)tags.poll());
        }
        return !tags.isEmpty();
    }, (hasMore, list, iteration, nbt) -> {
        if (list == null) {
            list = new ArrayList();
        }
        ArrayList l = list;
        nbt.getAllKeys().forEach(x -> l.add(nbt.getString(x)));
        return l;
    }, chunks -> chunks));
    public static final DataAccessorType<Void, List<TrainLine>, List<TrainLine>> GET_ALL_TRAIN_LINES = DataAccessorType.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"createrailwaysnavigator", (String)"get_all_train_lines"), (DataAccessorType)DataAccessorType.Builder.createNoInputChunked((player, in, temp, nbt, iteration) -> {
        Queue tags;
        if (temp.getFirst() == null) {
            temp.setFirst(new ConcurrentLinkedQueue<TrainLine>((Collection<TrainLine>)GlobalSettings.getInstance().getAllTrainLines()));
        }
        if ((tags = (Queue)temp.getFirst()).isEmpty()) {
            return false;
        }
        for (int i = 0; i < 256 && !tags.isEmpty(); ++i) {
            nbt.put("Data" + i, (Tag)((TrainLine)tags.poll()).toNbt());
        }
        return !tags.isEmpty();
    }, (hasMore, list, iteration, nbt) -> {
        if (list == null) {
            list = new ArrayList();
        }
        ArrayList l = list;
        nbt.getAllKeys().forEach(x -> l.add(TrainLine.fromNbt(nbt.getCompound(x))));
        return l;
    }, chunks -> chunks));
    public static final DataAccessorType<UUID, Void, Void> DELETE_TRAIN_LINE = DataAccessorType.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"createrailwaysnavigator", (String)"delete_train_line"), (DataAccessorType)DataAccessorType.Builder.createEmptyResponse((in, nbt) -> nbt.putUUID("Data", in), nbt -> nbt.getUUID("Data"), (player, in, temp, nbt, iteration) -> {
        GlobalSettings.getInstance().getTrainLine((UUID)in).ifPresent(x -> {
            if (!x.getOwner().isAllowed(new Owner(player)) || !GlobalSettings.modificationsAllowed(player)) {
                return;
            }
            GlobalSettings.getInstance().removeTrainLine((UUID)in);
        });
        return false;
    }));
    public static final DataAccessorType<UUID, Optional<TrainLine>, Optional<TrainLine>> GET_TRAIN_LINE = DataAccessorType.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"createrailwaysnavigator", (String)"get_train_line"), (DataAccessorType)DataAccessorType.Builder.create((in, nbt) -> nbt.putUUID("Data", in), nbt -> nbt.getUUID("Data"), (player, in, temp, nbt, iteration) -> {
        GlobalSettings.getInstance().getTrainLine((UUID)in).ifPresent(x -> nbt.put("Data", (Tag)x.toNbt()));
        return false;
    }, (hasMore, data, iteration, nbt) -> Optional.ofNullable(nbt.contains("Data") ? TrainLine.fromNbt(nbt.getCompound("Data")) : null)));
    public static final DataAccessorType<GlobalSettingsClient.UpdateTrainLineColorData, Void, Void> UPDATE_TRAIN_LINE_COLOR = DataAccessorType.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"createrailwaysnavigator", (String)"update_train_line_color"), (DataAccessorType)DataAccessorType.Builder.createEmptyResponse((in, nbt) -> {
        nbt.putUUID("Id", in.id());
        nbt.putInt("Color", in.color());
    }, nbt -> new GlobalSettingsClient.UpdateTrainLineColorData(nbt.getUUID("Id"), nbt.getInt("Color")), (player, in, temp, nbt, iteration) -> {
        GlobalSettings.getInstance().getTrainLine(in.id()).ifPresent(x -> {
            if (!x.getOwner().isAllowed(new Owner(player)) || !GlobalSettings.modificationsAllowed(player)) {
                return;
            }
            x.setColor(in.color());
        });
        return false;
    }));
    public static final DataAccessorType<GlobalSettingsClient.UpdateTrainLineNameData, Optional<TrainLine>, Optional<TrainLine>> UPDATE_TRAIN_LINE_NAME = DataAccessorType.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"createrailwaysnavigator", (String)"update_train_line_name"), (DataAccessorType)DataAccessorType.Builder.create((in, nbt) -> {
        nbt.putUUID("Id", in.id());
        nbt.putString("Name", in.name());
    }, nbt -> new GlobalSettingsClient.UpdateTrainLineNameData(nbt.getUUID("Id"), nbt.getString("Name")), (player, in, temp, nbt, iteration) -> {
        GlobalSettings.getInstance().getTrainLine(in.id()).ifPresent(x -> {
            if (!x.getOwner().isAllowed(new Owner(player)) || !GlobalSettings.modificationsAllowed(player)) {
                return;
            }
            x.setName(in.name());
            nbt.put("Data", (Tag)x.toNbt());
        });
        return false;
    }, (hasMore, data, iteration, nbt) -> Optional.ofNullable(nbt.contains("Data") ? TrainLine.fromNbt(nbt.getCompound("Data")) : null)));
    public static final DataAccessorType<String, Optional<TrainLine>, Optional<TrainLine>> CREATE_TRAIN_LINE = DataAccessorType.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"createrailwaysnavigator", (String)"create_train_line"), (DataAccessorType)DataAccessorType.Builder.create((in, nbt) -> nbt.putString("Data", in), nbt -> nbt.getString("Data"), (player, in, temp, nbt, iteration) -> {
        if (!GlobalSettings.modificationsAllowed(player)) {
            return false;
        }
        TrainLine line = GlobalSettings.getInstance().createOrGetTrainLine((String)in, new Owner(player));
        nbt.put("Data", (Tag)line.toNbt());
        return false;
    }, (hasMore, data, iteration, nbt) -> Optional.ofNullable(nbt.contains("Data") ? TrainLine.fromNbt(nbt.getCompound("Data")) : null)));
    public static final DataAccessorType<Lock.PermissionsUpdateData, Optional<TrainLine>, Optional<TrainLine>> UPDATE_TRAIN_LINE_PERMISSIONS = DataAccessorType.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"createrailwaysnavigator", (String)"update_train_line_permissions"), (DataAccessorType)DataAccessorType.Builder.create((in, nbt) -> nbt.put("Data", (Tag)in.toNbt()), nbt -> Lock.PermissionsUpdateData.fromNbt(nbt.getCompound("Data")), (player, in, temp, nbt, iteration) -> {
        GlobalSettings.getInstance().getTrainLine(in.id()).ifPresent(tag -> {
            if (!tag.getOwner().isAdmin(new Owner(player)) || !GlobalSettings.modificationsAllowed(player)) {
                return;
            }
            if (in.state() != null) {
                tag.getOwner().set(in.state());
            }
            if (in.trusted() != null) {
                tag.getOwner().updateTrusted(in.trusted());
            }
            if (in.newOwner() != null) {
                tag.getOwner().setOwner(in.newOwner());
                tag.getOwner().addTrusted(new Owner(player));
            }
            nbt.put("Data", (Tag)tag.toNbt());
        });
        return false;
    }, (hasMore, data, iteration, nbt) -> Optional.ofNullable(nbt.contains("Data") ? TrainLine.fromNbt(nbt.getCompound("Data")) : null)));
    public static final DataAccessorType<NavigationData, List<ClientRoute>, List<ClientRoute>> NAVIGATE = DataAccessorType.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"createrailwaysnavigator", (String)"navigate"), (DataAccessorType)DataAccessorType.Builder.createChunked((in, nbt) -> {
        nbt.putString("Start", in.start());
        nbt.putString("End", in.end());
        nbt.putUUID("Player", in.player());
    }, nbt -> new NavigationData(nbt.getString("Start"), nbt.getString("End"), nbt.getUUID("Player")), (player, in, temp, nbt, iteration) -> {
        try {
            Queue tags;
            if (temp.getFirst() == null) {
                GlobalSettings settings = GlobalSettings.getInstance();
                List<Route> routes = NavigatableGraph.searchRoutes(settings.getTagByName(TagName.of(in.start())).orElse(settings.getOrCreateStationTagFor(in.start())), settings.getTagByName(TagName.of(in.end())).orElse(settings.getOrCreateStationTagFor(in.end())), in.player(), true);
                temp.setFirst(new ConcurrentLinkedQueue<Route>(routes));
            }
            if ((tags = (Queue)temp.getFirst()).isEmpty()) {
                return false;
            }
            Route r = (Route)tags.poll();
            nbt.put("Data", (Tag)r.toNbt());
            return !tags.isEmpty();
        }
        catch (Exception e) {
            CreateRailwaysNavigator.LOGGER.error("Navigation error.", (Throwable)e);
            return false;
        }
    }, (hasMore, list, iteration, nbt) -> {
        if (!nbt.contains("Data")) {
            return List.of();
        }
        if (list == null) {
            list = new ArrayList<ClientRoute>();
        }
        list.add(ClientRoute.fromNbt(nbt.getCompound("Data"), true));
        return list;
    }, chunks -> chunks));
    public static final DataAccessorType<DepartureRoutesData, List<Pair<Boolean, ClientRoute>>, List<Pair<Boolean, ClientRoute>>> GET_DEPARTURE_AND_ARRIVAL_ROUTES_AT = DataAccessorType.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"createrailwaysnavigator", (String)"get_departure_and_arrival_routes_at"), (DataAccessorType)DataAccessorType.Builder.createChunked((in, nbt) -> {
        nbt.putString("Station", in.stationTagName());
        nbt.putUUID("Player", in.player());
    }, nbt -> new DepartureRoutesData(nbt.getString("Station"), nbt.getUUID("Player")), (player, in, temp, nbt, iteration) -> {
        try {
            Queue tags;
            if (temp.getFirst() == null) {
                UserSettings settings = UserSettings.getSettingsFor(in.player(), true);
                StationTag station = GlobalSettings.getInstance().getOrCreateStationTagFor(TagName.of(in.stationTagName()));
                Set<Train> trains = TrainUtils.getDepartingTrainsAt(station);
                trains.removeIf(x -> !TrainUtils.isTrainUsable(x) || GlobalSettings.getInstance().isTrainBlacklisted((Train)x) || !TrainListener.hasTrainData(x));
                LinkedList<Pair> routesL = new LinkedList<Pair>();
                for (Train train : trains) {
                    TrainData data = TrainListener.getTrainData(train.id).get();
                    List<TrainPrediction> matchingPredictions = data.getPredictionsChronologically();
                    for (int i = 0; i < matchingPredictions.size(); ++i) {
                        ScheduleSection section;
                        TrainPrediction prediction = matchingPredictions.get(i);
                        if (!prediction.getStationTag().equals(station) || !(section = prediction.getSection()).isUsable() && (!section.isFirstStop(prediction) || !section.previousSection().isUsable() || !section.previousSection().shouldIncludeNextStationOfNextSection()) || section.getTrainCategory().map(x -> settings.searchExcludedTrainCaegories.getValue().contains(x.getId())).orElse(false).booleanValue()) continue;
                        ScheduleSection previousSection = section.previousSection();
                        boolean isStart = section.isFirstStop(prediction);
                        boolean isLast = section.isFinalStop(prediction);
                        boolean isStartAndFinal = isStart && previousSection.isUsable() && previousSection.shouldIncludeNextStationOfNextSection() && previousSection.getTrainCategory().map(x -> !settings.searchExcludedTrainCaegories.getValue().contains(x.getId())).orElse(true) != false;
                        TrainStop stop = new TrainStop(prediction);
                        stop.simulateTicks(settings.searchDepartureInTicks.getValue().intValue());
                        TrainPrediction fromPrediction = section.getFirstStop().get();
                        TrainStop from = new TrainStop(fromPrediction);
                        Route route = new Route(List.of(new RoutePart(data.getSessionId(), train.id, List.of(stop, from), section.getAllStops(settings.searchDepartureInTicks.getValue().intValue(), prediction.getEntryIndex()))), false);
                        if ((!isStart || isStartAndFinal) && section.getTrainCategory().map(x -> !settings.searchExcludedTrainCaegories.getValue().contains(x.getId())).orElse(true).booleanValue()) {
                            Route selectedRoute = route;
                            if (isStartAndFinal) {
                                TrainPrediction frPred = previousSection.getFirstStop().get();
                                TrainStop fr = new TrainStop(frPred);
                                selectedRoute = new Route(List.of(new RoutePart(data.getSessionId(), train.id, List.of(stop, fr), previousSection.getAllStops(settings.searchDepartureInTicks.getValue().intValue(), prediction.getEntryIndex()))), false);
                            }
                            routesL.add(Pair.of((Object)true, (Object)selectedRoute));
                        }
                        if (!section.isUsable() || isLast && !section.shouldIncludeNextStationOfNextSection() || !section.getTrainCategory().map(x -> !settings.searchExcludedTrainCaegories.getValue().contains(x.getId())).orElse(true).booleanValue()) continue;
                        routesL.add(Pair.of((Object)false, (Object)route));
                    }
                }
                Collections.sort(routesL, (a, b) -> {
                    long val1 = (Boolean)a.getFirst() != false ? ((Route)a.getSecond()).getStart().getScheduledArrivalTime() : ((Route)a.getSecond()).getStart().getScheduledDepartureTime();
                    long val2 = (Boolean)b.getFirst() != false ? ((Route)b.getSecond()).getStart().getScheduledArrivalTime() : ((Route)b.getSecond()).getStart().getScheduledDepartureTime();
                    return Long.compare(val1, val2);
                });
                temp.setFirst(new ConcurrentLinkedQueue(routesL));
            }
            if ((tags = (Queue)temp.getFirst()).isEmpty()) {
                return false;
            }
            Pair r = (Pair)tags.poll();
            nbt.putBoolean("IsArrival", ((Boolean)r.getFirst()).booleanValue());
            nbt.put("Data", (Tag)((Route)r.getSecond()).toNbt());
            return !tags.isEmpty();
        }
        catch (Exception e) {
            CreateRailwaysNavigator.LOGGER.error("Schedule board generation error.", (Throwable)e);
            return false;
        }
    }, (hasMore, list, iteration, nbt) -> {
        if (!nbt.contains("Data")) {
            return List.of();
        }
        if (list == null) {
            list = new ArrayList<Pair>();
        }
        list.add(Pair.of((Object)nbt.getBoolean("IsArrival"), (Object)ClientRoute.fromNbt(nbt.getCompound("Data"), false)));
        return list;
    }, chunks -> chunks));
    public static final DataAccessorType<DeparturesData, List<ClientTrainStop>, List<ClientTrainStop>> GET_DEPARTURES_AT = DataAccessorType.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"createrailwaysnavigator", (String)"get_departures_at"), (DataAccessorType)DataAccessorType.Builder.create((in, nbt) -> {
        nbt.putUUID("Tag", in.stationTagId());
        nbt.putUUID("Train", in.trainId());
        nbt.putBoolean("RealTimeOnly", in.realTimeOnly());
    }, nbt -> new DeparturesData(nbt.getUUID("Tag"), nbt.getUUID("Train"), nbt.getBoolean("RealTimeOnly")), (player, in, temp, nbt, iteration) -> {
        try {
            if (!GlobalSettings.getInstance().stationTagExists(in.stationTagId())) {
                return false;
            }
            StationTag tag = GlobalSettings.getInstance().getStationTag(in.stationTagId()).get();
            ListTag list = new ListTag();
            for (TrainStop stop : TrainUtils.getDeparturesAt(tag, in.trainId(), in.realTimeOnly())) {
                list.add((Object)stop.toNbt(true));
            }
            nbt.put("Data", (Tag)list);
        }
        catch (Exception e) {
            CreateRailwaysNavigator.LOGGER.error("Next connections error.", (Throwable)e);
        }
        return false;
    }, (hasMore, data, iteration, nbt) -> nbt.contains("Data") ? nbt.getList("Data", 10).stream().map(x -> (ClientTrainStop)ClientTrainStop.fromNbt((CompoundTag)x)).toList() : List.of()));
    public static final DataAccessorType<Void, Boolean, Boolean> ALL_TRAINS_INITIALIZED = DataAccessorType.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"createrailwaysnavigator", (String)"all_trains_initialized"), (DataAccessorType)DataAccessorType.Builder.createNoInput((player, in, temp, nbt, iteration) -> {
        nbt.putBoolean("Data", TrainListener.allTrainsInitialized());
        return false;
    }, (hasMore, data, iteration, nbt) -> nbt.getBoolean("Data")));
    public static final DataAccessorType<Void, List<TrainDebugData>, List<TrainDebugData>> GET_ALL_TRAINS_DEBUG_DATA = DataAccessorType.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"createrailwaysnavigator", (String)"get_all_trains_debug_data"), (DataAccessorType)DataAccessorType.Builder.createNoInput((player, in, temp, nbt, iteration) -> {
        ListTag list = new ListTag();
        for (TrainData x : TrainListener.getAllTrainData()) {
            list.add((Object)TrainDebugData.fromTrain(x).toNbt());
        }
        nbt.put("Data", (Tag)list);
        return false;
    }, (hasMore, data, iteration, nbt) -> nbt.getList("Data", 10).stream().map(x -> TrainDebugData.fromNbt((CompoundTag)x)).toList()));
    public static final DataAccessorType<Void, Void, Void> SHOW_TRAIN_DEBUG_SCREEN = DataAccessorType.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"createrailwaysnavigator", (String)"show_train_debug_screen"), (DataAccessorType)DataAccessorType.Builder.createNoIO((player, in, temp, nbt, iteration) -> {
        ClientWrapper.showTrainDebugScreen();
        return false;
    }));
    public static final DataAccessorType<UUID, Void, Void> TRAIN_SOFT_RESET = DataAccessorType.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"createrailwaysnavigator", (String)"train_soft_reset"), (DataAccessorType)DataAccessorType.Builder.createEmptyResponse((in, nbt) -> nbt.putUUID("Data", in), nbt -> nbt.getUUID("Data"), (player, in, temp, nbt, iteration) -> {
        TrainListener.getTrainData(in).ifPresent(TrainData::softResetPredictions);
        return false;
    }));
    public static final DataAccessorType<UUID, Void, Void> TRAIN_HARD_RESET = DataAccessorType.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"createrailwaysnavigator", (String)"train_hard_reset"), (DataAccessorType)DataAccessorType.Builder.createEmptyResponse((in, nbt) -> nbt.putUUID("Data", in), nbt -> nbt.getUUID("Data"), (player, in, temp, nbt, iteration) -> {
        TrainListener.getTrainData(in).ifPresent(TrainData::hardResetPredictions);
        return false;
    }));
    public static final DataAccessorType<String, DepartureHistory.Stats, DepartureHistory.Stats> GET_STATION_DEPARTURE_HISTORY = DataAccessorType.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"createrailwaysnavigator", (String)"get_station_departure_history"), (DataAccessorType)DataAccessorType.Builder.create((in, nbt) -> nbt.putString("Data", in), nbt -> nbt.getString("Data"), (player, in, temp, nbt, iteration) -> {
        nbt.put("Data", (Tag)DepartureHistory.Stats.ofStation(in).toNbt());
        return false;
    }, (hasMore, data, iteration, nbt) -> DepartureHistory.Stats.fromNbt(nbt.getCompound("Data"))));
    public static final DataAccessorType<Void, List<Owner>, List<Owner>> GET_ONLINE_PLAYERS = DataAccessorType.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"createrailwaysnavigator", (String)"get_online_players"), (DataAccessorType)DataAccessorType.Builder.createNoInput((player, in, temp, nbt, iteration) -> {
        ListTag list = new ListTag();
        list.addAll(CRNPlatformSpecific.getAllKnownPlayers().entrySet().stream().map(e -> new Owner((UUID)e.getKey()).toNbt()).toList());
        nbt.put("Data", (Tag)list);
        return false;
    }, (hasMore, data, iteration, nbt) -> nbt.getList("Data", 10).stream().map(x -> Owner.fromNbt((CompoundTag)x)).sorted((a, b) -> a.name().compareToIgnoreCase(b.name())).toList()));

    public static void init() {
    }

    public record DeparturesData(UUID stationTagId, UUID trainId, boolean realTimeOnly) {
    }

    public record DepartureRoutesData(String stationTagName, UUID player) {
    }

    public record NavigationData(String start, String end, UUID player) {
    }
}

