/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data.storage;

import de.mrjulsen.crn.config.ModCommonConfig;
import de.mrjulsen.crn.data.StationTag;
import de.mrjulsen.crn.data.TrainCategory;
import de.mrjulsen.crn.data.TrainLine;
import de.mrjulsen.crn.registry.ModAccessorTypes;
import de.mrjulsen.crn.util.Lock;
import de.mrjulsen.crn.util.Owner;
import de.mrjulsen.mcdragonlib.util.accessor.DataAccessor;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;

public class GlobalSettingsClient {
    public static boolean modificationsAllowed() {
        return Minecraft.getInstance().player.hasPermissions(((Integer)ModCommonConfig.GLOBAL_SETTINGS_PERMISSION_LEVEL.get()).intValue());
    }

    public static void getStationTags(Consumer<Collection<StationTag>> result) {
        DataAccessor.getFromServer(null, ModAccessorTypes.GET_ALL_STATION_TAGS, result);
    }

    public static void getStationTag(String name, Consumer<StationTag> result) {
        DataAccessor.getFromServer((Object)name, ModAccessorTypes.GET_STATION_TAG, result);
    }

    public static void createStationTag(String name, Owner owner, Consumer<Optional<StationTag>> result) {
        DataAccessor.getFromServer((Object)new CreateStationTagData(name, owner), ModAccessorTypes.CREATE_STATION_TAG, result);
    }

    public static void registerNewStationTag(StationTag tag, Runnable callback) {
        DataAccessor.getFromServer((Object)tag, ModAccessorTypes.REGISTER_STATION_TAG, x -> callback.run());
    }

    public static void deleteStationTag(UUID tagId, Runnable callback) {
        DataAccessor.getFromServer((Object)tagId, ModAccessorTypes.DELETE_STATION_TAG, x -> callback.run());
    }

    public static void updateStationTagPermissions(Lock.PermissionsUpdateData data, Consumer<Optional<StationTag>> callback) {
        DataAccessor.getFromServer((Object)data, ModAccessorTypes.UPDATE_STATION_TAG_PERMISSIONS, x -> callback.accept((Optional<StationTag>)x));
    }

    public static void updateStationTagNameData(UUID tagId, String name, Runnable callback) {
        DataAccessor.getFromServer((Object)new UpdateStationTagNameData(tagId, name), ModAccessorTypes.UPDATE_STATION_TAG_NAME, x -> callback.run());
    }

    public static void addStationTagEntry(UUID tagId, String station, StationTag.StationInfo info, Consumer<Optional<StationTag>> callback) {
        DataAccessor.getFromServer((Object)new AddStationTagEntryData(tagId, station, info), ModAccessorTypes.ADD_STATION_TAG_ENTRY, callback);
    }

    public static void updateStationTagEntry(UUID tagId, String station, StationTag.StationInfo info, Consumer<Optional<StationTag>> callback) {
        DataAccessor.getFromServer((Object)new AddStationTagEntryData(tagId, station, info), ModAccessorTypes.UPDATE_STATION_TAG_ENTRY, callback);
    }

    public static void removeStationTagEntry(UUID tagId, String station, Consumer<Optional<StationTag>> callback) {
        DataAccessor.getFromServer((Object)new RemoveStationTagEntryData(tagId, station), ModAccessorTypes.REMOVE_STATION_TAG_ENTRY, callback);
    }

    public static void getTrainCategories(Consumer<List<TrainCategory>> result) {
        DataAccessor.getFromServer(null, ModAccessorTypes.GET_ALL_TRAIN_CATEGORIES, result);
    }

    public static void deleteTrainCategory(UUID id, Runnable callback) {
        DataAccessor.getFromServer((Object)id, ModAccessorTypes.DELETE_TRAIN_CATEGORY, x -> callback.run());
    }

    public static void getTrainCategory(UUID id, Runnable callback) {
        DataAccessor.getFromServer((Object)id, ModAccessorTypes.GET_TRAIN_CATEGORY, x -> callback.run());
    }

    public static void updateTrainCategoryColor(UUID id, int color, Runnable callback) {
        DataAccessor.getFromServer((Object)new UpdateTrainCategoryColorData(id, color), ModAccessorTypes.UPDATE_TRAIN_CATEGORY_COLOR, x -> callback.run());
    }

    public static void createTrainCategory(String name, Consumer<Optional<TrainCategory>> result) {
        DataAccessor.getFromServer((Object)name, ModAccessorTypes.CREATE_TRAIN_CATEGORY, result);
    }

    public static void updateTrainCategoryName(UUID id, String name, Consumer<Optional<TrainCategory>> callback) {
        DataAccessor.getFromServer((Object)new UpdateTrainCategoryNameData(id, name), ModAccessorTypes.UPDATE_TRAIN_CATEGORY_NAME, x -> callback.accept((Optional<TrainCategory>)x));
    }

    public static void updateTrainCategoryPermissions(Lock.PermissionsUpdateData data, Consumer<Optional<TrainCategory>> callback) {
        DataAccessor.getFromServer((Object)data, ModAccessorTypes.UPDATE_TRAIN_CATEGORY_PERMISSIONS, x -> callback.accept((Optional<TrainCategory>)x));
    }

    public static void getBlacklistedStations(Consumer<List<String>> result) {
        DataAccessor.getFromServer(null, ModAccessorTypes.GET_BLACKLISTED_STATIONS, result);
    }

    public static void addStationToBlacklist(String name, Consumer<Collection<String>> result) {
        DataAccessor.getFromServer((Object)name, ModAccessorTypes.ADD_STATION_TO_BLACKLIST, result);
    }

    public static void removeStationFromBlacklist(String name, Consumer<Collection<String>> result) {
        DataAccessor.getFromServer((Object)name, ModAccessorTypes.REMOVE_STATION_FROM_BLACKLIST, result);
    }

    public static void getBlacklistedTrains(Consumer<List<String>> result) {
        DataAccessor.getFromServer(null, ModAccessorTypes.GET_BLACKLISTED_TRAINS, result);
    }

    public static void addTrainToBlacklist(String name, Consumer<Collection<String>> result) {
        DataAccessor.getFromServer((Object)name, ModAccessorTypes.ADD_TRAIN_TO_BLACKLIST, result);
    }

    public static void removeTrainFromBlacklist(String name, Consumer<Collection<String>> result) {
        DataAccessor.getFromServer((Object)name, ModAccessorTypes.REMOVE_TRAIN_FROM_BLACKLIST, result);
    }

    public static void getTrainLines(Consumer<List<TrainLine>> result) {
        DataAccessor.getFromServer(null, ModAccessorTypes.GET_ALL_TRAIN_LINES, result);
    }

    public static void deleteTrainLine(UUID id, Runnable callback) {
        DataAccessor.getFromServer((Object)id, ModAccessorTypes.DELETE_TRAIN_LINE, x -> callback.run());
    }

    public static void updateTrainLineColor(UUID id, int color, Runnable callback) {
        DataAccessor.getFromServer((Object)new UpdateTrainLineColorData(id, color), ModAccessorTypes.UPDATE_TRAIN_LINE_COLOR, x -> callback.run());
    }

    public static void createTrainLine(String name, Consumer<Optional<TrainLine>> result) {
        DataAccessor.getFromServer((Object)name, ModAccessorTypes.CREATE_TRAIN_LINE, result);
    }

    public static void updateTrainLinePermissions(Lock.PermissionsUpdateData data, Consumer<Optional<TrainLine>> callback) {
        DataAccessor.getFromServer((Object)data, ModAccessorTypes.UPDATE_TRAIN_LINE_PERMISSIONS, x -> callback.accept((Optional<TrainLine>)x));
    }

    public static void updateTrainLineName(UUID id, String name, Consumer<Optional<TrainLine>> callback) {
        DataAccessor.getFromServer((Object)new UpdateTrainLineNameData(id, name), ModAccessorTypes.UPDATE_TRAIN_LINE_NAME, x -> callback.accept((Optional<TrainLine>)x));
    }

    public record CreateStationTagData(String name, Owner owner) {
    }

    public record UpdateStationTagNameData(UUID tagId, String name) {
    }

    public record AddStationTagEntryData(UUID tagId, String station, StationTag.StationInfo info) {
    }

    public record RemoveStationTagEntryData(UUID tagId, String station) {
    }

    public record UpdateTrainCategoryColorData(UUID id, int color) {
    }

    public record UpdateTrainCategoryNameData(UUID id, String name) {
    }

    public record UpdateTrainLineColorData(UUID id, int color) {
    }

    public record UpdateTrainLineNameData(UUID id, String name) {
    }
}

