/*
 * Decompiled with CFR 0.152.
 */
package dhj.ingameime;

import dhj.ingameime.ClientProxy;
import dhj.ingameime.Config;
import dhj.ingameime.IMStates;
import dhj.ingameime.IngameIME_Forge;
import dhj.ingameime.JEICompat;
import dhj.ingameime.mixins.MixinGuiScreen;
import ingameime.API;
import ingameime.CandidateListCallback;
import ingameime.CandidateListCallbackImpl;
import ingameime.CandidateListContext;
import ingameime.CandidateListState;
import ingameime.CommitCallback;
import ingameime.CommitCallbackImpl;
import ingameime.CompositionState;
import ingameime.IngameIME;
import ingameime.InputContext;
import ingameime.InputMode;
import ingameime.InputModeCallback;
import ingameime.InputModeCallbackImpl;
import ingameime.PreEditCallback;
import ingameime.PreEditCallbackImpl;
import ingameime.PreEditContext;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.fml.common.Loader;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.Display;

public class Internal {
    public static boolean LIBRARY_LOADED = false;
    public static InputContext InputCtx = null;
    static PreEditCallbackImpl preEditCallbackProxy = null;
    static CommitCallbackImpl commitCallbackProxy = null;
    static CandidateListCallbackImpl candidateListCallbackProxy = null;
    static InputModeCallbackImpl inputModeCallbackProxy = null;
    static PreEditCallback preEditCallback = null;
    static CommitCallback commitCallback = null;
    static CandidateListCallback candidateListCallback = null;
    static InputModeCallback inputModeCallback = null;

    private static void tryLoadLibrary(String libName) {
        if (!LIBRARY_LOADED) {
            try {
                InputStream lib = IngameIME.class.getClassLoader().getResourceAsStream(libName);
                if (lib == null) {
                    throw new RuntimeException("Required library resource not exist!");
                }
                Path path = Files.createTempFile("IngameIME-Native", null, new FileAttribute[0]);
                Files.copy(lib, path, StandardCopyOption.REPLACE_EXISTING);
                System.load(path.toString());
                LIBRARY_LOADED = true;
                IngameIME_Forge.LOG.info("Library [{}] has loaded!", (Object)libName);
            }
            catch (Throwable e) {
                IngameIME_Forge.LOG.warn("Try to load library [{}] but failed: {}", (Object)libName, (Object)e.getClass().getSimpleName());
            }
        } else {
            IngameIME_Forge.LOG.info("Library has loaded, skip loading of [{}]", (Object)libName);
        }
    }

    private static long getWindowHandle_LWJGL3() {
        try {
            Method getWindow = Display.class.getMethod("getWindow", new Class[0]);
            Class<?> NativeWin32 = Class.forName("org.lwjgl.glfw.GLFWNativeWin32");
            long glfwWindow = (Long)getWindow.invoke(null, new Object[0]);
            Method glfwGetWin32Window = NativeWin32.getMethod("glfwGetWin32Window", Long.TYPE);
            return (Long)glfwGetWin32Window.invoke(null, glfwWindow);
        }
        catch (Throwable e) {
            IngameIME_Forge.LOG.error("Failed to get window handle", e);
            return 0L;
        }
    }

    private static long getWindowHandle_LWJGL2() {
        try {
            Method getImplementation = Display.class.getDeclaredMethod("getImplementation", new Class[0]);
            getImplementation.setAccessible(true);
            Object impl = getImplementation.invoke(null, new Object[0]);
            Class<?> clsWindowsDisplay = Class.forName("org.lwjgl.opengl.WindowsDisplay");
            Method getHwnd = clsWindowsDisplay.getDeclaredMethod("getHwnd", new Class[0]);
            getHwnd.setAccessible(true);
            return (Long)getHwnd.invoke(impl, new Object[0]);
        }
        catch (Throwable e) {
            IngameIME_Forge.LOG.error("Failed to get window handle", e);
            return 0L;
        }
    }

    public static void destroyInputCtx() {
        if (InputCtx != null) {
            InputCtx.delete();
            InputCtx = null;
            IngameIME_Forge.LOG.info("InputContext has destroyed!");
        }
    }

    public static void createInputCtx() {
        long hWnd;
        if (!LIBRARY_LOADED) {
            return;
        }
        IngameIME_Forge.LOG.info("Using IngameIME-Native: {}", (Object)InputContext.getVersion());
        long l = hWnd = Loader.isModLoaded((String)"cleanroom") ? Internal.getWindowHandle_LWJGL3() : Internal.getWindowHandle_LWJGL2();
        if (hWnd != 0L) {
            if (Minecraft.func_71410_x().func_71372_G()) {
                Config.UiLess_Windows.set(true);
            }
        } else {
            IngameIME_Forge.LOG.error("InputContext could not init as the hWnd is NULL!");
            return;
        }
        API api = Config.API_Windows.getString().equals("TextServiceFramework") ? API.TextServiceFramework : API.Imm32;
        IngameIME_Forge.LOG.info("Using API: {}, UiLess: {}", (Object)api, (Object)Config.UiLess_Windows.getBoolean());
        InputCtx = IngameIME.CreateInputContextWin32(hWnd, api, Config.UiLess_Windows.getBoolean());
        IngameIME_Forge.LOG.info("InputContext has created!");
        preEditCallbackProxy = new PreEditCallbackImpl(){

            @Override
            protected void call(CompositionState arg0, PreEditContext arg1) {
                try {
                    IngameIME_Forge.LOG.info("PreEdit State: {}", (Object)arg0);
                    if (arg0 == CompositionState.Begin) {
                        ClientProxy.Screen.WInputMode.setActive(false);
                    }
                    if (arg1 != null) {
                        ClientProxy.Screen.PreEdit.setContent(arg1.getContent(), arg1.getSelStart());
                    } else {
                        ClientProxy.Screen.PreEdit.setContent(null, -1);
                    }
                }
                catch (Throwable e) {
                    IngameIME_Forge.LOG.error("Exception thrown during callback handling", e);
                }
            }
        };
        preEditCallback = new PreEditCallback(preEditCallbackProxy);
        commitCallbackProxy = new CommitCallbackImpl(){

            @Override
            protected void call(String text) {
                try {
                    Minecraft.func_71410_x().func_152344_a(() -> {
                        try {
                            if (Loader.isModLoaded((String)"jei") && IMStates.ActiveControl != null && IMStates.ActiveControl.getClass().getName().equals("mezz.jei.input.GuiTextFieldFilter")) {
                                IngameIME_Forge.LOG.info("JEI text field detected, using JEI API to set text.");
                                String oldText = JEICompat.getJEIFilterText();
                                JEICompat.setJEIFilterText(oldText + text);
                            } else {
                                GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
                                if (screen != null) {
                                    for (char c : text.toCharArray()) {
                                        ((MixinGuiScreen)screen).callKeyTyped(c, 0);
                                    }
                                }
                            }
                        }
                        catch (Throwable e) {
                            IngameIME_Forge.LOG.error("Exception thrown during scheduled commit task", e);
                        }
                    });
                }
                catch (Throwable e) {
                    IngameIME_Forge.LOG.error("Exception thrown when scheduling commit callback", e);
                }
            }
        };
        commitCallback = new CommitCallback(commitCallbackProxy);
        candidateListCallbackProxy = new CandidateListCallbackImpl(){

            @Override
            protected void call(CandidateListState arg0, CandidateListContext arg1) {
                try {
                    if (arg1 != null) {
                        ClientProxy.Screen.CandidateList.setContent(new ArrayList<String>(arg1.getCandidates()), arg1.getSelection());
                    } else {
                        ClientProxy.Screen.CandidateList.setContent(null, -1);
                    }
                }
                catch (Throwable e) {
                    IngameIME_Forge.LOG.error("Exception thrown during callback handling", e);
                }
            }
        };
        candidateListCallback = new CandidateListCallback(candidateListCallbackProxy);
        inputModeCallbackProxy = new InputModeCallbackImpl(){

            @Override
            protected void call(InputMode arg0) {
                try {
                    ClientProxy.Screen.WInputMode.setMode(arg0);
                }
                catch (Throwable e) {
                    IngameIME_Forge.LOG.error("Exception thrown during callback handling", e);
                }
            }
        };
        inputModeCallback = new InputModeCallback(inputModeCallbackProxy);
        InputCtx.setCallback(preEditCallback);
        InputCtx.setCallback(commitCallback);
        InputCtx.setCallback(candidateListCallback);
        InputCtx.setCallback(inputModeCallback);
        System.gc();
    }

    static void loadLibrary() {
        boolean isWindows;
        boolean bl = isWindows = LWJGLUtil.getPlatform() == 3;
        if (!isWindows) {
            IngameIME_Forge.LOG.info("Unsupported platform: {}", (Object)LWJGLUtil.getPlatformName());
            return;
        }
        Internal.tryLoadLibrary("IngameIME_Java-arm64.dll");
        Internal.tryLoadLibrary("IngameIME_Java-x64.dll");
        Internal.tryLoadLibrary("IngameIME_Java-x86.dll");
        if (!LIBRARY_LOADED) {
            IngameIME_Forge.LOG.error("Unsupported arch: {}", (Object)System.getProperty("os.arch"));
        }
    }

    public static boolean getActivated() {
        if (InputCtx != null) {
            return InputCtx.getActivated();
        }
        return false;
    }

    public static void setActivated(boolean activated) {
        if (InputCtx != null && Internal.getActivated() != activated) {
            InputCtx.setActivated(activated);
            IngameIME_Forge.LOG.info("IM active state: {}", (Object)activated);
        }
    }
}

