/*
 * Decompiled with CFR 0.152.
 */
package com.dhj.ingameime;

import com.dhj.ingameime.ClientProxy;
import com.dhj.ingameime.IMStates;
import com.dhj.ingameime.IngameIME_Forge;
import com.dhj.ingameime.Internal;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class FluxCompat {
    private boolean isFluxLoaded = Loader.isModLoaded((String)"fluxnetworks");
    private Class<?> guiFluxCoreClass;
    private Class<?> fluxTextFieldClass;
    private Field isFocusedField;
    private Field fontRendererField;
    private Field xField;
    private Field yField;
    private Field heightField;
    private Method getTextMethod;
    private Method getCursorPositionMethod;
    private Method getWidthMethod;

    public FluxCompat() {
        if (this.isFluxLoaded) {
            try {
                this.guiFluxCoreClass = Class.forName("sonar.fluxnetworks.client.gui.basic.GuiFluxCore");
                this.fluxTextFieldClass = Class.forName("sonar.fluxnetworks.client.gui.basic.GuiTextField");
                this.isFocusedField = this.fluxTextFieldClass.getDeclaredField("isFocused");
                this.isFocusedField.setAccessible(true);
                this.fontRendererField = this.fluxTextFieldClass.getDeclaredField("fontRenderer");
                this.fontRendererField.setAccessible(true);
                this.xField = this.fluxTextFieldClass.getDeclaredField("x");
                this.xField.setAccessible(true);
                this.yField = this.fluxTextFieldClass.getDeclaredField("y");
                this.yField.setAccessible(true);
                this.heightField = this.fluxTextFieldClass.getDeclaredField("height");
                this.heightField.setAccessible(true);
                this.getTextMethod = this.fluxTextFieldClass.getMethod("getText", new Class[0]);
                this.getCursorPositionMethod = this.fluxTextFieldClass.getMethod("getCursorPosition", new Class[0]);
                this.getWidthMethod = this.fluxTextFieldClass.getMethod("getWidth", new Class[0]);
                IngameIME_Forge.LOG.info("Flux Networks compatibility module initialized successfully.");
            }
            catch (Exception e) {
                IngameIME_Forge.LOG.error("Failed to find Flux Networks classes/fields, compatibility module disabled.", (Throwable)e);
                this.isFluxLoaded = false;
            }
        }
    }

    @SubscribeEvent
    public void onGuiDraw(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (!this.isFluxLoaded) {
            return;
        }
        GuiScreen gui = event.getGui();
        Object activeTextField = null;
        if (this.guiFluxCoreClass.isInstance(gui)) {
            for (Class<?> currentClass = gui.getClass(); currentClass != null && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
                for (Field field : currentClass.getDeclaredFields()) {
                    if (!this.fluxTextFieldClass.isAssignableFrom(field.getType())) continue;
                    try {
                        boolean isFocused;
                        field.setAccessible(true);
                        Object textFieldObj = field.get(gui);
                        if (textFieldObj == null || !(isFocused = ((Boolean)this.isFocusedField.get(textFieldObj)).booleanValue())) continue;
                        activeTextField = textFieldObj;
                        FontRenderer fontRenderer = (FontRenderer)this.fontRendererField.get(textFieldObj);
                        int x = this.xField.getInt(textFieldObj);
                        int y = this.yField.getInt(textFieldObj);
                        int height = this.heightField.getInt(textFieldObj);
                        String text = (String)this.getTextMethod.invoke(textFieldObj, new Object[0]);
                        int cursorPosition = (Integer)this.getCursorPositionMethod.invoke(textFieldObj, new Object[0]);
                        int width = (Integer)this.getWidthMethod.invoke(textFieldObj, new Object[0]);
                        String textBeforeCursor = text.substring(0, cursorPosition);
                        String trimmedText = fontRenderer.func_78269_a(textBeforeCursor, width);
                        int cursorX = x + 4 + fontRenderer.func_78256_a(trimmedText);
                        int cursorY = y + (height - 8) / 2 + fontRenderer.field_78288_b + 2;
                        ClientProxy.Screen.setCaretPos(cursorX, cursorY);
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (activeTextField != null) break;
            }
        }
        if (activeTextField != null) {
            if (IMStates.ActiveControl != activeTextField) {
                IMStates.ActiveControl = activeTextField;
                Internal.setActivated(true);
            }
        } else if (this.fluxTextFieldClass.isInstance(IMStates.ActiveControl)) {
            IMStates.ActiveControl = null;
            Internal.setActivated(false);
        }
    }
}

