/*
 * Decompiled with CFR 0.152.
 */
package com.dhj.ingameime;

import com.dhj.ingameime.ClientProxy;
import com.dhj.ingameime.Config;
import com.dhj.ingameime.IMEventHandler;
import com.dhj.ingameime.IngameIME_Forge;
import com.dhj.ingameime.Internal;
import com.dhj.ingameime.control.IControl;
import com.dhj.ingameime.control.NoControl;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiEditSign;

public enum IMStates implements IMEventHandler
{
    Disabled{

        @Override
        public IMStates onScreenOpen(@Nullable GuiScreen screen) {
            if (screen instanceof GuiEditSign) {
                Internal.setActivated(true);
                return OpenedInternal;
            }
            return this;
        }

        @Override
        public IMStates onControlFocus(@Nonnull IControl control, boolean focused, boolean isOverlay) {
            if (focused) {
                1.setControl(control, isOverlay);
                IngameIME_Forge.LOG.info("Opened by control focus: {}", (Object)control.getClass().getSimpleName());
                Internal.setActivated(true);
                return OpenedAuto;
            }
            return this;
        }

        @Override
        public IMStates onToggleKey() {
            IngameIME_Forge.LOG.info("Turned on by toggle key");
            Internal.setActivated(true);
            return OpenedManual;
        }
    }
    ,
    OpenedInternal{

        @Override
        public void onLeaveState() {
            NoControl.NO_CONTROL.setCursorX(0);
            NoControl.NO_CONTROL.setCursorY(0);
        }
    }
    ,
    OpenedManual{

        @Override
        public IMStates onMouseMove() {
            if (!Config.TurnOffOnMouseMove.getBoolean()) {
                return this;
            }
            Internal.setActivated(false);
            IngameIME_Forge.LOG.info("Turned off by mouse move");
            return Disabled;
        }
    }
    ,
    OpenedAuto{

        @Override
        public IMStates onControlFocus(@Nonnull IControl control, boolean focused, boolean isOverlay) {
            boolean changed;
            Object object = control.getControlObject();
            boolean bl = changed = !4.isControlObject(object, isOverlay);
            if (!focused) {
                if (!changed) {
                    Internal.setActivated(false);
                    4.setControl(NoControl.NO_CONTROL, isOverlay);
                    if (IMStates.getActiveControl() != NoControl.NO_CONTROL) {
                        Internal.setActivated(true);
                        IngameIME_Forge.LOG.info("Focus changed from Overlay {} to Common {}", (Object)control.getClass().getSimpleName(), (Object)IMStates.getActiveControl().getClass().getSimpleName());
                        return this;
                    }
                    IngameIME_Forge.LOG.info("Turned off by losing control focus: {}", (Object)control.getClass().getSimpleName());
                    return Disabled;
                }
                return this;
            }
            if (changed) {
                Internal.setActivated(false);
            }
            4.setControl(control, isOverlay);
            if (changed) {
                IngameIME_Forge.LOG.info("Opened by control focus: {}", (Object)control.getClass().getSimpleName());
            }
            Internal.setActivated(true);
            ClientProxy.Screen.WInputMode.setActive(true);
            return this;
        }
    };

    @Nonnull
    private static IControl CommonControl;
    @Nonnull
    private static IControl OverlayControl;

    @Override
    public IMStates onControlFocus(@Nonnull IControl control, boolean focused, boolean isOverlay) {
        if (focused) {
            IMStates.setControl(control, isOverlay);
        } else if (IMStates.isControlObject(control.getControlObject(), isOverlay)) {
            IMStates.setControl(NoControl.NO_CONTROL, isOverlay);
        }
        return this;
    }

    @Override
    public IMStates onScreenClose() {
        Internal.setActivated(false);
        IMStates.setControl(NoControl.NO_CONTROL, false);
        IMStates.setControl(NoControl.NO_CONTROL, true);
        return Disabled;
    }

    @Override
    public IMStates onScreenOpen(GuiScreen screen) {
        return this;
    }

    @Override
    public IMStates onMouseMove() {
        return this;
    }

    @Override
    public IMStates onToggleKey() {
        IngameIME_Forge.LOG.info("Turned off by toggle key");
        Internal.setActivated(false);
        return Disabled;
    }

    public static void setControl(@Nonnull IControl control, boolean isOverlay) {
        if (isOverlay) {
            OverlayControl = control;
        } else {
            CommonControl = control;
        }
    }

    public static boolean isControlObject(Object controlObject, boolean isOverlay) {
        return isOverlay ? OverlayControl.getControlObject() == controlObject : CommonControl.getControlObject() == controlObject;
    }

    @Nonnull
    public static IControl getActiveControl() {
        IMEventHandler eventHandler = ClientProxy.getIMEventHandler();
        return eventHandler == OpenedManual || eventHandler == OpenedInternal ? NoControl.NO_CONTROL : (OverlayControl == NoControl.NO_CONTROL ? CommonControl : OverlayControl);
    }

    static {
        CommonControl = NoControl.NO_CONTROL;
        OverlayControl = NoControl.NO_CONTROL;
    }
}

