/*
 * Decompiled with CFR 0.152.
 */
package com.dhj.ingameime.control;

import com.dhj.ingameime.control.IControl;
import com.dhj.ingameime.mixins.vanilla.AccessorGuiScreen;
import java.io.IOException;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;

public abstract class AbstractControl<T>
implements IControl {
    protected final T controlObject;

    public AbstractControl(T controlObject) {
        this.controlObject = controlObject;
    }

    public T getControlObject() {
        return this.controlObject;
    }

    @Override
    public void writeText(String text) throws IOException {
        AbstractControl.writeCurrentScreenText(text);
    }

    public static void writeCurrentScreenText(String text) throws IOException {
        GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
        if (screen != null) {
            for (char c : text.toCharArray()) {
                ((AccessorGuiScreen)screen).callKeyTyped(c, 0);
            }
        }
    }

    protected static int getCursorX(@Nonnull FontRenderer font, @Nonnull String text, int x, int width, int lineScrollOffset, int cursorPosition, int selectionEnd, boolean enableBackgroundDrawing) {
        int currentDrawX;
        String visibleText = font.func_78269_a(text.substring(lineScrollOffset), width);
        int cursorPosRelative = cursorPosition - lineScrollOffset;
        int selectionEndRelative = selectionEnd - lineScrollOffset;
        int n = currentDrawX = enableBackgroundDrawing ? x + 4 : x;
        if (selectionEndRelative > visibleText.length()) {
            selectionEndRelative = visibleText.length();
        }
        if (!visibleText.isEmpty()) {
            if (selectionEndRelative != cursorPosRelative) {
                return currentDrawX;
            }
            String rawTextBeforeCursor = visibleText.substring(0, cursorPosRelative);
            currentDrawX += font.func_78256_a(rawTextBeforeCursor);
        }
        return currentDrawX - 1;
    }

    protected static int getCursorY(int y, int height, boolean enableBackgroundDrawing) {
        return (enableBackgroundDrawing ? y + (height - 8) / 2 : y) - 1;
    }
}

