/*
 * Decompiled with CFR 0.152.
 */
package com.dhj.ingameime.gui;

import com.dhj.ingameime.gui.Widget;
import java.util.List;
import net.minecraft.client.Minecraft;

public class WidgetCandidateList
extends Widget {
    private final CandidateEntry drawItem = new CandidateEntry();
    private List<String> Candidates = null;
    private int Selected = -1;

    WidgetCandidateList() {
        this.Padding = 3;
        this.DrawInline = false;
    }

    public void setContent(List<String> candidates, int selected) {
        this.Candidates = candidates;
        this.Selected = selected;
        this.isDirty = true;
    }

    @Override
    public boolean isActive() {
        return this.Candidates != null && !this.Candidates.isEmpty();
    }

    @Override
    public void layout() {
        if (!this.isDirty) {
            return;
        }
        this.Width = 0;
        this.Height = 0;
        if (!this.isActive()) {
            this.isDirty = false;
            return;
        }
        this.Height = this.drawItem.getTotalHeight();
        int total = 0;
        int index = 1;
        for (String s : this.Candidates) {
            this.drawItem.setIndex(index++);
            this.drawItem.setText(s);
            total += this.drawItem.getTotalWidth();
        }
        this.Width = total;
        super.layout();
    }

    @Override
    public void draw() {
        if (!this.isActive()) {
            return;
        }
        if (this.isDirty) {
            this.layout();
        }
        super.draw();
        int drawX = this.X + this.Padding;
        int drawY = this.Y + this.Padding;
        int index = 1;
        for (String s : this.Candidates) {
            boolean isSelected;
            this.drawItem.setIndex(index++);
            this.drawItem.setText(s);
            boolean bl = isSelected = index - 1 == this.Selected + 1;
            if (isSelected) {
                int entryWidth = this.drawItem.getTotalWidth();
                WidgetCandidateList.func_73734_a((int)drawX, (int)this.Y, (int)(drawX + entryWidth), (int)(this.Y + this.Height + this.Padding * 2), (int)-336860181);
            }
            this.drawItem.draw(drawX, drawY, this.TextColor);
            drawX += this.drawItem.getTotalWidth();
        }
    }

    private static final class CandidateEntry {
        private final Minecraft mc = Minecraft.func_71410_x();
        private String text = null;
        private int index = 0;

        private CandidateEntry() {
        }

        private int getIndexAreaWidth() {
            return this.mc.field_71466_p.func_78256_a("00") + 5;
        }

        void setText(String text) {
            this.text = text;
        }

        void setIndex(int index) {
            this.index = index;
        }

        int getTextWidth() {
            return this.mc.field_71466_p.func_78256_a(this.text);
        }

        int getContentHeight() {
            return this.mc.field_71466_p.field_78288_b;
        }

        int getTotalWidth() {
            return 2 + this.getIndexAreaWidth() + this.getTextWidth() + 2;
        }

        int getTotalHeight() {
            return this.getContentHeight();
        }

        void draw(int x, int y, int textColor) {
            int offsetX = x + 2;
            int baselineY = y;
            String idx = Integer.toString(this.index);
            int indexAreaW = this.getIndexAreaWidth();
            int idxTextW = this.mc.field_71466_p.func_78256_a(idx);
            int centeredX = offsetX + (indexAreaW - idxTextW) / 2;
            this.mc.field_71466_p.func_78276_b(idx, centeredX, baselineY, -11184811);
            this.mc.field_71466_p.func_78276_b(this.text, offsetX += indexAreaW, baselineY, textColor);
        }
    }
}

