/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.elements;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.client.ClientUtils;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuBar;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuButton;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuButtonBase;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.handler.InputHandler;
import online.kingdomkeys.kingdomkeys.util.Utils;
import org.jetbrains.annotations.NotNull;

public class MenuBackground
extends Screen {
    int selected;
    String tip = null;
    Color color;
    protected Component title;
    public boolean shouldCloseOnMenu;
    public boolean drawPlayerInfo;
    public MenuBar bottomLeftBar;
    public MenuBar bottomRightBar;
    public MenuBar topLeftBar;
    public MenuBar topRightBar;
    public static float tooltipPosX;
    public static float tooltipPosY;
    protected float topBarHeight = (float)this.f_96544_ * 0.17f;
    protected float bottomBarHeight;
    protected float topLeftBarWidth;
    protected float topRightBarWidth;
    protected float topGap;
    protected float bottomLeftBarWidth;
    protected float bottomRightBarWidth;
    protected float bottomGap;
    protected float middleHeight;
    public boolean drawSeparately = false;
    protected float buttonPosX;
    protected int buttonPosY;
    protected float buttonWidth;
    public static final ResourceLocation menu;

    public MenuBackground(String name, Color rgb) {
        super((Component)Component.m_237115_((String)name));
        this.f_96541_ = Minecraft.m_91087_();
        this.selected = -1;
        this.color = rgb;
        this.title = this.f_96539_;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (super.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (InputHandler.Keybinds.OPENMENU.getKeybind().isActiveAndMatches(mouseKey) && this.shouldCloseOnMenu) {
            Minecraft mc = Minecraft.m_91087_();
            mc.f_91073_.m_5594_((Player)mc.f_91074_, mc.f_91074_.m_20183_(), (SoundEvent)ModSounds.menu_back.get(), SoundSource.MASTER, 1.0f, 1.0f);
            this.m_7379_();
            return true;
        }
        return false;
    }

    public Component m_96636_() {
        return this.title;
    }

    public void drawMenuBackground(GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        this.drawBars(gui);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawMunnyTime(gui);
        this.drawBiomeDim(gui);
        this.drawTip(gui);
        gui.m_280168_().m_85836_();
        gui.m_280168_().m_85841_(1.3f, 1.3f, 1.0f);
        gui.m_280488_(this.f_96541_.f_91062_, Utils.translateToLocal(this.m_96636_().getString(), new Object[0]), 2, 10, 0xFF9900);
        gui.m_280168_().m_85849_();
    }

    public void m_88315_(@NotNull GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        if (!this.drawSeparately) {
            this.drawMenuBackground(gui, mouseX, mouseY, partialTicks);
        }
        super.m_88315_(gui, mouseX, mouseY, partialTicks);
    }

    private void clearButtons() {
        for (Renderable btn : this.f_169369_) {
            if (!(btn instanceof MenuButtonBase)) continue;
            ((MenuButtonBase)btn).setSelected(false);
        }
    }

    public void drawBars(GuiGraphics gui) {
        this.m_280273_(gui);
        int sh = Minecraft.m_91087_().m_91268_().m_85446_();
        int sw = Minecraft.m_91087_().m_91268_().m_85445_();
        float r = (float)this.color.getRed() / 255.0f;
        float g = (float)this.color.getGreen() / 255.0f;
        float b = (float)this.color.getBlue() / 255.0f;
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
        RenderSystem.enableBlend();
        PoseStack matrixStack = gui.m_280168_();
        for (int i = 0; i < sh; i += 3) {
            matrixStack.m_85836_();
            matrixStack.m_252880_(0.0f, (float)i, 0.0f);
            matrixStack.m_85841_((float)sw, 1.0f, 1.0f);
            gui.m_280218_(menu, 0, 0, 77, 92, 1, 1);
            matrixStack.m_85849_();
        }
        RenderSystem.disableBlend();
        this.topLeftBar.draw(gui);
        this.topRightBar.draw(gui);
        this.bottomLeftBar.draw(gui);
        this.bottomRightBar.draw(gui);
    }

    public void drawBiomeDim(GuiGraphics gui) {
        gui.m_280168_().m_85836_();
        String dimension = this.f_96541_.f_91074_.m_9236_().m_46472_().m_135782_().m_135815_().toUpperCase().replaceAll("_", " ");
        ResourceLocation biomeLoc = new ResourceLocation(MenuBackground.printBiome((Holder<Biome>)this.f_96541_.f_91073_.m_204166_(this.f_96541_.f_91074_.m_20183_())));
        Object biome = "biome." + biomeLoc.m_135827_() + "." + biomeLoc.m_135815_();
        biome = Language.m_128107_().m_6722_((String)biome) ? Utils.translateToLocal((String)biome, new Object[0]) : biomeLoc.toString();
        String text = dimension + " | " + (String)biome;
        gui.m_280488_(this.f_96541_.f_91062_, text, this.f_96543_ - this.f_96541_.f_91062_.m_92895_(text) - 5, 5, 16091955);
        gui.m_280168_().m_85849_();
    }

    public void drawMunnyTime(GuiGraphics gui) {
        gui.m_280168_().m_85836_();
        gui.m_280168_().m_85841_(1.05f, 1.05f, 1.0f);
        IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)this.f_96541_.f_91074_);
        int y = (int)(this.topBarHeight + this.middleHeight + 1.0f);
        gui.m_280488_(this.f_96541_.f_91062_, Utils.translateToLocal("gui.menu.main.synthesis_tier", new Object[0]) + ": " + Utils.getTierFromInt(playerData.getSynthLevel()), 5, y, 0xFFFF00);
        Objects.requireNonNull(this.f_96541_.f_91062_);
        gui.m_280488_(this.f_96541_.f_91062_, Utils.translateToLocal("gui.menu.main.munny", new Object[0]) + ": " + playerData.getMunny(), 5, y += 9, 16148007);
        Objects.requireNonNull(this.f_96541_.f_91062_);
        gui.m_280488_(this.f_96541_.f_91062_, Utils.translateToLocal("gui.menu.main.hearts", new Object[0]) + ": " + playerData.getHearts(), 5, y += 9, playerData.getAlignment() == Utils.OrgMember.NONE ? 0x888888 : 0xFF3333);
        Objects.requireNonNull(this.f_96541_.f_91062_);
        gui.m_280488_(this.f_96541_.f_91062_, Utils.translateToLocal("gui.menu.main.time", new Object[0]) + ": " + MenuBackground.getWorldHours((Level)this.f_96541_.f_91073_) + ":" + MenuBackground.getWorldMinutes((Level)this.f_96541_.f_91073_), 5, y += 9, 0xFFFFFF);
        long seconds = this.f_96541_.f_91073_.m_46468_() / 20L;
        long h = seconds / 3600L;
        long m = seconds % 3600L / 60L;
        long s = seconds % 3600L % 60L;
        String sec = s < 10L ? "0" + s : "" + s;
        String min = m < 10L ? "0" + m : "" + m;
        String hou = h < 10L ? "0" + h : "" + h;
        String time = hou + ":" + min + ":" + sec;
        Objects.requireNonNull(this.f_96541_.f_91062_);
        gui.m_280488_(this.f_96541_.f_91062_, Utils.translateToLocal("gui.menu.main.time.spent", new Object[0]) + ": " + time, 5, y += 9, 4378367);
        gui.m_280168_().m_85849_();
    }

    public void drawTip(GuiGraphics gui) {
        this.tip = null;
        for (Renderable btn : this.f_169369_) {
            if (!(btn instanceof MenuButtonBase) || !((MenuButtonBase)btn).m_198029_()) continue;
            this.selected = -1;
            this.clearButtons();
            if (!(btn instanceof MenuButton) || !((MenuButton)btn).f_93624_) continue;
            this.tip = ((MenuButton)btn).getTip();
        }
        if (this.tip != null) {
            gui.m_280168_().m_85836_();
            ClientUtils.drawSplitString(gui, Utils.translateToLocal(this.tip, new Object[0]), (int)tooltipPosX, (int)tooltipPosY, (int)((float)this.f_96543_ * 0.6f), 0xFF9900);
            gui.m_280168_().m_85849_();
        }
    }

    public static String getWorldMinutes(Level world) {
        int time = (int)Math.abs((world.m_46467_() + 6000L) % 24000L);
        if (time % 1000 * 6 / 100 < 10) {
            return "0" + time % 1000 * 6 / 100;
        }
        return Integer.toString(time % 1000 * 6 / 100);
    }

    public static int getWorldHours(Level world) {
        int time = (int)Math.abs((world.m_46467_() + 6000L) % 24000L);
        return (int)((float)time / 1000.0f);
    }

    public void m_7856_() {
        this.topBarHeight = (float)this.f_96544_ * 0.17f;
        this.bottomBarHeight = (float)this.f_96544_ * 0.23f;
        this.topLeftBarWidth = (float)this.f_96543_ * 0.175f;
        this.topRightBarWidth = (float)this.f_96543_ * 0.82f;
        this.topGap = (float)this.f_96543_ * 0.005f;
        this.bottomLeftBarWidth = (float)this.f_96543_ * 0.304f;
        this.bottomRightBarWidth = (float)this.f_96543_ * 0.6875f;
        this.bottomGap = (float)this.f_96543_ * 0.0085f;
        this.middleHeight = (float)this.f_96544_ * 0.6f;
        this.topLeftBar = new MenuBar(-10, -10, (int)this.topLeftBarWidth + 10, (int)this.topBarHeight + 10, true);
        this.topRightBar = new MenuBar((int)(this.topLeftBarWidth + this.topGap), -10, (int)this.topRightBarWidth + 10, (int)this.topBarHeight + 10, true);
        this.bottomLeftBar = new MenuBar(-10, (int)(this.topBarHeight + this.middleHeight), (int)this.bottomLeftBarWidth + 10, (int)this.bottomBarHeight + 10, false);
        this.bottomRightBar = new MenuBar((int)(this.bottomLeftBarWidth + this.bottomGap), (int)(this.topBarHeight + this.middleHeight), (int)this.bottomRightBarWidth + 10, (int)this.bottomBarHeight + 10, false);
        this.buttonPosX = (float)this.f_96543_ * 0.03f;
        this.buttonPosY = (int)this.topBarHeight + 5;
        this.buttonWidth = (float)this.f_96543_ * 0.1744f - 22.0f;
        tooltipPosX = this.bottomRightBar.getPosX() + 15;
        tooltipPosY = this.bottomRightBar.getPosY() + 15;
    }

    private static String printBiome(Holder<Biome> p_205375_) {
        return (String)p_205375_.m_203439_().map(p_205377_ -> p_205377_.m_135782_().toString(), p_205367_ -> "[unregistered " + String.valueOf(p_205367_) + "]");
    }

    static {
        menu = new ResourceLocation("kingdomkeys", "textures/gui/menu/menu_button.png");
    }
}

