/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.menu.party;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.IWorldCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.client.gui.GuiHelper;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuBackground;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuButton;
import online.kingdomkeys.kingdomkeys.client.gui.menu.party.GuiMenu_Party_Leader;
import online.kingdomkeys.kingdomkeys.client.gui.menu.party.GuiMenu_Party_None;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.lib.Party;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.cts.CSPartyLeave;
import online.kingdomkeys.kingdomkeys.util.Utils;
import org.jetbrains.annotations.NotNull;

public class GuiMenu_Party_Member
extends MenuBackground {
    MenuButton back;
    MenuButton leave;
    final IPlayerCapabilities playerData;
    IWorldCapabilities worldData;
    Party party;
    final ResourceLocation texture;

    public GuiMenu_Party_Member() {
        super("gui.menu.party", new Color(0, 0, 255));
        this.playerData = ModCapabilities.getPlayer((Player)this.f_96541_.f_91074_);
        this.texture = new ResourceLocation("kingdomkeys", "textures/gui/menu/menu_button.png");
        this.drawPlayerInfo = true;
        this.worldData = ModCapabilities.getWorld((Level)this.f_96541_.f_91073_);
        this.party = this.worldData.getPartyFromMember(this.f_96541_.f_91074_.m_20148_());
    }

    protected void action(String string) {
        switch (string) {
            case "back": {
                GuiHelper.openMenu();
                break;
            }
            case "leave": {
                PacketHandler.sendToServer(new CSPartyLeave(this.party, this.f_96541_.f_91074_.m_20148_()));
                this.f_96541_.f_91073_.m_5594_((Player)this.f_96541_.f_91074_, this.f_96541_.f_91074_.m_20183_(), (SoundEvent)ModSounds.menu_in.get(), SoundSource.MASTER, 1.0f, 1.0f);
                this.f_96541_.m_91152_((Screen)new GuiMenu_Party_None());
            }
        }
        this.updateButtons();
    }

    private void updateButtons() {
        this.leave.f_93624_ = true;
    }

    @Override
    public void m_7856_() {
        this.f_96543_ = this.f_96543_;
        this.f_96544_ = this.f_96544_;
        super.m_7856_();
        this.f_169369_.clear();
        this.party = this.worldData.getPartyFromMember(this.f_96541_.f_91074_.m_20148_());
        if (this.party == null) {
            GuiHelper.openMenu();
        } else if (this.party.getMember(this.f_96541_.f_91074_.m_20148_()).isLeader()) {
            this.f_96541_.m_91152_((Screen)new GuiMenu_Party_Leader());
            return;
        }
        float topBarHeight = (float)this.f_96544_ * 0.17f;
        int button_statsY = (int)topBarHeight + 5;
        float buttonPosX = (float)this.f_96543_ * 0.03f;
        float buttonWidth = (float)this.f_96543_ * 0.1744f - 20.0f;
        this.leave = new MenuButton((int)buttonPosX, button_statsY + 0, (int)buttonWidth, Utils.translateToLocal("gui.menu.party.leave", new Object[0]), MenuButton.ButtonType.BUTTON, e -> this.action("leave"));
        this.m_142416_((GuiEventListener)this.leave);
        this.back = new MenuButton((int)buttonPosX, button_statsY + 18, (int)buttonWidth, Utils.translateToLocal("gui.menu.back", new Object[0]), MenuButton.ButtonType.BUTTON, e -> this.action("back"));
        this.m_142416_((GuiEventListener)this.back);
        this.updateButtons();
    }

    @Override
    public void m_88315_(@NotNull GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        PoseStack matrixStack = gui.m_280168_();
        super.m_88315_(gui, mouseX, mouseY, partialTicks);
        this.worldData = ModCapabilities.getWorld((Level)this.f_96541_.f_91073_);
        this.party = this.worldData.getPartyFromMember(this.f_96541_.f_91074_.m_20148_());
        if (this.party == null) {
            GuiHelper.openMenu();
        } else {
            if (this.party.getMember(this.f_96541_.f_91074_.m_20148_()).isLeader()) {
                this.f_96541_.m_91152_((Screen)new GuiMenu_Party_Leader());
                return;
            }
            matrixStack.m_85836_();
            matrixStack.m_85841_(1.5f, 1.5f, 1.0f);
            gui.m_280488_(this.f_96541_.f_91062_, "[" + this.party.getMembers().size() + "/" + this.party.getSize() + "] " + this.party.getName(), (int)(this.topLeftBarWidth + this.topGap) + 5, 10, 0xFF9900);
            matrixStack.m_85849_();
            this.drawParty(gui);
        }
    }

    public void drawParty(GuiGraphics gui) {
        gui.m_280168_().m_85836_();
        for (int i = 0; i < this.party.getMembers().size(); ++i) {
            Party.Member member = this.party.getMembers().get(i);
            this.drawPlayer(gui, i, member);
        }
        gui.m_280168_().m_85849_();
    }

    public void drawPlayer(GuiGraphics gui, int order, Party.Member member) {
        IPlayerCapabilities playerData;
        int i;
        PoseStack matrixStack = gui.m_280168_();
        byte partySize = (byte)ModCapabilities.getWorld(Minecraft.m_91087_().f_91074_.m_9236_()).getPartyFromMember(member.getUUID()).getMembers().size();
        float space = 0.18f;
        float playerHeight = (float)this.f_96544_ * 0.45f;
        float playerPosX = 140.0f + (space *= 2.0f / (float)partySize) * (float)order * 1000.0f;
        float playerPosY = (float)this.f_96544_ * 0.7f;
        Player player = Utils.getPlayerByName((Level)this.f_96541_.f_91073_, member.getUsername().toLowerCase());
        matrixStack.m_85836_();
        matrixStack.m_252880_(playerPosX, playerPosY, 0.0f);
        if (partySize > 4) {
            matrixStack.m_252880_(0.0f, -2.5f, 0.0f);
            matrixStack.m_85841_(5.0f / (float)partySize, 5.0f / (float)partySize, 1.0f);
        }
        matrixStack.m_85836_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (member != null && player != null) {
            matrixStack.m_85836_();
            InventoryScreen.m_274545_((GuiGraphics)gui, (int)0, (int)0, (int)((int)playerHeight / 2), (float)0.0f, (float)0.0f, (LivingEntity)player);
            matrixStack.m_85849_();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
        matrixStack.m_85849_();
        matrixStack.m_85836_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.m_252880_(-playerPosX, -playerPosY, 100.0f);
        RenderSystem.enableBlend();
        int infoBoxWidth = (int)((float)this.f_96543_ * 0.1385f - 14.0f);
        int infoBoxPosX = (int)(105.0f + space * (float)order * 1000.0f);
        int infoBoxPosY = (int)((float)this.f_96544_ * 0.54f);
        gui.m_280218_(this.texture, infoBoxPosX, infoBoxPosY, 123, 67, 12, 22);
        for (i = 0; i < infoBoxWidth; ++i) {
            gui.m_280218_(this.texture, infoBoxPosX + 10 + i, infoBoxPosY, 136, 67, 2, 22);
        }
        gui.m_280218_(this.texture, infoBoxPosX + 10 + infoBoxWidth, infoBoxPosY, 137, 67, 3, 22);
        gui.m_280218_(this.texture, infoBoxPosX, infoBoxPosY + 22, 123, 90, 4, 35);
        for (i = 0; i < infoBoxWidth + 8; ++i) {
            gui.m_280218_(this.texture, infoBoxPosX + 2 + i, infoBoxPosY + 22, 128, 90, 2, 35);
        }
        gui.m_280218_(this.texture, infoBoxPosX + 2 + infoBoxWidth + 8, infoBoxPosY + 22, 129, 90, 3, 35);
        RenderSystem.disableBlend();
        matrixStack.m_85849_();
        matrixStack.m_85836_();
        matrixStack.m_252880_(-playerPosX, -playerPosY, 100.0f);
        matrixStack.m_85836_();
        float f = infoBoxPosX + 8;
        Objects.requireNonNull(this.f_96541_.f_91062_);
        matrixStack.m_252880_(f, (float)(infoBoxPosY + (11 - 9 / 2)), 1.0f);
        gui.m_280488_(this.f_96541_.f_91062_, member.getUsername(), 0, 0, 0xFFFFFF);
        matrixStack.m_85849_();
        if (player != null && (playerData = ModCapabilities.getPlayer(player)) != null) {
            gui.m_280488_(this.f_96541_.f_91062_, Utils.translateToLocal("gui.menu.status.level", new Object[0]) + ": " + playerData.getLevel(), infoBoxPosX + 4, infoBoxPosY + 26, 16767232);
            Font font = this.f_96541_.f_91062_;
            String string = Utils.translateToLocal("gui.menu.status.hp", new Object[0]) + ": " + (int)player.m_21223_() + "/" + (int)player.m_21233_();
            Objects.requireNonNull(this.f_96541_.f_91062_);
            gui.m_280488_(font, string, infoBoxPosX + 4, infoBoxPosY + 26 + 9, 65280);
            Font font2 = this.f_96541_.f_91062_;
            String string2 = Utils.translateToLocal("gui.menu.status.mp", new Object[0]) + ": " + (int)playerData.getMP() + "/" + (int)playerData.getMaxMP();
            Objects.requireNonNull(this.f_96541_.f_91062_);
            gui.m_280488_(font2, string2, infoBoxPosX + 4, infoBoxPosY + 26 + 9 * 2, 0x4444FF);
        }
        matrixStack.m_85849_();
        matrixStack.m_85849_();
    }
}

