/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.menu.party;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.IWorldCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.client.gui.GuiHelper;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuBackground;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuButton;
import online.kingdomkeys.kingdomkeys.client.gui.menu.party.GuiMenu_Party_Create;
import online.kingdomkeys.kingdomkeys.client.gui.menu.party.GuiMenu_Party_Join;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.lib.Party;
import online.kingdomkeys.kingdomkeys.util.Utils;
import org.jetbrains.annotations.NotNull;

public class GuiMenu_Party_None
extends MenuBackground {
    MenuButton back;
    MenuButton create;
    MenuButton join;
    final IPlayerCapabilities playerData;
    IWorldCapabilities worldData;
    Party party;
    final ResourceLocation texture;

    public GuiMenu_Party_None() {
        super("gui.menu.party", new Color(0, 0, 255));
        this.playerData = ModCapabilities.getPlayer((Player)this.f_96541_.f_91074_);
        this.texture = new ResourceLocation("kingdomkeys", "textures/gui/menu/menu_button.png");
        this.drawPlayerInfo = true;
        this.worldData = ModCapabilities.getWorld((Level)this.f_96541_.f_91073_);
    }

    protected void action(String string) {
        switch (string) {
            case "back": {
                GuiHelper.openMenu();
                break;
            }
            case "create": {
                this.f_96541_.f_91073_.m_5594_((Player)this.f_96541_.f_91074_, this.f_96541_.f_91074_.m_20183_(), (SoundEvent)ModSounds.menu_in.get(), SoundSource.MASTER, 1.0f, 1.0f);
                this.f_96541_.m_91152_((Screen)new GuiMenu_Party_Create());
                break;
            }
            case "join": {
                this.f_96541_.f_91073_.m_5594_((Player)this.f_96541_.f_91074_, this.f_96541_.f_91074_.m_20183_(), (SoundEvent)ModSounds.menu_in.get(), SoundSource.MASTER, 1.0f, 1.0f);
                this.f_96541_.m_91152_((Screen)new GuiMenu_Party_Join());
            }
        }
        this.updateButtons();
    }

    private void updateButtons() {
        this.create.f_93624_ = true;
        this.join.f_93624_ = true;
        this.back.f_93624_ = true;
    }

    @Override
    public void m_7856_() {
        this.f_96543_ = this.f_96543_;
        this.f_96544_ = this.f_96544_;
        super.m_7856_();
        this.f_169369_.clear();
        this.party = this.worldData.getPartyFromMember(this.f_96541_.f_91074_.m_20148_());
        float topBarHeight = (float)this.f_96544_ * 0.17f;
        int button_statsY = (int)topBarHeight + 5;
        float buttonPosX = (float)this.f_96543_ * 0.03f;
        float buttonWidth = (float)this.f_96543_ * 0.1744f - 20.0f;
        this.create = new MenuButton((int)buttonPosX, button_statsY + 0, (int)buttonWidth, "gui.menu.party.create", MenuButton.ButtonType.BUTTON, true, e -> this.action("create"));
        this.m_142416_((GuiEventListener)this.create);
        this.join = new MenuButton((int)buttonPosX, button_statsY + 18, (int)buttonWidth, "gui.menu.party.join", MenuButton.ButtonType.BUTTON, true, e -> this.action("join"));
        this.m_142416_((GuiEventListener)this.join);
        this.back = new MenuButton((int)buttonPosX, button_statsY + 36, (int)buttonWidth, "gui.menu.back", MenuButton.ButtonType.BUTTON, true, e -> this.action("back"));
        this.m_142416_((GuiEventListener)this.back);
        this.updateButtons();
    }

    @Override
    public void m_88315_(@NotNull GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(gui, mouseX, mouseY, partialTicks);
        this.worldData = ModCapabilities.getWorld((Level)this.f_96541_.f_91073_);
        this.drawParty(gui);
    }

    public void drawParty(GuiGraphics gui) {
        this.party = this.worldData.getPartyFromMember(this.f_96541_.f_91074_.m_20148_());
        if (this.party != null) {
            for (int i = 0; i < this.party.getMembers().size(); ++i) {
                Party.Member member = this.party.getMembers().get(i);
                this.drawPlayer(gui, i, member);
            }
        } else {
            Party.Member m = new Party.Member(this.f_96541_.f_91074_.m_20148_(), this.f_96541_.f_91074_.m_5446_().getString());
            this.drawPlayer(gui, 0, m);
        }
    }

    public void drawPlayer(GuiGraphics gui, int order, Party.Member member) {
        IPlayerCapabilities playerData;
        int i;
        PoseStack matrixStack = gui.m_280168_();
        float playerHeight = (float)this.f_96544_ * 0.45f;
        float playerPosX = 150.0f + 0.18f * (float)order * (float)this.f_96543_;
        float playerPosY = (float)this.f_96544_ * 0.7f;
        Player player = Utils.getPlayerByName((Level)this.f_96541_.f_91073_, member.getUsername());
        matrixStack.m_85836_();
        matrixStack.m_85836_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (member != null && player != null) {
            InventoryScreen.m_274545_((GuiGraphics)gui, (int)((int)playerPosX), (int)((int)playerPosY), (int)((int)playerHeight / 2), (float)0.0f, (float)0.0f, (LivingEntity)this.f_96541_.f_91074_);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
        matrixStack.m_85849_();
        matrixStack.m_85836_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.m_252880_(9.0f, 1.0f, 100.0f);
        RenderSystem.enableBlend();
        int infoBoxWidth = (int)((float)this.f_96543_ * 0.1385f - 14.0f);
        int infoBoxPosX = (int)(105.0f + 0.18f * (float)order * (float)this.f_96543_);
        int infoBoxPosY = (int)((float)this.f_96544_ * 0.54f);
        gui.m_280218_(this.texture, infoBoxPosX, infoBoxPosY, 123, 67, 11, 22);
        for (i = 0; i < infoBoxWidth; ++i) {
            gui.m_280218_(this.texture, infoBoxPosX + 11 + i, infoBoxPosY, 135, 67, 1, 22);
        }
        gui.m_280218_(this.texture, infoBoxPosX + 11 + infoBoxWidth, infoBoxPosY, 137, 67, 3, 22);
        gui.m_280218_(this.texture, infoBoxPosX, infoBoxPosY + 22, 123, 90, 3, 35);
        for (i = 0; i < infoBoxWidth + 8; ++i) {
            gui.m_280218_(this.texture, infoBoxPosX + 3 + i, infoBoxPosY + 22, 127, 90, 1, 35);
        }
        gui.m_280218_(this.texture, infoBoxPosX + 3 + infoBoxWidth + 8, infoBoxPosY + 22, 129, 90, 3, 35);
        RenderSystem.disableBlend();
        matrixStack.m_85849_();
        matrixStack.m_85836_();
        matrixStack.m_252880_(10.0f, 2.0f, 100.0f);
        matrixStack.m_85836_();
        float f = infoBoxPosX + 8;
        Objects.requireNonNull(this.f_96541_.f_91062_);
        matrixStack.m_252880_(f, (float)(infoBoxPosY + (11 - 9 / 2)), 1.0f);
        gui.m_280488_(this.f_96541_.f_91062_, member.getUsername(), 0, 0, 0xFFFFFF);
        matrixStack.m_85849_();
        if (player != null && (playerData = ModCapabilities.getPlayer(player)) != null) {
            gui.m_280488_(this.f_96541_.f_91062_, "LV: " + playerData.getLevel(), infoBoxPosX + 4, infoBoxPosY + 26, 16767232);
            Font font = this.f_96541_.f_91062_;
            String string = "HP: " + (int)player.m_21223_() + "/" + (int)player.m_21233_();
            Objects.requireNonNull(this.f_96541_.f_91062_);
            gui.m_280488_(font, string, infoBoxPosX + 4, infoBoxPosY + 26 + 9, 65280);
            Font font2 = this.f_96541_.f_91062_;
            String string2 = "MP: " + (int)playerData.getMP() + "/" + (int)playerData.getMaxMP();
            Objects.requireNonNull(this.f_96541_.f_91062_);
            gui.m_280488_(font2, string2, infoBoxPosX + 4, infoBoxPosY + 26 + 9 * 2, 0x4444FF);
        }
        matrixStack.m_85849_();
        matrixStack.m_85849_();
    }
}

