/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.client.gui.overlay.OverlayBase;
import online.kingdomkeys.kingdomkeys.driveform.DriveForm;
import online.kingdomkeys.kingdomkeys.driveform.ModDriveForms;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class GuiOverlay
extends OverlayBase {
    public static final GuiOverlay INSTANCE = new GuiOverlay();
    public static boolean showExp;
    public static boolean showMunny;
    public static List<LevelUpData> levelUpList;
    public static boolean showDriveLevelUp;
    public static String driveForm;
    public static UUID playerWhoLevels;
    public static long timeExp;
    public static long timeMunny;
    public static long timeLevelUp;
    public static long timeDriveLevelUp;
    public static int munnyGet;
    int levelSeconds = 6;
    int width;
    int sHeight;
    IPlayerCapabilities playerData;
    ResourceLocation levelUpTexture = new ResourceLocation("kingdomkeys", "textures/gui/levelup.png");
    ResourceLocation menuTexture = new ResourceLocation("kingdomkeys", "textures/gui/menu/menu_button.png");
    public static float notifTicks;
    public static float prevNotifTicks;
    public static float driveNotifTicks;
    public static float prevDriveNotifTicks;

    @Override
    public void render(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int width, int height) {
        super.render(gui, guiGraphics, partialTick, width, height);
        this.width = this.minecraft.m_91268_().m_85445_();
        this.sHeight = this.minecraft.m_91268_().m_85446_();
        this.playerData = ModCapabilities.getPlayer((Player)this.minecraft.f_91074_);
        if (this.playerData != null) {
            if (showExp) {
                this.showExp(guiGraphics);
            }
            if (showMunny) {
                this.showMunny(guiGraphics);
            }
            int lvlCounter = 0;
            Iterator<LevelUpData> it = levelUpList.iterator();
            while (it.hasNext()) {
                this.showLevelUp(guiGraphics, partialTick, lvlCounter++);
                LevelUpData actual = it.next();
                if (System.currentTimeMillis() / 1000L <= actual.timeLevelUp + (long)this.levelSeconds) continue;
                it.remove();
            }
            if (showDriveLevelUp) {
                this.showDriveLevelUp(guiGraphics, partialTick);
            }
        }
    }

    private void showExp(GuiGraphics gui) {
        if (this.playerData != null) {
            String reqExp = String.valueOf(this.playerData.getExpNeeded(this.playerData.getLevel(), this.playerData.getExperience()));
            this.drawString(gui, this.minecraft.f_91062_, Utils.translateToLocal("stats.levelNext", new Object[0]), 5, 5, 0xFFFFFF);
            Font font = this.minecraft.f_91062_;
            Objects.requireNonNull(this.minecraft.f_91062_);
            this.drawString(gui, font, reqExp, 5, 5 + 9, 0xFFFFFF);
            if (System.currentTimeMillis() / 1000L > timeExp + 4L) {
                showExp = false;
            }
        }
    }

    private void showMunny(GuiGraphics gui) {
        PoseStack matrixStack = gui.m_280168_();
        int heightOffsetText = 0;
        int heightOffsetNum = 0;
        if (!showExp) {
            matrixStack.m_85836_();
            matrixStack.m_252880_(1.0f, 1.0f, 0.0f);
            heightOffsetText = 0;
            Objects.requireNonNull(this.minecraft.f_91062_);
            heightOffsetNum = 9;
            matrixStack.m_85849_();
        } else {
            Objects.requireNonNull(this.minecraft.f_91062_);
            heightOffsetText = 9 + 10;
            Objects.requireNonNull(this.minecraft.f_91062_);
            heightOffsetNum = 9 * 2 + 10;
        }
        this.drawString(this.guiGraphics, this.minecraft.f_91062_, Utils.translateToLocal("stats.munnyGet", new Object[0]), 5, 5 + heightOffsetText, 0xFFFFFF);
        this.drawString(this.guiGraphics, this.minecraft.f_91062_, "" + munnyGet, 5, 5 + heightOffsetNum, 0xFFFFFF);
        if (System.currentTimeMillis() / 1000L > timeMunny + 4L) {
            showMunny = false;
        }
    }

    private void showLevelUp(GuiGraphics gui, float partialTick, int actual) {
        if (actual >= levelUpList.size()) {
            return;
        }
        LevelUpData levelData = levelUpList.get(actual);
        if (levelData == null) {
            return;
        }
        int[] notifColor = Utils.getRGBFromDec(levelData.color);
        String name = levelData.playerName;
        int lvl = levelData.lvl;
        PoseStack matrixStack = gui.m_280168_();
        matrixStack.m_85836_();
        int totalSpace = 0;
        for (int i = 0; i < actual; ++i) {
            totalSpace = (int)((float)totalSpace + 21.6f);
            Objects.requireNonNull(this.minecraft.f_91062_);
            totalSpace += (int)(9.0f * 1.2f) * GuiOverlay.levelUpList.get((int)i).messages.size();
            totalSpace = (int)((float)totalSpace + 10.8f);
        }
        matrixStack.m_252880_(0.0f, (float)totalSpace, 0.0f);
        float notifXPos = (float)levelData.prevNotifTicks + (float)(levelData.notifTicks - levelData.prevNotifTicks) * partialTick;
        if (notifXPos <= -155.0f) {
            notifXPos = -155.0f;
        }
        matrixStack.m_252880_(notifXPos + 155.0f, 4.0f, 0.0f);
        Objects.requireNonNull(this.minecraft.f_91062_);
        int height = (int)(9.0f * 1.2f) * levelData.messages.size();
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)((float)notifColor[0] / 255.0f), (float)((float)notifColor[1] / 255.0f), (float)((float)notifColor[2] / 255.0f), (float)1.0f);
        matrixStack.m_85836_();
        matrixStack.m_252880_((float)this.width - 153.6f - 2.0f, 0.0f, 0.0f);
        matrixStack.m_85841_(0.6f, 0.6f, 1.0f);
        this.blit(gui, this.levelUpTexture, 0, 0, 0, 0, 256, 36);
        matrixStack.m_85849_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        this.showText(matrixStack, "LEVEL UP!" + String.valueOf(ChatFormatting.ITALIC), (float)this.width - (float)this.minecraft.f_91062_.m_92895_("LEVEL UP!") * 0.75f - 115.0f, 4.0f, 0.0f, 0.75f, 0.75f, 1.0f, Color.decode(String.format("#%02x%02x%02x", (byte)-1, (byte)-1, (byte)-1)).hashCode());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.showText(matrixStack, "LV.", (float)this.width - (float)this.minecraft.f_91062_.m_92895_("LV. ") * 0.75f - 90.0f, 4.0f, 0.0f, 0.75f, 0.75f, 1.0f, 14929920);
        this.showText(matrixStack, "" + lvl, (float)this.width - 192.0f + (float)this.minecraft.f_91062_.m_92895_("999") * 0.75f + 88.0f, 4.0f, 0.0f, 0.75f, 0.75f, 1.0f, 0xFFFFFF);
        this.showText(matrixStack, name, (float)this.width - (float)this.minecraft.f_91062_.m_92895_(name) * 0.75f - 7.0f, 4.0f, 0.0f, 0.75f, 0.75f, 1.0f, 0xFFFFFF);
        RenderSystem.setShaderColor((float)((float)notifColor[0] / 255.0f), (float)((float)notifColor[1] / 255.0f), (float)((float)notifColor[2] / 255.0f), (float)1.0f);
        matrixStack.m_85836_();
        matrixStack.m_252880_((float)this.width - 153.6f - 2.0f, 21.6f, 0.0f);
        matrixStack.m_85841_(0.6f, (float)height, 1.0f);
        this.blit(gui, this.levelUpTexture, 0, 0, 0, 36, 256, 1);
        matrixStack.m_85849_();
        RenderSystem.setShaderColor((float)((float)notifColor[0] / 255.0f), (float)((float)notifColor[1] / 255.0f), (float)((float)notifColor[2] / 255.0f), (float)1.0f);
        matrixStack.m_85836_();
        matrixStack.m_252880_((float)this.width - 153.6f - 2.0f, (float)height + 21.6f, 0.0f);
        matrixStack.m_85841_(0.6f, 0.6f, 1.0f);
        this.blit(gui, this.levelUpTexture, 0, 0, 0, 37, 256, 14);
        matrixStack.m_85849_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int i = 0; i < levelData.messages.size(); ++i) {
            String message = levelData.messages.get(i).toString();
            float x = (float)this.width - 204.8f + (float)this.minecraft.f_91062_.m_92895_("Maximum HP Increased!") * 0.8f - 35.0f;
            Objects.requireNonNull(this.minecraft.f_91062_);
            float y = 9.0f * 1.2f * (float)i + 23.0f;
            if (message.startsWith("A_")) {
                this.blit(gui, this.menuTexture, (int)x, (int)y - 2, 74, 102, 12, 12);
                message = message.replace("A_", "");
                x += 13.0f;
            }
            if (message.startsWith("S_")) {
                this.blit(gui, this.menuTexture, (int)x, (int)y - 2, 100, 102, 12, 12);
                message = message.replace("S_", "");
                x += 13.0f;
            }
            if (message.startsWith("M_")) {
                this.blit(gui, this.menuTexture, (int)x, (int)y - 2, 87, 115, 12, 12);
                message = message.replace("M_", "");
                x += 13.0f;
            }
            if (message.startsWith("C_")) {
                this.blit(gui, this.menuTexture, (int)x, (int)y - 2, 87, 129, 12, 12);
                message = message.replace("C_", "");
                x += 13.0f;
            }
            if (message.startsWith("R_")) {
                this.blit(gui, this.menuTexture, (int)x, (int)y - 2, 101, 129, 12, 12);
                message = message.replace("R_", "");
                x += 13.0f;
            }
            this.showText(matrixStack, Utils.translateToLocal(message, new Object[0]), x, y, 0.0f, 0.8f, 0.8f, 1.0f, 0xFFFFFF);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.m_85849_();
    }

    private void showDriveLevelUp(GuiGraphics gui, float partialTick) {
        PoseStack matrixStack = gui.m_280168_();
        if (this.playerData == null || driveForm == null) {
            return;
        }
        DriveForm drive = (DriveForm)ModDriveForms.registry.get().getValue(new ResourceLocation(driveForm));
        float[] driveColor = drive.getDriveColor();
        matrixStack.m_85836_();
        float driveNotifXPos = prevDriveNotifTicks + (driveNotifTicks - prevDriveNotifTicks) * partialTick;
        if (driveNotifXPos > 155.0f) {
            driveNotifXPos = 155.0f;
        }
        matrixStack.m_252880_(driveNotifXPos - 155.0f, 4.0f, 0.0f);
        Objects.requireNonNull(this.minecraft.f_91062_);
        int heightBase = (int)(9.0f * 1.1f) * this.playerData.getBFMessages().size();
        Objects.requireNonNull(this.minecraft.f_91062_);
        int heightDF = (int)(9.0f * 1.1f) * this.playerData.getDFMessages().size();
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)driveColor[0], (float)driveColor[1], (float)driveColor[2], (float)1.0f);
        matrixStack.m_85836_();
        RenderSystem.setShaderColor((float)0.4f, (float)0.4f, (float)0.4f, (float)1.0f);
        matrixStack.m_85836_();
        matrixStack.m_252880_(2.0f, (float)(this.sHeight / 3), 0.0f);
        matrixStack.m_85841_(0.6f, 0.6f, 1.0f);
        this.blit(gui, this.levelUpTexture, 0, 0, 0, 51, 256, 36);
        matrixStack.m_85849_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.showText(matrixStack, this.minecraft.f_91074_.m_5446_().getString(), 140.0f - (float)this.minecraft.f_91062_.m_92895_(this.minecraft.f_91074_.m_5446_().getString()) * 0.75f, this.sHeight / 3 + 4, 0.0f, 0.75f, 0.75f, 1.0f, 0xFFFFFF);
        RenderSystem.setShaderColor((float)0.4f, (float)0.4f, (float)0.4f, (float)1.0f);
        matrixStack.m_85836_();
        matrixStack.m_252880_(2.0f, (float)(this.sHeight / 3 + 21), 0.0f);
        matrixStack.m_85841_(0.6f, (float)(heightBase + 1), 1.0f);
        this.blit(gui, this.levelUpTexture, 0, 0, 0, 87, 256, 1);
        matrixStack.m_85849_();
        RenderSystem.setShaderColor((float)0.4f, (float)0.4f, (float)0.4f, (float)1.0f);
        matrixStack.m_85836_();
        matrixStack.m_252880_(2.0f, (float)(this.sHeight / 3 + 22 + heightBase), 0.0f);
        matrixStack.m_85841_(0.6f, 0.6f, 1.0f);
        this.blit(gui, this.levelUpTexture, 0, 0, 0, 88, 256, 14);
        matrixStack.m_85849_();
        RenderSystem.setShaderColor((float)0.4f, (float)0.4f, (float)0.4f, (float)1.0f);
        for (int i = 0; i < this.playerData.getBFMessages().size(); ++i) {
            String message = this.playerData.getBFMessages().get(i);
            float x = 33.0f;
            float f = this.sHeight / 3;
            Objects.requireNonNull(this.minecraft.f_91062_);
            float y = f + 9.0f * 1.1f * (float)i + 23.0f;
            if (message.startsWith("A_")) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.blit(gui, this.menuTexture, (int)x, (int)y - 3, 74, 102, 12, 12);
                message = message.replace("A_", "");
                x += 13.0f;
            }
            this.showText(matrixStack, Utils.translateToLocalFormatted(message, new Object[0]), x, y, 0.0f, 0.8f, 0.8f, 1.0f, 0xFFFFFF);
        }
        RenderSystem.setShaderColor((float)0.8f, (float)0.8f, (float)0.8f, (float)1.0f);
        matrixStack.m_85836_();
        matrixStack.m_252880_(4.5f, (float)(this.sHeight / 3 + 6), 0.0f);
        matrixStack.m_85841_(0.6f, 0.6f, 1.0f);
        this.blit(gui, this.levelUpTexture, 0, 0, 0, 102, 43, 36);
        matrixStack.m_85849_();
        matrixStack.m_85849_();
        matrixStack.m_85836_();
        RenderSystem.setShaderColor((float)driveColor[0], (float)driveColor[1], (float)driveColor[2], (float)1.0f);
        matrixStack.m_85836_();
        matrixStack.m_252880_(2.0f, (float)(this.sHeight / 3 + 29 + heightBase), 0.0f);
        matrixStack.m_85841_(0.6f, 0.6f, 1.0f);
        this.blit(gui, this.levelUpTexture, 0, 0, 0, 51, 256, 36);
        matrixStack.m_85849_();
        String formName = Utils.translateToLocal(((DriveForm)ModDriveForms.registry.get().getValue(new ResourceLocation(driveForm))).getTranslationKey(), new Object[0]);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.showText(matrixStack, "LV.", 2.0f + (float)this.minecraft.f_91062_.m_92895_("LV. ") * 0.75f + 20.0f, this.sHeight / 3 + 29 + heightBase + 4, 0.0f, 0.75f, 0.75f, 1.0f, 14929920);
        this.showText(matrixStack, "" + this.playerData.getDriveFormLevel(driveForm), 1.5f + (float)this.minecraft.f_91062_.m_92895_("999") * 0.75f + 32.0f, this.sHeight / 3 + 29 + heightBase + 4, 0.0f, 0.75f, 0.75f, 1.0f, 0xFFFFFF);
        this.showText(matrixStack, formName, 140.0f - (float)this.minecraft.f_91062_.m_92895_(formName) * 0.75f, this.sHeight / 3 + 29 + heightBase + 4, 0.0f, 0.75f, 0.75f, 1.0f, 0xFFFFFF);
        RenderSystem.setShaderColor((float)driveColor[0], (float)driveColor[1], (float)driveColor[2], (float)1.0f);
        matrixStack.m_85836_();
        matrixStack.m_252880_(2.0f, (float)(this.sHeight / 3 + 50 + heightBase), 0.0f);
        matrixStack.m_85841_(0.6f, (float)heightDF, 1.0f);
        this.blit(gui, this.levelUpTexture, 0, 0, 0, 87, 256, 1);
        matrixStack.m_85849_();
        RenderSystem.setShaderColor((float)driveColor[0], (float)driveColor[1], (float)driveColor[2], (float)1.0f);
        matrixStack.m_85836_();
        matrixStack.m_252880_(2.0f, (float)(this.sHeight / 3 + 50 + heightBase + heightDF), 0.0f);
        matrixStack.m_85841_(0.6f, 0.6f, 1.0f);
        this.blit(gui, this.levelUpTexture, 0, 0, 0, 88, 256, 14);
        matrixStack.m_85849_();
        matrixStack.m_85836_();
        matrixStack.m_252880_(0.0f, (float)(this.sHeight / 3 + 50 + heightBase), 0.0f);
        RenderSystem.setShaderColor((float)driveColor[0], (float)driveColor[1], (float)driveColor[2], (float)1.0f);
        for (int i = 0; i < this.playerData.getDFMessages().size(); ++i) {
            String message = this.playerData.getDFMessages().get(i);
            float x = 33.0f;
            Objects.requireNonNull(this.minecraft.f_91062_);
            float y = 9.0f * 1.1f * (float)i;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (message.startsWith("A_")) {
                this.blit(gui, this.menuTexture, (int)x, (int)y - 2, 74, 102, 12, 12);
                message = message.replace("A_", "");
                x += 13.0f;
            }
            this.showText(matrixStack, Utils.translateToLocalFormatted(message, new Object[0]), x, y, 0.0f, 0.8f, 0.8f, 1.0f, 0xFFFFFF);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.m_85849_();
        RenderSystem.setShaderColor((float)driveColor[0], (float)driveColor[1], (float)driveColor[2], (float)1.0f);
        matrixStack.m_85836_();
        matrixStack.m_252880_(4.5f, (float)(this.sHeight / 3 + 34 + heightBase), 0.0f);
        matrixStack.m_85841_(0.6f, 0.6f, 1.0f);
        this.blit(gui, this.levelUpTexture, 0, 0, 0, 102, 43, 36);
        matrixStack.m_85849_();
        matrixStack.m_85849_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.m_85849_();
        if (System.currentTimeMillis() / 1000L > timeDriveLevelUp + (long)this.levelSeconds) {
            showDriveLevelUp = false;
        }
    }

    private void showText(PoseStack matrixStack, String text, float tX, float tY, float tZ, float sX, float sY, float sZ, int color) {
        matrixStack.m_85836_();
        matrixStack.m_252880_(tX, tY, tZ);
        matrixStack.m_85841_(sX, sY, sZ);
        this.drawString(this.guiGraphics, this.minecraft.f_91062_, text, 0, 0, color);
        matrixStack.m_85849_();
    }

    @SubscribeEvent
    public void ClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END || Minecraft.m_91087_().m_91104_()) {
            return;
        }
        for (LevelUpData notif : levelUpList) {
            if (notif.sliding) {
                notif.prevNotifTicks = notif.notifTicks;
                notif.notifTicks -= 50;
                continue;
            }
            if (notif.notifTicks > -150) continue;
            notif.prevNotifTicks = 0;
            notif.notifTicks = 0;
        }
        if (showDriveLevelUp) {
            prevDriveNotifTicks = driveNotifTicks;
            driveNotifTicks += 50.0f;
        } else if (driveNotifTicks > 150.0f) {
            prevDriveNotifTicks = 0.0f;
            driveNotifTicks = 0.0f;
        }
    }

    static {
        levelUpList = new ArrayList<LevelUpData>();
        driveForm = "";
        playerWhoLevels = Util.f_137441_;
        notifTicks = 0.0f;
        prevNotifTicks = 0.0f;
        driveNotifTicks = 0.0f;
        prevDriveNotifTicks = 0.0f;
    }

    public static class LevelUpData {
        public String playerName;
        public UUID playerUUID;
        public int lvl;
        public int prevNotifTicks;
        public int notifTicks;
        public boolean sliding = true;
        public long timeLevelUp;
        public List<String> messages = new ArrayList<String>();
        public int color;
    }
}

