/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.synthesis;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.client.ClientUtils;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuBox;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuFilterable;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuButton;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuStockItem;
import online.kingdomkeys.kingdomkeys.client.gui.synthesis.SynthesisScreen;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.lib.Tags;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.cts.CSCloseMoogleGUI;
import online.kingdomkeys.kingdomkeys.network.cts.CSDepositMaterials;
import online.kingdomkeys.kingdomkeys.network.cts.CSTakeMaterials;
import online.kingdomkeys.kingdomkeys.util.Utils;
import org.jetbrains.annotations.NotNull;

public class SynthesisMaterialScreen
extends MenuFilterable {
    MenuButton deposit;
    MenuButton back;
    Button prev;
    Button next;
    Button take;
    MenuBox boxL;
    MenuBox boxR;
    EditBox amountBox;
    int page = 0;
    int itemsPerPage = 14;
    SynthesisScreen parent;

    public SynthesisMaterialScreen(SynthesisScreen parent) {
        super("gui.synthesis.materials", new Color(0, 255, 0));
        this.drawPlayerInfo = true;
        this.parent = parent;
    }

    public SynthesisMaterialScreen(String inv, String name, int moogle) {
        this(new SynthesisScreen(inv, name, moogle));
    }

    @Override
    public void action(ResourceLocation stackRL, ItemStack stack) {
        super.action(stackRL, stack);
        int amount = ModCapabilities.getPlayer((Player)this.f_96541_.f_91074_).getMaterialAmount(stack.m_41720_());
        this.amountBox.m_94144_("" + Math.min(64, amount));
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (delta > 0.0 && this.prev.f_93624_) {
            this.action("prev");
            return true;
        }
        if (delta < 0.0 && this.next.f_93624_) {
            this.action("next");
            return true;
        }
        return false;
    }

    protected void action(String string) {
        switch (string) {
            case "prev": {
                --this.page;
                this.f_96541_.f_91073_.m_5594_((Player)this.f_96541_.f_91074_, this.f_96541_.f_91074_.m_20183_(), (SoundEvent)ModSounds.menu_in.get(), SoundSource.MASTER, 1.0f, 1.0f);
                break;
            }
            case "next": {
                ++this.page;
                this.f_96541_.f_91073_.m_5594_((Player)this.f_96541_.f_91074_, this.f_96541_.f_91074_.m_20183_(), (SoundEvent)ModSounds.menu_in.get(), SoundSource.MASTER, 1.0f, 1.0f);
                break;
            }
            case "deposit": {
                this.f_96541_.f_91073_.m_5594_((Player)this.f_96541_.f_91074_, this.f_96541_.f_91074_.m_20183_(), (SoundEvent)ModSounds.menu_in.get(), SoundSource.MASTER, 1.0f, 1.0f);
                LocalPlayer player = this.f_96541_.f_91074_;
                IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)player);
                try {
                    for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                        ItemStack stack = player.m_150109_().m_8020_(i);
                        if (ItemStack.m_41728_((ItemStack)stack, (ItemStack)ItemStack.f_41583_) || !stack.m_204117_(Tags.MATERIALS)) continue;
                        playerData.addMaterial(stack.m_41720_(), stack.m_41613_());
                        player.m_150109_().m_6836_(i, ItemStack.f_41583_);
                    }
                }
                catch (ConcurrentModificationException e) {
                    e.printStackTrace();
                }
                PacketHandler.sendToServer(new CSDepositMaterials(this.parent.invFile, this.parent.name, this.parent.moogle));
                break;
            }
            case "back": {
                this.f_96541_.m_91152_((Screen)new SynthesisScreen(this.parent.invFile, this.parent.name, this.parent.moogle));
                break;
            }
            case "take": {
                ItemStack selectedItemstack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(this.selectedRL));
                if (ItemStack.m_41656_((ItemStack)selectedItemstack, (ItemStack)ItemStack.f_41583_) || this.f_96541_.f_91074_.m_150109_().m_36062_() <= -1) break;
                try {
                    Integer.parseInt(this.amountBox.m_94155_());
                    PacketHandler.sendToServer(new CSTakeMaterials(selectedItemstack.m_41720_(), Integer.parseInt(this.amountBox.m_94155_()), this.parent.invFile, this.parent.name == null ? "" : this.parent.name, this.parent.moogle));
                    break;
                }
                catch (NumberFormatException e) {
                    KingdomKeys.LOGGER.error("NaN " + this.amountBox.m_94155_());
                }
            }
        }
        this.updateButtons();
    }

    private void updateButtons() {
    }

    @Override
    public void m_7856_() {
        float boxPosX = (float)this.f_96543_ * 0.2f;
        float topBarHeight = (float)this.f_96544_ * 0.17f;
        float boxWidth = (float)this.f_96543_ * 0.33f;
        float middleHeight = (float)this.f_96544_ * 0.6f;
        this.boxL = new MenuBox((int)boxPosX, (int)topBarHeight, (int)boxWidth, (int)middleHeight, new Color(4, 4, 68));
        this.boxR = new MenuBox(this.boxL.m_252754_() + this.boxL.m_5711_(), (int)topBarHeight, (int)boxWidth, (int)middleHeight, new Color(4, 4, 68));
        super.m_7856_();
        this.initItems();
        this.itemsPerPage = (int)(middleHeight / 14.0f);
    }

    @Override
    public void initItems() {
        float buttonPosX = (float)this.f_96543_ * 0.008f;
        int button_statsY = (int)this.topBarHeight + 10;
        float buttonWidth = (float)this.f_96543_ * 0.1744f - 20.0f;
        float invPosX = this.boxL.m_252754_();
        float invPosY = (float)this.f_96544_ * 0.1851f;
        this.inventory.clear();
        this.m_6702_().clear();
        this.f_169369_.clear();
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)this.f_96541_.f_91074_);
        for (Map.Entry<ResourceLocation, Integer> mat : playerData.getMaterialMap().entrySet()) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(mat.getKey());
            items.add(new ItemStack((ItemLike)item, mat.getValue().intValue()));
        }
        items.sort(Comparator.comparing(Utils::getCategoryForStack).thenComparing(ItemStack::m_41778_));
        for (int i = 0; i < items.size(); ++i) {
            this.inventory.add(new MenuStockItem(this, (ItemStack)items.get(i), (int)invPosX, (int)invPosY + i * 14, (int)((float)this.f_96543_ * 0.3255f), true));
        }
        this.inventory.forEach(x$0 -> {
            MenuStockItem cfr_ignored_0 = (MenuStockItem)this.m_7787_((GuiEventListener)x$0);
        });
        this.prev = Button.m_253074_((Component)Component.m_237115_((String)"<--"), e -> this.action("prev")).m_252987_((int)buttonPosX + 10, (int)((float)this.f_96544_ * 0.1f), 30, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.prev);
        this.next = Button.m_253074_((Component)Component.m_237115_((String)"-->"), e -> this.action("next")).m_252987_((int)buttonPosX + 10 + 76, (int)((float)this.f_96544_ * 0.1f), 30, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.next);
        this.prev.f_93624_ = false;
        this.next.f_93624_ = false;
        this.deposit = new MenuButton((int)buttonPosX, button_statsY + 0, (int)buttonWidth, Utils.translateToLocal("gui.synthesis.materials.deposit", new Object[0]), MenuButton.ButtonType.BUTTON, e -> this.action("deposit"));
        this.m_142416_((GuiEventListener)this.deposit);
        this.back = new MenuButton((int)buttonPosX, button_statsY + 18, (int)buttonWidth, Utils.translateToLocal("gui.menu.back", new Object[0]), MenuButton.ButtonType.BUTTON, e -> this.action("back"));
        this.m_142416_((GuiEventListener)this.back);
        this.amountBox = new EditBox(this.f_96541_.f_91062_, this.boxR.m_252754_() + 50, (int)(this.topBarHeight + this.middleHeight - 20.0f), this.f_96541_.f_91062_.m_92895_("#####"), 16, (Component)Component.m_237115_((String)"test")){

            public boolean m_5534_(char c, int i) {
                if (Utils.isNumber(c)) {
                    String text = new StringBuilder(this.m_94155_()).insert(this.m_94207_(), c).toString();
                    if (Integer.parseInt(text) > 64) {
                        return false;
                    }
                } else {
                    return false;
                }
                return super.m_5534_(c, i);
            }
        };
        this.m_142416_((GuiEventListener)this.amountBox);
        this.take = Button.m_253074_((Component)Component.m_237115_((String)Utils.translateToLocal("gui.synthesis.materials.take", new Object[0])), e -> this.action("take")).m_252987_(this.amountBox.m_252754_() + this.amountBox.m_5711_() + 5, (int)(this.topBarHeight + this.middleHeight - 22.0f), 80, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.take);
        this.take.f_93624_ = false;
        this.updateButtons();
    }

    @Override
    public void m_88315_(@NotNull GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        int i;
        PoseStack matrixStack = gui.m_280168_();
        this.drawMenuBackground(gui, mouseX, mouseY, partialTicks);
        this.boxL.m_87963_(gui, mouseX, mouseY, partialTicks);
        this.boxR.m_87963_(gui, mouseX, mouseY, partialTicks);
        gui.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        super.m_88315_(gui, mouseX, mouseY, partialTicks);
        this.prev.f_93624_ = this.page > 0;
        boolean bl = this.next.f_93624_ = this.page < this.inventory.size() / this.itemsPerPage;
        if (this.f_96541_.f_91074_.m_150109_().m_36062_() == -1) {
            this.take.f_93623_ = false;
            this.take.m_93666_((Component)Component.m_237115_((String)"gui.shopno_empty_slot"));
        }
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)((float)this.f_96543_ * 0.008f + 45.0f), (double)this.f_96544_ * 0.15 - 18.0, 1.0);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        gui.m_280488_(this.f_96541_.f_91062_, Utils.translateToLocal("gui.shop.page", new Object[0]) + " " + (this.page + 1), 0, 10, 0xFF9900);
        matrixStack.m_85849_();
        for (i = 0; i < this.inventory.size(); ++i) {
            ((MenuStockItem)((Object)this.inventory.get((int)i))).f_93623_ = false;
        }
        for (i = this.page * this.itemsPerPage; i < this.page * this.itemsPerPage + this.itemsPerPage; ++i) {
            if (i >= this.inventory.size() || i < 0 || this.inventory.get(i) == null) continue;
            ((MenuStockItem)((Object)this.inventory.get((int)i))).f_93624_ = true;
            ((MenuStockItem)((Object)this.inventory.get(i))).m_253211_((int)this.topBarHeight + i % this.itemsPerPage * 14 + 5);
            ((MenuStockItem)((Object)this.inventory.get(i))).m_88315_(gui, mouseX, mouseY, partialTicks);
            ((MenuStockItem)((Object)this.inventory.get((int)i))).f_93623_ = true;
        }
        this.prev.m_88315_(gui, mouseX, mouseY, partialTicks);
        this.next.m_88315_(gui, mouseX, mouseY, partialTicks);
        this.deposit.m_88315_(gui, mouseX, mouseY, partialTicks);
        this.back.m_88315_(gui, mouseX, mouseY, partialTicks);
    }

    @Override
    protected void renderSelectedData(GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        PoseStack matrixStack = gui.m_280168_();
        this.amountBox.m_88315_(gui, mouseX, mouseY, partialTicks);
        this.take.m_88315_(gui, mouseX, mouseY, partialTicks);
        this.take.f_93624_ = true;
        float iconPosX = this.boxR.m_252754_();
        float iconPosY = this.boxR.m_252907_() + 15;
        matrixStack.m_85836_();
        String name = this.selectedItemStack.m_41786_().getString();
        matrixStack.m_252880_((float)(this.boxR.m_252754_() + this.boxR.m_5711_() / 2 - this.f_96541_.f_91062_.m_92895_(name) / 2), (float)(this.boxR.m_252907_() + 3), 1.0f);
        gui.m_280488_(this.f_96541_.f_91062_, Utils.translateToLocal(name, new Object[0]), 0, 0, 0xFF9900);
        matrixStack.m_85849_();
        matrixStack.m_85836_();
        float size = 80.0f;
        double offset = (float)this.boxR.m_5711_() * 0.1f;
        matrixStack.m_85837_((double)this.boxR.m_252754_() + offset / 2.0, (double)iconPosY, 1.0);
        matrixStack.m_252880_((float)this.boxR.m_5711_() * 0.7f / 2.0f, (float)(this.boxR.m_93694_() / 2) - size / 2.0f, 0.0f);
        ClientUtils.drawItemAsIcon(this.selectedItemStack, matrixStack, 0, 0, (int)size);
        matrixStack.m_85849_();
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7379_() {
        if (this.parent.moogle != -1) {
            PacketHandler.sendToServer(new CSCloseMoogleGUI(this.parent.moogle));
        }
        super.m_7379_();
    }
}

