/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.render.block;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import online.kingdomkeys.kingdomkeys.entity.block.PedestalTileEntity;
import online.kingdomkeys.kingdomkeys.item.KeychainItem;

public class PedestalRenderer
implements BlockEntityRenderer<PedestalTileEntity> {
    private ItemRenderer renderItem;

    public PedestalRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(PedestalTileEntity tileEntityIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        this.renderItem = Minecraft.m_91087_().m_91291_();
        if (!tileEntityIn.isStationOfAwakeningMarker()) {
            tileEntityIn.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(iih -> {
                if (!iih.getStackInSlot(0).m_41619_()) {
                    this.renderItem(tileEntityIn, matrixStackIn, bufferIn, partialTicks, iih.getStackInSlot(0).m_41720_() instanceof KeychainItem ? new ItemStack((ItemLike)((KeychainItem)iih.getStackInSlot(0).m_41720_()).getKeyblade()) : iih.getStackInSlot(0), combinedLightIn);
                }
            });
        } else if (!tileEntityIn.hide) {
            this.renderItem(tileEntityIn, matrixStackIn, bufferIn, partialTicks, tileEntityIn.getDisplayStack(), combinedLightIn);
        }
    }

    private void renderItem(PedestalTileEntity tileEntity, PoseStack matrixStack, MultiBufferSource buffer, float partialTicks, ItemStack toRender, int combinedLightIn) {
        float rotation;
        float height;
        matrixStack.m_85836_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (!tileEntity.isPaused()) {
            float lerpedTicks = (float)PedestalTileEntity.previousTicks + (float)(tileEntity.ticksExisted() - PedestalTileEntity.previousTicks) * partialTicks;
            height = tileEntity.getBaseHeight() + 0.1f * (float)Math.sin(tileEntity.getBobSpeed() * lerpedTicks);
            rotation = lerpedTicks * tileEntity.getRotationSpeed() % 360.0f;
            tileEntity.setCurrentTransforms(rotation, height);
        } else {
            height = tileEntity.getSavedHeight();
            rotation = tileEntity.getSavedRotation();
        }
        matrixStack.m_252880_(0.5f, height, 0.5f);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(rotation));
        matrixStack.m_85841_(tileEntity.getScale(), tileEntity.getScale(), tileEntity.getScale());
        if (tileEntity.isFlipped()) {
            matrixStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
            matrixStack.m_252880_(0.0f, -0.6f, 0.0f);
        }
        BakedModel model = this.renderItem.m_174264_(toRender, tileEntity.m_58904_(), null, 1);
        this.renderItem.m_115143_(toRender, ItemDisplayContext.FIXED, false, matrixStack, buffer, combinedLightIn, OverlayTexture.f_118083_, model);
        matrixStack.m_85849_();
    }
}

