/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.command.BaseCommand;

public class HeartsCommand
extends BaseCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.m_82127_((String)"hearts").requires(source -> source.m_6761_(2));
        builder.then(Commands.m_82127_((String)"set").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1, (int)Integer.MAX_VALUE)).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(HeartsCommand::setValue))).executes(HeartsCommand::setValue)));
        builder.then(Commands.m_82127_((String)"give").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1, (int)Integer.MAX_VALUE)).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(HeartsCommand::addValue))).executes(HeartsCommand::addValue)));
        builder.then(Commands.m_82127_((String)"take").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1, (int)Integer.MAX_VALUE)).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(HeartsCommand::removeValue))).executes(HeartsCommand::removeValue)));
        KingdomKeys.LOGGER.warn("Registered command " + builder.getLiteral());
        return builder;
    }

    private static int setValue(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<ServerPlayer> players = HeartsCommand.getPlayers(context, 3);
        int value = IntegerArgumentType.getInteger(context, (String)"value");
        for (ServerPlayer player : players) {
            HeartsCommand.setValue(context, value, player);
        }
        return 1;
    }

    private static int setValue(CommandContext<CommandSourceStack> context, int value, ServerPlayer player) throws CommandSyntaxException {
        IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)player);
        playerData.setHearts(value);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)("Set " + player.m_5446_().getString() + " hearts to " + value)), true);
        player.m_213846_((Component)Component.m_237115_((String)("Your hearts have been set to " + value)));
        return 1;
    }

    private static int addValue(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<ServerPlayer> players = HeartsCommand.getPlayers(context, 4);
        int value = IntegerArgumentType.getInteger(context, (String)"value");
        for (ServerPlayer player : players) {
            HeartsCommand.addValue(context, value, player);
        }
        return 1;
    }

    private static int addValue(CommandContext<CommandSourceStack> context, int value, ServerPlayer player) throws CommandSyntaxException {
        IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)player);
        playerData.addHearts(value);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)("Added " + value + " hearts to " + player.m_5446_().getString())), true);
        player.m_213846_((Component)Component.m_237115_((String)("Your hearts have been increased by " + value)));
        return 1;
    }

    private static int removeValue(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<ServerPlayer> players = HeartsCommand.getPlayers(context, 4);
        int value = IntegerArgumentType.getInteger(context, (String)"value");
        for (ServerPlayer player : players) {
            HeartsCommand.removeValue(context, value, player);
        }
        return 1;
    }

    private static int removeValue(CommandContext<CommandSourceStack> context, int value, ServerPlayer player) throws CommandSyntaxException {
        IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)player);
        playerData.removeHearts(value);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)("Taken " + value + " hearts from " + player.m_5446_().getString())), true);
        player.m_213846_((Component)Component.m_237115_((String)("Your hearts have been decreased by " + value)));
        return 1;
    }
}

