/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.command.BaseCommand;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncCapabilityPacket;
import online.kingdomkeys.kingdomkeys.shotlock.ModShotlocks;
import online.kingdomkeys.kingdomkeys.shotlock.Shotlock;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class ShotlockCommand
extends BaseCommand {
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_SHOTLOCKS = (p_198296_0_, p_198296_1_) -> {
        ArrayList<String> list = new ArrayList<String>();
        for (ResourceLocation actual : ModShotlocks.registry.get().getKeys()) {
            list.add(actual.toString());
        }
        return SharedSuggestionProvider.m_82981_(list.stream().map(StringArgumentType::escapeIfRequired), (SuggestionsBuilder)p_198296_1_);
    };

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.m_82127_((String)"shotlock").requires(source -> source.m_6761_(2));
        builder.then(Commands.m_82127_((String)"give").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"shotlock", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_SHOTLOCKS).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(ShotlockCommand::addShotlock))).executes(ShotlockCommand::addShotlock)));
        builder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"take").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"shotlock", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_SHOTLOCKS).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(ShotlockCommand::removeShotlock))).executes(ShotlockCommand::removeShotlock))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"all").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(ShotlockCommand::removeAllShotlocks))).executes(ShotlockCommand::removeAllShotlocks)));
        KingdomKeys.LOGGER.warn("Registered command " + builder.getLiteral());
        return builder;
    }

    private static int addShotlock(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<ServerPlayer> players = ShotlockCommand.getPlayers(context, 4);
        String shotlockName = StringArgumentType.getString(context, (String)"shotlock");
        for (ServerPlayer player : players) {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)player);
            Shotlock a = (Shotlock)ModShotlocks.registry.get().getValue(new ResourceLocation(shotlockName));
            playerData.addShotlockToList(shotlockName, true);
            if (player != ((CommandSourceStack)context.getSource()).m_81375_()) {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)("Added '" + Utils.translateToLocal(a.getTranslationKey(), new Object[0]) + "' shotlock to " + player.m_5446_().getString())), true);
            }
            player.m_213846_((Component)Component.m_237115_((String)("You have been given the shotlock '" + Utils.translateToLocal(a.getTranslationKey(), new Object[0]) + "'")));
            PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), player);
        }
        return 1;
    }

    private static int removeShotlock(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<ServerPlayer> players = ShotlockCommand.getPlayers(context, 4);
        String shotlock = StringArgumentType.getString(context, (String)"shotlock");
        for (ServerPlayer player : players) {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)player);
            playerData.removeShotlockFromList(shotlock);
            if (player != ((CommandSourceStack)context.getSource()).m_81375_()) {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)("Removed shotlock '" + Utils.translateToLocal(shotlock, new Object[0]) + "' from " + player.m_5446_().getString())), true);
            }
            Shotlock a = (Shotlock)ModShotlocks.registry.get().getValue(new ResourceLocation(shotlock));
            player.m_213846_((Component)Component.m_237115_((String)("Your shotlock '" + Utils.translateToLocal(a.getTranslationKey(), new Object[0]) + "' has been taken away")));
            PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), player);
        }
        return 1;
    }

    private static int removeAllShotlocks(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<ServerPlayer> players = ShotlockCommand.getPlayers(context, 4);
        for (ServerPlayer player : players) {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)player);
            playerData.getShotlockList().clear();
            if (player != ((CommandSourceStack)context.getSource()).m_81375_()) {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)("Removed all shotlocks from " + player.m_5446_().getString())), true);
            }
            player.m_213846_((Component)Component.m_237115_((String)"Your shotlocks have been taken away"));
            PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), player);
        }
        return 1;
    }
}

