/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.driveform;

import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.driveform.DriveForm;
import online.kingdomkeys.kingdomkeys.driveform.ModDriveForms;
import online.kingdomkeys.kingdomkeys.entity.EntityHelper;
import online.kingdomkeys.kingdomkeys.entity.mob.IKHMob;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.cts.CSSetAerialDodgeTicksPacket;
import online.kingdomkeys.kingdomkeys.network.cts.CSSetGlidingPacket;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncCapabilityPacket;

@Mod.EventBusSubscriber(modid="kingdomkeys")
public class DriveFormFinal
extends DriveForm {
    public DriveFormFinal(String registryName, int order, ResourceLocation skinRL, boolean hasKeychain, boolean baseGrowth) {
        super(registryName, order, hasKeychain, baseGrowth);
        this.color = new float[]{0.9f, 0.9f, 0.9f};
        this.skinRL = skinRL;
    }

    @SubscribeEvent
    public static void getFinalFormXP(LivingDeathEvent event) {
        Player player;
        IPlayerCapabilities playerData;
        if ((!event.getEntity().m_9236_().f_46443_ && event.getEntity() instanceof EnderMan || event.getEntity() instanceof IKHMob && ((IKHMob)event.getEntity()).getKHMobType() == EntityHelper.MobType.NOBODY) && event.getSource().m_7639_() instanceof Player && (playerData = ModCapabilities.getPlayer(player = (Player)event.getSource().m_7639_())) != null && playerData.getActiveDriveForm().equals("kingdomkeys:form_final")) {
            double mult = Double.parseDouble(ModConfigs.driveFormXPMultiplier.get(4).split(",")[1]);
            playerData.setDriveFormExp(player, playerData.getActiveDriveForm(), (int)((double)playerData.getDriveFormExp(playerData.getActiveDriveForm()) + 1.0 * mult));
            PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), (ServerPlayer)player);
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingTickEvent event) {
        Player player;
        IPlayerCapabilities playerData;
        if (event.getEntity() instanceof Player && (playerData = ModCapabilities.getPlayer(player = (Player)event.getEntity())) != null) {
            if (playerData.getDriveFormMap() != null && playerData.getActiveDriveForm().equals("kingdomkeys:form_final")) {
                DriveFormFinal.handleHighJump(player, playerData);
            }
            DriveForm form = (DriveForm)ModDriveForms.registry.get().getValue(new ResourceLocation(playerData.getActiveDriveForm()));
            if (playerData.getActiveDriveForm().equals("kingdomkeys:form_final") || (playerData.getActiveDriveForm().equals(DriveForm.NONE.toString()) || form.getBaseGrowthAbilities()) && playerData.getDriveFormMap().containsKey("kingdomkeys:form_final") && playerData.getDriveFormLevel("kingdomkeys:form_final") >= 3 && playerData.getEquippedAbilityLevel("kingdomkeys:ability_glide") != null && playerData.getEquippedAbilityLevel("kingdomkeys:ability_glide")[1] > 0) {
                DriveFormFinal.handleGlide(player, playerData);
            }
            if (playerData.getIsGliding() && playerData.getActiveDriveForm().equals(DriveForm.NONE.toString()) && playerData.getEquippedAbilityLevel("kingdomkeys:ability_glide")[1] == 0) {
                playerData.setIsGliding(false);
            }
        }
    }

    private static void handleHighJump(Player player, IPlayerCapabilities playerData) {
        boolean j = false;
        if (player.m_9236_().f_46443_) {
            j = Minecraft.m_91087_().f_91066_.f_92089_.m_90857_();
        }
        if (j && player.m_20184_().f_82480_ > 0.0 && playerData.getActiveDriveForm().equals("kingdomkeys:form_final")) {
            player.m_20256_(player.m_20184_().m_82520_(0.0, (double)DriveForm.FINAL_JUMP_BOOST[playerData.getDriveFormLevel("kingdomkeys:form_final")], 0.0));
        }
    }

    private static void handleGlide(Player player, IPlayerCapabilities playerData) {
        if (player.m_20069_() || player.m_20077_()) {
            return;
        }
        if (player.m_9236_().f_46443_) {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ == player) {
                if (!player.m_20096_() && player.f_19789_ > 0.0f) {
                    if (mc.f_91066_.f_92089_.m_90857_()) {
                        if (!(playerData.getIsGliding() || player.m_9236_().m_8055_(player.m_20183_()).m_60734_() instanceof LiquidBlock || player.m_9236_().m_8055_(player.m_20183_().m_7495_()).m_60734_() instanceof LiquidBlock)) {
                            playerData.setIsGliding(true);
                            playerData.setAerialDodgeTicks(0);
                            PacketHandler.sendToServer(new CSSetGlidingPacket(true));
                            PacketHandler.sendToServer(new CSSetAerialDodgeTicksPacket(true, 0));
                        }
                    } else if (playerData.getIsGliding()) {
                        playerData.setIsGliding(false);
                        PacketHandler.sendToServer(new CSSetGlidingPacket(false));
                    }
                } else if (playerData.getIsGliding()) {
                    playerData.setIsGliding(false);
                    PacketHandler.sendToServer(new CSSetGlidingPacket(false));
                    PacketHandler.sendToServer(new CSSetAerialDodgeTicksPacket(false, 0));
                }
            }
        }
        if (playerData.getIsGliding()) {
            int glideLevel = playerData.getActiveDriveForm().equals(DriveForm.NONE.toString()) ? playerData.getDriveFormLevel("kingdomkeys:form_final") - 2 : playerData.getDriveFormLevel("kingdomkeys:form_final");
            float glide = DriveForm.FINAL_GLIDE[glideLevel];
            float limit = DriveForm.FINAL_GLIDE_SPEED[glideLevel];
            Vec3 motion = player.m_20184_();
            if (Math.abs(motion.m_7096_()) < (double)limit && Math.abs(motion.m_7094_()) < (double)limit) {
                player.m_20334_(motion.m_7096_() * 1.1, (double)glide, motion.m_7094_() * 1.1);
            }
            if (player.getForcedPose() != Pose.SWIMMING) {
                player.setForcedPose(Pose.SWIMMING);
            }
        }
    }
}

