/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncCapabilityPacket;

public abstract class ItemDropEntity
extends Entity {
    public int delayBeforeCanPickup;
    public int value;
    private Player closestPlayer;
    private static final EntityDataAccessor<Integer> VALUE = SynchedEntityData.m_135353_(ItemDropEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public ItemDropEntity(EntityType<? extends Entity> type, Level worldIn, double x, double y, double z, int expValue) {
        this(type, worldIn);
        this.m_6034_(x, y, z);
        this.m_146922_((float)(this.f_19796_.m_188500_() * 360.0));
        this.m_20334_((this.f_19796_.m_188500_() * (double)0.2f - (double)0.1f) * 2.0, this.f_19796_.m_188500_() * 0.2 * 2.0, (this.f_19796_.m_188500_() * (double)0.2f - (double)0.1f) * 2.0);
        this.setValue(expValue);
        this.delayBeforeCanPickup = 20;
    }

    public ItemDropEntity(EntityType<ItemDropEntity> type, PlayMessages.SpawnEntity spawnEntity, Level world) {
        super(type, world);
    }

    public ItemDropEntity(EntityType<? extends Entity> type, Level world) {
        super(type, world);
    }

    protected boolean isMovementNoisy() {
        return false;
    }

    public void m_8119_() {
        IPlayerCapabilities playerData;
        if (this.f_19797_ > 2400) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        super.m_8119_();
        if (this.delayBeforeCanPickup > 0) {
            --this.delayBeforeCanPickup;
        }
        this.f_19854_ = this.m_20185_();
        this.f_19855_ = this.m_20186_();
        this.f_19856_ = this.m_20189_();
        if (this.m_204029_(FluidTags.f_13131_)) {
            this.applyFloatMotion();
        } else if (!this.m_20068_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.03, 0.0));
        }
        if (this.m_9236_().m_6425_(new BlockPos((int)this.m_20182_().f_82479_, (int)this.m_20182_().f_82480_, (int)this.m_20182_().f_82481_)).m_205070_(FluidTags.f_13132_)) {
            this.m_20334_((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f, 0.2f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f);
            this.m_5496_(SoundEvents.f_11909_, 0.4f, 2.0f + this.f_19796_.m_188501_() * 0.4f);
        }
        if (!this.m_9236_().m_45772_(this.m_20191_())) {
            this.m_20314_(this.m_20185_(), (this.m_20191_().f_82289_ + this.m_20191_().f_82292_) / 2.0, this.m_20189_());
        }
        double maxDist = 8.0;
        if (this.closestPlayer == null || this.closestPlayer.m_20280_((Entity)this) > Math.pow(maxDist, 2.0)) {
            this.closestPlayer = this.m_9236_().m_45930_((Entity)this, maxDist);
        }
        if (this.closestPlayer != null && this.closestPlayer.m_5833_()) {
            this.closestPlayer = null;
        }
        if (this.closestPlayer != null && (playerData = ModCapabilities.getPlayer(this.closestPlayer)) != null) {
            maxDist = 8 + playerData.getNumberOfAbilitiesEquipped("kingdomkeys:ability_treasure_magnet") * 2;
            Vec3 vec3d = new Vec3(this.closestPlayer.m_20185_() - this.m_20185_(), this.closestPlayer.m_20186_() + (double)this.closestPlayer.m_20192_() / 2.0 - this.m_20186_(), this.closestPlayer.m_20189_() - this.m_20189_());
            double d1 = vec3d.m_82556_();
            if (d1 < Math.pow(maxDist, 2.0)) {
                double d2 = 1.0 - Math.sqrt(d1) / maxDist;
                this.m_20256_(this.m_20184_().m_82549_(vec3d.m_82541_().m_82490_(d2 * d2 * 0.1)));
            }
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        float f = 0.98f;
        if (this.m_20096_()) {
            BlockPos pos = new BlockPos((int)this.m_20185_(), (int)(this.m_20186_() - 1.0), (int)this.m_20189_());
            f = this.m_9236_().m_8055_(pos).getFriction((LevelReader)this.m_9236_(), pos, (Entity)this) * 0.98f;
        }
        this.m_20256_(this.m_20184_().m_82542_((double)f, 0.98, (double)f));
        if (this.m_20096_()) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, -0.9, 1.0));
        }
    }

    private void applyFloatMotion() {
        Vec3 vec3d = this.m_20184_();
        this.m_20334_(vec3d.f_82479_ * (double)0.99f, Math.min(vec3d.f_82480_ + (double)5.0E-4f, (double)0.06f), vec3d.f_82481_ * (double)0.99f);
    }

    protected void dealFireDamage(int amount) {
        this.m_6469_(this.m_269291_().m_269549_(), amount);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_9236_().f_46443_ || this.m_213877_()) {
            return false;
        }
        if (this.m_6673_(source)) {
            return false;
        }
        this.m_5834_();
        return false;
    }

    public void m_7380_(CompoundTag compound) {
        compound.m_128405_("value", this.getValue());
    }

    public void m_7378_(CompoundTag compound) {
        this.setValue(compound.m_128451_("value"));
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (key.equals(VALUE)) {
            this.value = (Integer)this.f_19804_.m_135370_(VALUE);
        }
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int v) {
        this.f_19804_.m_135381_(VALUE, (Object)v);
        this.value = v;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(VALUE, (Object)0);
    }

    public void m_6123_(Player entityIn) {
        if (!this.m_9236_().f_46443_ && this.delayBeforeCanPickup == 0) {
            this.onPickup(entityIn);
            this.m_5496_(this.getPickupSound(), 1.0f, 1.0f);
            this.m_142687_(Entity.RemovalReason.KILLED);
            PacketHandler.sendTo(new SCSyncCapabilityPacket(ModCapabilities.getPlayer(entityIn)), (ServerPlayer)entityIn);
        }
    }

    abstract void onPickup(Player var1);

    abstract SoundEvent getPickupSound();

    @OnlyIn(value=Dist.CLIENT)
    public int getTextureByXP() {
        if (this.value >= 2477) {
            return 10;
        }
        if (this.value >= 1237) {
            return 9;
        }
        if (this.value >= 617) {
            return 8;
        }
        if (this.value >= 307) {
            return 7;
        }
        if (this.value >= 149) {
            return 6;
        }
        if (this.value >= 73) {
            return 5;
        }
        if (this.value >= 37) {
            return 4;
        }
        if (this.value >= 17) {
            return 3;
        }
        if (this.value >= 7) {
            return 2;
        }
        return this.value >= 3 ? 1 : 0;
    }

    public boolean m_6097_() {
        return false;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

