/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.block;

import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;

public class BlastBloxEntity
extends Entity {
    private static final EntityDataAccessor<Integer> FUSE = SynchedEntityData.m_135353_(BlastBloxEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int fuse = 40;
    @Nullable
    private LivingEntity placedBy;

    public BlastBloxEntity(EntityType<? extends Entity> type, Level world) {
        super(type, world);
        this.f_19850_ = true;
    }

    public static BlastBloxEntity create(EntityType<? extends Entity> type, Level world) {
        return new BlastBloxEntity(type, world);
    }

    public BlastBloxEntity(PlayMessages.SpawnEntity spawnEntity, Level world) {
        super((EntityType)ModEntities.TYPE_BLAST_BLOX.get(), world);
    }

    public BlastBloxEntity(EntityType type, Level world, double x, double y, double z, @Nullable LivingEntity igniter) {
        this((EntityType<? extends Entity>)type, world);
        this.m_6034_(x, y, z);
        double random = world.f_46441_.m_188500_() * 6.2831854820251465;
        this.m_20334_(-Math.sin(random) * 0.02, 0.2f, -Math.cos(random) * 0.02);
        this.setFuse(40);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
        this.placedBy = igniter;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(FUSE, (Object)40);
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    public boolean m_6087_() {
        return this.m_6084_();
    }

    public void m_8119_() {
        this.f_19854_ = this.m_20183_().m_123341_();
        this.f_19855_ = this.m_20183_().m_123342_();
        this.f_19856_ = this.m_20183_().m_123343_();
        if (!this.m_20068_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        this.m_20256_(this.m_20184_().m_82490_(0.98));
        if (this.m_20096_()) {
            this.m_20256_(this.m_20184_().m_82542_(0.7, -0.5, 0.7));
        }
        --this.fuse;
        if (this.fuse <= 0) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            if (!this.m_9236_().f_46443_) {
                this.explode();
            }
        } else {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, (double)this.m_20183_().m_123341_(), (double)this.m_20183_().m_123342_() + 0.5, (double)this.m_20183_().m_123343_(), 0.0, 0.0, 0.0);
        }
    }

    private void explode() {
        float explosionSize = 4.0f;
        this.m_9236_().m_255391_((Entity)this, (double)this.m_20183_().m_123341_(), (double)this.m_20183_().m_123342_() + (double)(this.m_20206_() / 16.0f), (double)this.m_20183_().m_123343_(), explosionSize, true, Level.ExplosionInteraction.TNT);
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128376_("Fuse", (short)this.getFuse());
    }

    protected void m_7378_(CompoundTag compound) {
        this.setFuse(compound.m_128448_("Fuse"));
    }

    @Nullable
    public LivingEntity getPlacedBy() {
        return this.placedBy;
    }

    protected float m_6380_(Pose pose, EntityDimensions entitySize) {
        return 0.0f;
    }

    public void setFuse(int fuse) {
        this.f_19804_.m_135381_(FUSE, (Object)fuse);
        this.fuse = fuse;
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (FUSE.equals(key)) {
            this.fuse = this.getFuseDataManager();
        }
    }

    public int getFuseDataManager() {
        return (Integer)this.f_19804_.m_135370_(FUSE);
    }

    public int getFuse() {
        return this.fuse;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

