/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.mob;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.entity.EntityHelper;
import online.kingdomkeys.kingdomkeys.entity.mob.BaseKHEntity;
import online.kingdomkeys.kingdomkeys.item.KKResistanceType;

public abstract class BaseBombEntity
extends BaseKHEntity
implements IEntityAdditionalSpawnData {
    public int ticksToExplode = 100;
    boolean hasExploded = false;

    protected BaseBombEntity(EntityType<? extends Monster> type, Level worldIn) {
        super(type, worldIn);
    }

    public BaseBombEntity(EntityType<? extends Monster> type, PlayMessages.SpawnEntity spawnEntity, Level world) {
        this(type, world);
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract ResourceLocation getTexture();

    public abstract float getExplosionStength();

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.m_21183_().m_22268_(Attributes.f_22277_, 35.0).m_22268_(Attributes.f_22279_, 0.4).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22282_, 1.0);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new BombGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Villager.class, true));
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeInt(this.ticksToExplode);
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.ticksToExplode = additionalData.readInt();
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (!this.m_9236_().f_46443_ && ModConfigs.bombExplodeWithfire && (this.m_6060_() || source.m_19385_().equals(KKResistanceType.fire.toString()))) {
            this.explode();
        }
        return super.m_6469_(source, amount);
    }

    public void m_8119_() {
        if (EntityHelper.getState((Entity)this) == 1) {
            --this.ticksToExplode;
        }
        super.m_8119_();
    }

    public void explode() {
        if (!this.hasExploded) {
            this.hasExploded = true;
            Level.ExplosionInteraction explosion$mode = ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this) ? Level.ExplosionInteraction.MOB : Level.ExplosionInteraction.NONE;
            this.m_9236_().m_255391_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.getExplosionStength(), false, explosion$mode);
            for (LivingEntity enemy : EntityHelper.getEntitiesNear((Entity)this, this.getExplosionStength() + 1.0f)) {
                this.m_7327_((Entity)enemy);
            }
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    @Override
    public EntityHelper.MobType getKHMobType() {
        return EntityHelper.MobType.HEARTLESS_EMBLEM;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(EntityHelper.STATE, (Object)0);
    }

    class BombGoal
    extends Goal {
        private BaseBombEntity bomb;

        public BombGoal(BaseBombEntity bomb) {
            this.bomb = bomb;
        }

        public boolean m_8036_() {
            return this.bomb.m_5448_() != null && this.bomb.m_20280_((Entity)this.bomb.m_5448_()) < 64.0 && this.bomb.m_21223_() < this.bomb.m_21233_();
        }

        public boolean m_8045_() {
            if (this.m_8036_()) {
                EntityHelper.setState((Entity)this.bomb, 1);
                this.bomb.m_21051_(Attributes.f_22279_).m_22100_(0.8);
                if (this.bomb.ticksToExplode <= 0) {
                    this.bomb.explode();
                }
            }
            return false;
        }
    }
}

