/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.mob;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.item.ModItems;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCOpenSynthesisGui;
import online.kingdomkeys.kingdomkeys.synthesis.shop.ShopList;
import online.kingdomkeys.kingdomkeys.synthesis.shop.ShopListRegistry;
import online.kingdomkeys.kingdomkeys.synthesis.shop.names.NamesListRegistry;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class MoogleEntity
extends PathfinderMob
implements IEntityAdditionalSpawnData {
    String inv = Utils.randomWithRange(0, 100) >= 98 ? "kingdomkeys:special" : "kingdomkeys:default";
    String name;
    Player interacting;
    private boolean fakeMoogle = false;

    public MoogleEntity(EntityType<? extends PathfinderMob> type, Level worldIn) {
        super(type, worldIn);
        this.setRandomName();
        if (this.name == null) {
            this.name = "";
        }
    }

    public void setRandomName() {
        List<String> names;
        ShopList shop = ShopListRegistry.getInstance().getValue(new ResourceLocation(this.inv));
        if (shop != null && (names = NamesListRegistry.getInstance().getValue(shop.getNames())) != null && !names.isEmpty()) {
            this.name = names.get(Utils.randomWithRange(0, names.size() - 1));
        }
    }

    @Nullable
    public Component m_7770_() {
        if (this.name != null && !this.name.isEmpty()) {
            return Component.m_237115_((String)this.name);
        }
        return super.m_7770_();
    }

    public boolean m_8077_() {
        if (this.name != null && !this.name.isEmpty()) {
            return true;
        }
        return super.m_8077_();
    }

    public MoogleEntity(PlayMessages.SpawnEntity spawnEntity, Level world) {
        this((EntityType<? extends PathfinderMob>)((EntityType)ModEntities.TYPE_MOOGLE.get()), world);
    }

    protected void m_8099_() {
        this.normalGoals();
    }

    public void normalGoals() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new PanicGoal((PathfinderMob)this, 0.5));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.m_21183_().m_22268_(Attributes.f_22277_, 35.0).m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.28);
    }

    public Player getInteracting() {
        return this.interacting;
    }

    public void stopInteracting() {
        this.interacting = null;
        this.normalGoals();
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.inv);
        buffer.m_130070_(this.name);
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.inv = additionalData.m_130277_();
        this.name = additionalData.m_130277_();
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public InteractionResult m_7111_(Player player, Vec3 vec, InteractionHand hand) {
        if (!player.m_9236_().f_46443_) {
            if (!player.m_6047_()) {
                ItemStack itemstack = player.m_21120_(hand);
                if (!ItemStack.m_41656_((ItemStack)itemstack, (ItemStack)ItemStack.f_41583_) && itemstack.m_41720_() == ModItems.winnerStick.get()) {
                    IPlayerCapabilities playerData = ModCapabilities.getPlayer(player);
                    int reward = 500;
                    playerData.setMunny(playerData.getMunny() + reward);
                    itemstack.m_41774_(1);
                    player.m_213846_((Component)Component.m_237115_((String)(String.valueOf(ChatFormatting.YELLOW) + "You have been rewarded with " + reward + " munny!")));
                    return InteractionResult.FAIL;
                }
                PacketHandler.sendTo(new SCOpenSynthesisGui(this.inv, this.name, this.m_19879_()), (ServerPlayer)player);
                this.interacting = player;
                this.f_21345_.m_262460_(Objects::nonNull);
                this.f_21345_.m_25352_(0, (Goal)new LookAtInteractingPlayerGoal(this));
                return InteractionResult.SUCCESS;
            }
            return super.m_7111_(player, vec, hand);
        }
        ItemStack itemstack = player.m_21120_(hand);
        if (!ItemStack.m_41656_((ItemStack)itemstack, (ItemStack)ItemStack.f_41583_) && itemstack.m_41720_() == ModItems.winnerStick.get()) {
            return InteractionResult.SUCCESS;
        }
        return super.m_7111_(player, vec, hand);
    }

    public boolean m_6090_() {
        return true;
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    public int m_5792_() {
        return 1;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.kupoliving.get();
    }

    public int m_8100_() {
        return 600;
    }

    public boolean m_5545_(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return true;
    }

    public boolean isFakeMoogle() {
        return this.fakeMoogle;
    }

    public void setFakeMoogle(boolean fake) {
        this.fakeMoogle = fake;
    }

    public void m_8119_() {
        if (this.interacting != null && this.m_20270_((Entity)this.interacting) > 10.0f) {
            this.interacting = null;
        }
        super.m_8119_();
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128359_("inv", this.inv);
        pCompound.m_128359_("name", this.name);
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.inv = pCompound.m_128461_("inv");
        this.name = pCompound.m_128461_("name");
        if (this.name.isEmpty()) {
            this.setRandomName();
        }
    }

    public static class LookAtInteractingPlayerGoal
    extends LookAtPlayerGoal {
        public LookAtInteractingPlayerGoal(MoogleEntity moogle) {
            super((Mob)moogle, Player.class, 8.0f);
        }

        public boolean m_8036_() {
            if (((MoogleEntity)this.f_25512_).interacting != null) {
                this.f_25513_ = ((MoogleEntity)this.f_25512_).interacting;
                return true;
            }
            return false;
        }
    }
}

