/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.mob;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import online.kingdomkeys.kingdomkeys.capability.IGlobalCapabilities;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.entity.EntityHelper;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.entity.mob.IKHMob;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncCapabilityPacket;
import online.kingdomkeys.kingdomkeys.util.Utils;
import online.kingdomkeys.kingdomkeys.world.utils.BaseTeleporter;

public class SpawningOrbEntity
extends Monster {
    Monster mob;
    boolean portal;
    private static final EntityDataAccessor<String> ENTITY_TYPE = SynchedEntityData.m_135353_(SpawningOrbEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);

    public SpawningOrbEntity(EntityType<? extends SpawningOrbEntity> type, Level worldIn) {
        super(type, worldIn);
        Player player = Utils.getClosestPlayer((Entity)this, worldIn);
        if (player != null) {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer(player);
            if (playerData == null) {
                return;
            }
            this.mob = ModEntities.getRandomEnemy(playerData.getLevel(), this.m_9236_());
            this.setEntityType(((IKHMob)this.mob).getKHMobType().name());
            int randomLevel = Utils.getRandomMobLevel(player);
            IGlobalCapabilities mobData = ModCapabilities.getGlobal((LivingEntity)this.mob);
            if (mobData != null) {
                mobData.setLevel(randomLevel);
                PacketHandler.syncToAllAround((LivingEntity)this.mob, mobData);
            }
        }
    }

    public SpawningOrbEntity(PlayMessages.SpawnEntity spawnEntity, Level world) {
        super((EntityType)ModEntities.TYPE_SPAWNING_ORB.get(), world);
    }

    public boolean m_5545_(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        if (worldIn instanceof Level) {
            return ModCapabilities.getWorld((Level)worldIn).getHeartlessSpawnLevel() > 0;
        }
        return true;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return false;
    }

    public void m_8119_() {
        SimpleParticleType particle;
        if (this.f_19797_ == 1 && !this.m_9236_().f_46443_ && this.mob != null) {
            if (this.m_9236_().f_46441_.m_188500_() < 0.1) {
                this.setPortal(true);
            }
            this.setEntityType(((IKHMob)this.mob).getKHMobType().name());
        }
        SimpleParticleType simpleParticleType = particle = this.getEntityType().equals(EntityHelper.MobType.NOBODY.name()) ? ParticleTypes.f_123810_ : ParticleTypes.f_123799_;
        if (this.f_19797_ > 10 && this.f_19797_ < 60) {
            double x = this.m_20185_() + (this.m_9236_().f_46441_.m_188500_() - 0.5) * 2.0;
            double y = this.m_20186_() + (this.m_9236_().f_46441_.m_188500_() - 0.5) * 2.0 + 1.0;
            double z = this.m_20189_() + (this.m_9236_().f_46441_.m_188500_() - 0.5) * 2.0;
            this.m_9236_().m_7106_((ParticleOptions)particle, x, y, z, 0.0, 0.0, 0.0);
        }
        if (this.f_19797_ == 70) {
            if (!this.m_9236_().f_46443_) {
                if (this.mob != null) {
                    this.mob.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                    this.mob.m_5634_(this.mob.m_21233_());
                    this.m_9236_().m_7967_((Entity)this.mob);
                }
            } else {
                float radius = 0.5f;
                double X = this.m_20185_();
                double Y = this.m_20186_();
                double Z = this.m_20189_();
                for (int t = 1; t < 360; t += 20) {
                    for (int s = 1; s < 360; s += 20) {
                        double x = X + (double)radius * Math.cos(Math.toRadians(s)) * Math.sin(Math.toRadians(t));
                        double z = Z + (double)radius * Math.sin(Math.toRadians(s)) * Math.sin(Math.toRadians(t));
                        double y = Y + (double)radius * Math.cos(Math.toRadians(t)) + 1.0;
                        this.m_9236_().m_7106_((ParticleOptions)particle, x, y, z, (this.m_9236_().f_46441_.m_188500_() - 0.5) / 4.0, (this.m_9236_().f_46441_.m_188500_() - 0.5) / 4.0, (this.m_9236_().f_46441_.m_188500_() - 0.5) / 4.0);
                    }
                }
            }
        }
        if (this.f_19797_ >= 100) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        super.m_8119_();
    }

    public void setPortal(boolean portal) {
        this.portal = portal;
    }

    public boolean getPortal() {
        return this.portal;
    }

    public void m_6123_(Player nPlayer) {
        if (this.getPortal()) {
            ResourceKey dimension = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("kingdomkeys:realm_of_darkness"));
            IPlayerCapabilities playerData = ModCapabilities.getPlayer(nPlayer);
            if (playerData == null) {
                return;
            }
            playerData.setRespawnROD(true);
            if (!nPlayer.m_9236_().m_5776_()) {
                PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), (ServerPlayer)nPlayer);
            }
            BlockPos coords = nPlayer.m_20194_().m_129880_(dimension).m_220360_();
            nPlayer.changeDimension(nPlayer.m_20194_().m_129880_(dimension), (ITeleporter)new BaseTeleporter(coords));
            nPlayer.m_213846_((Component)Component.m_237115_((String)("You have been teleported to " + dimension.m_135782_().toString())));
        }
        super.m_6123_(nPlayer);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.m_21183_().m_22268_(Attributes.f_22277_, 35.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22278_, 1000.0).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22282_, 1.0);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.f_19804_.m_135370_(ENTITY_TYPE) != null) {
            compound.m_128359_("entity", (String)this.f_19804_.m_135370_(ENTITY_TYPE));
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(ENTITY_TYPE, (Object)compound.m_128461_("entity"));
    }

    public String getEntityType() {
        return (String)this.m_20088_().m_135370_(ENTITY_TYPE);
    }

    public void setEntityType(String type) {
        this.f_19804_.m_135381_(ENTITY_TYPE, (Object)type);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ENTITY_TYPE, (Object)"");
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

