/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.organization;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.item.KeybladeItem;
import online.kingdomkeys.kingdomkeys.item.organization.CardItem;
import online.kingdomkeys.kingdomkeys.item.organization.ChakramItem;
import online.kingdomkeys.kingdomkeys.item.organization.KnifeItem;
import online.kingdomkeys.kingdomkeys.item.organization.ScytheItem;

public class KKThrowableEntity
extends ThrowableItemProjectile {
    public static final EntityDataAccessor<ItemStack> ITEMSTACK = SynchedEntityData.m_135353_(KKThrowableEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<Integer> ROTATION_POINT = SynchedEntityData.m_135353_(KKThrowableEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    Set<LivingEntity> hitSet = new HashSet<LivingEntity>();
    public ItemStack originalItem;
    public int slot;
    public UUID ownerUUID;
    int maxTicks = 120;
    boolean returning = false;
    float dmg;
    Player owner;
    int rotationPoint;

    public KKThrowableEntity(PlayMessages.SpawnEntity spawnEntity, Level world) {
        super((EntityType)ModEntities.TYPE_KK_THROWABLE.get(), world);
    }

    public KKThrowableEntity(Level world) {
        super((EntityType)ModEntities.TYPE_KK_THROWABLE.get(), world);
        this.f_19850_ = true;
    }

    public void setData(float damage, UUID ownerUUID, int slot, ItemStack stack) {
        this.dmg = damage;
        this.ownerUUID = ownerUUID;
        this.slot = slot;
        this.originalItem = stack;
    }

    public Player getProjOwner() {
        if (this.owner == null && !this.m_9236_().f_46443_) {
            this.owner = (Player)((ServerLevel)this.m_9236_()).m_8791_(this.ownerUUID);
        }
        return this.owner;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected float m_7139_() {
        return 0.0f;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            if (this.getProjOwner() == null) {
                this.m_142687_(Entity.RemovalReason.KILLED);
                return;
            }
            if (this.f_19797_ > this.maxTicks) {
                this.m_142687_(Entity.RemovalReason.KILLED);
            }
            if (this.originalItem.m_41720_() instanceof KnifeItem) {
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_175830_, this.m_20185_(), this.m_20186_() + (double)0.3f, this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
            }
            if (this.f_19797_ > 30) {
                this.setReturn();
            }
            if (Math.max(Math.abs(this.m_20184_().f_82479_), Math.max(Math.abs(this.m_20184_().f_82480_), Math.abs(this.m_20184_().f_82481_))) < 0.1) {
                this.setReturn();
            }
            if (this.returning) {
                List entityTagetList = this.m_9236_().m_45976_(Entity.class, this.m_20191_().m_82377_(1.0, 1.0, 1.0));
                for (int i = 0; i < entityTagetList.size(); ++i) {
                    Player owner;
                    Entity entityTarget = (Entity)entityTagetList.get(i);
                    if (entityTarget == null || !(entityTarget instanceof Player) || (owner = (Player)entityTarget) != this.getProjOwner()) continue;
                    this.m_142687_(Entity.RemovalReason.KILLED);
                    this.returnItemToPlayer();
                    owner.m_36335_().m_41524_(this.originalItem.m_41720_(), 20);
                }
            }
        }
    }

    public void setReturn() {
        this.hitSet.clear();
        if (this.originalItem.m_41720_() instanceof KeybladeItem) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        } else if (this.originalItem.m_41720_() instanceof ChakramItem) {
            this.returning = true;
            if (this.getProjOwner() != null) {
                this.m_6686_(this.getProjOwner().m_20185_() - this.m_20185_(), this.getProjOwner().m_20186_() - this.m_20186_() + 1.25, this.getProjOwner().m_20189_() - this.m_20189_(), 2.0f, 0.0f);
            }
        } else if (this.originalItem.m_41720_() instanceof ScytheItem) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.returnItemToPlayer();
        } else if (this.originalItem.m_41720_() instanceof KnifeItem) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.returnItemToPlayer();
        } else if (this.originalItem.m_41720_() instanceof CardItem) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.returnItemToPlayer();
        }
    }

    private void returnItemToPlayer() {
        if (this.owner == null) {
            return;
        }
        if (!ItemStack.m_41656_((ItemStack)this.owner.m_150109_().m_8020_(this.slot), (ItemStack)this.originalItem)) {
            if (!ItemStack.m_41656_((ItemStack)this.owner.m_150109_().m_8020_(this.slot), (ItemStack)ItemStack.f_41583_)) {
                this.owner.m_36356_(this.originalItem);
            } else {
                this.owner.m_150109_().m_36040_(this.slot, this.originalItem);
            }
        }
    }

    protected void m_6532_(HitResult rtRes) {
        if (!this.m_9236_().f_46443_) {
            EntityHitResult ertResult = null;
            BlockHitResult brtResult = null;
            if (rtRes instanceof EntityHitResult) {
                ertResult = (EntityHitResult)rtRes;
            }
            if (rtRes instanceof BlockHitResult) {
                brtResult = (BlockHitResult)rtRes;
            }
            if (ertResult != null && ertResult.m_82443_() != null && ertResult.m_82443_() instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)ertResult.m_82443_();
                if (target != this.getProjOwner() && !this.hitSet.contains(target)) {
                    this.hitSet.add(target);
                    target.f_19802_ = 0;
                    target.m_6469_(target.m_269291_().m_269390_((Entity)this, (Entity)this.getProjOwner()), this.dmg < 4.0f ? 4.0f : this.dmg);
                    this.m_20256_(this.m_20184_().m_82490_(0.8));
                    this.dmg = (float)((double)this.dmg * 1.2);
                }
            } else if (brtResult != null && this.m_9236_().m_8055_(brtResult.m_82425_()).m_60734_() != Blocks.f_50359_ && this.m_9236_().m_8055_(brtResult.m_82425_()).m_60734_() != Blocks.f_50034_ && this.m_9236_().m_8055_(brtResult.m_82425_()).m_60734_() != Blocks.f_50130_ && this.m_9236_().m_8055_(brtResult.m_82425_()).m_60734_() != Blocks.f_50191_) {
                this.setReturn();
            }
        }
    }

    public int getMaxTicks() {
        return this.maxTicks;
    }

    public void setMaxTicks(int maxTicks) {
        this.maxTicks = maxTicks;
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (key.equals(ITEMSTACK)) {
            this.originalItem = (ItemStack)this.f_19804_.m_135370_(ITEMSTACK);
        }
        if (key.equals(ROTATION_POINT)) {
            this.rotationPoint = (Integer)this.f_19804_.m_135370_(ROTATION_POINT);
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128365_("ogitem", (Tag)this.originalItem.serializeNBT());
        if (this.ownerUUID != null) {
            compound.m_128362_("ownerUUID", this.ownerUUID);
        }
        compound.m_128405_("Rotation", this.getRotationPoint());
        compound.m_128405_("slot", this.slot);
        compound.m_128350_("damage", this.dmg);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("ogitem")) {
            this.originalItem = ItemStack.m_41712_((CompoundTag)compound.m_128469_("ogitem"));
        }
        this.f_19804_.m_135381_(ITEMSTACK, (Object)this.originalItem);
        if (compound.m_128441_("ownerUUID")) {
            this.ownerUUID = compound.m_128342_("ownerUUID");
            this.owner = this.getProjOwner();
        }
        this.setRotationPoint(compound.m_128451_("Rotation"));
        this.slot = compound.m_128451_("slot");
        this.dmg = compound.m_128457_("damage");
    }

    public int getRotationPoint() {
        return this.rotationPoint;
    }

    public void setRotationPoint(int rotations) {
        this.f_19804_.m_135381_(ROTATION_POINT, (Object)rotations);
        this.rotationPoint = rotations;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ITEMSTACK, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(ROTATION_POINT, (Object)0);
    }

    public ItemStack m_7846_() {
        if (this.originalItem == null) {
            this.originalItem = (ItemStack)this.f_19804_.m_135370_(ITEMSTACK);
        }
        return this.originalItem;
    }

    protected Item m_7881_() {
        if (this.originalItem == null) {
            this.originalItem = (ItemStack)this.f_19804_.m_135370_(ITEMSTACK);
        }
        return this.originalItem.m_41720_();
    }
}

