/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.organization;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.entity.ItemDropEntity;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.entity.organization.LaserDomeShotEntity;
import online.kingdomkeys.kingdomkeys.lib.Party;

public class LaserCircleCoreEntity
extends ThrowableProjectile {
    int maxTicks = 70;
    List<LaserDomeShotEntity> list = new ArrayList<LaserDomeShotEntity>();
    List<Entity> targetList = new ArrayList<Entity>();
    Set<Integer> usedIndexes = new HashSet<Integer>();
    float dmg;
    float radius = 4.0f;
    int space;
    int shotsPerTick;
    private static final EntityDataAccessor<Optional<UUID>> OWNER = SynchedEntityData.m_135353_(LaserCircleCoreEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Optional<UUID>> TARGET = SynchedEntityData.m_135353_(LaserCircleCoreEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);

    public LaserCircleCoreEntity(EntityType<? extends ThrowableProjectile> type, Level world) {
        super(type, world);
        this.f_19850_ = true;
    }

    public LaserCircleCoreEntity(PlayMessages.SpawnEntity spawnEntity, Level world) {
        super((EntityType)ModEntities.TYPE_LASER_CIRCLE.get(), world);
    }

    public LaserCircleCoreEntity(Level world, Player player, LivingEntity target, float dmg) {
        super((EntityType)ModEntities.TYPE_LASER_CIRCLE.get(), (LivingEntity)player, world);
        this.setCaster(player.m_20148_());
        this.setTarget(target.m_20148_());
        this.dmg = dmg;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected float m_7139_() {
        return 0.0f;
    }

    public void m_8119_() {
        if (this.f_19797_ > this.maxTicks || this.getCaster() == null) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        double X = this.m_20185_();
        double Y = this.m_20186_();
        double Z = this.m_20189_();
        if (this.getCaster() != null) {
            if (this.f_19797_ >= 0 && this.f_19797_ <= 40 && this.f_19797_ % 2 == 0) {
                double x = X + (double)this.radius * Math.cos(Math.toRadians(this.f_19797_ * 9));
                double z = Z + (double)this.radius * Math.sin(Math.toRadians(this.f_19797_ * 9));
                LaserDomeShotEntity bullet = new LaserDomeShotEntity(this.m_9236_(), (LivingEntity)this.getCaster(), this.dmg);
                bullet.m_6034_(x, Y + 1.0, z);
                bullet.setMaxTicks(this.maxTicks);
                bullet.m_6686_(this.m_20185_() - bullet.m_20185_(), this.m_20186_() - bullet.m_20186_() + 1.0, this.m_20189_() - bullet.m_20189_(), 0.001f, 0.0f);
                this.m_9236_().m_5594_(this.getCaster(), this.getCaster().m_20183_(), (SoundEvent)ModSounds.laser.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                this.list.add(bullet);
                this.m_9236_().m_7967_((Entity)bullet);
                this.m_20334_(0.0, 0.0, 0.0);
                this.f_19864_ = true;
            } else if (this.f_19797_ == 60) {
                this.updateList();
                LaserCircleCoreEntity target = this;
                if (this.targetList.size() > 1) {
                    this.targetList.remove((Object)this);
                }
                int targetIndex = this.f_19796_.m_188503_(this.targetList.size());
                target = this.targetList.get(targetIndex);
                for (LaserDomeShotEntity bullet : this.list) {
                    if (target == null || !target.m_6084_() || this.getCaster() == null) continue;
                    bullet.m_6686_(target.m_20185_() - bullet.m_20185_(), target.m_20186_() - bullet.m_20186_() + 1.0, target.m_20189_() - bullet.m_20189_(), 1.5f, 0.0f);
                }
                this.m_9236_().m_5594_(this.getCaster(), this.getCaster().m_20183_(), (SoundEvent)ModSounds.laser.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
        super.m_8119_();
    }

    private void updatePos(float r) {
        for (LaserDomeShotEntity shot : this.list) {
            double x = this.m_20185_() + (double)r * Math.cos(Math.toRadians(shot.f_19797_ * 9));
            double z = this.m_20189_() + (double)r * Math.sin(Math.toRadians(shot.f_19797_ * 9));
            shot.m_6034_(x, this.m_20186_() + 1.0, z);
            shot.m_6686_(this.m_20185_() - shot.m_20185_(), this.m_20186_() - shot.m_20186_(), this.m_20189_() - shot.m_20189_(), 0.001f, 0.0f);
        }
    }

    private void updateList() {
        List tempList = this.m_9236_().m_45933_((Entity)this.getCaster(), this.m_20191_().m_82377_((double)this.radius, (double)this.radius, (double)this.radius));
        Party casterParty = ModCapabilities.getWorld(this.m_9236_()).getPartyFromMember(this.getCaster().m_20148_());
        if (casterParty != null && !casterParty.getFriendlyFire()) {
            for (Party.Member m : casterParty.getMembers()) {
                tempList.remove(this.m_9236_().m_46003_(m.getUUID()));
            }
        } else {
            tempList.remove(this.m_19749_());
        }
        this.targetList.clear();
        for (Entity t : tempList) {
            if (t instanceof LaserDomeShotEntity || t instanceof ItemDropEntity || t instanceof ItemEntity || t instanceof ExperienceOrb) continue;
            this.targetList.add(t);
        }
    }

    protected void m_6532_(HitResult rtRes) {
    }

    public int getMaxTicks() {
        return this.maxTicks;
    }

    public void setMaxTicks(int maxTicks) {
        this.maxTicks = maxTicks;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.f_19804_.m_135370_(OWNER) != null) {
            compound.m_128359_("OwnerUUID", ((UUID)((Optional)this.f_19804_.m_135370_(OWNER)).get()).toString());
            compound.m_128359_("TargetUUID", ((UUID)((Optional)this.f_19804_.m_135370_(TARGET)).get()).toString());
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(OWNER, Optional.of(UUID.fromString(compound.m_128461_("OwnerUUID"))));
        this.f_19804_.m_135381_(TARGET, Optional.of(UUID.fromString(compound.m_128461_("TargetUUID"))));
    }

    public Player getCaster() {
        return ((Optional)this.m_20088_().m_135370_(OWNER)).isPresent() ? this.m_9236_().m_46003_((UUID)((Optional)this.m_20088_().m_135370_(OWNER)).get()) : null;
    }

    public void setCaster(UUID uuid) {
        this.f_19804_.m_135381_(OWNER, Optional.of(uuid));
    }

    public Player getTarget() {
        return ((Optional)this.m_20088_().m_135370_(TARGET)).isPresent() ? this.m_9236_().m_46003_((UUID)((Optional)this.m_20088_().m_135370_(TARGET)).get()) : null;
    }

    public void setTarget(UUID uuid) {
        this.f_19804_.m_135381_(TARGET, Optional.of(uuid));
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(OWNER, Optional.of(new UUID(0L, 0L)));
        this.f_19804_.m_135372_(TARGET, Optional.of(new UUID(0L, 0L)));
    }
}

