/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.handler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.GrindstoneEvent;
import net.minecraftforge.event.PlayLevelSoundEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.AnimalTameEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.block.ModBlocks;
import online.kingdomkeys.kingdomkeys.capability.IGlobalCapabilities;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.IWorldCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.command.DimensionCommand;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.damagesource.StopDamageSource;
import online.kingdomkeys.kingdomkeys.driveform.DriveForm;
import online.kingdomkeys.kingdomkeys.driveform.DriveFormDataLoader;
import online.kingdomkeys.kingdomkeys.driveform.ModDriveForms;
import online.kingdomkeys.kingdomkeys.entity.DriveOrbEntity;
import online.kingdomkeys.kingdomkeys.entity.EntityHelper;
import online.kingdomkeys.kingdomkeys.entity.FocusOrbEntity;
import online.kingdomkeys.kingdomkeys.entity.HPOrbEntity;
import online.kingdomkeys.kingdomkeys.entity.HeartEntity;
import online.kingdomkeys.kingdomkeys.entity.MPOrbEntity;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.entity.MunnyEntity;
import online.kingdomkeys.kingdomkeys.entity.SpawningMode;
import online.kingdomkeys.kingdomkeys.entity.XPEntity;
import online.kingdomkeys.kingdomkeys.entity.block.SoRCoreTileEntity;
import online.kingdomkeys.kingdomkeys.entity.mob.BaseKHEntity;
import online.kingdomkeys.kingdomkeys.entity.mob.DuskEntity;
import online.kingdomkeys.kingdomkeys.entity.mob.IKHMob;
import online.kingdomkeys.kingdomkeys.entity.mob.MarluxiaEntity;
import online.kingdomkeys.kingdomkeys.entity.mob.MoogleEntity;
import online.kingdomkeys.kingdomkeys.entity.mob.ShadowEntity;
import online.kingdomkeys.kingdomkeys.entity.organization.KKThrowableEntity;
import online.kingdomkeys.kingdomkeys.item.KKResistanceType;
import online.kingdomkeys.kingdomkeys.item.KeybladeArmorItem;
import online.kingdomkeys.kingdomkeys.item.KeybladeItem;
import online.kingdomkeys.kingdomkeys.item.ModItems;
import online.kingdomkeys.kingdomkeys.item.PauldronItem;
import online.kingdomkeys.kingdomkeys.item.SynthesisItem;
import online.kingdomkeys.kingdomkeys.item.organization.IOrgWeapon;
import online.kingdomkeys.kingdomkeys.item.organization.OrganizationDataLoader;
import online.kingdomkeys.kingdomkeys.lib.DamageCalculation;
import online.kingdomkeys.kingdomkeys.lib.Party;
import online.kingdomkeys.kingdomkeys.lib.SoAState;
import online.kingdomkeys.kingdomkeys.lib.Tags;
import online.kingdomkeys.kingdomkeys.limit.LimitDataLoader;
import online.kingdomkeys.kingdomkeys.magic.Magic;
import online.kingdomkeys.kingdomkeys.magic.MagicDataLoader;
import online.kingdomkeys.kingdomkeys.magic.ModMagic;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.cts.CSSetAirStepPacket;
import online.kingdomkeys.kingdomkeys.network.stc.SCOpenAlignmentScreen;
import online.kingdomkeys.kingdomkeys.network.stc.SCRecalculateEyeHeight;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncCapabilityPacket;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncCastleOblivionInteriorCapability;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncDriveFormData;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncGlobalCapabilityPacket;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncGlobalCapabilityToAllPacket;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncJsonRegistry;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncKeybladeData;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncLimitData;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncMagicData;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncMoogleNames;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncOrganizationData;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncShopData;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncSynthesisData;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncWorldCapability;
import online.kingdomkeys.kingdomkeys.network.stc.SCUpdateCORooms;
import online.kingdomkeys.kingdomkeys.reactioncommands.ModReactionCommands;
import online.kingdomkeys.kingdomkeys.reactioncommands.ReactionCommand;
import online.kingdomkeys.kingdomkeys.synthesis.keybladeforge.KeybladeDataLoader;
import online.kingdomkeys.kingdomkeys.synthesis.recipe.RecipeRegistry;
import online.kingdomkeys.kingdomkeys.synthesis.shop.ShopListRegistry;
import online.kingdomkeys.kingdomkeys.synthesis.shop.names.NamesListRegistry;
import online.kingdomkeys.kingdomkeys.util.Utils;
import online.kingdomkeys.kingdomkeys.world.dimension.ModDimensions;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.CastleOblivionHandler;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.registry.ModJsonRegistries;
import online.kingdomkeys.kingdomkeys.world.utils.BaseTeleporter;

public class EntityEvents {
    public static boolean isBoss = false;
    public static boolean isHostiles = false;
    public int ticks;
    Map<UUID, Boolean> openedAlignment = new HashMap<UUID, Boolean>();
    int airstepTicks = -1;

    @SubscribeEvent
    public void soundPlayed(PlayLevelSoundEvent.AtEntity event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (((SoundEvent)event.getSound().get()).m_11660_().m_135815_().contains("step")) {
                boolean kbArmor = false;
                int index = 0;
                for (ItemStack a : player.m_6168_()) {
                    Item item = a.m_41720_();
                    if (item instanceof ArmorItem) {
                        ArmorItem armor = (ArmorItem)item;
                        if (index < 3 && armor.m_40401_().m_7344_() == ModSounds.keyblade_armor.get()) {
                            kbArmor = true;
                        }
                    }
                    index = (byte)(index + 1);
                }
                if (kbArmor) {
                    event.getEntity().m_216990_((SoundEvent)ModSounds.keyblade_armor.get());
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinLevelEvent e) {
        Entity entity = e.getEntity();
        if (entity instanceof LivingEntity) {
            IKHMob ikhmob;
            LivingEntity mob = (LivingEntity)entity;
            IGlobalCapabilities mobData = ModCapabilities.getGlobal(mob);
            if (mobData == null) {
                return;
            }
            Player player = Utils.getClosestPlayer((Entity)mob, mob.m_9236_());
            if (player == null) {
                return;
            }
            if (e.getLevel().m_46472_().m_135782_().m_135815_().equals("realm_of_darkness") && mob instanceof IKHMob && (ikhmob = (IKHMob)mob).getKHMobType() == EntityHelper.MobType.HEARTLESS_PUREBLOOD) {
                double dist = e.getEntity().m_20182_().m_82554_(new Vec3(0.0, 62.0, 0.0));
                int level = (int)Math.min(dist / (double)ModConfigs.rodHeartlessLevelScale, (double)ModConfigs.rodHeartlessMaxLevel);
                mobData.setLevel(level);
            }
            if (mobData.getLevel() <= 0 && mob instanceof Monster && ModConfigs.hostileMobsLevel) {
                mobData.setLevel(Utils.getRandomMobLevel(player));
            }
            if (mob instanceof OwnableEntity) {
                LivingEntity livingEntity;
                OwnableEntity ownableEntity = (OwnableEntity)mob;
                if (mobData.getLevel() == 0 && (livingEntity = ownableEntity.m_269323_()) instanceof Player) {
                    Player owner = (Player)livingEntity;
                    IPlayerCapabilities ownerData = ModCapabilities.getPlayer(owner);
                    mobData.setLevel(ownerData.getLevel());
                }
            }
            if (mobData.getLevel() > 0) {
                int lvl = mobData.getLevel();
                Utils.applyMobLevel(mob, lvl);
                mob.m_5634_(mob.m_21233_());
                if (!mob.m_8077_() && !(mob instanceof OwnableEntity) && ModConfigs.mobLevelName) {
                    mob.m_6593_((Component)Component.m_237115_((String)(mob.m_5446_().getString() + " Lv." + String.valueOf(Utils.getLevelColor(player, lvl)) + lvl + String.valueOf(ChatFormatting.RESET))));
                }
                PacketHandler.sendTo(new SCSyncGlobalCapabilityToAllPacket(mob.m_19879_(), mobData), (ServerPlayer)player);
            }
        }
    }

    public void checkRecipeMaterials(Player player) {
        RecipeRegistry.getInstance().getValues().forEach(recipe -> recipe.getMaterials().keySet().forEach(item -> {
            if (item == Items.f_41852_) {
                player.m_213846_((Component)Component.m_237115_((String)(String.valueOf(ChatFormatting.RED) + "Recipe[" + recipe.getRegistryName().toString() + "] contains an invalid material")));
            } else if (!item.m_204114_().m_203656_(Tags.MATERIALS)) {
                player.m_213846_((Component)Component.m_237115_((String)(String.valueOf(ChatFormatting.RED) + "Recipe[" + recipe.getRegistryName().toString() + "] contains material[" + ForgeRegistries.ITEMS.getKey(item).toString() + "] that are not present in the \"synthesis/materials\" tag you will be unable to create this recipe")));
            }
        }));
        ForgeRegistries.ITEMS.getEntries().stream().filter(itemRegistryObject -> itemRegistryObject.getValue() instanceof KeybladeItem).map(itemRegistryObject -> (KeybladeItem)itemRegistryObject.getValue()).toList().forEach(keybladeItem -> {
            if (keybladeItem.data != null) {
                for (int i = 0; i < keybladeItem.data.getMaxLevel(); ++i) {
                    keybladeItem.data.getLevelData(i).getMaterialList().keySet().forEach(item -> {
                        if (item == Items.f_41852_) {
                            player.m_213846_((Component)Component.m_237115_((String)(String.valueOf(ChatFormatting.RED) + "Keyblade level data[" + String.valueOf(ForgeRegistries.ITEMS.getKey(keybladeItem)) + "] contains an invalid material")));
                        } else if (!item.m_204114_().m_203656_(Tags.MATERIALS)) {
                            player.m_213846_((Component)Component.m_237115_((String)(String.valueOf(ChatFormatting.RED) + "Keyblade level data[" + String.valueOf(ForgeRegistries.ITEMS.getKey(keybladeItem)) + "] contains material[" + String.valueOf(ForgeRegistries.ITEMS.getKey(item)) + "] that are not present in the \"synthesis/materials\" tag you will be unable to upgrade this keyblade")));
                        }
                    });
                }
            }
        });
    }

    @SubscribeEvent
    public void animalTame(AnimalTameEvent event) {
        IGlobalCapabilities mobData = ModCapabilities.getGlobal((LivingEntity)event.getAnimal());
        IPlayerCapabilities ownerData = ModCapabilities.getPlayer(event.getTamer());
        mobData.setLevel(ownerData.getLevel());
        int lvl = mobData.getLevel();
        Utils.applyMobLevel((LivingEntity)event.getAnimal(), lvl);
        event.getAnimal().m_5634_(event.getAnimal().m_21233_());
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent e) {
        this.checkRecipeMaterials(e.getEntity());
        Player player = e.getEntity();
        IPlayerCapabilities playerData = ModCapabilities.getPlayer(player);
        IWorldCapabilities worldData = ModCapabilities.getWorld(player.m_9236_());
        ModCapabilities.mobDataClientCache = new HashMap<Integer, IGlobalCapabilities>();
        if (playerData != null) {
            if (worldData != null) {
                if (worldData.getHeartlessSpawnLevel() > 0 && ModConfigs.heartlessSpawningMode == SpawningMode.NEVER) {
                    worldData.setHeartlessSpawnLevel(0);
                } else if (worldData.getHeartlessSpawnLevel() == 0 && ModConfigs.heartlessSpawningMode == SpawningMode.ALWAYS) {
                    worldData.setHeartlessSpawnLevel(1);
                }
            }
            ModConfigs.startingRecipes.forEach(resourceLocation -> {
                if (RecipeRegistry.getInstance().containsKey((ResourceLocation)resourceLocation)) {
                    playerData.addKnownRecipe((ResourceLocation)resourceLocation);
                } else {
                    KingdomKeys.LOGGER.error("Recipe[{}] in startingRecipes config doesn't exist", resourceLocation);
                }
            });
            if (!player.m_9236_().f_46443_) {
                int i;
                HashMap accessoriesMap;
                int i2;
                HashMap<Integer, Object> map;
                if (!playerData.getDriveFormMap().containsKey(DriveForm.NONE.toString())) {
                    playerData.setDriveFormLevel(DriveForm.NONE.toString(), 1);
                    playerData.setDriveFormLevel(DriveForm.SYNCH_BLADE.toString(), 1);
                    playerData.setDriveFormLevel("kingdomkeys:form_anti", 1);
                    playerData.addVisibleDriveForm("kingdomkeys:form_anti");
                    if (playerData.getEquippedItems().isEmpty()) {
                        map = new HashMap<Integer, ItemStack>();
                        for (i2 = 0; i2 < 4; ++i2) {
                            map.put(i2, ItemStack.f_41583_);
                        }
                        playerData.equipAllItems(map, true);
                    }
                }
                if (!playerData.getVisibleDriveForms().contains("kingdomkeys:form_anti")) {
                    playerData.addVisibleDriveForm("kingdomkeys:form_anti");
                }
                if (!playerData.getDriveFormMap().containsKey("kingdomkeys:form_anti")) {
                    playerData.setDriveFormLevel("kingdomkeys:form_anti", 1);
                }
                if (!playerData.getDriveFormMap().containsKey("kingdomkeys:form_anti")) {
                    playerData.setDriveFormLevel("kingdomkeys:form_anti", 1);
                }
                if (playerData.getSoAState() == SoAState.COMPLETE) {
                    switch (playerData.getChosen()) {
                        case WARRIOR: {
                            if (playerData.getStrengthStat().hasModifier("choice") || playerData.getStrengthStat().hasModifier("sacrifice")) break;
                            playerData.setStrength(playerData.getStrength(false) - 1);
                            playerData.getStrengthStat().addModifier("choice", 1.0, false, false);
                            break;
                        }
                        case GUARDIAN: {
                            if (playerData.getDefenseStat().hasModifier("choice") || playerData.getDefenseStat().hasModifier("sacrifice")) break;
                            playerData.setDefense(playerData.getDefense(false) - 1);
                            playerData.getDefenseStat().addModifier("choice", 1.0, false, false);
                            break;
                        }
                        case MYSTIC: {
                            if (playerData.getMagicStat().hasModifier("choice") || playerData.getMagicStat().hasModifier("sacrifice")) break;
                            playerData.setMagic(playerData.getMagic(false) - 1);
                            playerData.getMagicStat().addModifier("choice", 1.0, false, false);
                        }
                    }
                    switch (playerData.getSacrificed()) {
                        case WARRIOR: {
                            if (playerData.getStrengthStat().hasModifier("choice") || playerData.getStrengthStat().hasModifier("sacrifice")) break;
                            playerData.setStrength(playerData.getStrength(false) + 1);
                            playerData.getStrengthStat().addModifier("sacrifice", -1.0, false, false);
                            break;
                        }
                        case GUARDIAN: {
                            if (playerData.getDefenseStat().hasModifier("choice") || playerData.getDefenseStat().hasModifier("sacrifice")) break;
                            playerData.setDefense(playerData.getDefense(false) + 1);
                            playerData.getDefenseStat().addModifier("sacrifice", -1.0, false, false);
                            break;
                        }
                        case MYSTIC: {
                            if (playerData.getMagicStat().hasModifier("choice") || playerData.getMagicStat().hasModifier("sacrifice")) break;
                            playerData.setMagic(playerData.getMagic(false) + 1);
                            playerData.getMagicStat().addModifier("sacrifice", -1.0, false, false);
                        }
                    }
                }
                if (!playerData.getEquippedWeapon().m_150930_(Items.f_41852_)) {
                    Utils.createKeybladeID(playerData.getEquippedWeapon());
                }
                playerData.getWeaponsUnlocked().forEach(itemStack -> {
                    if (itemStack.m_150930_(playerData.getEquippedWeapon().m_41720_())) {
                        Utils.copyKeybladeID(playerData.getEquippedWeapon(), itemStack);
                    } else {
                        Utils.createKeybladeID(itemStack);
                    }
                });
                if (!playerData.getDriveFormMap().containsKey(DriveForm.SYNCH_BLADE.toString())) {
                    playerData.setDriveFormLevel(DriveForm.SYNCH_BLADE.toString(), 1);
                }
                if (playerData.getEquippedKBArmors().isEmpty()) {
                    map = new HashMap();
                    for (i2 = 0; i2 < 1; ++i2) {
                        map.put(i2, ItemStack.f_41583_);
                    }
                    playerData.equipAllKBArmor(map, true);
                }
                if ((accessoriesMap = (HashMap)playerData.getEquippedAccessories()).isEmpty()) {
                    for (i2 = 0; i2 < 4; ++i2) {
                        accessoriesMap.put(i2, ItemStack.f_41583_);
                    }
                }
                for (i2 = accessoriesMap.size(); i2 < 4; ++i2) {
                    accessoriesMap.put(i2, ItemStack.f_41583_);
                }
                playerData.equipAllAccessories(accessoriesMap, true);
                HashMap armorsMap = (HashMap)playerData.getEquippedArmors();
                if (armorsMap.isEmpty()) {
                    for (i = 0; i < 4; ++i) {
                        armorsMap.put(i, ItemStack.f_41583_);
                    }
                }
                for (i = armorsMap.size(); i < 4; ++i) {
                    armorsMap.put(i, ItemStack.f_41583_);
                }
                playerData.equipAllArmors(armorsMap, true);
                playerData.getDriveFormMap().keySet().forEach(key -> {
                    if (ModDriveForms.registry.get().containsKey(new ResourceLocation(key)) && ((DriveForm)ModDriveForms.registry.get().getValue(new ResourceLocation(key))).hasKeychain() && playerData.getDriveFormMap().containsKey(key) && !playerData.getEquippedKeychains().containsKey(new ResourceLocation(key))) {
                        playerData.setNewKeychain(new ResourceLocation(key), ItemStack.f_41583_);
                    }
                });
                PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), (ServerPlayer)player);
                PacketHandler.sendTo(new SCSyncWorldCapability(worldData), (ServerPlayer)player);
                PacketHandler.syncToAllAround(player, playerData);
                PacketHandler.sendTo(new SCSyncKeybladeData(KeybladeDataLoader.names, KeybladeDataLoader.dataList), (ServerPlayer)player);
                PacketHandler.sendTo(new SCSyncOrganizationData(OrganizationDataLoader.names, OrganizationDataLoader.dataList), (ServerPlayer)player);
                PacketHandler.sendTo(new SCSyncSynthesisData(RecipeRegistry.getInstance().getValues()), (ServerPlayer)player);
                PacketHandler.sendTo(new SCSyncMoogleNames(NamesListRegistry.getInstance()), (ServerPlayer)player);
                PacketHandler.sendTo(new SCSyncShopData(ShopListRegistry.getInstance().getValues()), (ServerPlayer)player);
                PacketHandler.sendTo(new SCSyncMagicData(MagicDataLoader.names, MagicDataLoader.dataList), (ServerPlayer)player);
                PacketHandler.sendTo(new SCSyncDriveFormData(DriveFormDataLoader.names, DriveFormDataLoader.dataList), (ServerPlayer)player);
                PacketHandler.sendTo(new SCSyncLimitData(LimitDataLoader.names, LimitDataLoader.dataList), (ServerPlayer)player);
                ModJsonRegistries.registry.get().forEach(jsonRegistry -> PacketHandler.sendTo(new SCSyncJsonRegistry(jsonRegistry), (ServerPlayer)player));
                Utils.RefreshAbilityAttributes(player, playerData);
                if (player.m_9236_().m_46472_().m_135782_().m_135815_().contains("castle_oblivion_interior")) {
                    SCSyncCastleOblivionInteriorCapability.syncClients(player.m_9236_());
                    PacketHandler.sendTo(new SCUpdateCORooms(CastleOblivionHandler.getCurrentFloor(player).getRooms()), (ServerPlayer)player);
                } else {
                    PacketHandler.sendTo(new SCUpdateCORooms(List.of()), (ServerPlayer)player);
                }
            }
            PacketHandler.syncToAllAround(player, playerData);
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            IPlayerCapabilities playerData;
            if (this.ticks >= Integer.MAX_VALUE) {
                this.ticks = Integer.MIN_VALUE;
            }
            if ((playerData = ModCapabilities.getPlayer(event.player)) != null) {
                ArrayList<ReactionCommand> rcList = new ArrayList<ReactionCommand>();
                for (ReactionCommand rc : ModReactionCommands.registry.get().getValues()) {
                    if (!rc.needsConstantCheck() || !rc.conditionsToAppear(event.player, (LivingEntity)event.player)) continue;
                    rcList.add(rc);
                }
                for (String rcName : playerData.getReactionCommands()) {
                    ReactionCommand rc = (ReactionCommand)ModReactionCommands.registry.get().getValue(new ResourceLocation(rcName));
                    if (!rc.conditionsToAppear(event.player, (LivingEntity)event.player)) continue;
                    rcList.add(rc);
                }
                playerData.setReactionCommands(new ArrayList<String>());
                for (ReactionCommand rc : rcList) {
                    playerData.addReactionCommand(rc.getName(), event.player);
                }
                if (!event.player.m_9236_().f_46443_ && event.player.f_19797_ == 5) {
                    PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), (ServerPlayer)event.player);
                }
                if (playerData.getActiveDriveForm().equals("kingdomkeys:form_anti")) {
                    if (playerData.getFP() > 0.0) {
                        playerData.setFP(playerData.getFP() - 0.3);
                    } else {
                        playerData.setActiveDriveForm(DriveForm.NONE.toString());
                        event.player.m_9236_().m_6263_(event.player, event.player.m_20182_().m_7096_(), event.player.m_20182_().m_7098_(), event.player.m_20182_().m_7094_(), (SoundEvent)ModSounds.unsummon.get(), SoundSource.MASTER, 1.0f, 1.0f);
                        if (!event.player.m_9236_().f_46443_) {
                            PacketHandler.syncToAllAround(event.player, playerData);
                        }
                    }
                } else if (!playerData.getActiveDriveForm().equals(DriveForm.NONE.toString())) {
                    ((DriveForm)ModDriveForms.registry.get().getValue(new ResourceLocation(playerData.getActiveDriveForm()))).updateDrive(event.player);
                }
                if (playerData.getLimitCooldownTicks() > 0 && !event.player.m_9236_().f_46443_) {
                    playerData.setLimitCooldownTicks(playerData.getLimitCooldownTicks() - 1);
                    if (playerData.getLimitCooldownTicks() <= 0) {
                        PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), (ServerPlayer)event.player);
                    }
                }
                if (playerData.getMagicCasttimeTicks() > 0 && !event.player.m_9236_().f_46443_) {
                    playerData.remMagicCasttimeTicks(1);
                }
                if (playerData.getCastedMagic() != null && playerData.getMagicCasttimeTicks() <= 0) {
                    Utils.castMagic castedMagic = playerData.getCastedMagic();
                    castedMagic.magic().magicUse(castedMagic.player(), castedMagic.caster(), castedMagic.level(), castedMagic.fullMPBlastMult(), castedMagic.lockOnEntity());
                    event.player.m_21011_(InteractionHand.MAIN_HAND, true);
                    playerData.setCastedMagic(null);
                    PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), (ServerPlayer)event.player);
                }
                if (playerData.getMagicCooldownTicks() > 0 && !event.player.m_9236_().f_46443_) {
                    playerData.setMagicCooldownTicks(playerData.getMagicCooldownTicks() - 1);
                    if (playerData.getMagicCooldownTicks() <= 0) {
                        PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), (ServerPlayer)event.player);
                    }
                }
                if (playerData.getRecharge()) {
                    if (playerData.getMP() >= playerData.getMaxMP()) {
                        playerData.setRecharge(false);
                        playerData.setMP(playerData.getMaxMP());
                    } else {
                        if (playerData.getMP() < 0.0) {
                            playerData.setMP(0.0);
                        }
                        playerData.addMP(playerData.getMaxMP() / 500.0 * (Utils.getMPHasteValue(playerData) / 10.0 + 2.0));
                    }
                } else if (playerData.getMP() <= 0.0 && playerData.getMaxMP() > 0.0) {
                    playerData.setRecharge(true);
                    if (!event.player.m_9236_().f_46443_) {
                        PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), (ServerPlayer)event.player);
                    }
                }
                if (!event.player.m_9236_().f_46443_) {
                    if (playerData.getAlignment() == Utils.OrgMember.NONE) {
                        boolean wearingOrgCloak;
                        if (!this.openedAlignment.containsKey(event.player.m_20148_())) {
                            this.openedAlignment.put(event.player.m_20148_(), false);
                        }
                        if (wearingOrgCloak = Utils.isWearingOrgRobes(event.player)) {
                            if (!this.openedAlignment.get(event.player.m_20148_()).booleanValue()) {
                                PacketHandler.sendTo(new SCOpenAlignmentScreen(), (ServerPlayer)event.player);
                                this.openedAlignment.put(event.player.m_20148_(), true);
                            }
                        } else {
                            this.openedAlignment.put(event.player.m_20148_(), false);
                        }
                    }
                    if (playerData.isAbilityEquipped("kingdomkeys:ability_treasure_magnet") && !event.player.m_6047_() && event.player.m_150109_().m_36062_() > -1) {
                        double x = event.player.m_20185_();
                        double y = event.player.m_20186_() + 0.75;
                        double z = event.player.m_20189_();
                        float range = 1 + playerData.getNumberOfAbilitiesEquipped("kingdomkeys:ability_treasure_magnet");
                        List items = event.player.m_9236_().m_45976_(ItemEntity.class, new AABB(x - (double)range, y - (double)range, z - (double)range, x + (double)range, y + (double)range, z + (double)range));
                        int pulled = 0;
                        for (ItemEntity item : items) {
                            if (item.f_19797_ < 20 || pulled > 200) break;
                            Vec3 entityVector = new Vec3(item.m_20185_(), item.m_20186_() - item.m_6049_() + (double)(item.m_20206_() / 2.0f), item.m_20189_());
                            Vec3 finalVector = new Vec3(x, y, z).m_82546_(entityVector);
                            if (Math.sqrt(x * x + y * y + z * z) > 1.0) {
                                finalVector = finalVector.m_82541_();
                            }
                            item.m_20256_(finalVector.m_82542_((double)0.45f, (double)0.45f, (double)0.45f));
                            ++pulled;
                        }
                    }
                }
            }
        }
        if (this.ticks % 5 == 0) {
            this.updateCommandMenu(event.player);
        }
    }

    private void updateCommandMenu(Player player) {
        List<LivingEntity> entities = Utils.getLivingEntitiesInRadius((Entity)player, 16.0f);
        List<LivingEntity> bossEntities = Utils.getLivingEntitiesInRadius((Entity)player, 150.0f);
        if (!bossEntities.isEmpty()) {
            for (int i = 0; i < bossEntities.size(); ++i) {
                if (bossEntities.get(i) instanceof EnderDragon || bossEntities.get(i) instanceof WitherBoss || bossEntities.get(i) instanceof MarluxiaEntity) {
                    isBoss = true;
                    return;
                }
                isBoss = false;
            }
        } else {
            isBoss = false;
        }
        if (!entities.isEmpty()) {
            for (Entity entity : entities) {
                if (entity instanceof Monster || entity instanceof Slime) {
                    isHostiles = true;
                    return;
                }
                isHostiles = false;
            }
        } else {
            isHostiles = false;
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingTickEvent event) {
        IGlobalCapabilities globalData = ModCapabilities.getGlobal(event.getEntity());
        IPlayerCapabilities playerData = null;
        Player player = null;
        if (event.getEntity() instanceof Player && (playerData = ModCapabilities.getPlayer(player = (Player)event.getEntity())) != null) {
            if (!playerData.getActiveDriveForm().equals(DriveForm.NONE.toString())) {
                DriveForm form = (DriveForm)ModDriveForms.registry.get().getValue(new ResourceLocation(playerData.getActiveDriveForm()));
                if (player.m_20096_() && player.m_20075_().getFriction((LevelReader)player.m_9236_(), player.m_20183_(), (Entity)player) <= 0.6f) {
                    player.m_20256_(player.m_20184_().m_82559_(new Vec3((double)form.getSpeedMult(), 1.0, (double)form.getSpeedMult())));
                }
            }
            if (!playerData.getAirStep().equals((Object)new BlockPos(0, 0, 0))) {
                ++this.airstepTicks;
                BlockPos pos = playerData.getAirStep();
                float speedFactor = 0.3f;
                if (pos.m_203193_((Position)player.m_20182_()) < 2.0 || this.airstepTicks > 5 && player.m_20184_().m_7096_() == 0.0 && player.m_20184_().m_7094_() == 0.0) {
                    player.m_20334_(0.0, 0.0, 0.0);
                    player.m_146884_(pos.m_252807_().m_82492_(0.0, 0.4, 0.0));
                    if (player.m_9236_().f_46443_) {
                        PacketHandler.sendToServer(new CSSetAirStepPacket(new BlockPos(0, 0, 0)));
                        this.airstepTicks = -1;
                    }
                }
                if (this.airstepTicks > -1) {
                    player.m_20334_(((double)pos.m_123341_() - player.m_20185_()) * (double)speedFactor, ((double)pos.m_123342_() - player.m_20186_()) * (double)speedFactor, ((double)pos.m_123343_() - player.m_20189_()) * (double)speedFactor);
                }
            }
        }
        if (globalData != null) {
            if (globalData.isKO()) {
                if (event.getEntity().f_19797_ % 20 == 0) {
                    if (event.getEntity().m_21223_() - 1.0f <= 0.0f) {
                        event.getEntity().m_6074_();
                        globalData.setKO(false);
                        PacketHandler.syncToAllAround(event.getEntity(), globalData);
                    } else {
                        event.getEntity().m_21153_(event.getEntity().m_21223_() - 1.0f);
                    }
                }
                event.getEntity().m_146922_(0.0f);
                event.getEntity().m_5618_(0.0f);
                event.getEntity().m_146926_(0.0f);
            }
            if (globalData.getStopModelTicks() > 0) {
                globalData.setStopModelTicks(globalData.getStopModelTicks() - 1);
                if (globalData.getStopModelTicks() <= 0) {
                    PacketHandler.syncToAllAround(event.getEntity(), globalData);
                }
            }
            if (globalData.getStoppedTicks() > 0) {
                globalData.subStoppedTicks(1);
                event.getEntity().m_20334_(0.0, 0.0, 0.0);
                event.getEntity().f_19864_ = true;
                if (event.getEntity() instanceof Mob) {
                    ((Mob)event.getEntity()).m_6710_(null);
                }
                if (globalData.getStoppedTicks() <= 0) {
                    if (event.getEntity() instanceof Mob) {
                        ((Mob)event.getEntity()).m_21557_(false);
                    }
                    globalData.setStoppedTicks(0);
                    if (globalData.getStopDamage() > 0.0f && globalData.getStopCaster() != null) {
                        event.getEntity().m_6469_(StopDamageSource.getStopDamage((Entity)Utils.getPlayerByName(event.getEntity().m_9236_(), globalData.getStopCaster().toLowerCase())), globalData.getStopDamage() / 2.0f);
                    }
                    if (event.getEntity() instanceof ServerPlayer) {
                        PacketHandler.sendTo(new SCSyncGlobalCapabilityPacket(globalData), (ServerPlayer)event.getEntity());
                    }
                    globalData.setStopDamage(0.0f);
                    globalData.setStopCaster(null);
                }
            }
            if (globalData.getFlatTicks() > 0) {
                globalData.subFlatTicks(1);
                if (event.getEntity() instanceof Player && ((Player)event.getEntity()).getForcedPose() != Pose.SWIMMING) {
                    ((Player)event.getEntity()).setForcedPose(Pose.SWIMMING);
                }
                event.getEntity().m_20334_(0.0, -4.0, 0.0);
                event.getEntity().f_19864_ = true;
                if (globalData.getFlatTicks() <= 0) {
                    globalData.setFlatTicks(0);
                    if (event.getEntity() instanceof LivingEntity) {
                        PacketHandler.syncToAllAround(event.getEntity(), globalData);
                        if (event.getEntity() instanceof ServerPlayer) {
                            PacketHandler.sendTo(new SCRecalculateEyeHeight(), (ServerPlayer)event.getEntity());
                        }
                    }
                }
            } else {
                Player pl;
                LivingEntity speedFactor = event.getEntity();
                if (speedFactor instanceof Player && (pl = (Player)speedFactor).getForcedPose() != null && !ModCapabilities.getPlayer(pl).getIsGliding()) {
                    pl.setForcedPose(null);
                }
            }
            if (globalData.getAeroTicks() > 0) {
                globalData.remAeroTicks(1);
                if (globalData.getAeroLevel() == 1) {
                    if (event.getEntity().f_19797_ % 20 == 0) {
                        float radius = 0.4f;
                        List<LivingEntity> list = Utils.getLivingEntitiesInRadius((Entity)event.getEntity(), radius);
                        if (!list.isEmpty()) {
                            for (Entity entity : list) {
                                if (!(event.getEntity() instanceof Player)) continue;
                                entity.m_6469_(entity.m_269291_().m_269075_(player), DamageCalculation.getMagicDamage(player) * 0.033f);
                            }
                        }
                    }
                } else if (globalData.getAeroLevel() == 2 && event.getEntity().f_19797_ % 10 == 0) {
                    float radius = 0.6f;
                    List<LivingEntity> list = Utils.getLivingEntitiesInRadius((Entity)event.getEntity(), radius);
                    if (!list.isEmpty()) {
                        for (Entity entity : list) {
                            if (!(event.getEntity() instanceof Player)) continue;
                            entity.m_6469_(entity.m_269291_().m_269075_(player), DamageCalculation.getMagicDamage(player) * 0.066f);
                        }
                    }
                }
            }
        }
        if (playerData != null) {
            if (playerData.getAerialDodgeTicks() > 0) {
                playerData.setAerialDodgeTicks(playerData.getAerialDodgeTicks() - 1);
            }
            if (playerData.getReflectTicks() > 0) {
                playerData.remReflectTicks(1);
                event.getEntity().m_20334_(0.0, 0.0, 0.0);
                event.getEntity().f_19864_ = true;
                float radius = 1.5f;
                double X = event.getEntity().m_20185_();
                double d = event.getEntity().m_20186_();
                double Z = event.getEntity().m_20189_();
                for (int t = 1; t < 360; t += 20) {
                    for (int s = 1; s < 360; s += 20) {
                        double x = X + (double)radius * Math.cos(Math.toRadians(s)) * Math.sin(Math.toRadians(t));
                        double z = Z + (double)radius * Math.sin(Math.toRadians(s)) * Math.sin(Math.toRadians(t));
                        double y = d + (double)radius * Math.cos(Math.toRadians(t));
                        event.getEntity().m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123772_, x, y + 1.0, z, 0.0, 0.0, 0.0);
                    }
                }
            } else if (playerData.getReflectActive()) {
                float dmgMult = 1.0f;
                float radius = 1.0f;
                switch (playerData.getReflectLevel()) {
                    case 0: {
                        radius = 2.5f;
                        dmgMult = 0.3f;
                        break;
                    }
                    case 1: {
                        radius = 3.0f;
                        dmgMult = 0.5f;
                        break;
                    }
                    case 2: {
                        radius = 3.5f;
                        dmgMult = 0.7f;
                    }
                }
                List list = player.m_9236_().m_45933_((Entity)player, player.m_20191_().m_82377_((double)radius, (double)radius, (double)radius));
                Party party = ModCapabilities.getWorld(player.m_9236_()).getPartyFromMember(player.m_20148_());
                if (party != null && !party.getFriendlyFire()) {
                    for (Party.Member m : party.getMembers()) {
                        list.remove(player.m_9236_().m_46003_(m.getUUID()));
                    }
                }
                double X = event.getEntity().m_20185_();
                double Y = event.getEntity().m_20186_();
                double Z = event.getEntity().m_20189_();
                for (int t = 1; t < 360; t += 20) {
                    double x = X + (double)radius * Math.cos(Math.toRadians(t));
                    double z = Z + (double)radius * Math.sin(Math.toRadians(t));
                    ((ServerLevel)event.getEntity().m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123795_.m_6012_(), x, Y + 1.0, z, 5, 0.0, 0.0, 0.0, 1.0);
                }
                if (!list.isEmpty()) {
                    for (int i = 0; i < list.size(); ++i) {
                        Entity e = (Entity)list.get(i);
                        if (!(e instanceof LivingEntity)) continue;
                        e.m_6469_(e.m_269291_().m_269075_(player), DamageCalculation.getMagicDamage(player) * dmgMult * ((Magic)ModMagic.registry.get().getValue(new ResourceLocation("kingdomkeys:magic_reflect"))).getDamageMult(playerData.getReflectLevel()));
                    }
                    player.m_9236_().m_6263_(null, player.m_20182_().m_7096_(), player.m_20182_().m_7098_(), player.m_20182_().m_7094_(), (SoundEvent)ModSounds.reflect2.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                playerData.setReflectActive(false);
            }
        }
    }

    @SubscribeEvent
    public void entityPickup(EntityItemPickupEvent event) {
        if (event.getItem().m_32055_() != null && event.getItem().m_32055_().m_41720_() instanceof SynthesisItem) {
            for (int i = 0; i < event.getEntity().m_150109_().m_6643_(); ++i) {
                ItemStack bag = event.getEntity().m_150109_().m_8020_(i);
                if (ItemStack.m_41728_((ItemStack)bag, (ItemStack)ItemStack.f_41583_) || bag.m_41720_() != ModItems.synthesisBag.get()) continue;
                IItemHandler inv = (IItemHandler)bag.getCapability(ForgeCapabilities.ITEM_HANDLER, null).orElse(null);
                this.addSynthesisMaterialToBag(inv, event, bag);
            }
        }
    }

    public void addSynthesisMaterialToBag(IItemHandler inv, EntityItemPickupEvent event, ItemStack bag) {
        CompoundTag nbt = bag.m_41784_();
        int bagLevel = nbt.m_128451_("level");
        int maxSlots = switch (bagLevel) {
            case 0 -> 18;
            case 1 -> 36;
            case 2 -> 54;
            case 3 -> 72;
            default -> 0;
        };
        for (int j = 0; j < maxSlots; ++j) {
            ItemStack bagItem = inv.getStackInSlot(j);
            ItemStack pickUp = event.getItem().m_32055_();
            if (!ItemStack.m_41728_((ItemStack)bagItem, (ItemStack)ItemStack.f_41583_)) {
                if (!bagItem.m_41720_().equals(pickUp.m_41720_()) || bagItem.m_41613_() >= 64 || bagItem.m_41613_() + pickUp.m_41613_() > 64) continue;
                ItemStack stack = new ItemStack((ItemLike)pickUp.m_41777_().m_41720_(), pickUp.m_41777_().m_41613_());
                inv.insertItem(j, stack, false);
                pickUp.m_41764_(0);
                return;
            }
            if (!ItemStack.m_41728_((ItemStack)bagItem, (ItemStack)ItemStack.f_41583_)) continue;
            inv.insertItem(j, pickUp.m_41777_(), false);
            pickUp.m_41764_(0);
            return;
        }
    }

    @SubscribeEvent
    public void hitEntity(LivingHurtEvent event) {
        IGlobalCapabilities globalData;
        Object playerData;
        LivingEntity weapon;
        Player player;
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player) {
            IPlayerCapabilities playerData2;
            player = (Player)entity;
            weapon = Utils.getWeaponDamageStack(event.getSource(), player);
            if (weapon != null && !(event.getSource() instanceof StopDamageSource)) {
                float dmg = 0.0f;
                if (weapon.m_41720_() instanceof KeybladeItem) {
                    dmg = DamageCalculation.getKBStrengthDamage(player, (ItemStack)weapon);
                } else if (weapon.m_41720_() instanceof IOrgWeapon) {
                    dmg = DamageCalculation.getOrgStrengthDamage(player, (ItemStack)weapon);
                }
                if (!(!(player.f_19789_ > 0.0f) || player.m_20096_() || player.m_6147_() || player.m_20069_() || player.m_21023_(MobEffects.f_19610_) || player.m_20159_())) {
                    dmg = (float)((double)dmg * ModConfigs.critMult);
                    dmg += dmg * (float)ModCapabilities.getPlayer(player).getNumberOfAbilitiesEquipped("kingdomkeys:ability_critical_boost") * 0.1f;
                }
                event.setAmount(event.getAmount() - 1.0f + dmg * player.m_36403_(0.0f));
            }
            if ((playerData2 = ModCapabilities.getPlayer(player)) != null && playerData2.getActiveDriveForm().equals("kingdomkeys:form_anti")) {
                event.setAmount((float)ModCapabilities.getPlayer(player).getStrength(true));
            }
        }
        if ((weapon = event.getEntity()) instanceof Player) {
            Party p;
            player = (Player)weapon;
            playerData = ModCapabilities.getPlayer(player);
            if (playerData == null) {
                return;
            }
            if (playerData.getReflectTicks() <= 0) {
                if (playerData.isAbilityEquipped("kingdomkeys:ability_mp_rage")) {
                    playerData.addMP(event.getAmount() * 0.2f * (float)playerData.getNumberOfAbilitiesEquipped("kingdomkeys:ability_mp_rage"));
                    PacketHandler.sendTo(new SCSyncCapabilityPacket((IPlayerCapabilities)playerData), (ServerPlayer)player);
                }
                if (playerData.isAbilityEquipped("kingdomkeys:ability_damage_drive")) {
                    playerData.addDP(event.getAmount() * 0.2f * (float)playerData.getNumberOfAbilitiesEquipped("kingdomkeys:ability_damage_drive"));
                    PacketHandler.sendTo(new SCSyncCapabilityPacket((IPlayerCapabilities)playerData), (ServerPlayer)player);
                }
            }
            IWorldCapabilities worldData = ModCapabilities.getWorld(player.m_9236_());
            IGlobalCapabilities globalData2 = ModCapabilities.getGlobal((LivingEntity)player);
            if (worldData != null && globalData2 != null && worldData.getPartyFromMember(player.m_20148_()) != null && !player.m_9236_().m_5776_() && Utils.anyPartyMemberOnExcept(player, p = worldData.getPartyFromMember(player.m_20148_()), (ServerLevel)player.m_9236_())) {
                if (ModConfigs.allowPartyKO) {
                    if (!globalData2.isKO() && player.m_21223_() - event.getAmount() <= 0.0f) {
                        event.setCanceled(true);
                        player.m_21219_();
                        player.m_21153_(player.m_21233_());
                        player.f_19802_ = 40;
                        player.m_36324_().m_38705_(10);
                        player.m_36324_().m_150378_(0.0f);
                        player.m_36324_().m_38717_(0.0f);
                        globalData2.setKO(true);
                        player.m_9236_().m_247517_(null, player.m_20183_(), (SoundEvent)ModSounds.playerDeathHardcore.get(), SoundSource.PLAYERS);
                    }
                    PacketHandler.syncToAllAround((LivingEntity)player, globalData2);
                } else {
                    globalData2.setKO(false);
                }
            }
        }
        if ((playerData = event.getEntity()) instanceof Player) {
            player = (Player)playerData;
            playerData = ModCapabilities.getPlayer(player);
            globalData = ModCapabilities.getGlobal((LivingEntity)player);
            float damage = event.getAmount() * 100.0f / (float)(100 + playerData.getDefense(true));
            if (globalData.getAeroTicks() > 0) {
                float resistMultiplier = globalData.getAeroLevel() == 0 ? 0.3f : (globalData.getAeroLevel() == 1 ? 0.35f : (globalData.getAeroLevel() == 2 ? 0.4f : 0.0f));
                globalData.remAeroTicks((int)damage * 2);
                damage -= damage * resistMultiplier;
            }
            if (event.getSource().m_19385_().equals(KKResistanceType.fire.toString())) {
                damage *= (float)(100 - Utils.getArmorsStat((IPlayerCapabilities)playerData, KKResistanceType.fire.toString())) / 100.0f;
            } else if (event.getSource().m_19385_().equals(KKResistanceType.ice.toString())) {
                damage *= (float)(100 - Utils.getArmorsStat((IPlayerCapabilities)playerData, KKResistanceType.ice.toString())) / 100.0f;
            } else if (event.getSource().m_19385_().equals(KKResistanceType.lightning.toString())) {
                damage *= (float)(100 - Utils.getArmorsStat((IPlayerCapabilities)playerData, KKResistanceType.lightning.toString())) / 100.0f;
            } else if (event.getSource().m_19385_().equals(KKResistanceType.darkness.toString())) {
                damage *= (float)(100 - Utils.getArmorsStat((IPlayerCapabilities)playerData, KKResistanceType.darkness.toString())) / 100.0f;
            }
            if (Utils.isPlayerLowHP(player) && playerData.isAbilityEquipped("kingdomkeys:ability_damage_control")) {
                damage /= (float)(1 + playerData.getNumberOfAbilitiesEquipped("kingdomkeys:ability_damage_control"));
            }
            if (playerData.isAbilityEquipped("kingdomkeys:ability_protect")) {
                float protectReduction = damage * 0.1f;
                damage -= protectReduction;
            }
            if (playerData.isAbilityEquipped("kingdomkeys:ability_protectra")) {
                float protectReduction = damage * 0.2f;
                damage -= protectReduction;
            }
            if (playerData.isAbilityEquipped("kingdomkeys:ability_protectga")) {
                float protectReduction = damage * 0.4f;
                damage -= protectReduction;
            }
            if (playerData.isAbilityEquipped("kingdomkeys:ability_second_chance") && damage >= player.m_21223_() && player.m_21223_() > 1.0f) {
                if (player.m_21023_(MobEffects.f_19605_)) {
                    player.m_21195_(MobEffects.f_19605_);
                    player.f_20948_ = true;
                }
                damage = player.m_21223_() - 1.0f;
            }
            PacketHandler.sendTo(new SCSyncCapabilityPacket((IPlayerCapabilities)playerData), (ServerPlayer)player);
            PacketHandler.sendTo(new SCSyncGlobalCapabilityPacket(globalData), (ServerPlayer)player);
            event.setAmount(damage <= 0.0f ? 1.0f : damage);
        }
        if (event.getEntity() instanceof BaseKHEntity) {
            float damage = event.getAmount();
            int defense = ((BaseKHEntity)event.getEntity()).getDefense();
            if (defense > 0) {
                damage = Math.round(damage * 100.0f / (float)(300 + defense));
            }
            if ((globalData = ModCapabilities.getGlobal(event.getEntity())).getAeroTicks() > 0) {
                float resistMultiplier = globalData.getAeroLevel() == 0 ? 0.3f : (globalData.getAeroLevel() == 1 ? 0.35f : (globalData.getAeroLevel() == 2 ? 0.4f : 0.0f));
                globalData.remAeroTicks((int)damage * 2);
                damage -= damage * resistMultiplier;
            }
            if (event.getEntity() instanceof MarluxiaEntity) {
                MarluxiaEntity mar = (MarluxiaEntity)event.getEntity();
                if (EntityHelper.getState((Entity)event.getEntity()) != 3 && mar.marluxiaGoal.chasedTimes == 0 && mar.m_21223_() - damage <= 0.0f) {
                    ++mar.marluxiaGoal.chasedTimes;
                    EntityHelper.setState((Entity)mar, 3);
                    event.setAmount(mar.m_21223_() - 1.0f);
                    mar.m_20331_(true);
                    return;
                }
                if (EntityHelper.getState((Entity)event.getEntity()) == 1) {
                    damage = event.getAmount() * 0.1f;
                    if (event.getSource().m_19385_().equals(KKResistanceType.fire.toString())) {
                        mar.marluxiaGoal.removeArmor(mar);
                    }
                } else if (EntityHelper.getState((Entity)event.getEntity()) == 2 && event.getSource().m_7639_() == mar.m_21232_()) {
                    EntityHelper.setState((Entity)mar, 0);
                    mar.m_20242_(false);
                }
            }
            event.setAmount(damage < 1.0f ? 1.0f : damage);
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent event) {
        if (!event.getEntity().m_9236_().f_46443_ && event.getSource().m_7639_() instanceof LivingEntity) {
            IGlobalCapabilities globalData;
            IPlayerCapabilities playerData;
            Party p;
            LivingEntity attacker = (LivingEntity)event.getSource().m_7639_();
            LivingEntity target = event.getEntity();
            if (attacker instanceof Player && target instanceof Player && (p = ModCapabilities.getWorld(attacker.m_9236_()).getPartyFromMember(attacker.m_20148_())) != null && p.getMember(event.getEntity().m_20148_()) != null && !p.getFriendlyFire()) {
                event.setCanceled(true);
            }
            if (target instanceof Player && (playerData = ModCapabilities.getPlayer((Player)target)) != null && playerData.getReflectTicks() > 0) {
                if (!playerData.getReflectActive()) {
                    playerData.setReflectActive(true);
                }
                event.setCanceled(true);
            }
            if ((globalData = ModCapabilities.getGlobal(target)) != null && event.getSource().m_7639_() instanceof Player) {
                Player source = (Player)event.getSource().m_7639_();
                if (globalData.getStoppedTicks() > 0) {
                    float dmg = event.getAmount();
                    if (event.getSource().m_7639_() instanceof Player) {
                        ItemStack stack = Utils.getWeaponDamageStack(event.getSource(), source);
                        if (stack != null) {
                            if (stack.m_41720_() instanceof KeybladeItem) {
                                dmg = DamageCalculation.getKBStrengthDamage((Player)event.getSource().m_7639_(), stack);
                            } else if (stack.m_41720_() instanceof IOrgWeapon) {
                                dmg = DamageCalculation.getOrgStrengthDamage((Player)event.getSource().m_7639_(), stack);
                            }
                        }
                        if (dmg == 0.0f) {
                            dmg = event.getAmount();
                        }
                    }
                    globalData.addDamage(dmg);
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public void onLivingDeathEvent(LivingDeathEvent event) {
        Player player;
        Object object;
        IWorldCapabilities worldData = ModCapabilities.getWorld(event.getEntity().m_9236_());
        if (event.getEntity() instanceof EnderDragon) {
            LivingEntity entity = event.getEntity();
            if (worldData.getHeartlessSpawnLevel() == 0 && ModConfigs.heartlessSpawningMode == SpawningMode.AFTER_DRAGON) {
                worldData.setHeartlessSpawnLevel(1);
            }
            object = entity.m_9236_().m_6907_().iterator();
            while (object.hasNext()) {
                Player p = (Player)object.next();
                entity.m_9236_().m_7967_((Entity)new ItemEntity(entity.m_9236_(), p.m_20185_(), p.m_20186_(), p.m_20189_(), new ItemStack((ItemLike)ModItems.proofOfHeart.get(), 1)));
            }
        }
        if ((object = event.getEntity()) instanceof Player) {
            player = (Player)object;
            if (player.m_9236_().m_6106_().m_5466_()) {
                player.m_9236_().m_6263_(null, player.m_20182_().m_7096_(), player.m_20182_().m_7098_(), player.m_20182_().m_7094_(), (SoundEvent)ModSounds.playerDeathHardcore.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            } else {
                player.m_9236_().m_6263_(null, player.m_20182_().m_7096_(), player.m_20182_().m_7098_(), player.m_20182_().m_7094_(), (SoundEvent)ModSounds.playerDeath.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
        if (!event.getEntity().m_9236_().f_46443_) {
            Entity entity4;
            player = null;
            Entity entity2 = event.getSource().m_7640_();
            if (entity2 instanceof Player) {
                Player pl;
                player = pl = (Player)entity2;
            } else {
                entity2 = event.getSource().m_7639_();
                if (entity2 instanceof Player) {
                    Player pl;
                    player = pl = (Player)entity2;
                }
            }
            if (player != null) {
                IPlayerCapabilities playerData = ModCapabilities.getPlayer(player);
                if (player.m_21205_().m_41720_() instanceof IOrgWeapon || player.m_21205_().m_41720_() instanceof KeybladeItem || event.getSource().m_7640_() instanceof KKThrowableEntity) {
                    IOrgWeapon weapon;
                    int multiplier = 1;
                    if (player.m_21205_().m_41720_() instanceof IOrgWeapon && ((weapon = (IOrgWeapon)player.m_21205_().m_41720_()).getMember() == playerData.getAlignment() || event.getSource().m_7640_() instanceof KKThrowableEntity && playerData.getAlignment() == Utils.OrgMember.AXEL)) {
                        multiplier = 2;
                    }
                    if (event.getEntity() instanceof IKHMob) {
                        IKHMob mob = (IKHMob)event.getEntity();
                        if (mob.getKHMobType() == EntityHelper.MobType.HEARTLESS_EMBLEM) {
                            playerData.addHearts((int)((double)(20 * multiplier) * ModConfigs.heartMultiplier));
                        }
                    } else if (event.getEntity() instanceof EnderDragon || event.getEntity() instanceof WitherBoss) {
                        playerData.addHearts((int)((double)(1000 * multiplier) * ModConfigs.heartMultiplier));
                    } else if (event.getEntity() instanceof Villager) {
                        playerData.addHearts((int)((double)(5 * multiplier) * ModConfigs.heartMultiplier));
                    } else if (event.getEntity() instanceof Monster) {
                        playerData.addHearts((int)((double)(2 * multiplier) * ModConfigs.heartMultiplier));
                    } else {
                        playerData.addHearts((int)((double)(1 * multiplier) * ModConfigs.heartMultiplier));
                    }
                }
                if (event.getEntity() instanceof IKHMob) {
                    IKHMob heartless = (IKHMob)event.getEntity();
                    if (heartless.getKHMobType() == EntityHelper.MobType.HEARTLESS_EMBLEM && Utils.getWeaponDamageStack(event.getSource(), player) != null && Utils.getWeaponDamageStack(event.getSource(), player).m_41720_() instanceof KeybladeItem) {
                        HeartEntity heart = new HeartEntity(event.getEntity().m_9236_());
                        heart.m_6034_(event.getEntity().m_20185_(), event.getEntity().m_20186_() + 1.0, event.getEntity().m_20189_());
                        event.getEntity().m_9236_().m_7967_((Entity)heart);
                    }
                    if (heartless.getKHMobType() == EntityHelper.MobType.HEARTLESS_PUREBLOOD && event.getEntity().m_9236_() instanceof ServerLevel) {
                        LivingEntity entity3 = event.getEntity();
                        for (int i = 0; i < 2; ++i) {
                            ((ServerLevel)entity3.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123762_, entity3.m_20185_() + entity3.m_9236_().f_46441_.m_188500_() / 2.0 - 0.25, entity3.m_20186_() + entity3.m_9236_().f_46441_.m_188500_() / 2.0 - 0.25, entity3.m_20189_() + entity3.m_9236_().f_46441_.m_188500_() / 2.0 - 0.25, 50, 0.0, -1.0, 0.0, 0.3);
                            ((ServerLevel)entity3.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123765_, entity3.m_20185_() + entity3.m_9236_().f_46441_.m_188500_() / 2.0 - 0.25, entity3.m_20186_() + entity3.m_9236_().f_46441_.m_188500_() / 2.0 - 0.25, entity3.m_20189_() + entity3.m_9236_().f_46441_.m_188500_() / 2.0 - 0.25, 30, 0.0, -1.0, 0.0, 0.1);
                        }
                    }
                }
                if (event.getEntity().getClassification(false) == MobCategory.MONSTER) {
                    int num;
                    if (!playerData.isAbilityEquipped("kingdomkeys:ability_zero_exp")) {
                        LivingEntity mob = event.getEntity();
                        double value = mob.m_21051_(Attributes.f_22276_).m_22135_() / 2.0;
                        double exp = Utils.randomWithRange(value * 0.8, value * 1.8);
                        playerData.addExperience(player, (int)(exp * ModConfigs.xpMultiplier), true, true);
                        if (event.getEntity() instanceof WitherBoss) {
                            playerData.addExperience(player, (int)((exp += 1500.0) * ModConfigs.xpMultiplier), true, true);
                        }
                        if (!playerData.isAbilityEquipped("kingdomkeys:ability_zero_exp")) {
                            if (playerData.getNumberOfAbilitiesEquipped("kingdomkeys:ability_experience_boost") > 0 && player.m_21223_() <= player.m_21233_() / 2.0f) {
                                exp *= (double)(1 + playerData.getNumberOfAbilitiesEquipped("kingdomkeys:ability_experience_boost"));
                            }
                            XPEntity xp = new XPEntity(mob.m_9236_(), player, mob, exp);
                            player.m_9236_().m_7967_((Entity)xp);
                        }
                    }
                    LivingEntity entity4 = event.getEntity();
                    double x = entity4.m_20185_();
                    double y = entity4.m_20186_();
                    double z = entity4.m_20189_();
                    if (entity4.m_9236_().f_46441_.m_188503_(100) <= ModConfigs.munnyDropProbability) {
                        num = (int)Utils.randomWithRange(5.0f, entity4.m_21233_() / 5.0f);
                        num = (int)((double)num + (double)playerData.getNumberOfAbilitiesEquipped("kingdomkeys:ability_jackpot") * 1.2);
                        entity4.m_9236_().m_7967_((Entity)new MunnyEntity(event.getEntity().m_9236_(), x, y, z, num /= 1 + playerData.getNumberOfAbilitiesEquipped("kingdomkeys:ability_drive_converter")));
                    }
                    if (entity4.m_9236_().f_46441_.m_188503_(100) <= ModConfigs.hpDropProbability) {
                        num = (int)Utils.randomWithRange(entity4.m_21233_() / 10.0f, entity4.m_21233_() / 5.0f);
                        num = (int)((double)num + (double)playerData.getNumberOfAbilitiesEquipped("kingdomkeys:ability_jackpot") * 1.2);
                        entity4.m_9236_().m_7967_((Entity)new HPOrbEntity(event.getEntity().m_9236_(), x, y, z, num));
                    }
                    if (entity4.m_9236_().f_46441_.m_188503_(100) <= ModConfigs.mpDropProbability) {
                        num = (int)Utils.randomWithRange(entity4.m_21233_() / 10.0f, entity4.m_21233_() / 5.0f);
                        num = (int)((double)num + (double)playerData.getNumberOfAbilitiesEquipped("kingdomkeys:ability_jackpot") * 1.2);
                        entity4.m_9236_().m_7967_((Entity)new MPOrbEntity(event.getEntity().m_9236_(), x, y, z, num));
                    }
                    if (entity4.m_9236_().f_46441_.m_188503_(100) <= ModConfigs.driveDropProbability) {
                        num = (int)((double)Utils.randomWithRange(entity4.m_21233_() * 0.1f, entity4.m_21233_() * 0.25f) * ModConfigs.drivePointsMultiplier);
                        num = (int)((double)num + (double)(num * playerData.getNumberOfAbilitiesEquipped("kingdomkeys:ability_drive_converter")) * 0.5);
                        entity4.m_9236_().m_7967_((Entity)new DriveOrbEntity(event.getEntity().m_9236_(), x, y, z, num));
                    }
                    if (entity4.m_9236_().f_46441_.m_188503_(100) <= ModConfigs.focusDropProbability) {
                        num = (int)((double)Utils.randomWithRange(entity4.m_21233_() * 0.1f, entity4.m_21233_() * 0.25f) * ModConfigs.focusPointsMultiplier);
                        num = (int)((double)num + (double)(num * playerData.getNumberOfAbilitiesEquipped("kingdomkeys:ability_focus_converter")) * 0.25);
                        entity4.m_9236_().m_7967_((Entity)new FocusOrbEntity(event.getEntity().m_9236_(), x, y, z, num));
                    }
                    if ((num = Utils.randomWithRange(0, 99)) < ModConfigs.recipeDropChance + Utils.getLootingLevel(player)) {
                        Item recipeTier = (Item)ModItems.recipeD.get();
                        IGlobalCapabilities mobData = ModCapabilities.getGlobal(entity4);
                        if (mobData != null) {
                            int num2 = Utils.randomWithRange(0, mobData.getLevel() + 1);
                            if (num2 < 15) {
                                recipeTier = (Item)ModItems.recipeD.get();
                            } else if (num2 < 30) {
                                recipeTier = (Item)ModItems.recipeC.get();
                            } else if (num2 < 60) {
                                recipeTier = (Item)ModItems.recipeB.get();
                            } else if (num2 < 90) {
                                recipeTier = (Item)ModItems.recipeA.get();
                            } else if (num2 < 150) {
                                recipeTier = (Item)ModItems.recipeS.get();
                            } else if (num2 < 200) {
                                recipeTier = (Item)ModItems.recipeSS.get();
                            } else if (num2 == 200) {
                                recipeTier = (Item)ModItems.recipeSSS.get();
                            }
                        }
                        ItemEntity ie = new ItemEntity(player.m_9236_(), x, y, z, new ItemStack((ItemLike)recipeTier));
                        player.m_9236_().m_7967_((Entity)ie);
                    }
                    PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), (ServerPlayer)player);
                }
            }
            if (event.getEntity() instanceof MoogleEntity && event.getSource().m_19385_().equals("anvil")) {
                ItemEntity ie = new ItemEntity(event.getEntity().m_9236_(), event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_(), new ItemStack((ItemLike)ModBlocks.moogleProjector.get()));
                event.getEntity().m_9236_().m_7967_((Entity)ie);
            }
            if ((entity4 = event.getSource().m_7639_()) instanceof IKHMob) {
                IKHMob killerMob = (IKHMob)entity4;
                if (ModConfigs.playerSpawnHeartless && !event.getSource().m_7639_().m_8077_() && (killerMob.getKHMobType() == EntityHelper.MobType.HEARTLESS_EMBLEM || killerMob.getKHMobType() == EntityHelper.MobType.HEARTLESS_PUREBLOOD)) {
                    if (event.getEntity() instanceof Player) {
                        IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)event.getEntity());
                        String[] heartless = ModConfigs.playerSpawnHeartlessData.get(0).split(",");
                        String[] nobody = ModConfigs.playerSpawnHeartlessData.get(1).split(",");
                        DuskEntity newDusk = new DuskEntity((EntityType<? extends Monster>)((EntityType)ModEntities.TYPE_DUSK.get()), event.getSource().m_7639_().m_9236_());
                        newDusk.m_6034_(event.getEntity().m_20183_().m_123341_(), event.getEntity().m_20183_().m_123342_(), event.getEntity().m_20183_().m_123343_());
                        newDusk.m_6593_((Component)Component.m_237115_((String)(event.getEntity().m_5446_().getString() + "'s Nobody")));
                        newDusk.m_21051_(Attributes.f_22276_).m_22100_(Math.max((double)event.getEntity().m_21233_() * Double.parseDouble(nobody[1]) / 100.0, (double)newDusk.m_21233_()));
                        newDusk.m_5634_(newDusk.m_21233_());
                        newDusk.m_21051_(Attributes.f_22281_).m_22100_(Math.max((double)playerData.getStrength(true) * Double.parseDouble(nobody[2]) / 100.0, newDusk.m_21051_(Attributes.f_22281_).m_22115_()));
                        event.getSource().m_7639_().m_9236_().m_7967_((Entity)newDusk);
                        ShadowEntity newShadow = new ShadowEntity((EntityType<? extends Monster>)((EntityType)ModEntities.TYPE_SHADOW.get()), event.getSource().m_7639_().m_9236_());
                        newShadow.m_6034_(event.getEntity().m_20183_().m_123341_(), event.getEntity().m_20183_().m_123342_(), event.getEntity().m_20183_().m_123343_());
                        newShadow.m_6593_((Component)Component.m_237115_((String)(event.getEntity().m_5446_().getString() + "'s Heartless")));
                        newShadow.m_21051_(Attributes.f_22276_).m_22100_(Math.max((double)event.getEntity().m_21233_() * Double.parseDouble(heartless[1]) / 100.0, (double)newShadow.m_21233_()));
                        newShadow.m_5634_(newShadow.m_21233_());
                        newShadow.m_21051_(Attributes.f_22281_).m_22100_(Math.max((double)playerData.getStrength(true) * Double.parseDouble(heartless[2]) / 100.0, newShadow.m_21051_(Attributes.f_22281_).m_22115_()));
                        event.getSource().m_7639_().m_9236_().m_7967_((Entity)newShadow);
                        HeartEntity heart = new HeartEntity(event.getEntity().m_9236_());
                        heart.m_6034_(event.getEntity().m_20185_(), event.getEntity().m_20186_() + 1.0, event.getEntity().m_20189_());
                        event.getEntity().m_9236_().m_7967_((Entity)heart);
                    } else if (event.getEntity() instanceof Villager) {
                        ShadowEntity newShadow = new ShadowEntity((EntityType<? extends Monster>)((EntityType)ModEntities.TYPE_SHADOW.get()), event.getSource().m_7639_().m_9236_());
                        newShadow.m_6034_(event.getEntity().m_20183_().m_123341_(), event.getEntity().m_20183_().m_123342_(), event.getEntity().m_20183_().m_123343_());
                        event.getSource().m_7639_().m_9236_().m_7967_((Entity)newShadow);
                        HeartEntity heart = new HeartEntity(event.getEntity().m_9236_());
                        heart.m_6034_(event.getEntity().m_20185_(), event.getEntity().m_20186_() + 1.0, event.getEntity().m_20189_());
                        event.getEntity().m_9236_().m_7967_((Entity)heart);
                    }
                }
            }
            if (event.getEntity() instanceof MarluxiaEntity && event.getSource().m_7639_() instanceof Player && event.getSource().m_7639_().m_9236_().m_46472_().equals(ModDimensions.STATION_OF_SORROW)) {
                ResourceKey dimension = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("overworld"));
                BlockPos coords = DimensionCommand.getWorldCoords(player, (ResourceKey<Level>)dimension);
                player.changeDimension(player.m_20194_().m_129880_(dimension), (ITeleporter)new BaseTeleporter(coords.m_123341_(), coords.m_123342_(), coords.m_123343_()));
            }
        }
    }

    @SubscribeEvent
    public void onFall(LivingFallEvent event) {
        Player player;
        IPlayerCapabilities playerData;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (playerData = ModCapabilities.getPlayer(player = (Player)livingEntity)) != null && playerData.getActiveDriveForm() != null) {
            if (!playerData.getActiveDriveForm().equals(DriveForm.NONE.toString())) {
                event.setDistance(0.0f);
            } else if (playerData.isAbilityEquipped("kingdomkeys:ability_high_jump") || playerData.isAbilityEquipped("kingdomkeys:ability_aerial_dodge") || playerData.isAbilityEquipped("kingdomkeys:ability_glide")) {
                event.setDistance(0.0f);
            }
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        if (!event.getLevel().m_5776_() && !event.getPlayer().m_7500_() && event.getPlayer().m_21205_().getEnchantmentLevel(Enchantments.f_44985_) == 0) {
            if (event.getState().m_60734_() == ModBlocks.prizeBlox.get()) {
                event.getLevel().m_7967_((Entity)new MunnyEntity((Level)event.getLevel(), event.getPos().m_123341_(), event.getPos().m_123342_(), event.getPos().m_123343_(), Utils.randomWithRange(50, 200)));
            } else if (event.getState().m_60734_() == ModBlocks.rarePrizeBlox.get()) {
                event.getLevel().m_7967_((Entity)new MunnyEntity((Level)event.getLevel(), event.getPos().m_123341_(), event.getPos().m_123342_(), event.getPos().m_123343_(), Utils.randomWithRange(300, 500)));
            }
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        Player oPlayer = event.getOriginal();
        Player nPlayer = event.getEntity();
        oPlayer.reviveCaps();
        IPlayerCapabilities oldPlayerData = ModCapabilities.getPlayer(oPlayer);
        IPlayerCapabilities newPlayerData = ModCapabilities.getPlayer(nPlayer);
        newPlayerData.setLevel(oldPlayerData.getLevel());
        newPlayerData.setExperience(oldPlayerData.getExperience());
        newPlayerData.setExperienceGiven(oldPlayerData.getExperienceGiven());
        newPlayerData.setStrengthStat(oldPlayerData.getStrengthStat());
        newPlayerData.setMagicStat(oldPlayerData.getMagicStat());
        newPlayerData.setDefenseStat(oldPlayerData.getDefenseStat());
        newPlayerData.setMaxHP(oldPlayerData.getMaxHP());
        newPlayerData.setMP(oldPlayerData.getMP());
        newPlayerData.setMaxMP(oldPlayerData.getMaxMP());
        newPlayerData.setDP(oldPlayerData.getDP());
        newPlayerData.setFP(oldPlayerData.getFP());
        newPlayerData.setMaxDP(oldPlayerData.getMaxDP());
        newPlayerData.setMaxAPStat(oldPlayerData.getMaxAPStat());
        newPlayerData.setFocus(oldPlayerData.getFocus());
        newPlayerData.setMaxFocus(oldPlayerData.getMaxFocus());
        newPlayerData.setMunny(oldPlayerData.getMunny());
        newPlayerData.setMagicsMap(oldPlayerData.getMagicsMap());
        newPlayerData.setAbilityMap(oldPlayerData.getAbilityMap());
        newPlayerData.setDriveFormMap(oldPlayerData.getDriveFormMap());
        newPlayerData.setVisibleDriveForms(oldPlayerData.getVisibleDriveForms());
        newPlayerData.setAntiPoints(oldPlayerData.getAntiPoints());
        newPlayerData.setActiveDriveForm(oldPlayerData.getActiveDriveForm());
        newPlayerData.setPartiesInvited(oldPlayerData.getPartiesInvited());
        newPlayerData.setKnownRecipeList(oldPlayerData.getKnownRecipeList());
        newPlayerData.setMaterialMap(oldPlayerData.getMaterialMap());
        newPlayerData.equipAllKeychains(oldPlayerData.getEquippedKeychains(), true);
        newPlayerData.setSoAState(oldPlayerData.getSoAState());
        newPlayerData.setReturnDimension(oldPlayerData.getReturnDimension());
        newPlayerData.setReturnLocation(oldPlayerData.getReturnLocation());
        newPlayerData.setChoice(oldPlayerData.getChosen());
        newPlayerData.setChoicePedestal(oldPlayerData.getChoicePedestal());
        newPlayerData.setSacrifice(oldPlayerData.getSacrificed());
        newPlayerData.setSacrificePedestal(oldPlayerData.getSacrificePedestal());
        newPlayerData.setHearts(oldPlayerData.getHearts());
        newPlayerData.setAlignment(oldPlayerData.getAlignment());
        newPlayerData.equipWeapon(oldPlayerData.getEquippedWeapon());
        newPlayerData.setWeaponsUnlocked(oldPlayerData.getWeaponsUnlocked());
        newPlayerData.setLimitCooldownTicks(oldPlayerData.getLimitCooldownTicks());
        newPlayerData.setEquippedShotlock(oldPlayerData.getEquippedShotlock());
        newPlayerData.setShotlockList(oldPlayerData.getShotlockList());
        newPlayerData.equipAllItems(oldPlayerData.getEquippedItems(), true);
        newPlayerData.equipAllAccessories(oldPlayerData.getEquippedAccessories(), true);
        newPlayerData.equipAllArmors(oldPlayerData.getEquippedArmors(), true);
        newPlayerData.equipAllKBArmor(oldPlayerData.getEquippedKBArmors(), true);
        newPlayerData.setMaxAccessories(oldPlayerData.getMaxAccessories());
        newPlayerData.setMaxArmors(oldPlayerData.getMaxArmors());
        newPlayerData.setNotifColor(oldPlayerData.getNotifColor());
        newPlayerData.setArmorColor(oldPlayerData.getArmorColor());
        newPlayerData.setArmorGlint(oldPlayerData.getArmorGlint());
        newPlayerData.setRespawnROD(oldPlayerData.getRespawnROD());
        newPlayerData.setSingleStyle(oldPlayerData.getSingleStyle());
        newPlayerData.setDualStyle(oldPlayerData.getDualStyle());
        nPlayer.m_21153_((float)oldPlayerData.getMaxHP());
        nPlayer.m_21051_(Attributes.f_22276_).m_22100_((double)oldPlayerData.getMaxHP());
        newPlayerData.setShortcutsMap(oldPlayerData.getShortcutsMap());
        newPlayerData.setSynthLevel(oldPlayerData.getSynthLevel());
        newPlayerData.setSynthExperience(oldPlayerData.getSynthExperience());
        Utils.RefreshAbilityAttributes(nPlayer, newPlayerData);
        newPlayerData.setDiscoveredSavePoints(oldPlayerData.discoveredSavePoints());
        PacketHandler.sendTo(new SCSyncWorldCapability(ModCapabilities.getWorld(nPlayer.m_9236_())), (ServerPlayer)nPlayer);
        oPlayer.invalidateCaps();
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player nPlayer = event.getEntity();
        IWorldCapabilities newWorldData = ModCapabilities.getWorld(nPlayer.m_9236_());
        IPlayerCapabilities playerData = ModCapabilities.getPlayer(nPlayer);
        nPlayer.m_21153_((float)playerData.getMaxHP());
        Utils.RefreshAbilityAttributes(nPlayer, playerData);
        if (!nPlayer.m_9236_().f_46443_) {
            PacketHandler.sendTo(new SCSyncWorldCapability(newWorldData), (ServerPlayer)nPlayer);
        }
        if (!event.isEndConquered() && !nPlayer.m_9236_().m_5776_() && playerData.getRespawnROD() && ModConfigs.respawnROD) {
            ServerPlayer sPlayer = (ServerPlayer)nPlayer;
            ResourceKey dimension = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("kingdomkeys", "realm_of_darkness"));
            ServerLevel serverlevel = ((ServerLevel)sPlayer.m_9236_()).m_7654_().m_129880_(dimension);
            BlockPos pos = serverlevel.m_220360_();
            sPlayer.changeDimension(serverlevel, (ITeleporter)new BaseTeleporter(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()));
        }
    }

    @SubscribeEvent
    public void onDimensionChanged(PlayerEvent.PlayerChangedDimensionEvent e) {
        Player player = e.getEntity();
        if (!player.m_9236_().f_46443_) {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer(player);
            ServerLevel world = player.m_20194_().m_129880_(e.getTo());
            if (e.getTo() == ModDimensions.STATION_OF_SORROW) {
                BlockPos blockPos = player.m_20183_().m_6625_(2);
                world.m_7731_(blockPos, ((Block)ModBlocks.sorCore.get()).m_49966_(), 2);
                if (world.m_7702_(blockPos) instanceof SoRCoreTileEntity) {
                    SoRCoreTileEntity te = (SoRCoreTileEntity)world.m_7702_(blockPos);
                    te.setUUID(player.m_20148_());
                }
            }
            IWorldCapabilities fromWorldData = ModCapabilities.getWorld((Level)player.m_20194_().m_129880_(e.getFrom()));
            IWorldCapabilities toWorldData = ModCapabilities.getWorld((Level)world);
            toWorldData.deserializeNBT((Tag)((CompoundTag)fromWorldData.serializeNBT()));
            Utils.RefreshAbilityAttributes(player, playerData);
            PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), (ServerPlayer)player);
            PacketHandler.sendTo(new SCSyncWorldCapability(ModCapabilities.getWorld((Level)world)), (ServerPlayer)player);
        }
    }

    @SubscribeEvent
    public void playerStartedTracking(PlayerEvent.StartTracking e) {
        Player localPlayer = e.getEntity();
        IPlayerCapabilities playerData = ModCapabilities.getPlayer(localPlayer);
        IGlobalCapabilities globalData = ModCapabilities.getGlobal((LivingEntity)localPlayer);
        if (playerData == null || globalData == null) {
            return;
        }
        PacketHandler.syncToAllAround(localPlayer, playerData);
        PacketHandler.syncToAllAround((LivingEntity)localPlayer, globalData);
        Entity entity = e.getTarget();
        if (entity instanceof Player) {
            Player targetPlayer = (Player)entity;
            IPlayerCapabilities targetPlayerData = ModCapabilities.getPlayer(targetPlayer);
            IGlobalCapabilities globalData2 = ModCapabilities.getGlobal((LivingEntity)targetPlayer);
            PacketHandler.syncToAllAround(targetPlayer, targetPlayerData);
            PacketHandler.syncToAllAround((LivingEntity)targetPlayer, globalData2);
        }
    }

    @SubscribeEvent
    public void playerStoppedTracking(PlayerEvent.StopTracking e) {
        Player player = e.getEntity();
        IPlayerCapabilities playerData = ModCapabilities.getPlayer(player);
        IWorldCapabilities worldData = ModCapabilities.getWorld(player.m_9236_());
        if (playerData == null || worldData == null) {
            return;
        }
        Party p = worldData.getPartyFromMember(player.m_20148_());
        if (p == null) {
            return;
        }
        Party.Member m = p.getMember(player.m_20148_());
        m.setLevel(playerData.getLevel());
        m.setHP((int)player.m_21233_());
        m.setMP((int)playerData.getMaxMP());
        Utils.syncWorldData(player.m_9236_(), worldData);
    }

    @SubscribeEvent
    public void looting(LootingLevelEvent event) {
        Player player;
        IPlayerCapabilities playerData;
        if (event.getDamageSource() != null && event.getDamageSource().m_7639_() instanceof Player && (playerData = ModCapabilities.getPlayer(player = (Player)event.getDamageSource().m_7639_())) != null) {
            event.setLootingLevel(event.getLootingLevel() + playerData.getNumberOfAbilitiesEquipped("kingdomkeys:ability_lucky_lucky"));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void anvilUpdate(AnvilUpdateEvent event) {
        Item item = event.getLeft().m_41720_();
        if ((item instanceof KeybladeItem || item instanceof IOrgWeapon || item instanceof KeybladeArmorItem) && !event.getRight().m_41619_() && !(event.getRight().m_41720_() instanceof EnchantedBookItem)) {
            event.setOutput(ItemStack.f_41583_);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void grindstoneEvent(GrindstoneEvent.OnPlaceItem event) {
        Item item;
        if (event.getTopItem() != null && (item = event.getTopItem().m_41720_()) instanceof PauldronItem) {
            PauldronItem pauldron = (PauldronItem)item;
            event.setOutput(new ItemStack((ItemLike)pauldron));
            int xp = 5 * event.getTopItem().m_41783_().m_128440_();
            event.setXp(xp);
        }
    }
}

