/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.integration.epicfight;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.client.model.armor.ArmorBaseModel;
import online.kingdomkeys.kingdomkeys.client.render.KeybladeArmorRenderer;
import online.kingdomkeys.kingdomkeys.item.KeybladeArmorItem;
import online.kingdomkeys.kingdomkeys.util.Utils;
import yesman.epicfight.api.client.model.AnimatedMesh;
import yesman.epicfight.api.client.model.Meshes;
import yesman.epicfight.api.client.model.transformer.CustomModelBakery;
import yesman.epicfight.api.forgeevent.ModelBuildEvent;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.mesh.HumanoidMesh;
import yesman.epicfight.client.renderer.EpicFightRenderTypes;
import yesman.epicfight.client.renderer.patched.layer.PatchedLayer;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class PatchedArmourLayerRenderer<E extends LivingEntity, T extends LivingEntityPatch<E>, M extends HumanoidModel<E>, AM extends AnimatedMesh>
extends PatchedLayer<E, T, M, KeybladeArmorRenderer<E, M>> {
    boolean hideHelmet;
    public static final Map<Item, AnimatedMesh> epicfight_armorModels = new HashMap<Item, AnimatedMesh>();
    ResourceLocation texture;

    @SubscribeEvent
    public static void clearModels(ModelBuildEvent.MeshBuild meshBuildEvent) {
        epicfight_armorModels.values().forEach(AnimatedMesh::destroy);
        epicfight_armorModels.clear();
    }

    public PatchedArmourLayerRenderer(boolean hideHelmet) {
        this.hideHelmet = hideHelmet;
    }

    public void renderLayer(T t, E e, KeybladeArmorRenderer<E, M> emRenderLayer, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLightIn, OpenMatrix4f[] poses, float bob, float netYawHead, float pitchHead, float partialTicks) {
        if (e instanceof Player) {
            Player player = (Player)e;
            IPlayerCapabilities playerData = ModCapabilities.getPlayer(player);
            int color = playerData.getArmorColor();
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            boolean glint = playerData.getArmorGlint();
            NonNullList armor = player.m_150109_().f_35975_;
            for (int i = 0; !(i > 3 || this.hideHelmet && i == 3); ++i) {
                ItemStack itemStack = (ItemStack)armor.get(i);
                Item item = itemStack.m_41720_();
                if (!(item instanceof KeybladeArmorItem)) continue;
                KeybladeArmorItem item2 = (KeybladeArmorItem)item;
                ArmorBaseModel<LivingEntity> model = KeybladeArmorRenderer.armorModels.get(item2);
                if (!epicfight_armorModels.containsKey(item2) || ClientEngine.getInstance().isVanillaModelDebuggingMode()) {
                    HumanoidModel humanoidModel = new HumanoidModel(model.root);
                    this.setPartVisibility((HumanoidModel<LivingEntity>)humanoidModel, EquipmentSlot.m_20744_((EquipmentSlot.Type)EquipmentSlot.Type.ARMOR, (int)i));
                    epicfight_armorModels.put((Item)item2, CustomModelBakery.bakeArmor((LivingEntity)player, (ItemStack)itemStack, (ArmorItem)item2, (EquipmentSlot)EquipmentSlot.m_20744_((EquipmentSlot.Type)EquipmentSlot.Type.ARMOR, (int)i), (HumanoidModel)((HumanoidModel)emRenderLayer.m_117386_()), (Model)humanoidModel, (HumanoidModel)((HumanoidModel)emRenderLayer.m_117386_()), (HumanoidMesh)Meshes.BIPED));
                    humanoidModel.m_8009_(true);
                }
                AnimatedMesh modelAnimated = epicfight_armorModels.get(item2);
                String armorName = Utils.getItemRegistryName((Item)item2).m_135815_().substring(0, Utils.getItemRegistryName((Item)item2).m_135815_().indexOf("_"));
                String textureIndex = i == 1 ? "2" : "1";
                this.texture = new ResourceLocation("kingdomkeys", "textures/models/armor/" + armorName + textureIndex + ".png");
                modelAnimated.draw(poseStack, multiBufferSource, EpicFightRenderTypes.m_110431_((ResourceLocation)this.texture), packedLightIn, red, green, blue, 1.0f, OverlayTexture.f_118083_, (Armature)Armatures.BIPED, poses);
            }
        }
    }

    protected void setPartVisibility(HumanoidModel<LivingEntity> pModel, EquipmentSlot pSlot) {
        pModel.m_8009_(false);
        switch (pSlot) {
            case HEAD: {
                pModel.f_102808_.f_104207_ = true;
                pModel.f_102809_.f_104207_ = true;
                break;
            }
            case CHEST: {
                pModel.f_102810_.f_104207_ = true;
                pModel.f_102811_.f_104207_ = true;
                pModel.f_102812_.f_104207_ = true;
                break;
            }
            case LEGS: {
                pModel.f_102810_.f_104207_ = true;
                pModel.f_102813_.f_104207_ = true;
                pModel.f_102814_.f_104207_ = true;
                break;
            }
            case FEET: {
                pModel.f_102813_.f_104207_ = true;
                pModel.f_102814_.f_104207_ = true;
            }
        }
    }

    public HumanoidMesh getModel(E e) {
        boolean defaultSkin = ((AbstractClientPlayer)e).m_108564_().equals("default");
        if (defaultSkin) {
            return Meshes.BIPED;
        }
        return Meshes.ALEX;
    }
}

