/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import online.kingdomkeys.kingdomkeys.api.item.IItemCategory;
import online.kingdomkeys.kingdomkeys.api.item.ItemCategory;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.IWorldCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.lib.Party;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class KKPotionItem
extends Item
implements IItemCategory {
    PotionType type;
    double amount;
    boolean percentage;
    boolean all;

    public KKPotionItem(Item.Properties properties, PotionType type, double amount, boolean perc, boolean all) {
        super(properties);
        this.type = type;
        this.amount = amount;
        this.percentage = perc;
        this.all = all;
    }

    public void potionEffect(Player player) {
        IPlayerCapabilities playerData = ModCapabilities.getPlayer(player);
        switch (this.type) {
            case HP: {
                IWorldCapabilities worldData;
                Party party;
                float hpAmount = (float)(this.percentage ? (double)player.m_21233_() * this.amount / 100.0 : this.amount);
                hpAmount += hpAmount * (float)playerData.getNumberOfAbilitiesEquipped("kingdomkeys:ability_item_boost") / 2.0f;
                player.m_5634_(hpAmount);
                player.m_9236_().m_6263_(null, player.m_20182_().m_7096_(), player.m_20182_().m_7098_(), player.m_20182_().m_7094_(), (SoundEvent)ModSounds.potion.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                Utils.reviveFromKO((LivingEntity)player);
                if (!this.all || (party = (worldData = ModCapabilities.getWorld(player.m_9236_())).getPartyFromMember(player.m_20148_())) == null) break;
                for (Party.Member m : party.getMembers()) {
                    Player target;
                    if (m.getUUID().equals(player.m_20148_()) || !((target = player.m_9236_().m_46003_(m.getUUID())).m_20270_((Entity)player) < (float)ModConfigs.partyRangeLimit)) continue;
                    hpAmount = (float)(this.percentage ? (double)target.m_21233_() * this.amount / 100.0 : this.amount);
                    hpAmount += hpAmount * (float)playerData.getNumberOfAbilitiesEquipped("kingdomkeys:ability_item_boost") / 2.0f;
                    target.m_5634_(hpAmount);
                    Utils.reviveFromKO((LivingEntity)target);
                    player.m_9236_().m_6263_(null, player.m_20182_().m_7096_(), player.m_20182_().m_7098_(), player.m_20182_().m_7094_(), (SoundEvent)ModSounds.potion.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                break;
            }
            case MP: {
                IWorldCapabilities worldData;
                Party party;
                float mpAmount = (float)(this.percentage ? playerData.getMaxMP() * this.amount / 100.0 : this.amount);
                playerData.addMP(mpAmount);
                player.m_9236_().m_6263_(null, player.m_20182_().m_7096_(), player.m_20182_().m_7098_(), player.m_20182_().m_7094_(), (SoundEvent)ModSounds.potion.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                if (!this.all || (party = (worldData = ModCapabilities.getWorld(player.m_9236_())).getPartyFromMember(player.m_20148_())) == null) break;
                for (Party.Member m : party.getMembers()) {
                    if (m.getUUID().equals(player.m_20148_())) continue;
                    Player target = player.m_9236_().m_46003_(m.getUUID());
                    IPlayerCapabilities targetData = ModCapabilities.getPlayer(target);
                    if (target.m_20270_((Entity)player) < (float)ModConfigs.partyRangeLimit) {
                        mpAmount = (float)(this.percentage ? targetData.getMaxMP() * this.amount / 100.0 : this.amount);
                        targetData.addMP(mpAmount);
                        player.m_9236_().m_6263_(null, player.m_20182_().m_7096_(), player.m_20182_().m_7098_(), player.m_20182_().m_7094_(), (SoundEvent)ModSounds.potion.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                    PacketHandler.syncToAllAround(target, targetData);
                }
                break;
            }
            case HPMP: {
                IWorldCapabilities worldData;
                Party party;
                float mpAmount = (float)(this.percentage ? playerData.getMaxMP() * this.amount / 100.0 : this.amount);
                float hpAmount = (float)(this.percentage ? (double)player.m_21233_() * this.amount / 100.0 : this.amount);
                hpAmount += hpAmount * (float)playerData.getNumberOfAbilitiesEquipped("kingdomkeys:ability_item_boost") / 2.0f;
                playerData.addMP(mpAmount);
                Utils.reviveFromKO((LivingEntity)player);
                player.m_5634_(hpAmount);
                player.m_9236_().m_5594_(null, player.m_20183_(), (SoundEvent)ModSounds.potion.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                if (!this.all || (party = (worldData = ModCapabilities.getWorld(player.m_9236_())).getPartyFromMember(player.m_20148_())) == null) break;
                for (Party.Member m : party.getMembers()) {
                    if (m.getUUID().equals(player.m_20148_())) continue;
                    Player target = player.m_9236_().m_46003_(m.getUUID());
                    IPlayerCapabilities targetData = ModCapabilities.getPlayer(target);
                    if (target.m_20270_((Entity)player) < (float)ModConfigs.partyRangeLimit) {
                        mpAmount = (float)(this.percentage ? targetData.getMaxMP() * this.amount / 100.0 : this.amount);
                        hpAmount = (float)(this.percentage ? (double)target.m_21233_() * this.amount / 100.0 : this.amount);
                        hpAmount += hpAmount * (float)playerData.getNumberOfAbilitiesEquipped("kingdomkeys:ability_item_boost") / 2.0f;
                        Utils.reviveFromKO((LivingEntity)target);
                        targetData.addMP(mpAmount);
                        target.m_5634_(hpAmount);
                        player.m_9236_().m_6263_(null, player.m_20182_().m_7096_(), player.m_20182_().m_7098_(), player.m_20182_().m_7094_(), (SoundEvent)ModSounds.potion.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                    PacketHandler.syncToAllAround(target, targetData);
                }
                break;
            }
            case DRIVE: {
                IWorldCapabilities worldData;
                Party party;
                float dpAmount = (float)(this.percentage ? playerData.getMaxDP() * this.amount / 100.0 : this.amount);
                playerData.addDP(dpAmount);
                player.m_9236_().m_6263_(null, player.m_20182_().m_7096_(), player.m_20182_().m_7098_(), player.m_20182_().m_7094_(), (SoundEvent)ModSounds.potion.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                if (!this.all || (party = (worldData = ModCapabilities.getWorld(player.m_9236_())).getPartyFromMember(player.m_20148_())) == null) break;
                for (Party.Member m : party.getMembers()) {
                    if (m.getUUID().equals(player.m_20148_())) continue;
                    Player target = player.m_9236_().m_46003_(m.getUUID());
                    IPlayerCapabilities targetData = ModCapabilities.getPlayer(target);
                    if (target.m_20270_((Entity)player) < (float)ModConfigs.partyRangeLimit) {
                        dpAmount = (float)(this.percentage ? targetData.getMaxDP() * this.amount / 100.0 : this.amount);
                        targetData.addDP(dpAmount);
                        player.m_9236_().m_5594_(null, target.m_20183_(), (SoundEvent)ModSounds.potion.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                    PacketHandler.syncToAllAround(target, targetData);
                }
                break;
            }
            case FOCUS: {
                IWorldCapabilities worldData;
                Party party;
                float focusAmount = (float)(this.percentage ? playerData.getMaxFocus() * this.amount / 100.0 : this.amount);
                playerData.addFocus(focusAmount);
                player.m_9236_().m_6263_(null, player.m_20182_().m_7096_(), player.m_20182_().m_7098_(), player.m_20182_().m_7094_(), (SoundEvent)ModSounds.potion.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                if (!this.all || (party = (worldData = ModCapabilities.getWorld(player.m_9236_())).getPartyFromMember(player.m_20148_())) == null) break;
                for (Party.Member m : party.getMembers()) {
                    if (m.getUUID().equals(player.m_20148_())) continue;
                    Player target = player.m_9236_().m_46003_(m.getUUID());
                    IPlayerCapabilities targetData = ModCapabilities.getPlayer(target);
                    if (target.m_20270_((Entity)player) < (float)ModConfigs.partyRangeLimit) {
                        focusAmount = (float)(this.percentage ? targetData.getMaxFocus() * this.amount / 100.0 : this.amount);
                        targetData.addFocus(focusAmount);
                        player.m_9236_().m_6263_(null, player.m_20182_().m_7096_(), player.m_20182_().m_7098_(), player.m_20182_().m_7094_(), (SoundEvent)ModSounds.potion.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                    PacketHandler.syncToAllAround(target, targetData);
                }
                break;
            }
        }
        PacketHandler.syncToAllAround(player, playerData);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        String sType = Utils.translateToLocal("potion.desc." + this.type.toString().toLowerCase(), new Object[0]);
        String beginning = Utils.translateToLocal("potion.desc.beginning", (int)this.amount, this.percentage ? "%" : "", sType);
        String end = Utils.translateToLocal(this.all ? "potion.desc.toall" : "potion.desc.toone", new Object[0]);
        tooltip.add((Component)Component.m_237115_((String)(beginning + end)));
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    @Override
    public ItemCategory getCategory() {
        return ItemCategory.CONSUMABLE;
    }

    public boolean isGlobal() {
        return this.all;
    }

    public static enum PotionType {
        HP,
        MP,
        HPMP,
        DRIVE,
        FOCUS;

    }
}

