/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.item;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import online.kingdomkeys.kingdomkeys.api.item.IItemCategory;
import online.kingdomkeys.kingdomkeys.api.item.ItemCategory;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.magic.Magic;
import online.kingdomkeys.kingdomkeys.magic.ModMagic;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncCapabilityPacket;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class MagicSpellItem
extends Item
implements IItemCategory {
    String magic;

    public MagicSpellItem(Item.Properties properties, String name) {
        super(properties);
        this.magic = name;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        IPlayerCapabilities playerData = ModCapabilities.getPlayer(player);
        Magic magicInstance = (Magic)ModMagic.registry.get().getValue(new ResourceLocation(this.magic));
        if (!world.f_46443_) {
            if (playerData != null && playerData.getMagicsMap() != null) {
                if (!playerData.getMagicsMap().containsKey(this.magic)) {
                    playerData.getMagicsMap().put(this.magic, new int[]{0, 0});
                    this.takeItem(player);
                    player.m_5661_((Component)Component.m_237110_((String)"message.unlocked", (Object[])new Object[]{Utils.translateToLocal(magicInstance.getTranslationKey(), new Object[0])}), true);
                } else {
                    int actualLevel = playerData.getMagicLevel(new ResourceLocation(this.magic));
                    if (actualLevel < magicInstance.getMaxLevel()) {
                        player.m_5661_((Component)Component.m_237110_((String)"message.magic_upgrade", (Object[])new Object[]{Utils.translateToLocal(magicInstance.getTranslationKey(actualLevel), new Object[0]), Utils.translateToLocal(magicInstance.getTranslationKey(actualLevel + 1), new Object[0])}), true);
                        playerData.getMagicsMap().put(this.magic, new int[]{actualLevel + 1, 0});
                        this.takeItem(player);
                    } else {
                        player.m_5661_((Component)Component.m_237110_((String)"message.magic_max_level", (Object[])new Object[]{Utils.translateToLocal(magicInstance.getTranslationKey(actualLevel), new Object[0])}), true);
                    }
                }
                PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), (ServerPlayer)player);
            }
        } else if (!playerData.getMagicsMap().containsKey(this.magic) && !ModConfigs.magicDisplayedInCommandMenu.contains(this.magic)) {
            ArrayList<String> list = new ArrayList<String>(ModConfigs.magicDisplayedInCommandMenu);
            list.add(this.magic);
            ModConfigs.setMagicDisplayedInCommandMenu(list);
        }
        return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
    }

    private void takeItem(Player player) {
        if (!ItemStack.m_41728_((ItemStack)player.m_21205_(), (ItemStack)ItemStack.f_41583_) && player.m_21205_().m_41720_() == this) {
            player.m_21205_().m_41774_(1);
        } else if (!ItemStack.m_41728_((ItemStack)player.m_21206_(), (ItemStack)ItemStack.f_41583_) && player.m_21206_().m_41720_() == this) {
            player.m_21206_().m_41774_(1);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        Magic magicInstance = (Magic)ModMagic.registry.get().getValue(new ResourceLocation(this.magic));
        if (Minecraft.m_91087_().f_91074_ != null) {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)Minecraft.m_91087_().f_91074_);
            int actualLevel = playerData.getMagicLevel(new ResourceLocation(this.magic));
            if (!playerData.getMagicsMap().containsKey(this.magic)) {
                --actualLevel;
            }
            if (actualLevel < magicInstance.getMaxLevel()) {
                tooltip.add((Component)Component.m_237110_((String)"gui.magicspell.unlock", (Object[])new Object[]{Utils.translateToLocal(magicInstance.getTranslationKey(actualLevel + 1), new Object[0])}));
            } else {
                tooltip.add((Component)Component.m_237110_((String)"gui.magicspell.maxed", (Object[])new Object[]{Utils.translateToLocal(magicInstance.getTranslationKey(actualLevel), new Object[0])}));
            }
        }
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    @Override
    public ItemCategory getCategory() {
        return ItemCategory.MISC;
    }
}

