/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.cts;

import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.item.KeybladeItem;
import online.kingdomkeys.kingdomkeys.item.KeychainItem;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncCapabilityPacket;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class CSLevelUpKeybladePacket {
    ItemStack stack;

    public CSLevelUpKeybladePacket() {
    }

    public CSLevelUpKeybladePacket(ItemStack stack) {
        this.stack = stack;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130055_(this.stack);
    }

    public static CSLevelUpKeybladePacket decode(FriendlyByteBuf buffer) {
        CSLevelUpKeybladePacket msg = new CSLevelUpKeybladePacket();
        msg.stack = buffer.m_130267_();
        return msg;
    }

    public static void handle(CSLevelUpKeybladePacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)player);
            ItemStack stack = message.stack.m_41777_();
            KeychainItem kcItem = (KeychainItem)stack.m_41720_();
            KeybladeItem item = kcItem.getKeyblade();
            Iterator<Map.Entry<Item, Integer>> itMats = item.data.getLevelData(item.getKeybladeLevel(stack)).getMaterialList().entrySet().iterator();
            boolean hasMaterials = true;
            while (itMats.hasNext()) {
                Map.Entry<Item, Integer> m = itMats.next();
                if (playerData.getMaterialAmount(m.getKey()) >= m.getValue()) continue;
                hasMaterials = false;
            }
            if (hasMaterials) {
                UUID uUID;
                Item patt2819$temp;
                ItemStack itemStack;
                for (Map.Entry entry : item.data.getLevelData(item.getKeybladeLevel(stack)).getMaterialList().entrySet()) {
                    playerData.removeMaterial((Item)entry.getKey(), (Integer)entry.getValue());
                }
                kcItem.setKeybladeLevel(stack, kcItem.getKeybladeLevel(stack) + 1);
                int id = Utils.findSummoned(player.m_150109_(), stack);
                if (id > -1 && (itemStack = player.m_150109_().m_8020_(id)) != null && (patt2819$temp = itemStack.m_41720_()) instanceof KeybladeItem) {
                    KeybladeItem kbItem = (KeybladeItem)patt2819$temp;
                    kbItem.setKeybladeLevel(itemStack, kcItem.getKeybladeLevel(stack));
                }
                if ((uUID = Utils.getKeybladeID(stack)) != null) {
                    ResourceLocation slot = null;
                    for (Map.Entry<ResourceLocation, ItemStack> entry : playerData.getEquippedKeychains().entrySet()) {
                        if (!uUID.equals(Utils.getKeybladeID(entry.getValue()))) continue;
                        slot = entry.getKey();
                    }
                    if (slot != null) {
                        playerData.equipKeychain(slot, stack);
                    } else {
                        player.m_150109_().m_6836_(player.m_150109_().m_36030_(message.stack), stack);
                    }
                }
            }
            PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), player);
        });
        ctx.get().setPacketHandled(true);
    }
}

