/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.cts;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import online.kingdomkeys.kingdomkeys.capability.IWorldCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.lib.Party;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class CSPartyLeave {
    String name;
    UUID playerUUID;

    public CSPartyLeave() {
    }

    public CSPartyLeave(Party party, UUID playerUUID) {
        this.name = party.getName();
        this.playerUUID = playerUUID;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.name.length());
        buffer.m_130070_(this.name);
        buffer.m_130077_(this.playerUUID);
    }

    public static CSPartyLeave decode(FriendlyByteBuf buffer) {
        CSPartyLeave msg = new CSPartyLeave();
        int length = buffer.readInt();
        msg.name = buffer.m_130136_(length);
        msg.playerUUID = buffer.m_130259_();
        return msg;
    }

    public static void handle(CSPartyLeave message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            IWorldCapabilities worldData = ModCapabilities.getWorld(player.m_9236_());
            Party p = worldData.getPartyFromName(message.name);
            p.removeMember(message.playerUUID);
            Utils.syncWorldData(player.m_9236_(), worldData);
        });
        ctx.get().setPacketHandled(true);
    }
}

