/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.cts;

import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkEvent;
import online.kingdomkeys.kingdomkeys.api.item.IKeychain;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.item.KeybladeItem;
import online.kingdomkeys.kingdomkeys.item.organization.IOrgWeapon;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class CSSummonKeyblade {
    ResourceLocation formToSummonFrom;
    boolean hasForm;
    boolean forceDesummon;

    public CSSummonKeyblade() {
        this.hasForm = false;
        this.forceDesummon = false;
    }

    public CSSummonKeyblade(boolean forceDesummon) {
        this.forceDesummon = forceDesummon;
    }

    public CSSummonKeyblade(ResourceLocation formToSummonFrom) {
        this.formToSummonFrom = formToSummonFrom;
        this.hasForm = true;
        this.forceDesummon = false;
    }

    public CSSummonKeyblade(boolean forceDesummon, Utils.OrgMember alignment) {
        this.hasForm = false;
        this.forceDesummon = forceDesummon;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.forceDesummon);
        buffer.writeBoolean(this.hasForm);
        if (this.formToSummonFrom != null) {
            buffer.m_130085_(this.formToSummonFrom);
        }
    }

    public static CSSummonKeyblade decode(FriendlyByteBuf buffer) {
        CSSummonKeyblade msg = new CSSummonKeyblade();
        msg.forceDesummon = buffer.readBoolean();
        msg.hasForm = buffer.readBoolean();
        if (msg.hasForm) {
            msg.formToSummonFrom = buffer.m_130281_();
        }
        return msg;
    }

    public static void handle(CSSummonKeyblade message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            Utils.summonKeyblade((Player)player, message.forceDesummon, message.formToSummonFrom);
        });
        ctx.get().setPacketHandled(true);
    }

    @Mod.EventBusSubscriber
    public static class Events {
        @SubscribeEvent
        public static void containerClose(PlayerContainerEvent.Close event) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            AbstractContainerMenu openContainer = event.getContainer();
            InventoryMenu playerContainer = player.f_36095_;
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)player);
            if (playerData != null && !openContainer.equals(playerContainer)) {
                openContainer.f_38839_.forEach(slot -> {
                    ItemStack stack = slot.m_7993_();
                    if (!(stack.m_41720_() instanceof IKeychain) && slot.f_40218_ != player.m_150109_() && Utils.hasKeybladeID(stack)) {
                        slot.m_5852_(ItemStack.f_41583_);
                        if (stack.m_41720_() instanceof IOrgWeapon || playerData.getAlignment() != Utils.OrgMember.NONE) {
                            Set<ItemStack> weapons = playerData.getWeaponsUnlocked();
                            for (ItemStack weapon : weapons) {
                                if (!ItemStack.m_41656_((ItemStack)weapon, (ItemStack)stack)) continue;
                                weapon.m_41751_(stack.m_41783_());
                                break;
                            }
                            playerData.setWeaponsUnlocked(weapons);
                        }
                        openContainer.m_38946_();
                        player.m_9236_().m_6263_(null, player.m_20182_().m_7096_(), player.m_20182_().m_7098_(), player.m_20182_().m_7094_(), (SoundEvent)ModSounds.unsummon.get(), SoundSource.MASTER, 1.0f, 1.0f);
                    }
                });
            }
        }

        @SubscribeEvent
        public static void dropItem(ItemTossEvent event) {
            ItemStack droppedItem = event.getEntity().m_32055_();
            Player player = event.getPlayer();
            IPlayerCapabilities playerData = ModCapabilities.getPlayer(player);
            if (playerData != null && droppedItem != null && !(droppedItem.m_41720_() instanceof IKeychain) && Utils.hasKeybladeID(droppedItem)) {
                if (playerData.getEquippedWeapon() != null && (droppedItem.m_41720_() instanceof IOrgWeapon || droppedItem.m_41720_() instanceof KeybladeItem && playerData.getAlignment() != Utils.OrgMember.NONE || playerData.getEquippedWeapon().m_41720_() == droppedItem.m_41720_())) {
                    Set<ItemStack> weapons = playerData.getWeaponsUnlocked();
                    for (ItemStack weapon : weapons) {
                        if (!ItemStack.m_41656_((ItemStack)weapon, (ItemStack)droppedItem)) continue;
                        weapon.m_41751_(droppedItem.m_41783_());
                        break;
                    }
                    playerData.setWeaponsUnlocked(weapons);
                }
                player.m_9236_().m_6263_(null, player.m_20182_().m_7096_(), player.m_20182_().m_7098_(), player.m_20182_().m_7094_(), (SoundEvent)ModSounds.unsummon.get(), SoundSource.MASTER, 1.0f, 1.0f);
                event.setCanceled(true);
            }
        }
    }
}

