/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.stc;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.NetworkEvent;
import online.kingdomkeys.kingdomkeys.capability.IGlobalCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;

public class SCSyncGlobalCapabilityPacket {
    private int stoppedTicks;
    private int flatTicks;
    private int level;
    private int aeroTicks;
    private int aeroLevel;
    private int stopModelTicks;
    private float stopDmg;
    private boolean castleOblivionMarker;
    private boolean isKO;

    public SCSyncGlobalCapabilityPacket() {
    }

    public SCSyncGlobalCapabilityPacket(IGlobalCapabilities capability) {
        this.stoppedTicks = capability.getStoppedTicks();
        this.stopDmg = capability.getStopDamage();
        this.flatTicks = capability.getFlatTicks();
        this.aeroTicks = capability.getAeroTicks();
        this.aeroLevel = capability.getAeroLevel();
        this.castleOblivionMarker = capability.getCastleOblivionMarker();
        this.level = capability.getLevel();
        this.stopModelTicks = capability.getStopModelTicks();
        this.isKO = capability.isKO();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.stoppedTicks);
        buffer.writeFloat(this.stopDmg);
        buffer.writeInt(this.flatTicks);
        buffer.writeInt(this.aeroTicks);
        buffer.writeInt(this.aeroLevel);
        buffer.writeBoolean(this.castleOblivionMarker);
        buffer.writeInt(this.level);
        buffer.writeInt(this.stopModelTicks);
        buffer.writeBoolean(this.isKO);
    }

    public static SCSyncGlobalCapabilityPacket decode(FriendlyByteBuf buffer) {
        SCSyncGlobalCapabilityPacket msg = new SCSyncGlobalCapabilityPacket();
        msg.stoppedTicks = buffer.readInt();
        msg.stopDmg = buffer.readFloat();
        msg.flatTicks = buffer.readInt();
        msg.aeroTicks = buffer.readInt();
        msg.aeroLevel = buffer.readInt();
        msg.castleOblivionMarker = buffer.readBoolean();
        msg.level = buffer.readInt();
        msg.stopModelTicks = buffer.readInt();
        msg.isKO = buffer.readBoolean();
        return msg;
    }

    public static void handle(SCSyncGlobalCapabilityPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            LazyOptional globalData = Minecraft.m_91087_().f_91074_.getCapability(ModCapabilities.GLOBAL_CAPABILITIES);
            globalData.ifPresent(cap -> {
                cap.setStoppedTicks(message.stoppedTicks);
                cap.setStopDamage(message.stopDmg);
                cap.setFlatTicks(message.flatTicks);
                cap.setAeroTicks(message.aeroTicks, message.aeroLevel);
                cap.setCastleOblivionMarker(message.castleOblivionMarker);
                cap.setLevel(message.level);
                cap.setStopModelTicks(message.stopModelTicks);
                cap.setKO(message.isKO);
            });
        });
        ctx.get().setPacketHandled(true);
    }
}

