/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.stc;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.NetworkEvent;
import online.kingdomkeys.kingdomkeys.capability.GlobalCapabilities;
import online.kingdomkeys.kingdomkeys.capability.IGlobalCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;

public class SCSyncGlobalCapabilityToAllPacket {
    int id;
    private int stopTicks;
    private int flatTicks;
    private int level;
    private int aeroTicks;
    private int aeroLevel;
    private int stopModelTicks;
    private float stopDmg;
    private boolean castleOblivionMarker;
    private boolean isKO;

    public SCSyncGlobalCapabilityToAllPacket() {
    }

    public SCSyncGlobalCapabilityToAllPacket(int id, IGlobalCapabilities capability) {
        this.id = id;
        this.stopTicks = capability.getStoppedTicks();
        this.stopDmg = capability.getStopDamage();
        this.flatTicks = capability.getFlatTicks();
        this.aeroTicks = capability.getAeroTicks();
        this.aeroLevel = capability.getAeroLevel();
        this.castleOblivionMarker = capability.getCastleOblivionMarker();
        this.level = capability.getLevel();
        this.stopModelTicks = capability.getStopModelTicks();
        this.isKO = capability.isKO();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.id);
        buffer.writeInt(this.stopTicks);
        buffer.writeFloat(this.stopDmg);
        buffer.writeInt(this.flatTicks);
        buffer.writeInt(this.aeroTicks);
        buffer.writeInt(this.aeroLevel);
        buffer.writeBoolean(this.castleOblivionMarker);
        buffer.writeInt(this.level);
        buffer.writeInt(this.stopModelTicks);
        buffer.writeBoolean(this.isKO);
    }

    public static SCSyncGlobalCapabilityToAllPacket decode(FriendlyByteBuf buffer) {
        SCSyncGlobalCapabilityToAllPacket msg = new SCSyncGlobalCapabilityToAllPacket();
        msg.id = buffer.readInt();
        msg.stopTicks = buffer.readInt();
        msg.stopDmg = buffer.readFloat();
        msg.flatTicks = buffer.readInt();
        msg.aeroTicks = buffer.readInt();
        msg.aeroLevel = buffer.readInt();
        msg.castleOblivionMarker = buffer.readBoolean();
        msg.level = buffer.readInt();
        msg.stopModelTicks = buffer.readInt();
        msg.isKO = buffer.readBoolean();
        return msg;
    }

    public static void handle(SCSyncGlobalCapabilityToAllPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            LivingEntity entity = (LivingEntity)Minecraft.m_91087_().f_91073_.m_6815_(message.id);
            GlobalCapabilities cache = new GlobalCapabilities();
            cache.setStoppedTicks(message.stopTicks);
            cache.setStopDamage(message.stopDmg);
            cache.setFlatTicks(message.flatTicks);
            cache.setCastleOblivionMarker(message.castleOblivionMarker);
            cache.setLevel(message.level);
            cache.setStopModelTicks(message.stopModelTicks);
            cache.setKO(message.isKO);
            if (message.id != Minecraft.m_91087_().f_91074_.m_19879_()) {
                ModCapabilities.mobDataClientCache.put(message.id, cache);
            }
            if (entity != null) {
                LazyOptional globalData = entity.getCapability(ModCapabilities.GLOBAL_CAPABILITIES);
                globalData.ifPresent(cap -> {
                    cap.setStoppedTicks(message.stopTicks);
                    cap.setStopDamage(message.stopDmg);
                    cap.setFlatTicks(message.flatTicks);
                    cap.setAeroTicks(message.aeroTicks, message.aeroLevel);
                    cap.setCastleOblivionMarker(message.castleOblivionMarker);
                    cap.setLevel(message.level);
                    cap.setStopModelTicks(message.stopModelTicks);
                    cap.setKO(message.isKO);
                });
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

