/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.synthesis.recipe;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.registries.ForgeRegistries;

public class Recipe
implements INBTSerializable<CompoundTag> {
    @Nullable
    Map<Item, Integer> materials;
    @Nullable
    Item result;
    @Nullable
    int amount;
    @Nullable
    String type;
    @Nullable
    int cost;
    @Nullable
    int tier;
    ResourceLocation registryName;

    public Recipe() {
    }

    public Recipe(Map<Item, Integer> materials, int cost, Item result, int amount, String type) {
        this.materials = materials;
        this.result = result;
        this.amount = amount;
        this.type = type;
        this.cost = cost;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Map<Item, Integer> getMaterials() {
        return this.materials;
    }

    public void setMaterials(Map<Item, Integer> materials) {
        this.materials = materials;
    }

    public Item getResult() {
        return this.result;
    }

    public void setResult(Item result, int amount) {
        this.result = result;
        this.amount = amount;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public int getCost() {
        return this.cost;
    }

    public void setCost(int cost) {
        this.cost = cost;
    }

    public int getTier() {
        return this.tier;
    }

    public void setTier(int tier) {
        this.tier = tier;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("regname", this.getRegistryName().toString());
        nbt.m_128359_("result", ForgeRegistries.ITEMS.getKey((Object)this.result).toString());
        nbt.m_128405_("amount", this.amount);
        nbt.m_128405_("cost", this.cost);
        nbt.m_128405_("tier", this.tier);
        nbt.m_128359_("type", this.getType());
        nbt.m_128405_("ingredients_size", this.materials.entrySet().size());
        AtomicInteger i = new AtomicInteger();
        this.materials.entrySet().forEach(entry -> {
            nbt.m_128359_("ingredient_material_" + String.valueOf(i), ForgeRegistries.ITEMS.getKey((Object)((Item)entry.getKey())).toString());
            nbt.m_128405_("ingredient_amount_" + String.valueOf(i), ((Integer)entry.getValue()).intValue());
            i.getAndIncrement();
        });
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.setResult((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(nbt.m_128461_("result"))), nbt.m_128451_("amount"));
        this.setType(nbt.m_128461_("type"));
        this.setCost(nbt.m_128451_("cost"));
        this.setTier(nbt.m_128451_("tier"));
        HashMap<Item, Integer> ingredients = new HashMap<Item, Integer>();
        for (int i = 0; i < nbt.m_128451_("ingredients_size"); ++i) {
            ingredients.put((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(nbt.m_128461_("ingredient_material_" + i))), nbt.m_128451_("ingredient_amount_" + i));
        }
        this.setMaterials(ingredients);
        this.setRegistryName(nbt.m_128461_("regname"));
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public void setRegistryName(String registryName) {
        this.registryName = new ResourceLocation(registryName);
    }

    public void setRegistryName(String namespace, String path) {
        this.registryName = new ResourceLocation(namespace, path);
    }

    public void setRegistryName(ResourceLocation registryName) {
        this.registryName = registryName;
    }
}

