/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.synthesis.shop.names;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;

public class NamesListRegistry {
    private static NamesListRegistry INSTANCE;
    private Map<ResourceLocation, List<String>> registry = new HashMap<ResourceLocation, List<String>>();

    private NamesListRegistry() {
    }

    public static NamesListRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new NamesListRegistry();
        }
        return INSTANCE;
    }

    public void register(ResourceLocation registryName, List<String> names) {
        if (registryName != null) {
            this.registry.put(registryName, names);
            if (ModConfigs.debugConsoleOutput) {
                KingdomKeys.LOGGER.info("Successfully registered Moogle names {}", (Object)registryName);
            }
        } else {
            KingdomKeys.LOGGER.error("Cannot register Moogle names with no registry name");
        }
    }

    public List<String> getValue(ResourceLocation key) {
        if (this.containsKey(key)) {
            return this.registry.get(key);
        }
        KingdomKeys.LOGGER.error("Moogle names registry does not contain location: {}", (Object)key);
        return null;
    }

    public boolean containsKey(ResourceLocation key) {
        return this.registry.containsKey(key);
    }

    public void clearRegistry() {
        this.registry.clear();
        KingdomKeys.LOGGER.debug("Moogle names registry cleared");
    }

    public Map<ResourceLocation, List<String>> getRegistry() {
        return this.registry;
    }

    public List<List<String>> getValues() {
        return new LinkedList<List<String>>(this.registry.values());
    }

    public List<ResourceLocation> getKeys() {
        return new LinkedList<ResourceLocation>(this.registry.keySet());
    }

    public void setRegistry(Map<ResourceLocation, List<String>> registry) {
        this.registry = registry;
    }
}

