/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.floor;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.registries.ForgeRegistries;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.registry.JsonRegistryObject;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.registry.ModRoomTypes;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomType;
import org.jetbrains.annotations.Nullable;

public class FloorType
extends JsonRegistryObject {
    private int critPathLength;
    private int bonusRoomsCount;
    private int bonusRoomsChance;
    private int branchCount;
    private int branchChance;
    private Color floorColour;
    @Nullable
    private ResourceLocation music;
    private List<ResourceLocation> roomBlacklist;
    @Nullable
    private ResourceLocation startingRoom;
    @Nullable
    private ResourceLocation fixedLayout;

    public FloorType(CompoundTag tag) {
        super(tag);
    }

    public FloorType(JsonElement element) {
        super(element);
    }

    public int getCritPathLength() {
        return this.critPathLength;
    }

    public int getBonusRoomCount() {
        return this.bonusRoomsCount;
    }

    public int getBonusRoomChance() {
        return this.bonusRoomsChance;
    }

    public int getBranchCount() {
        return this.branchCount;
    }

    public int getBranchChance() {
        return this.branchChance;
    }

    public Color getFloorColour() {
        return this.floorColour;
    }

    public List<RoomType> getRoomBlacklist() {
        return this.roomBlacklist.stream().map(resourceLocation -> ModRoomTypes.registry.get().getValue((ResourceLocation)resourceLocation)).toList();
    }

    @Nullable
    public RoomType getStartingRoom() {
        if (this.startingRoom != null) {
            return ModRoomTypes.registry.get().getValue(this.startingRoom);
        }
        return null;
    }

    @Nullable
    public SoundEvent getMusic() {
        if (this.music != null) {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(this.music);
        }
        return null;
    }

    @Nullable
    public ResourceLocation getFixedLayout() {
        return this.fixedLayout;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("crit_path", this.critPathLength);
        tag.m_128405_("bonus_count", this.bonusRoomsCount);
        tag.m_128405_("bonus_chance", this.bonusRoomsChance);
        tag.m_128405_("branch_count", this.branchCount);
        tag.m_128405_("branch_chance", this.branchCount);
        tag.m_128405_("colour", this.floorColour.getRGB());
        CompoundTag blacklist = new CompoundTag();
        if (this.roomBlacklist != null) {
            this.roomBlacklist.forEach(roomType -> blacklist.m_128359_(roomType.toString(), roomType.toString()));
        }
        tag.m_128365_("blacklist", (Tag)blacklist);
        if (this.music != null) {
            tag.m_128359_("music", this.music.toString());
        }
        if (this.startingRoom != null) {
            tag.m_128359_("starting_room", this.startingRoom.toString());
        }
        if (this.fixedLayout != null) {
            tag.m_128359_("fixed_layout", this.fixedLayout.toString());
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.critPathLength = tag.m_128451_("crit_path");
        this.bonusRoomsCount = tag.m_128451_("bonus_count");
        this.bonusRoomsChance = tag.m_128451_("bonus_chance");
        this.branchCount = tag.m_128451_("branch_count");
        this.branchChance = tag.m_128451_("branch_chance");
        this.floorColour = new Color(tag.m_128451_("colour"));
        this.roomBlacklist = new ArrayList<ResourceLocation>();
        tag.m_128469_("blacklist").m_128431_().forEach(s -> this.roomBlacklist.add(new ResourceLocation(s)));
        if (tag.m_128441_("music")) {
            this.music = new ResourceLocation(tag.m_128461_("music"));
        }
        if (tag.m_128441_("starting_room")) {
            this.startingRoom = new ResourceLocation(tag.m_128461_("starting_room"));
        }
        if (tag.m_128441_("fixed_layout")) {
            this.fixedLayout = new ResourceLocation(tag.m_128461_("fixed_layout"));
        }
    }

    @Override
    public void deserializeJson(JsonElement element) throws JsonParseException {
        JsonObject root = element.getAsJsonObject();
        if (!root.has("crit_path_length")) {
            throw new JsonParseException("Missing required element \"crit_path_length\"");
        }
        root.entrySet().forEach(entry -> {
            JsonElement entryElement = (JsonElement)entry.getValue();
            switch ((String)entry.getKey()) {
                case "crit_path_length": {
                    int length = entryElement.getAsInt();
                    if (length < 0 || length > 25) {
                        throw new JsonParseException("crit_path_length is out of range 0-25");
                    }
                    this.critPathLength = length;
                    break;
                }
                case "bonus_rooms": {
                    JsonObject bonusRooms = entryElement.getAsJsonObject();
                    if (bonusRooms.has("count") && bonusRooms.has("chance")) {
                        this.bonusRoomsCount = bonusRooms.get("count").getAsInt();
                        this.bonusRoomsChance = bonusRooms.get("chance").getAsInt();
                        break;
                    }
                    throw new JsonParseException("Missing either \"count\" or \"chance\" for bonus_rooms");
                }
                case "branches": {
                    JsonObject branches = entryElement.getAsJsonObject();
                    if (branches.has("count") && branches.has("chance")) {
                        this.branchCount = branches.get("count").getAsInt();
                        this.branchCount = branches.get("chance").getAsInt();
                        break;
                    }
                    throw new JsonParseException("Missing either \"count\" or \"chance\" for branches");
                }
                case "colour": {
                    JsonArray colourArray = entryElement.getAsJsonArray();
                    if (colourArray.size() >= 3) {
                        int r = Math.max(0, Math.min(colourArray.get(0).getAsInt(), 255));
                        int g = Math.max(0, Math.min(colourArray.get(1).getAsInt(), 255));
                        int b = Math.max(0, Math.min(colourArray.get(2).getAsInt(), 255));
                        this.floorColour = new Color(r, g, b);
                        break;
                    }
                    throw new JsonParseException("Colour should have 3 values");
                }
                case "music": {
                    String s = entryElement.getAsString();
                    if (s.isEmpty()) break;
                    if (ForgeRegistries.SOUND_EVENTS.containsKey(new ResourceLocation(s))) {
                        this.music = new ResourceLocation(s);
                        break;
                    }
                    throw new JsonParseException("Supplied music does not exist");
                }
                case "black_list": {
                    JsonArray blackList = entryElement.getAsJsonArray();
                    this.roomBlacklist = new ArrayList<ResourceLocation>();
                    blackList.forEach(roomTypeElement -> {
                        String s = roomTypeElement.getAsString();
                        this.roomBlacklist.add(new ResourceLocation(s));
                    });
                    break;
                }
                case "starting_room": {
                    String s = entryElement.getAsString();
                    if (s.isEmpty()) break;
                    this.startingRoom = new ResourceLocation(s);
                    break;
                }
                case "fixed_layout": {
                    String s = entryElement.getAsString();
                    if (s.isEmpty()) break;
                    this.fixedLayout = new ResourceLocation(s);
                }
            }
        });
        if (this.roomBlacklist == null) {
            this.roomBlacklist = new ArrayList<ResourceLocation>();
        }
        if (this.floorColour == null) {
            this.floorColour = Color.black;
        }
    }
}

