/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.world.structure.castle_oblivion;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.CastleOblivionChunkGenerator;
import online.kingdomkeys.kingdomkeys.world.structure.JigsawPlacementRotation;
import online.kingdomkeys.kingdomkeys.world.structure.ModStructures;
import online.kingdomkeys.kingdomkeys.world.structure.castle_oblivion.CastleOblivionEntranceHallStructure;

public class CastleOblivionStructure
extends Structure {
    public static final Codec<CastleOblivionStructure> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CastleOblivionEntranceHallStructure.m_226567_((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size), (App)Codec.intRange((int)0, (int)6).fieldOf("piece_index").forGetter(structure -> structure.pieceIndex)).apply((Applicative)instance, CastleOblivionStructure::new));
    private final Holder<StructureTemplatePool> startPool;
    private final int size;
    private final int pieceIndex;

    public CastleOblivionStructure(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, int size, int pieceIndex) {
        super(config);
        this.startPool = startPool;
        this.size = size;
        this.pieceIndex = pieceIndex;
    }

    protected Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        if (!CastleOblivionStructure.isFeatureChunk(context, this.pieceIndex) || !(context.f_226622_() instanceof CastleOblivionChunkGenerator)) {
            return Optional.empty();
        }
        BlockPos pos = new BlockPos(context.f_226628_().m_151382_(0), 0, context.f_226628_().m_151391_(0));
        pos = pos.m_6630_(0);
        Rotation rotation = Rotation.NONE;
        Optional<Structure.GenerationStub> structurePiecesGenerator = JigsawPlacementRotation.addPieces(context, this.startPool, Optional.empty(), this.size, pos, rotation, false, Optional.empty(), 128);
        if (structurePiecesGenerator.isPresent()) {
            KingdomKeys.LOGGER.debug("Castle Oblivion generated at {}", (Object)pos);
        }
        return structurePiecesGenerator;
    }

    public StructureType<?> m_213658_() {
        return (StructureType)ModStructures.CASTLE_OBLIVION.get();
    }

    private static boolean isFeatureChunk(Structure.GenerationContext context, int pieceIndex) {
        return switch (pieceIndex) {
            case 1 -> context.f_226628_().equals((Object)new ChunkPos(0, -9));
            case 2 -> context.f_226628_().equals((Object)new ChunkPos(0, -18));
            case 3 -> context.f_226628_().equals((Object)new ChunkPos(-9, 0));
            case 4 -> context.f_226628_().equals((Object)new ChunkPos(-9, -9));
            case 5 -> context.f_226628_().equals((Object)new ChunkPos(-9, -18));
            case 6 -> context.f_226628_().equals((Object)new ChunkPos(-18, 0));
            default -> context.f_226628_().equals((Object)new ChunkPos(0, 0));
        };
    }
}

