package online.kingdomkeys.kingdomkeys.item;

import com.google.common.collect.ImmutableMap;
import net.minecraft.core.Holder;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SwordItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.item.card.MapCardItem;
import online.kingdomkeys.kingdomkeys.item.card.MinglingWorldsMapCardItem;
import online.kingdomkeys.kingdomkeys.item.card.WorldCardItem;
import online.kingdomkeys.kingdomkeys.item.organization.*;
import online.kingdomkeys.kingdomkeys.item.tier.KeybladeItemTier;
import online.kingdomkeys.kingdomkeys.item.tier.WoodenKeybladeItemTier;
import online.kingdomkeys.kingdomkeys.lib.Strings;
import online.kingdomkeys.kingdomkeys.sound.ModJukeboxSongs;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.floor.FloorType;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.registry.ModFloorTypes;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.registry.ModRoomTypes;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomType;

import java.util.function.Supplier;

public class ModItems {

	public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems(KingdomKeys.MODID);

    public static final Supplier<Item>
			abaddonPlasma = createKeybladeItem(Strings.abaddonPlasma),
			abyssalTide = createKeybladeItem(Strings.abyssalTide),
			acedsKeyblade = createKeybladeItem(Strings.acedsKeyblade),
			adventRed = createKeybladeItem(Strings.adventRed),
			allForOne = createKeybladeItem(Strings.allForOne),
			astralBlast = createKeybladeItem(Strings.astralBlast),
			aubade = createKeybladeItem(Strings.aubade),
			avasKeyblade = createKeybladeItem(Strings.avasKeyblade),
			bondOfFlame = createKeybladeItem(Strings.bondOfFlame),
			bondOfTheBlaze = createKeybladeItem(Strings.bondOfTheBlaze),
			braveheart = createKeybladeItem(Strings.braveheart),
			brightcrest = createKeybladeItem(Strings.brightcrest),
			chaosRipper = createKeybladeItem(Strings.chaosRipper),
			circleOfLife = createKeybladeItem(Strings.circleOfLife),
			classicTone = createKeybladeItem(Strings.classicTone),
			counterpoint = createKeybladeItem(Strings.counterpoint),
			crabclaw = createKeybladeItem(Strings.crabclaw),
			crownOfGuilt = createKeybladeItem(Strings.crownOfGuilt),
			crystalSnow = createKeybladeItem(Strings.crystalSnow),
			darkerThanDark = createKeybladeItem(Strings.darkerThanDark),
			darkgnaw = createKeybladeItem(Strings.darkgnaw),
			dawnTillDusk = createKeybladeItem(Strings.dawnTillDusk),
			deadOfNight = createKeybladeItem(Strings.deadOfNight),
			decisivePumpkin = createKeybladeItem(Strings.decisivePumpkin),
			destinysEmbrace = createKeybladeItem(Strings.destinysEmbrace),
			diamondDust = createKeybladeItem(Strings.diamondDust),
			divewing = createKeybladeItem(Strings.divewing),
			divineRose = createKeybladeItem(Strings.divineRose),
			dualDisc = createKeybladeItem(Strings.dualDisc),
			earthshaker = createKeybladeItem(Strings.earthshaker),
			elementalEncoder = createKeybladeItem(Strings.elementalEncoder),
			endOfPain = createKeybladeItem(Strings.endOfPain),
			endsOfTheEarth = createKeybladeItem(Strings.endsOfTheEarth),
			everAfter = createKeybladeItem(Strings.everAfter),
			fairyHarp = createKeybladeItem(Strings.fairyHarp),
			fairyStars = createKeybladeItem(Strings.fairyStars),
			fatalCrest = createKeybladeItem(Strings.fatalCrest),
			favoriteDeputy = createKeybladeItem(Strings.favoriteDeputy),
			fenrir = createKeybladeItem(Strings.fenrir),
			ferrisGear = createKeybladeItem(Strings.ferrisGear),
			followTheWind = createKeybladeItem(Strings.followTheWind),
			frolicFlame = createKeybladeItem(Strings.frolicFlame),
			glimpseOfDarkness = createKeybladeItem(Strings.glimpseOfDarkness),
			grandChef = createKeybladeItem(Strings.grandChef),
			guardianBell = createKeybladeItem(Strings.guardianBell),
			guardianSoul = createKeybladeItem(Strings.guardianSoul),
			gulasKeyblade = createKeybladeItem(Strings.gulasKeyblade),
			gullWing = createKeybladeItem(Strings.gullWing),
			happyGear = createKeybladeItem(Strings.happyGear),
			herosCrest = createKeybladeItem(Strings.herosCrest),
			herosOrigin = createKeybladeItem(Strings.herosOrigin),
			hiddenDragon = createKeybladeItem(Strings.hiddenDragon),
			hunnySpout = createKeybladeItem(Strings.hunnySpout),
			hyperdrive = createKeybladeItem(Strings.hyperdrive),
			incompleteKiblade = createKeybladeItem(Strings.incompleteKiblade),
			invisKeyblade = createKeybladeItem(Strings.invisKeyblade),
			irasKeyblade = createKeybladeItem(Strings.irasKeyblade),
			jungleKing = createKeybladeItem(Strings.jungleKing),
			keybladeOfPeoplesHearts = createKeybladeItem(Strings.keybladeOfPeoplesHearts),
			kiblade = createKeybladeItem(Strings.kiblade),
			kingdomKey = createKeybladeItem(Strings.kingdomKey),
			kingdomKeyD = createKeybladeItem(Strings.kingdomKeyD),
			knockoutPunch = createKeybladeItem(Strings.knockoutPunch),
			ladyLuck = createKeybladeItem(Strings.ladyLuck),
			leviathan = createKeybladeItem(Strings.leviathan),
			lionheart = createKeybladeItem(Strings.lionheart),
			lostMemory = createKeybladeItem(Strings.lostMemory),
			lunarEclipse = createKeybladeItem(Strings.lunarEclipse),
			markOfAHero = createKeybladeItem(Strings.markOfAHero),
			mastersDefender = createKeybladeItem(Strings.mastersDefender),
			maverickFlare = createKeybladeItem(Strings.maverickFlare),
			metalChocobo = createKeybladeItem(Strings.metalChocobo),
			midnightBlue = createKeybladeItem(Strings.midnightBlue),
			midnightRoar = createKeybladeItem(Strings.midnightRoar),
			mirageSplit = createKeybladeItem(Strings.mirageSplit),
			missingAche = createKeybladeItem(Strings.missingAche),
			monochrome = createKeybladeItem(Strings.monochrome),
			moogleOGlory = createKeybladeItem(Strings.moogleOGlory),
			mysteriousAbyss = createKeybladeItem(Strings.mysteriousAbyss),
			nanoGear = createKeybladeItem(Strings.nanoGear),
			nightmaresEnd = createKeybladeItem(Strings.nightmaresEnd),
			nightmaresEndAndMirageSplit = createKeybladeItem(Strings.nightmaresEndAndMirageSplit),
			noName = createKeybladeItem(Strings.noName),
			noNameBBS = createKeybladeItem(Strings.noNameBBS),
			oathkeeper = createKeybladeItem(Strings.oathkeeper),
			oblivion = createKeybladeItem(Strings.oblivion),
			oceansRage = createKeybladeItem(Strings.oceansRage),
			olympia = createKeybladeItem(Strings.olympia),
			omegaWeapon = createKeybladeItem(Strings.omegaWeapon),
			ominousBlight = createKeybladeItem(Strings.ominousBlight),
			oneWingedAngel = createKeybladeItem(Strings.oneWingedAngel),
			painOfSolitude = createKeybladeItem(Strings.painOfSolitude),
			phantomGreen = createKeybladeItem(Strings.phantomGreen),
			photonDebugger = createKeybladeItem(Strings.photonDebugger),
			pixiePetal = createKeybladeItem(Strings.pixiePetal),
			pumpkinhead = createKeybladeItem(Strings.pumpkinhead),
			rainfell = createKeybladeItem(Strings.rainfell),
			rejectionOfFate = createKeybladeItem(Strings.rejectionOfFate),
			royalRadiance = createKeybladeItem(Strings.royalRadiance),
			rumblingRose = createKeybladeItem(Strings.rumblingRose),
			shootingStar = createKeybladeItem(Strings.shootingStar),
			signOfInnocence = createKeybladeItem(Strings.signOfInnocence),
			silentDirge = createKeybladeItem(Strings.silentDirge),
			skullNoise = createKeybladeItem(Strings.skullNoise),
			sleepingLion = createKeybladeItem(Strings.sleepingLion),
			soulEater = createKeybladeItem(Strings.soulEater),
			spellbinder = createKeybladeItem(Strings.spellbinder),
			starCluster = createKeybladeItem(Strings.starCluster),
			starSeeker = createKeybladeItem(Strings.starSeeker),
			starlight = createKeybladeItem(Strings.starlight),
			stormfall = createKeybladeItem(Strings.stormfall),
			strokeOfMidnight = createKeybladeItem(Strings.strokeOfMidnight),
			sweetDreams = createKeybladeItem(Strings.sweetDreams),
			sweetMemories = createKeybladeItem(Strings.sweetMemories),
			sweetstack = createKeybladeItem(Strings.sweetstack),
			threeWishes = createKeybladeItem(Strings.threeWishes),
			totalEclipse = createKeybladeItem(Strings.totalEclipse),
			treasureTrove = createKeybladeItem(Strings.treasureTrove),
			trueLightsFlight = createKeybladeItem(Strings.trueLightsFlight),
			twilightBlaze = createKeybladeItem(Strings.twilightBlaze),
			twoBecomeOne = createKeybladeItem(Strings.twoBecomeOne),
			ultimaWeaponBBS = createKeybladeItem(Strings.ultimaWeaponBBS),
			ultimaWeaponDDD = createKeybladeItem(Strings.ultimaWeaponDDD),
			ultimaWeaponKH1 = createKeybladeItem(Strings.ultimaWeaponKH1),
			ultimaWeaponKH2 = createKeybladeItem(Strings.ultimaWeaponKH2),
			ultimaWeaponKH3 = createKeybladeItem(Strings.ultimaWeaponKH3),
			umbrella = createKeybladeItem(Strings.umbrella),
			unbound = createKeybladeItem(Strings.unbound),
			victoryLine = createKeybladeItem(Strings.victoryLine),
			voidGear = createKeybladeItem(Strings.voidGear),
			voidGearRemnant = createKeybladeItem(Strings.voidGearRemnant),
			waytotheDawn = createKeybladeItem(Strings.wayToTheDawn),
			waywardWind = createKeybladeItem(Strings.waywardWind),
			wheelOfFate = createKeybladeItem(Strings.wheelOfFate),
			winnersProof = createKeybladeItem(Strings.winnersProof),
			wishingLamp = createKeybladeItem(Strings.wishingLamp),
			wishingStar = createKeybladeItem(Strings.wishingStar),
			woodenKeyblade = createNewItem(Strings.woodenKeyblade, () -> new SwordItem(new WoodenKeybladeItemTier(), new Item.Properties().attributes(SwordItem.createAttributes(new WoodenKeybladeItemTier(), 4, 1)).stacksTo(1))),
			woodenStick = createNewItem(Strings.woodenStick, () -> new SwordItem(new WoodenKeybladeItemTier(), new Item.Properties().attributes(SwordItem.createAttributes(new WoodenKeybladeItemTier(), 2, 1)).stacksTo(1))),
			youngXehanortsKeyblade = createKeybladeItem(Strings.youngXehanortsKeyblade),
			zeroOne = createKeybladeItem(Strings.zeroOne),

			dreamShield = createNewItem(Strings.dreamShield, () -> new KKShieldItem(new Item.Properties().stacksTo(1))),
			dreamStaff = createNewItem(Strings.dreamStaff, () -> new SwordItem(new KeybladeItemTier(0), new Item.Properties().attributes(SwordItem.createAttributes(new KeybladeItemTier(0), 2, 1)).stacksTo(1))),
			dreamSword = createNewItem(Strings.dreamSword, () -> new SwordItem(new KeybladeItemTier(0), new Item.Properties().attributes(SwordItem.createAttributes(new KeybladeItemTier(0), 2, 1)).stacksTo(1))),

			k111 = createKeybladeItem(Strings.k111),
			retribution = createKeybladeItem(Strings.retribution),
			
			abaddonPlasmaChain = createNewItem(Strings.abaddonPlasmaChain, KeychainItem::new),
			abyssalTideChain = createNewItem(Strings.abyssalTideChain, KeychainItem::new),
			acedsKeybladeChain = createNewItem(Strings.acedsKeybladeChain, KeychainItem::new),
			adventRedChain = createNewItem(Strings.adventRedChain, KeychainItem::new),
			allForOneChain = createNewItem(Strings.allForOneChain, KeychainItem::new),
			astralBlastChain = createNewItem(Strings.astralBlastChain, KeychainItem::new),
			aubadeChain = createNewItem(Strings.aubadeChain, KeychainItem::new),
			avasKeybladeChain = createNewItem(Strings.avasKeybladeChain, KeychainItem::new),
			bondOfFlameChain = createNewItem(Strings.bondOfFlameChain, KeychainItem::new),
			bondOfTheBlazeChain = createNewItem(Strings.bondOfTheBlazeChain, KeychainItem::new),
			braveheartChain = createNewItem(Strings.braveheartChain, KeychainItem::new),
			brightcrestChain = createNewItem(Strings.brightcrestChain, KeychainItem::new),
			chaosRipperChain = createNewItem(Strings.chaosRipperChain, KeychainItem::new),
			circleOfLifeChain = createNewItem(Strings.circleOfLifeChain, KeychainItem::new),
			classicToneChain = createNewItem(Strings.classicToneChain, KeychainItem::new),
			counterpointChain = createNewItem(Strings.counterpointChain, KeychainItem::new),
			crabclawChain = createNewItem(Strings.crabclawChain, KeychainItem::new),
			crownOfGuiltChain = createNewItem(Strings.crownOfGuiltChain, KeychainItem::new),
			crystalSnowChain = createNewItem(Strings.crystalSnowChain, KeychainItem::new),
			darkerThanDarkChain = createNewItem(Strings.darkerThanDarkChain, KeychainItem::new),
			darkgnawChain = createNewItem(Strings.darkgnawChain, KeychainItem::new),
			dawnTillDuskChain = createNewItem(Strings.dawnTillDuskChain, KeychainItem::new),
			deadOfNightChain = createNewItem(Strings.deadOfNightChain, KeychainItem::new),
			decisivePumpkinChain = createNewItem(Strings.decisivePumpkinChain, KeychainItem::new),
			destinysEmbraceChain = createNewItem(Strings.destinysEmbraceChain, KeychainItem::new),
			diamondDustChain = createNewItem(Strings.diamondDustChain, KeychainItem::new),
			divewingChain = createNewItem(Strings.divewingChain, KeychainItem::new),
			divineRoseChain = createNewItem(Strings.divineRoseChain, KeychainItem::new),
			dualDiscChain = createNewItem(Strings.dualDiscChain, KeychainItem::new),
			earthshakerChain = createNewItem(Strings.earthshakerChain, KeychainItem::new),
			elementalEncoderChain = createNewItem(Strings.elementalEncoderChain, KeychainItem::new),
			endOfPainChain = createNewItem(Strings.endOfPainChain, KeychainItem::new),
			endsOfTheEarthChain = createNewItem(Strings.endsOfTheEarthChain, KeychainItem::new),
			everAfterChain = createNewItem(Strings.everAfterChain, KeychainItem::new),
			fairyHarpChain = createNewItem(Strings.fairyHarpChain, KeychainItem::new),
			fairyStarsChain = createNewItem(Strings.fairyStarsChain, KeychainItem::new),
			fatalCrestChain = createNewItem(Strings.fatalCrestChain, KeychainItem::new),
			favoriteDeputyChain = createNewItem(Strings.favoriteDeputyChain, KeychainItem::new),
			fenrirChain = createNewItem(Strings.fenrirChain, KeychainItem::new),
			ferrisGearChain = createNewItem(Strings.ferrisGearChain, KeychainItem::new),
			followTheWindChain = createNewItem(Strings.followTheWindChain, KeychainItem::new),
			frolicFlameChain = createNewItem(Strings.frolicFlameChain, KeychainItem::new),
			glimpseOfDarknessChain = createNewItem(Strings.glimpseOfDarknessChain, KeychainItem::new),
			grandChefChain = createNewItem(Strings.grandChefChain, KeychainItem::new),
			guardianBellChain = createNewItem(Strings.guardianBellChain, KeychainItem::new),
			guardianSoulChain = createNewItem(Strings.guardianSoulChain, KeychainItem::new),
			gulasKeybladeChain = createNewItem(Strings.gulasKeybladeChain, KeychainItem::new),
			gullWingChain = createNewItem(Strings.gullWingChain, KeychainItem::new),
			happyGearChain = createNewItem(Strings.happyGearChain, KeychainItem::new),
			herosCrestChain = createNewItem(Strings.herosCrestChain, KeychainItem::new),
			herosOriginChain = createNewItem(Strings.herosOriginChain, KeychainItem::new),
			hiddenDragonChain = createNewItem(Strings.hiddenDragonChain, KeychainItem::new),
			hunnySpoutChain = createNewItem(Strings.hunnySpoutChain, KeychainItem::new),
			hyperdriveChain = createNewItem(Strings.hyperdriveChain, KeychainItem::new),
			incompleteKibladeChain = createNewItem(Strings.incompleteKibladeChain, KeychainItem::new),
			invisKeybladeChain = createNewItem(Strings.invisKeybladeChain, KeychainItem::new),
			irasKeybladeChain = createNewItem(Strings.irasKeybladeChain, KeychainItem::new),
			jungleKingChain = createNewItem(Strings.jungleKingChain, KeychainItem::new),
			keybladeOfPeoplesHeartsChain = createNewItem(Strings.keybladeOfPeoplesHeartsChain, KeychainItem::new),
			kibladeChain = createNewItem(Strings.kibladeChain, KeychainItem::new),
			kingdomKeyChain = createNewItem(Strings.kingdomKeyChain, KeychainItem::new),
			kingdomKeyDChain = createNewItem(Strings.kingdomKeyDChain, KeychainItem::new),
			knockoutPunchChain = createNewItem(Strings.knockoutPunchChain, KeychainItem::new),
			ladyLuckChain = createNewItem(Strings.ladyLuckChain, KeychainItem::new),
			leviathanChain = createNewItem(Strings.leviathanChain, KeychainItem::new),
			lionheartChain = createNewItem(Strings.lionheartChain, KeychainItem::new),
			lostMemoryChain = createNewItem(Strings.lostMemoryChain, KeychainItem::new),
			lunarEclipseChain = createNewItem(Strings.lunarEclipseChain, KeychainItem::new),
			markOfAHeroChain = createNewItem(Strings.markOfAHeroChain, KeychainItem::new),
			mastersDefenderChain = createNewItem(Strings.mastersDefenderChain, KeychainItem::new),
			maverickFlareChain = createNewItem(Strings.maverickFlareChain, KeychainItem::new),
			metalChocoboChain = createNewItem(Strings.metalChocoboChain, KeychainItem::new),
			midnightBlueChain = createNewItem(Strings.midnightBlueChain, KeychainItem::new),
			midnightRoarChain = createNewItem(Strings.midnightRoarChain, KeychainItem::new),
			mirageSplitChain = createNewItem(Strings.mirageSplitChain, KeychainItem::new),
			missingAcheChain = createNewItem(Strings.missingAcheChain, KeychainItem::new),
			monochromeChain = createNewItem(Strings.monochromeChain, KeychainItem::new),
			moogleOGloryChain = createNewItem(Strings.moogleOGloryChain, KeychainItem::new),
			mysteriousAbyssChain = createNewItem(Strings.mysteriousAbyssChain, KeychainItem::new),
			nanoGearChain = createNewItem(Strings.nanoGearChain, KeychainItem::new),
			nightmaresEndChain = createNewItem(Strings.nightmaresEndChain, KeychainItem::new),
			nightmaresEndAndMirageSplitChain = createNewItem(Strings.nightmaresEndAndMirageSplitChain, KeychainItem::new),
			noNameChain = createNewItem(Strings.noNameChain, KeychainItem::new),
			noNameBBSChain = createNewItem(Strings.noNameBBSChain, KeychainItem::new),
			oathkeeperChain = createNewItem(Strings.oathkeeperChain, KeychainItem::new),
			oblivionChain = createNewItem(Strings.oblivionChain, KeychainItem::new),
			oceansRageChain = createNewItem(Strings.oceansRageChain, KeychainItem::new),
			olympiaChain = createNewItem(Strings.olympiaChain, KeychainItem::new),
			omegaWeaponChain = createNewItem(Strings.omegaWeaponChain, KeychainItem::new),
			ominousBlightChain = createNewItem(Strings.ominousBlightChain, KeychainItem::new),
			oneWingedAngelChain = createNewItem(Strings.oneWingedAngelChain, KeychainItem::new),
			painOfSolitudeChain = createNewItem(Strings.painOfSolitudeChain, KeychainItem::new),
			phantomGreenChain = createNewItem(Strings.phantomGreenChain, KeychainItem::new),
			photonDebuggerChain = createNewItem(Strings.photonDebuggerChain, KeychainItem::new),
			pixiePetalChain = createNewItem(Strings.pixiePetalChain, KeychainItem::new),
			pumpkinheadChain = createNewItem(Strings.pumpkinheadChain, KeychainItem::new),
			rainfellChain = createNewItem(Strings.rainfellChain, KeychainItem::new),
			rejectionOfFateChain = createNewItem(Strings.rejectionOfFateChain, KeychainItem::new),
			royalRadianceChain = createNewItem(Strings.royalRadianceChain, KeychainItem::new),
			rumblingRoseChain = createNewItem(Strings.rumblingRoseChain, KeychainItem::new),
			shootingStarChain = createNewItem(Strings.shootingStarChain, KeychainItem::new),
			signOfInnocenceChain = createNewItem(Strings.signOfInnocenceChain, KeychainItem::new),
			silentDirgeChain = createNewItem(Strings.silentDirgeChain, KeychainItem::new),
			skullNoiseChain = createNewItem(Strings.skullNoiseChain, KeychainItem::new),
			sleepingLionChain = createNewItem(Strings.sleepingLionChain, KeychainItem::new),
			soulEaterChain = createNewItem(Strings.soulEaterChain, KeychainItem::new),
			spellbinderChain = createNewItem(Strings.spellbinderChain, KeychainItem::new),
			starClusterChain = createNewItem(Strings.starClusterChain, KeychainItem::new),
			starSeekerChain = createNewItem(Strings.starSeekerChain, KeychainItem::new),
			starlightChain = createNewItem(Strings.starlightChain, KeychainItem::new),
			stormfallChain = createNewItem(Strings.stormfallChain, KeychainItem::new),
			strokeOfMidnightChain = createNewItem(Strings.strokeOfMidnightChain, KeychainItem::new),
			sweetDreamsChain = createNewItem(Strings.sweetDreamsChain, KeychainItem::new),
			sweetMemoriesChain = createNewItem(Strings.sweetMemoriesChain, KeychainItem::new),
			sweetstackChain = createNewItem(Strings.sweetstackChain, KeychainItem::new),
			threeWishesChain = createNewItem(Strings.threeWishesChain, KeychainItem::new),
			totalEclipseChain = createNewItem(Strings.totalEclipseChain, KeychainItem::new),
			treasureTroveChain = createNewItem(Strings.treasureTroveChain, KeychainItem::new),
			trueLightsFlightChain = createNewItem(Strings.trueLightsFlightChain, KeychainItem::new),
			twilightBlazeChain = createNewItem(Strings.twilightBlazeChain, KeychainItem::new),
			twoBecomeOneChain = createNewItem(Strings.twoBecomeOneChain, KeychainItem::new),
			ultimaWeaponBBSChain = createNewItem(Strings.ultimaWeaponBBSChain, KeychainItem::new),
			ultimaWeaponDDDChain = createNewItem(Strings.ultimaWeaponDDDChain, KeychainItem::new),
			ultimaWeaponKH1Chain = createNewItem(Strings.ultimaWeaponKH1Chain, KeychainItem::new),
			ultimaWeaponKH2Chain = createNewItem(Strings.ultimaWeaponKH2Chain, KeychainItem::new),
			ultimaWeaponKH3Chain = createNewItem(Strings.ultimaWeaponKH3Chain, KeychainItem::new),
			umbrellaChain = createNewItem(Strings.umbrellaChain, KeychainItem::new),
			unboundChain = createNewItem(Strings.unboundChain, KeychainItem::new),
			victoryLineChain = createNewItem(Strings.victoryLineChain, KeychainItem::new),
			voidGearChain = createNewItem(Strings.voidGearChain, KeychainItem::new),
			voidGearRemnantChain = createNewItem(Strings.voidGearRemnantChain, KeychainItem::new),
			waytotheDawnChain = createNewItem(Strings.wayToTheDawnChain, KeychainItem::new),
			waywardWindChain = createNewItem(Strings.waywardWindChain, KeychainItem::new),
			wheelOfFateChain = createNewItem(Strings.wheelOfFateChain, KeychainItem::new),
			winnersProofChain = createNewItem(Strings.winnersProofChain, KeychainItem::new),
			wishingLampChain = createNewItem(Strings.wishingLampChain, KeychainItem::new),
			wishingStarChain = createNewItem(Strings.wishingStarChain, KeychainItem::new),
			youngXehanortsKeybladeChain = createNewItem(Strings.youngXehanortsKeybladeChain, KeychainItem::new),
			zeroOneChain = createNewItem(Strings.zeroOneChain, KeychainItem::new),

			//Custom Keychains
			k111c = createNewItem(Strings.k111c, KeychainItem::new),
			retributionChain = createNewItem(Strings.retributionChain, KeychainItem::new),

			
			malice = createNewItem(Strings.malice, EtherealBladeItem::new),
			sanction = createNewItem(Strings.sanction, EtherealBladeItem::new),
			overlord = createNewItem(Strings.overlord, EtherealBladeItem::new),
			veneration = createNewItem(Strings.veneration, EtherealBladeItem::new),
			autocracy = createNewItem(Strings.autocracy, EtherealBladeItem::new),
			conquest = createNewItem(Strings.conquest, EtherealBladeItem::new),
			terminus = createNewItem(Strings.terminus, EtherealBladeItem::new),
			judgement = createNewItem(Strings.judgement, EtherealBladeItem::new),
			discipline = createNewItem(Strings.discipline, EtherealBladeItem::new),
			aristocracy = createNewItem(Strings.aristocracy, EtherealBladeItem::new),
			superiority = createNewItem(Strings.superiority, EtherealBladeItem::new),
			aggression = createNewItem(Strings.aggression, EtherealBladeItem::new),
			fury = createNewItem(Strings.fury, EtherealBladeItem::new),
			despair = createNewItem(Strings.despair, EtherealBladeItem::new),
			triumph = createNewItem(Strings.triumph, EtherealBladeItem::new),
			ruination = createNewItem(Strings.ruination, EtherealBladeItem::new),
			domination = createNewItem(Strings.domination, EtherealBladeItem::new),
			annihilation = createNewItem(Strings.annihilation, EtherealBladeItem::new),
			tyrant = createNewItem(Strings.tyrant, EtherealBladeItem::new),
			magnificence = createNewItem(Strings.magnificence, EtherealBladeItem::new),
			infinity = createNewItem(Strings.infinity, EtherealBladeItem::new),
			interdiction = createNewItem(Strings.interdiction, EtherealBladeItem::new),
			roundFan = createNewItem(Strings.roundFan, EtherealBladeItem::new),
			absolute = createNewItem(Strings.absolute, EtherealBladeItem::new),
			
			standalone = createNewItem(Strings.standalone, ArrowgunItem::new),
			killerbee = createNewItem(Strings.killerbee, ArrowgunItem::new),
			stingray = createNewItem(Strings.stingray, ArrowgunItem::new),
			counterweight = createNewItem(Strings.counterweight, ArrowgunItem::new),
			precision = createNewItem(Strings.precision, ArrowgunItem::new),
			dualHead = createNewItem(Strings.dualHead, ArrowgunItem::new),
			bahamut = createNewItem(Strings.bahamut, ArrowgunItem::new),
			gullwing = createNewItem(Strings.gullwing, ArrowgunItem::new),
			blueFrame = createNewItem(Strings.blueFrame, ArrowgunItem::new),
			starShell = createNewItem(Strings.starShell, ArrowgunItem::new),
			sunrise = createNewItem(Strings.sunrise, ArrowgunItem::new),
			ignition = createNewItem(Strings.ignition, ArrowgunItem::new),
			armstrong = createNewItem(Strings.armstrong, ArrowgunItem::new),
			hardBoiledHeat = createNewItem(Strings.hardBoiledHeat, ArrowgunItem::new),
			diabloEye = createNewItem(Strings.diabloEye, ArrowgunItem::new),
			doubleTap = createNewItem(Strings.doubleTap, ArrowgunItem::new),
			stardust = createNewItem(Strings.stardust, ArrowgunItem::new),
			energyMuzzle = createNewItem(Strings.energyMuzzle, ArrowgunItem::new),
			crimeAndPunishment = createNewItem(Strings.crimeAndPunishment, ArrowgunItem::new),
			cupidsArrow = createNewItem(Strings.cupidsArrow, ArrowgunItem::new),
			finalWeapon = createNewItem(Strings.finalWeapon, ArrowgunItem::new),
			sharpshooter = createNewItem(Strings.sharpshooter, ArrowgunItem::new),
			dryer = createNewItem(Strings.dryer, ArrowgunItem::new),
			trumpet = createNewItem(Strings.trumpet, ArrowgunItem::new),
			
			zephyr = createNewItem(Strings.zephyr, LanceItem::new),
			moonglade = createNewItem(Strings.moonglade, LanceItem::new),
			aer = createNewItem(Strings.aer, LanceItem::new),
			nescience = createNewItem(Strings.nescience, LanceItem::new),
			brume = createNewItem(Strings.brume, LanceItem::new),
			asura = createNewItem(Strings.asura, LanceItem::new),
			crux = createNewItem(Strings.crux, LanceItem::new),
			paladin = createNewItem(Strings.paladin, LanceItem::new),
			fellking = createNewItem(Strings.fellking, LanceItem::new),
			nightcloud = createNewItem(Strings.nightcloud, LanceItem::new),
			shimmer = createNewItem(Strings.shimmer, LanceItem::new),
			vortex = createNewItem(Strings.vortex, LanceItem::new),
			scission = createNewItem(Strings.scission, LanceItem::new),
			heavenfall = createNewItem(Strings.heavenfall, LanceItem::new),
			aether = createNewItem(Strings.aether, LanceItem::new),
			mazzaroth = createNewItem(Strings.mazzaroth, LanceItem::new),
			hegemon = createNewItem(Strings.hegemon, LanceItem::new),
			foxfire = createNewItem(Strings.foxfire, LanceItem::new),
			yaksha = createNewItem(Strings.yaksha, LanceItem::new),
			cynosura = createNewItem(Strings.cynosura, LanceItem::new),
			dragonreign = createNewItem(Strings.dragonreign, LanceItem::new),
			lindworm = createNewItem(Strings.lindworm, LanceItem::new),
			broom = createNewItem(Strings.broom, LanceItem::new),
			wyvern = createNewItem(Strings.wyvern, LanceItem::new),
			
			testerZero = createNewItem(Strings.testerZero, OrgShieldItem::new),
			productOne = createNewItem(Strings.productOne, OrgShieldItem::new),
			deepFreeze = createNewItem(Strings.deepFreeze, OrgShieldItem::new),
			cryoliteShield = createNewItem(Strings.cryoliteShield, OrgShieldItem::new),
			falseTheory = createNewItem(Strings.falseTheory, OrgShieldItem::new),
			glacier = createNewItem(Strings.glacier, OrgShieldItem::new),
			absoluteZero = createNewItem(Strings.absoluteZero, OrgShieldItem::new),
			gunz = createNewItem(Strings.gunz, OrgShieldItem::new),
			mindel = createNewItem(Strings.mindel, OrgShieldItem::new),
			snowslide = createNewItem(Strings.snowslide, OrgShieldItem::new),
			iceberg = createNewItem(Strings.iceberg, OrgShieldItem::new),
			inquisition = createNewItem(Strings.inquisition, OrgShieldItem::new),
			scrutiny = createNewItem(Strings.scrutiny, OrgShieldItem::new),
			empiricism = createNewItem(Strings.empiricism, OrgShieldItem::new),
			edification = createNewItem(Strings.edification, OrgShieldItem::new),
			contrivance = createNewItem(Strings.contrivance, OrgShieldItem::new),
			wurm = createNewItem(Strings.wurm, OrgShieldItem::new),
			subzero = createNewItem(Strings.subzero, OrgShieldItem::new),
			coldBlood = createNewItem(Strings.coldBlood, OrgShieldItem::new),
			diamondShield = createNewItem(Strings.diamondShield, OrgShieldItem::new),
			aegis = createNewItem(Strings.aegis, OrgShieldItem::new),
			frozenPride = createNewItem(Strings.frozenPride, OrgShieldItem::new),
			potLid = createNewItem(Strings.potLid, OrgShieldItem::new),
			snowman = createNewItem(Strings.snowman, OrgShieldItem::new),
			
			reticence = createNewItem(Strings.reticence, AxeSwordItem::new),
			goliath = createNewItem(Strings.goliath, AxeSwordItem::new),
			copperRed = createNewItem(Strings.copperRed, AxeSwordItem::new),
			daybreak = createNewItem(Strings.daybreak, AxeSwordItem::new),
			colossus = createNewItem(Strings.colossus, AxeSwordItem::new),
			ursaMajor = createNewItem(Strings.ursaMajor, AxeSwordItem::new),
			megacosm = createNewItem(Strings.megacosm, AxeSwordItem::new),
			terrene = createNewItem(Strings.terrene, AxeSwordItem::new),
			fuligin = createNewItem(Strings.fuligin, AxeSwordItem::new),
			hardWinter = createNewItem(Strings.hardWinter, AxeSwordItem::new),
			firefly = createNewItem(Strings.firefly, AxeSwordItem::new),
			harbinger = createNewItem(Strings.harbinger, AxeSwordItem::new),
			redwood = createNewItem(Strings.redwood, AxeSwordItem::new),
			sequoia = createNewItem(Strings.sequoia, AxeSwordItem::new),
			ironBlack = createNewItem(Strings.ironBlack, AxeSwordItem::new),
			earthshine = createNewItem(Strings.earthshine, AxeSwordItem::new),
			octiron = createNewItem(Strings.octiron, AxeSwordItem::new),
			hyperion = createNewItem(Strings.hyperion, AxeSwordItem::new),
			clarity = createNewItem(Strings.clarity, AxeSwordItem::new),
			oneThousandAndOneNights = createNewItem(Strings.oneThousandAndOneNights, AxeSwordItem::new),
			cardinalVirtue = createNewItem(Strings.cardinalVirtue, AxeSwordItem::new),
			skysplitter = createNewItem(Strings.skysplitter, AxeSwordItem::new),
			bleepBloopBop = createNewItem(Strings.bleepBloopBop, AxeSwordItem::new),
			monolith = createNewItem(Strings.monolith, AxeSwordItem::new),
			
			blackPrimer = createNewItem(Strings.blackPrimer, LexiconItem::new),
			whiteTome = createNewItem(Strings.whiteTome, LexiconItem::new),
			illicitResearch = createNewItem(Strings.illicitResearch, LexiconItem::new),
			buriedSecrets = createNewItem(Strings.buriedSecrets, LexiconItem::new),
			arcaneCompendium = createNewItem(Strings.arcaneCompendium, LexiconItem::new),
			dissentersNotes = createNewItem(Strings.dissentersNotes, LexiconItem::new),
			nefariousCodex = createNewItem(Strings.nefariousCodex, LexiconItem::new),
			mysticAlbum = createNewItem(Strings.mysticAlbum, LexiconItem::new),
			cursedManual = createNewItem(Strings.cursedManual, LexiconItem::new),
			tabooText = createNewItem(Strings.tabooText, LexiconItem::new),
			eldritchEsoterica = createNewItem(Strings.eldritchEsoterica, LexiconItem::new),
			freakishBestiary = createNewItem(Strings.freakishBestiary, LexiconItem::new),
			madmansVita = createNewItem(Strings.madmansVita, LexiconItem::new),
			untitledWritings = createNewItem(Strings.untitledWritings, LexiconItem::new),
			abandonedDogma = createNewItem(Strings.abandonedDogma, LexiconItem::new),
			atlasOfOmens = createNewItem(Strings.atlasOfOmens, LexiconItem::new),
			revoltingScrapbook = createNewItem(Strings.revoltingScrapbook, LexiconItem::new),
			lostHeterodoxy = createNewItem(Strings.lostHeterodoxy, LexiconItem::new),
			otherworldlyTales = createNewItem(Strings.otherworldlyTales, LexiconItem::new),
			indescribableLore = createNewItem(Strings.indescribableLore, LexiconItem::new),
			radicalTreatise = createNewItem(Strings.radicalTreatise, LexiconItem::new),
			bookOfRetribution = createNewItem(Strings.bookOfRetribution, LexiconItem::new),
			midnightSnack = createNewItem(Strings.midnightSnack, LexiconItem::new),
			dearDiary = createNewItem(Strings.dearDiary, LexiconItem::new),
			
			newMoon = createNewItem(Strings.newMoon, ClaymoreItem::new),
			werewolf = createNewItem(Strings.werewolf, ClaymoreItem::new),
			artemis = createNewItem(Strings.artemis, ClaymoreItem::new),
			luminary = createNewItem(Strings.luminary, ClaymoreItem::new),
			selene = createNewItem(Strings.selene, ClaymoreItem::new),
			moonrise = createNewItem(Strings.moonrise, ClaymoreItem::new),
			astrologia = createNewItem(Strings.astrologia, ClaymoreItem::new),
			crater = createNewItem(Strings.crater, ClaymoreItem::new),
			lunarPhase = createNewItem(Strings.lunarPhase, ClaymoreItem::new),
			crescent = createNewItem(Strings.crescent, ClaymoreItem::new),
			gibbous = createNewItem(Strings.gibbous, ClaymoreItem::new),
			berserker = createNewItem(Strings.berserker, ClaymoreItem::new),
			twilight = createNewItem(Strings.twilight, ClaymoreItem::new),
			queenOfTheNight = createNewItem(Strings.queenOfTheNight, ClaymoreItem::new),
			balsamicMoon = createNewItem(Strings.balsamicMoon, ClaymoreItem::new),
			orbit = createNewItem(Strings.orbit, ClaymoreItem::new),
			lightYear = createNewItem(Strings.lightYear, ClaymoreItem::new),
			kingOfTheNight = createNewItem(Strings.kingOfTheNight, ClaymoreItem::new),
			moonset = createNewItem(Strings.moonset, ClaymoreItem::new),
			horoscope = createNewItem(Strings.horoscope, ClaymoreItem::new),
			dichotomy = createNewItem(Strings.dichotomy, ClaymoreItem::new),
			lunatic = createNewItem(Strings.lunatic, ClaymoreItem::new),
			justDesserts = createNewItem(Strings.justDesserts, ClaymoreItem::new),
			bunnymoon = createNewItem(Strings.bunnymoon, ClaymoreItem::new),
			
			ashes = createNewItem(Strings.ashes, ChakramItem::new),
			doldrums = createNewItem(Strings.doldrums, ChakramItem::new),
			delayedAction = createNewItem(Strings.delayedAction, ChakramItem::new),
			diveBombers = createNewItem(Strings.diveBombers, ChakramItem::new),
			combustion = createNewItem(Strings.combustion, ChakramItem::new),
			moulinRouge = createNewItem(Strings.moulinRouge, ChakramItem::new),
			blazeOfGlory = createNewItem(Strings.blazeOfGlory, ChakramItem::new),
			prometheus = createNewItem(Strings.prometheus, ChakramItem::new),
			ifrit = createNewItem(Strings.ifrit, ChakramItem::new),
			magmaOcean = createNewItem(Strings.magmaOcean, ChakramItem::new),
			volcanics = createNewItem(Strings.volcanics, ChakramItem::new),
			inferno = createNewItem(Strings.inferno, ChakramItem::new),
			sizzlingEdge = createNewItem(Strings.sizzlingEdge, ChakramItem::new),
			corona = createNewItem(Strings.corona, ChakramItem::new),
			ferrisWheel = createNewItem(Strings.ferrisWheel, ChakramItem::new),
			burnout = createNewItem(Strings.burnout, ChakramItem::new),
			omegaTrinity = createNewItem(Strings.omegaTrinity, ChakramItem::new),
			outbreak = createNewItem(Strings.outbreak, ChakramItem::new),
			doubleEdge = createNewItem(Strings.doubleEdge, ChakramItem::new),
			wildfire = createNewItem(Strings.wildfire, ChakramItem::new),
			prominence = createNewItem(Strings.prominence, ChakramItem::new),
			eternalFlames = createNewItem(Strings.eternalFlames, ChakramItem::new),
			pizzaCut = createNewItem(Strings.pizzaCut, ChakramItem::new),
			conformers = createNewItem(Strings.conformers, ChakramItem::new),
			
			basicModel = createNewItem(Strings.basicModel, SitarItem::new),
			tuneUp = createNewItem(Strings.tuneUp, SitarItem::new),
			quartet = createNewItem(Strings.quartet, SitarItem::new),
			quintet = createNewItem(Strings.quintet, SitarItem::new),
			overture = createNewItem(Strings.overture, SitarItem::new),
			oldHand = createNewItem(Strings.oldHand, SitarItem::new),
			daCapo = createNewItem(Strings.daCapo, SitarItem::new),
			powerChord = createNewItem(Strings.powerChord, SitarItem::new),
			fermata = createNewItem(Strings.fermata, SitarItem::new),
			interlude = createNewItem(Strings.interlude, SitarItem::new),
			serenade = createNewItem(Strings.serenade, SitarItem::new),
			songbird = createNewItem(Strings.songbird, SitarItem::new),
			riseToFame = createNewItem(Strings.riseToFame, SitarItem::new),
			rockStar = createNewItem(Strings.rockStar, SitarItem::new),
			eightFinger = createNewItem(Strings.eightFinger, SitarItem::new),
			concerto = createNewItem(Strings.concerto, SitarItem::new),
			harmonics = createNewItem(Strings.harmonics, SitarItem::new),
			millionBucks = createNewItem(Strings.millionBucks, SitarItem::new),
			fortissimo = createNewItem(Strings.fortissimo, SitarItem::new),
			upToEleven = createNewItem(Strings.upToEleven, SitarItem::new),
			sanctuary = createNewItem(Strings.sanctuary, SitarItem::new),
			arpeggio = createNewItem(Strings.arpeggio, SitarItem::new),
			princeOfAwesome = createNewItem(Strings.princeOfAwesome, SitarItem::new),
			afterSchool = createNewItem(Strings.afterSchool, SitarItem::new),
			
			theFool = createNewItem(Strings.theFool, CardItem::new),
			theMagician = createNewItem(Strings.theMagician, CardItem::new),
			theStar = createNewItem(Strings.theStar, CardItem::new),
			theMoon = createNewItem(Strings.theMoon, CardItem::new),
			justice = createNewItem(Strings.justice, CardItem::new),
			theHierophant = createNewItem(Strings.theHierophant, CardItem::new),
			theWorld = createNewItem(Strings.theWorld, CardItem::new),
			temperance = createNewItem(Strings.temperance, CardItem::new),
			theHighPriestess = createNewItem(Strings.theHighPriestess, CardItem::new),
			theTower = createNewItem(Strings.theTower, CardItem::new),
			theHangedMan = createNewItem(Strings.theHangedMan, CardItem::new),
			death = createNewItem(Strings.death, CardItem::new),
			theHermit = createNewItem(Strings.theHermit, CardItem::new),
			strength = createNewItem(Strings.strength, CardItem::new),
			theLovers = createNewItem(Strings.theLovers, CardItem::new),
			theChariot = createNewItem(Strings.theChariot, CardItem::new),
			theSun = createNewItem(Strings.theSun, CardItem::new),
			theDevil = createNewItem(Strings.theDevil, CardItem::new),
			theEmpress = createNewItem(Strings.theEmpress, CardItem::new),
			theEmperor = createNewItem(Strings.theEmperor, CardItem::new),
			theJoker = createNewItem(Strings.theJoker, CardItem::new),
			fairGame = createNewItem(Strings.fairGame, CardItem::new),
			finestFantasy13 = createNewItem(Strings.finestFantasy13, CardItem::new),
			highRollersSecret = createNewItem(Strings.highRollersSecret, CardItem::new),
			
			fickleErica = createNewItem(Strings.fickleErica, ScytheItem::new),
			jiltedAnemone = createNewItem(Strings.jiltedAnemone, ScytheItem::new),
			proudAmaryllis = createNewItem(Strings.proudAmaryllis, ScytheItem::new),
			madSafflower = createNewItem(Strings.madSafflower, ScytheItem::new),
			poorMelissa = createNewItem(Strings.poorMelissa, ScytheItem::new),
			tragicAllium = createNewItem(Strings.tragicAllium, ScytheItem::new),
			mournfulCineria = createNewItem(Strings.mournfulCineria, ScytheItem::new),
			pseudoSilene = createNewItem(Strings.pseudoSilene, ScytheItem::new),
			faithlessDigitalis = createNewItem(Strings.faithlessDigitalis, ScytheItem::new),
			grimMuscari = createNewItem(Strings.grimMuscari, ScytheItem::new),
			docileVallota = createNewItem(Strings.docileVallota, ScytheItem::new),
			quietBelladonna = createNewItem(Strings.quietBelladonna, ScytheItem::new),
			partingIpheion = createNewItem(Strings.partingIpheion, ScytheItem::new),
			loftyGerbera = createNewItem(Strings.loftyGerbera, ScytheItem::new),
			gallantAchillea = createNewItem(Strings.gallantAchillea, ScytheItem::new),
			noblePeony = createNewItem(Strings.noblePeony, ScytheItem::new),
			fearsomeAnise = createNewItem(Strings.fearsomeAnise, ScytheItem::new),
			vindictiveThistle = createNewItem(Strings.vindictiveThistle, ScytheItem::new),
			fairHelianthus = createNewItem(Strings.fairHelianthus, ScytheItem::new),
			solemnMagnolia = createNewItem(Strings.solemnMagnolia, ScytheItem::new),
			hallowedLotus = createNewItem(Strings.hallowedLotus, ScytheItem::new),
			gracefulDahlia = createNewItem(Strings.gracefulDahlia, ScytheItem::new),
			stirringLadle = createNewItem(Strings.stirringLadle, ScytheItem::new),
			daintyBellflowers = createNewItem(Strings.daintyBellflowers, ScytheItem::new),
			
			trancheuse = createNewItem(Strings.trancheuse, KnifeItem::new),
			orage = createNewItem(Strings.orage, KnifeItem::new),
			tourbillon = createNewItem(Strings.tourbillon, KnifeItem::new),
			tempete = createNewItem(Strings.tempete, KnifeItem::new),
			carmin = createNewItem(Strings.carmin, KnifeItem::new),
			meteore = createNewItem(Strings.meteore, KnifeItem::new),
			etoile = createNewItem(Strings.etoile, KnifeItem::new),
			irregulier = createNewItem(Strings.irregulier, KnifeItem::new),
			dissonance = createNewItem(Strings.dissonance, KnifeItem::new),
			eruption = createNewItem(Strings.eruption, KnifeItem::new),
			soleilCouchant = createNewItem(Strings.soleilCouchant, KnifeItem::new),
			indigo = createNewItem(Strings.indigo, KnifeItem::new),
			vague = createNewItem(Strings.vague, KnifeItem::new),
			deluge = createNewItem(Strings.deluge, KnifeItem::new),
			rafale = createNewItem(Strings.rafale, KnifeItem::new),
			typhon = createNewItem(Strings.typhon, KnifeItem::new),
			extirpeur = createNewItem(Strings.extirpeur, KnifeItem::new),
			croixDuSud = createNewItem(Strings.croixDuSud, KnifeItem::new),
			lumineuse = createNewItem(Strings.lumineuse, KnifeItem::new),
			clairDeLune = createNewItem(Strings.clairDeLune, KnifeItem::new),
			volDeNuit = createNewItem(Strings.volDeNuit, KnifeItem::new),
			foudre = createNewItem(Strings.foudre, KnifeItem::new),
			demoiselle = createNewItem(Strings.demoiselle, KnifeItem::new),
			ampoule = createNewItem(Strings.ampoule, KnifeItem::new),


			organizationRobe_Helmet = createArmorItem(Strings.organization+"_"+Strings.helmet, ModArmorMaterials.ORGANIZATION, ArmorItem.Type.HELMET, Strings.organization),
			organizationRobe_Chestplate = createArmorItem(Strings.organization+"_"+Strings.chestplate, ModArmorMaterials.ORGANIZATION, ArmorItem.Type.CHESTPLATE, Strings.organization),
			organizationRobe_Leggings = createArmorItem(Strings.organization+"_"+Strings.leggings, ModArmorMaterials.ORGANIZATION, ArmorItem.Type.LEGGINGS, Strings.organization),
			organizationRobe_Boots = createArmorItem(Strings.organization+"_"+Strings.boots, ModArmorMaterials.ORGANIZATION, ArmorItem.Type.BOOTS, Strings.organization),

			xemnas_Helmet = createArmorItem(Strings.xemnas+"_"+Strings.helmet, ModArmorMaterials.ORGANIZATION, ArmorItem.Type.HELMET, Strings.xemnas),
			xemnas_Chestplate = createArmorItem(Strings.xemnas+"_"+Strings.chestplate, ModArmorMaterials.ORGANIZATION, ArmorItem.Type.CHESTPLATE, Strings.xemnas),
			xemnas_Leggings = createArmorItem(Strings.xemnas+"_"+Strings.leggings, ModArmorMaterials.ORGANIZATION, ArmorItem.Type.LEGGINGS, Strings.xemnas),
			xemnas_Boots = createArmorItem(Strings.xemnas+"_"+Strings.boots, ModArmorMaterials.ORGANIZATION, ArmorItem.Type.BOOTS, Strings.xemnas),
					
			antiCoat_Helmet = createArmorItem(Strings.antiCoat+"_"+Strings.helmet, ModArmorMaterials.ORGANIZATION, ArmorItem.Type.HELMET, Strings.antiCoat),
			antiCoat_Chestplate = createArmorItem(Strings.antiCoat+"_"+Strings.chestplate, ModArmorMaterials.ORGANIZATION, ArmorItem.Type.CHESTPLATE, Strings.antiCoat),
			antiCoat_Leggings = createArmorItem(Strings.antiCoat+"_"+Strings.leggings, ModArmorMaterials.ORGANIZATION, ArmorItem.Type.LEGGINGS, Strings.antiCoat),
			antiCoat_Boots = createArmorItem(Strings.antiCoat+"_"+Strings.boots, ModArmorMaterials.ORGANIZATION, ArmorItem.Type.BOOTS, Strings.antiCoat),
					
			terra_Helmet = createKeybladeArmorItem(Strings.terra+"_"+Strings.helmet, ModArmorMaterials.KEYBLADE, ArmorItem.Type.HELMET, Strings.terra),
			terra_Chestplate = createKeybladeArmorItem(Strings.terra+"_"+Strings.chestplate, ModArmorMaterials.KEYBLADE, ArmorItem.Type.CHESTPLATE, Strings.terra),
			terra_Leggings = createKeybladeArmorItem(Strings.terra+"_"+Strings.leggings, ModArmorMaterials.KEYBLADE, ArmorItem.Type.LEGGINGS, Strings.terra),
			terra_Boots = createKeybladeArmorItem(Strings.terra+"_"+Strings.boots, ModArmorMaterials.KEYBLADE,ArmorItem.Type.BOOTS, Strings.terra),
			terra_Shoulder = createNewItem(Strings.terra+"_shoulder", () -> new PauldronItem(new Item.Properties().stacksTo(1), Strings.terra, new Item[]{terra_Boots.get(),terra_Leggings.get(),terra_Chestplate.get(),terra_Helmet.get()})),

			aqua_Helmet = createKeybladeArmorItem(Strings.aqua+"_"+Strings.helmet, ModArmorMaterials.KEYBLADE, ArmorItem.Type.HELMET, Strings.aqua),
			aqua_Chestplate = createKeybladeArmorItem(Strings.aqua+"_"+Strings.chestplate, ModArmorMaterials.KEYBLADE, ArmorItem.Type.CHESTPLATE, Strings.aqua),
			aqua_Leggings = createKeybladeArmorItem(Strings.aqua+"_"+Strings.leggings, ModArmorMaterials.KEYBLADE, ArmorItem.Type.LEGGINGS, Strings.aqua),
			aqua_Boots = createKeybladeArmorItem(Strings.aqua+"_"+Strings.boots, ModArmorMaterials.KEYBLADE, ArmorItem.Type.BOOTS, Strings.aqua),
			aqua_Shoulder = createNewItem(Strings.aqua+"_shoulder", () -> new PauldronItem(new Item.Properties().stacksTo(1), Strings.aqua, new Item[]{aqua_Boots.get(),aqua_Leggings.get(),aqua_Chestplate.get(),aqua_Helmet.get()})),

			ventus_Helmet = createKeybladeArmorItem(Strings.ventus+"_"+Strings.helmet, ModArmorMaterials.KEYBLADE, ArmorItem.Type.HELMET, Strings.ventus),
			ventus_Chestplate = createKeybladeArmorItem(Strings.ventus+"_"+Strings.chestplate, ModArmorMaterials.KEYBLADE, ArmorItem.Type.CHESTPLATE, Strings.ventus),
			ventus_Leggings = createKeybladeArmorItem(Strings.ventus+"_"+Strings.leggings, ModArmorMaterials.KEYBLADE, ArmorItem.Type.LEGGINGS, Strings.ventus),
			ventus_Boots = createKeybladeArmorItem(Strings.ventus+"_"+Strings.boots, ModArmorMaterials.KEYBLADE, ArmorItem.Type.BOOTS, Strings.ventus),
			ventus_Shoulder = createNewItem(Strings.ventus+"_shoulder", () -> new PauldronItem(new Item.Properties().stacksTo(1), Strings.ventus, new Item[]{ventus_Boots.get(),ventus_Leggings.get(),ventus_Chestplate.get(),ventus_Helmet.get()})),
			
			nightmareVentus_Helmet = createKeybladeArmorItem(Strings.nightmareVentus+"_"+Strings.helmet, ModArmorMaterials.KEYBLADE, ArmorItem.Type.HELMET, Strings.nightmareVentus),
			nightmareVentus_Chestplate = createKeybladeArmorItem(Strings.nightmareVentus+"_"+Strings.chestplate, ModArmorMaterials.KEYBLADE, ArmorItem.Type.CHESTPLATE, Strings.nightmareVentus),
			nightmareVentus_Leggings = createKeybladeArmorItem(Strings.nightmareVentus+"_"+Strings.leggings, ModArmorMaterials.KEYBLADE, ArmorItem.Type.LEGGINGS, Strings.nightmareVentus),
			nightmareVentus_Boots = createKeybladeArmorItem(Strings.nightmareVentus+"_"+Strings.boots, ModArmorMaterials.KEYBLADE, ArmorItem.Type.BOOTS, Strings.nightmareVentus),
			nightmareVentus_Shoulder = createNewItem(Strings.nightmareVentus+"_shoulder", () -> new PauldronItem(new Item.Properties().stacksTo(1), Strings.nightmareVentus, new Item[]{nightmareVentus_Boots.get(),nightmareVentus_Leggings.get(),nightmareVentus_Chestplate.get(),nightmareVentus_Helmet.get()})),

			eraqus_Helmet = createKeybladeArmorItem(Strings.eraqus+"_"+Strings.helmet, ModArmorMaterials.KEYBLADE, ArmorItem.Type.HELMET, Strings.eraqus),
			eraqus_Chestplate = createKeybladeArmorItem(Strings.eraqus+"_"+Strings.chestplate, ModArmorMaterials.KEYBLADE, ArmorItem.Type.CHESTPLATE, Strings.eraqus),
			eraqus_Leggings = createKeybladeArmorItem(Strings.eraqus+"_"+Strings.leggings, ModArmorMaterials.KEYBLADE, ArmorItem.Type.LEGGINGS, Strings.eraqus),
			eraqus_Boots = createKeybladeArmorItem(Strings.eraqus+"_"+Strings.boots, ModArmorMaterials.KEYBLADE, ArmorItem.Type.BOOTS, Strings.eraqus),
			eraqus_Shoulder = createNewItem(Strings.eraqus+"_shoulder", () -> new PauldronItem(new Item.Properties().stacksTo(1), Strings.eraqus, new Item[]{eraqus_Boots.get(),eraqus_Leggings.get(),eraqus_Chestplate.get(),eraqus_Helmet.get()})),
			
			xehanort_Helmet = createKeybladeArmorItem(Strings.xehanort+"_"+Strings.helmet, ModArmorMaterials.KEYBLADE, ArmorItem.Type.HELMET, Strings.xehanort),
			xehanort_Chestplate = createKeybladeArmorItem(Strings.xehanort+"_"+Strings.chestplate, ModArmorMaterials.KEYBLADE, ArmorItem.Type.CHESTPLATE, Strings.xehanort),
			xehanort_Leggings = createKeybladeArmorItem(Strings.xehanort+"_"+Strings.leggings, ModArmorMaterials.KEYBLADE, ArmorItem.Type.LEGGINGS, Strings.xehanort),
			xehanort_Boots = createKeybladeArmorItem(Strings.xehanort+"_"+Strings.boots, ModArmorMaterials.KEYBLADE, ArmorItem.Type.BOOTS, Strings.xehanort),
			xehanort_Shoulder = createNewItem(Strings.xehanort+"_shoulder", () -> new PauldronItem(new Item.Properties().stacksTo(1), Strings.xehanort, new Item[]{xehanort_Boots.get(),xehanort_Leggings.get(),xehanort_Chestplate.get(),xehanort_Helmet.get()})),

			ux_Helmet = createKeybladeArmorItem(Strings.ux+"_"+Strings.helmet, ModArmorMaterials.KEYBLADE, ArmorItem.Type.HELMET, Strings.ux),
			ux_Chestplate = createKeybladeArmorItem(Strings.ux+"_"+Strings.chestplate, ModArmorMaterials.KEYBLADE, ArmorItem.Type.CHESTPLATE, Strings.ux),
			ux_Leggings = createKeybladeArmorItem(Strings.ux+"_"+Strings.leggings, ModArmorMaterials.KEYBLADE, ArmorItem.Type.LEGGINGS, Strings.ux),
			ux_Boots = createKeybladeArmorItem(Strings.ux+"_"+Strings.boots, ModArmorMaterials.KEYBLADE, ArmorItem.Type.BOOTS, Strings.ux),
			ux_Shoulder = createNewItem(Strings.ux+"_shoulder", () -> new PauldronItem(new Item.Properties().stacksTo(1), Strings.ux, new Item[]{ux_Boots.get(),ux_Leggings.get(),ux_Chestplate.get(),ux_Helmet.get()})),
					
			vanitas_Helmet = createArmorItem(Strings.vanitas+"_"+Strings.helmet, ModArmorMaterials.VANITY, ArmorItem.Type.HELMET, Strings.vanitas),
			vanitas_Chestplate = createArmorItem(Strings.vanitas+"_"+Strings.chestplate, ModArmorMaterials.VANITY, ArmorItem.Type.CHESTPLATE, Strings.vanitas),
			vanitas_Leggings = createArmorItem(Strings.vanitas+"_"+Strings.leggings, ModArmorMaterials.VANITY, ArmorItem.Type.LEGGINGS, Strings.vanitas),
			vanitas_Boots = createArmorItem(Strings.vanitas+"_"+Strings.boots, ModArmorMaterials.VANITY, ArmorItem.Type.BOOTS, Strings.vanitas),

			vanitas_Remnant_Helmet = createArmorItem(Strings.vanitasRemnant+"_"+Strings.helmet, ModArmorMaterials.VANITY, ArmorItem.Type.HELMET, Strings.vanitasRemnant),
			vanitas_Remnant_Chestplate = createArmorItem(Strings.vanitasRemnant+"_"+Strings.chestplate, ModArmorMaterials.VANITY, ArmorItem.Type.CHESTPLATE, Strings.vanitasRemnant),
			vanitas_Remnant_Leggings = createArmorItem(Strings.vanitasRemnant+"_"+Strings.leggings, ModArmorMaterials.VANITY, ArmorItem.Type.LEGGINGS, Strings.vanitasRemnant),
			vanitas_Remnant_Boots = createArmorItem(Strings.vanitasRemnant+"_"+Strings.boots, ModArmorMaterials.VANITY, ArmorItem.Type.BOOTS, Strings.vanitasRemnant),
			
			dark_Riku_Chestplate = createArmorItem(Strings.darkRiku+"_"+Strings.chestplate, ModArmorMaterials.VANITY, ArmorItem.Type.CHESTPLATE, Strings.darkRiku),
			dark_Riku_Leggings = createArmorItem(Strings.darkRiku+"_"+Strings.leggings, ModArmorMaterials.VANITY, ArmorItem.Type.LEGGINGS, Strings.darkRiku),
			dark_Riku_Boots = createArmorItem(Strings.darkRiku+"_"+Strings.boots, ModArmorMaterials.VANITY, ArmorItem.Type.BOOTS, Strings.darkRiku),
			
			aced_Helmet = createArmorItem(Strings.aced+"_"+Strings.helmet, ModArmorMaterials.VANITY, ArmorItem.Type.HELMET, Strings.aced),
			aced_Chestplate = createArmorItem(Strings.aced+"_"+Strings.chestplate, ModArmorMaterials.VANITY, ArmorItem.Type.CHESTPLATE, Strings.aced),
			aced_Leggings = createArmorItem(Strings.aced+"_"+Strings.leggings, ModArmorMaterials.VANITY, ArmorItem.Type.LEGGINGS, Strings.aced),
			aced_Boots = createArmorItem(Strings.aced+"_"+Strings.boots, ModArmorMaterials.VANITY, ArmorItem.Type.BOOTS, Strings.aced),
					
			ava_Helmet = createArmorItem(Strings.ava+"_"+Strings.helmet, ModArmorMaterials.VANITY, ArmorItem.Type.HELMET, Strings.ava),
			ava_Chestplate = createArmorItem(Strings.ava+"_"+Strings.chestplate, ModArmorMaterials.VANITY, ArmorItem.Type.CHESTPLATE, Strings.ava),
			ava_Leggings = createArmorItem(Strings.ava+"_"+Strings.leggings, ModArmorMaterials.VANITY, ArmorItem.Type.LEGGINGS, Strings.ava),
			ava_Boots = createArmorItem(Strings.ava+"_"+Strings.boots, ModArmorMaterials.VANITY, ArmorItem.Type.BOOTS, Strings.ava),
					
			gula_Helmet = createArmorItem(Strings.gula+"_"+Strings.helmet, ModArmorMaterials.VANITY, ArmorItem.Type.HELMET, Strings.gula),
			gula_Chestplate = createArmorItem(Strings.gula+"_"+Strings.chestplate, ModArmorMaterials.VANITY, ArmorItem.Type.CHESTPLATE, Strings.gula),
			gula_Leggings = createArmorItem(Strings.gula+"_"+Strings.leggings, ModArmorMaterials.VANITY, ArmorItem.Type.LEGGINGS, Strings.gula),
			gula_Boots = createArmorItem(Strings.gula+"_"+Strings.boots, ModArmorMaterials.VANITY, ArmorItem.Type.BOOTS, Strings.gula),
					
			invi_Helmet = createArmorItem(Strings.invi+"_"+Strings.helmet, ModArmorMaterials.VANITY, ArmorItem.Type.HELMET, Strings.invi),
			invi_Chestplate = createArmorItem(Strings.invi+"_"+Strings.chestplate, ModArmorMaterials.VANITY, ArmorItem.Type.CHESTPLATE, Strings.invi),
			invi_Leggings = createArmorItem(Strings.invi+"_"+Strings.leggings, ModArmorMaterials.VANITY, ArmorItem.Type.LEGGINGS, Strings.invi),
			invi_Boots = createArmorItem(Strings.invi+"_"+Strings.boots, ModArmorMaterials.VANITY, ArmorItem.Type.BOOTS, Strings.invi),
			
			ira_Helmet = createArmorItem(Strings.ira+"_"+Strings.helmet, ModArmorMaterials.VANITY, ArmorItem.Type.HELMET, Strings.ira),
			ira_Chestplate = createArmorItem(Strings.ira+"_"+Strings.chestplate, ModArmorMaterials.VANITY, ArmorItem.Type.CHESTPLATE, Strings.ira),
			ira_Leggings = createArmorItem(Strings.ira+"_"+Strings.leggings, ModArmorMaterials.VANITY, ArmorItem.Type.LEGGINGS, Strings.ira),
			ira_Boots = createArmorItem(Strings.ira+"_"+Strings.boots, ModArmorMaterials.VANITY, ArmorItem.Type.BOOTS, Strings.ira),

			iceCream = createNewItem(Strings.iceCream, () -> new KKIceCreamItem(new Item.Properties().food(new FoodProperties.Builder().fast().saturationModifier(2.0f).nutrition(2).alwaysEdible().build()))),
			winnerStick = createNewItem(Strings.winnerStick, () -> new Item(new Item.Properties())),

			disc_Birth_by_Sleep_A_Link_to_the_Future = createNewItem(Strings.Disc_Birth_by_Sleep_A_Link_to_the_Future, () -> new KKRecordItem(ModJukeboxSongs.BIRTH_BY_SLEEP_A_LINK_TO_THE_FUTURE)),
			disc_Dream_Drop_Distance_The_Next_Awakening = createNewItem(Strings.Disc_Dream_Drop_Distance_The_Next_Awakening, () -> new KKRecordItem(ModJukeboxSongs.DREAM_DROP_DISTANCE_THE_NEXT_AWAKENING)),
			disc_Hikari_KINGDOM_Instrumental_Version = createNewItem(Strings.Disc_Hikari_KINGDOM_Instrumental_Version, () -> new KKRecordItem(ModJukeboxSongs.HIKARI_KINGDOM_INSTRUMENTAL_VERSION)),
			disc_L_Oscurita_Dell_Ignoto = createNewItem(Strings.Disc_L_Oscurita_Dell_Ignoto, () -> new KKRecordItem(ModJukeboxSongs.L_OSCURITA_DELL_IGNOTO)),
			disc_Musique_pour_la_tristesse_de_Xion = createNewItem(Strings.Disc_Musique_pour_la_tristesse_de_Xion, () -> new KKRecordItem(ModJukeboxSongs.MUSIQUE_POUR_LA_TRISTESSE_DE_XION)),
			disc_No_More_Bugs_Bug_Version = createNewItem(Strings.Disc_No_More_Bugs_Bug_Version, () -> new KKRecordItem(ModJukeboxSongs.NO_MORE_BUGS_BUG_VERSION)),
			disc_Organization_XIII = createNewItem(Strings.Disc_Organization_XIII, () -> new KKRecordItem(ModJukeboxSongs.ORGANIZATION_XIII)),
			
			disc_Dearly_Beloved_UX = createNewItem(Strings.Disc_Dearly_Beloved_UX, () -> new KKRecordItem(ModJukeboxSongs.DEARLY_BELOVED_UX)),
			disc_Passion_Instrumental = createNewItem(Strings.Disc_Passion_Instrumental, () -> new KKRecordItem(ModJukeboxSongs.PASSION_INSTRUMENTAL)),
			disc_Rage_Awakened = createNewItem(Strings.Disc_Rage_Awakened, () -> new KKRecordItem(ModJukeboxSongs.RAGE_AWAKENED)),
			disc_The_Other_Promise = createNewItem(Strings.Disc_The_Other_Promise, () -> new KKRecordItem(ModJukeboxSongs.THE_OTHER_PROMISE)),
			disc_13th_Struggle_Luxord = createNewItem(Strings.Disc_13th_Struggle_Luxord, () -> new KKRecordItem(ModJukeboxSongs.THE_13TH_STRUGGLE_LUXORD)),
			disc_13th_Dilemma_Saix = createNewItem(Strings.Disc_13th_Dilemma_Saix, () -> new KKRecordItem(ModJukeboxSongs.THE_13TH_DILEMMA_SAIX)),
			disc_13th_Reflection = createNewItem(Strings.Disc_13th_Reflection, () -> new KKRecordItem(ModJukeboxSongs.THE_13TH_REFLECTION)),
			disc_Another_Side_Battle_Ver = createNewItem(Strings.Disc_Another_Side_Battle_Ver, () -> new KKRecordItem(ModJukeboxSongs.ANOTHER_SIDE_BATTLE_VER)),
			disc_Cavern_Of_Remembrance_Days = createNewItem(Strings.Disc_Cavern_Of_Remembrance_Days, () -> new KKRecordItem(ModJukeboxSongs.CAVERN_OF_REMEMBRANCE_DAYS)),
			disc_Forgotten_Challenge_Recoded = createNewItem(Strings.Disc_Forgotten_Challenge_Recoded, () -> new KKRecordItem(ModJukeboxSongs.FORGOTTEN_CHALLENGE_RECODED)),
			disc_Anger_Unchained = createNewItem(Strings.Disc_Anger_Unchained, () -> new KKRecordItem(ModJukeboxSongs.ANGER_UNCHAINED)),
			disc_Hunter_Of_The_Dark = createNewItem(Strings.Disc_Hunter_Of_The_Dark, () -> new KKRecordItem(ModJukeboxSongs.HUNTER_OF_THE_DARK)),
			disc_Destati = createNewItem(Strings.Disc_Destati, () -> new KKRecordItem(ModJukeboxSongs.DESTATI)),

			blazing_crystal = createNewItem(Strings.SM_BlazingCrystal, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_S)),
			blazing_gem = createNewItem(Strings.SM_BlazingGem, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_A)),
			blazing_stone = createNewItem(Strings.SM_BlazingStone, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_B)),
			blazing_shard = createNewItem(Strings.SM_BlazingShard, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_C)),
			soothing_crystal = createNewItem(Strings.SM_SoothingCrystal, () -> new SynthesisItem(new Item.Properties(),  Strings.SM_Rank_S)),
			soothing_gem = createNewItem(Strings.SM_SoothingGem, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_A)),
			soothing_stone = createNewItem(Strings.SM_SoothingStone, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_B)),
			soothing_shard = createNewItem(Strings.SM_SoothingShard, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_C)),
			writhing_crystal = createNewItem(Strings.SM_WrithingCrystal, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_S)),
			writhing_gem = createNewItem(Strings.SM_WrithingGem, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_A)),
			writhing_stone = createNewItem(Strings.SM_WrithingStone, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_B)),
			writhing_shard = createNewItem(Strings.SM_WrithingShard, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_C)),
			betwixt_crystal = createNewItem(Strings.SM_BetwixtCrystal, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_S)),
			betwixt_gem = createNewItem(Strings.SM_BetwixtGem, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_A)),
			betwixt_stone = createNewItem(Strings.SM_BetwixtStone, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_B)),
			betwixt_shard = createNewItem(Strings.SM_BetwixtShard, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_C)),
			wellspring_crystal = createNewItem(Strings.SM_WellspringCrystal, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_S)),
			wellspring_gem = createNewItem(Strings.SM_WellspringGem, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_A)),
			wellspring_stone = createNewItem(Strings.SM_WellspringStone, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_B)),
			wellspring_shard = createNewItem(Strings.SM_WellspringShard, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_C)),
			frost_crystal = createNewItem(Strings.SM_FrostCrystal, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_S)),
			frost_gem = createNewItem(Strings.SM_FrostGem, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_A)),
			frost_stone = createNewItem(Strings.SM_FrostStone, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_B)),
			frost_shard = createNewItem(Strings.SM_FrostShard, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_C)),
			lightning_crystal = createNewItem(Strings.SM_LightningCrystal, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_S)),
			lightning_gem = createNewItem(Strings.SM_LightningGem, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_A)),
			lightning_stone = createNewItem(Strings.SM_LightningStone, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_B)),
			lightning_shard = createNewItem(Strings.SM_LightningShard, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_C)),
			lucid_crystal = createNewItem(Strings.SM_LucidCrystal, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_S)),
			lucid_gem = createNewItem(Strings.SM_LucidGem, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_A)),
			lucid_stone = createNewItem(Strings.SM_LucidStone, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_B)),
			lucid_shard = createNewItem(Strings.SM_LucidShard, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_C)),
			hungry_crystal = createNewItem(Strings.SM_HungryCrystal, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_S)),
			hungry_gem = createNewItem(Strings.SM_HungryGem, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_A)),
			hungry_stone = createNewItem(Strings.SM_HungryStone,() -> new SynthesisItem(new Item.Properties(),  Strings.SM_Rank_B)),
			hungry_shard = createNewItem(Strings.SM_HungryShard, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_C)),
			twilight_crystal = createNewItem(Strings.SM_TwilightCrystal, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_S)),
			twilight_gem = createNewItem(Strings.SM_TwilightGem, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_A)),
			twilight_stone = createNewItem(Strings.SM_TwilightStone, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_B)),
			twilight_shard = createNewItem(Strings.SM_TwilightShard, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_C)),
			mythril_crystal = createNewItem(Strings.SM_MythrilCrystal, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_S)),
			mythril_gem = createNewItem(Strings.SM_MythrilGem, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_A)),
			mythril_stone = createNewItem(Strings.SM_MythrilStone, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_B)),
			mythril_shard = createNewItem(Strings.SM_MythrilShard, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_C)),
			tranquility_crystal = createNewItem(Strings.SM_TranquilityCrystal, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_S)),
			tranquility_gem = createNewItem(Strings.SM_TranquilityGem, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_A)),
			tranquility_stone = createNewItem(Strings.SM_TranquilityStone, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_B)),
			tranquility_shard = createNewItem(Strings.SM_TranquilityShard, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_C)),
			sinister_crystal = createNewItem(Strings.SM_SinisterCrystal, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_S)),
			sinister_gem = createNewItem(Strings.SM_SinisterGem, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_A)),
			sinister_stone = createNewItem(Strings.SM_SinisterStone, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_B)),
			sinister_shard = createNewItem(Strings.SM_SinisterShard, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_C)),
			stormy_crystal = createNewItem(Strings.SM_StormyCrystal, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_S)),
			stormy_gem = createNewItem(Strings.SM_StormyGem, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_A)),
			stormy_stone = createNewItem(Strings.SM_StormyStone, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_B)),
			stormy_shard = createNewItem(Strings.SM_StormyShard, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_C)),
			remembrance_crystal = createNewItem(Strings.SM_RemembranceCrystal, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_S)),
			remembrance_gem = createNewItem(Strings.SM_RemembranceGem, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_A)),
			remembrance_stone = createNewItem(Strings.SM_RemembranceStone, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_B)),
			remembrance_shard = createNewItem(Strings.SM_RemembranceShard, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_C)),
			pulsing_crystal = createNewItem(Strings.SM_PulsingCrystal, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_S)),
			pulsing_gem = createNewItem(Strings.SM_PulsingGem, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_A)),
			pulsing_stone = createNewItem(Strings.SM_PulsingStone, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_B)),
			pulsing_shard = createNewItem(Strings.SM_PulsingShard, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_C)),
			orichalcumplus = createNewItem(Strings.SM_OrichalcumPlus, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_S)),
			orichalcum = createNewItem(Strings.SM_Orichalcum, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_A)),
			manifest_illusion = createNewItem(Strings.SM_ManifestIllusion, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_S)),
			lost_illusion = createNewItem(Strings.SM_LostIllusion, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_A)),
			fluorite = createNewItem(Strings.SM_Fluorite, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_C)),
			damascus = createNewItem(Strings.SM_Damascus, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_B)),
			adamantite = createNewItem(Strings.SM_Adamantite, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_A)),
			electrum = createNewItem(Strings.SM_Electrum, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_S)),
			evanescent_crystal = createNewItem(Strings.SM_EvanescentCrystal, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_S)),
			illusory_crystal = createNewItem(Strings.SM_IllusoryCrystal, () -> new SynthesisItem(new Item.Properties(), Strings.SM_Rank_S)),

			fireSpell = createNewItem(Strings.SpellFire, () -> new MagicSpellItem(new Item.Properties(), KingdomKeys.MODID + ":" + Strings.Mag_Prefix + "fire")),
			blizzardSpell = createNewItem(Strings.SpellBlizzard, () -> new MagicSpellItem(new Item.Properties(), KingdomKeys.MODID + ":" + Strings.Mag_Prefix + "blizzard")),
			waterSpell = createNewItem(Strings.SpellWater, () -> new MagicSpellItem(new Item.Properties(), KingdomKeys.MODID + ":" + Strings.Mag_Prefix + "water")),
			thunderSpell = createNewItem(Strings.SpellThunder, () -> new MagicSpellItem(new Item.Properties(), KingdomKeys.MODID + ":" + Strings.Mag_Prefix + "thunder")),
			cureSpell = createNewItem(Strings.SpellCure, () -> new MagicSpellItem(new Item.Properties(), KingdomKeys.MODID + ":" + Strings.Mag_Prefix + "cure")),
			aeroSpell = createNewItem(Strings.SpellAero, () -> new MagicSpellItem(new Item.Properties(), KingdomKeys.MODID + ":" + Strings.Mag_Prefix + "aero")),
			magnetSpell = createNewItem(Strings.SpellMagnet, () -> new MagicSpellItem(new Item.Properties(), KingdomKeys.MODID + ":" + Strings.Mag_Prefix + "magnet")),
			reflectSpell= createNewItem(Strings.SpellReflect, () -> new MagicSpellItem(new Item.Properties(), KingdomKeys.MODID + ":" + Strings.Mag_Prefix + "reflect")),
			gravitySpell = createNewItem(Strings.SpellGravity, () -> new MagicSpellItem(new Item.Properties(), KingdomKeys.MODID + ":" + Strings.Mag_Prefix + "gravity")),
			stopSpell = createNewItem(Strings.SpellStop, () -> new MagicSpellItem(new Item.Properties(), KingdomKeys.MODID + ":" + Strings.Mag_Prefix + "stop")),


			struggleSword = createNewItem(Strings.StruggleSword, () -> new SwordItem(new KeybladeItemTier(0),new Item.Properties().attributes(SwordItem.createAttributes(new KeybladeItemTier(0), 1, 1)).stacksTo(1))),
			struggleWand = createNewItem(Strings.StruggleWand, () -> new SwordItem(new KeybladeItemTier(0), new Item.Properties().attributes(SwordItem.createAttributes(new KeybladeItemTier(0), 1, 1)).stacksTo(1))),
			struggleHammer = createNewItem(Strings.StruggleHammer, () -> new SwordItem(new KeybladeItemTier(0), new Item.Properties().attributes(SwordItem.createAttributes(new KeybladeItemTier(0), 1, 1)).stacksTo(1))),

			
			valorOrb = createNewItem(Strings.LevelUpValor, () -> new DriveFormOrbItem(new Item.Properties(), KingdomKeys.MODID+":form_valor")),
			wisdomOrb = createNewItem(Strings.LevelUpWisdom, () -> new DriveFormOrbItem(new Item.Properties(), KingdomKeys.MODID+":form_wisdom")),
			limitOrb = createNewItem(Strings.LevelUpLimit, () -> new DriveFormOrbItem(new Item.Properties(), KingdomKeys.MODID+":form_limit")),
			masterOrb = createNewItem(Strings.LevelUpMaster, () -> new DriveFormOrbItem(new Item.Properties(), KingdomKeys.MODID+":form_master")),
			finalOrb = createNewItem(Strings.LevelUpFinal, () -> new DriveFormOrbItem(new Item.Properties(), KingdomKeys.MODID+":form_final")),
			
			synthesisBag = createNewItem("synthesis_bag", () -> new SynthesisBagItem(new Item.Properties().stacksTo(1))),
			recipe = createNewItem("recipe", () -> new RecipeItem(0,new Item.Properties().stacksTo(16))),
			recipeD = createNewItem("recipe_d", () -> new RecipeItem(1,new Item.Properties().stacksTo(16))),
			recipeC = createNewItem("recipe_c", () -> new RecipeItem(2,new Item.Properties().stacksTo(16))),
			recipeB = createNewItem("recipe_b", () -> new RecipeItem(3,new Item.Properties().stacksTo(16))),
			recipeA = createNewItem("recipe_a", () -> new RecipeItem(4,new Item.Properties().stacksTo(16))),
			recipeS = createNewItem("recipe_s", () -> new RecipeItem(5,new Item.Properties().stacksTo(16))),
			recipeSS = createNewItem("recipe_ss", () -> new RecipeItem(6,new Item.Properties().stacksTo(16))),
			recipeSSS = createNewItem("recipe_sss", () -> new RecipeItem(7,new Item.Properties().stacksTo(16))),

			proofOfHeart = createNewItem("proof_of_heart", () -> new ProofOfHeartItem(new Item.Properties())),
			
			potion = createNewItem(Strings.potion, () -> new KKPotionItem(new Item.Properties().stacksTo(1), KKPotionItem.PotionType.HP, 30, true, false)),
			hiPotion = createNewItem(Strings.hiPotion, () -> new KKPotionItem(new Item.Properties().stacksTo(1), KKPotionItem.PotionType.HP, 60, true, false)),
			megaPotion = createNewItem(Strings.megaPotion, () -> new KKPotionItem(new Item.Properties().stacksTo(1), KKPotionItem.PotionType.HP, 40, true, true)),
			ether = createNewItem(Strings.ether, () -> new KKPotionItem(new Item.Properties().stacksTo(1), KKPotionItem.PotionType.MP, 30, true, false)),
			hiEther = createNewItem(Strings.hiEther, () -> new KKPotionItem(new Item.Properties().stacksTo(1), KKPotionItem.PotionType.MP, 60, true, false)),
			megaEther = createNewItem(Strings.megaEther, () -> new KKPotionItem(new Item.Properties().stacksTo(1), KKPotionItem.PotionType.MP, 40, true, true)),
			elixir = createNewItem(Strings.elixir, () -> new KKPotionItem(new Item.Properties().stacksTo(1), KKPotionItem.PotionType.HPMP, 100, true, false)),
			megaLixir = createNewItem(Strings.megaLixir, () -> new KKPotionItem(new Item.Properties().stacksTo(1), KKPotionItem.PotionType.HPMP, 100, true, true)),
			driveRecovery = createNewItem(Strings.driveRecovery, () -> new KKPotionItem(new Item.Properties().stacksTo(1), KKPotionItem.PotionType.DRIVE, 300, false, false)),
			hiDriveRecovery = createNewItem(Strings.hiDriveRecovery, () -> new KKPotionItem(new Item.Properties().stacksTo(1), KKPotionItem.PotionType.DRIVE, 1000, false, false)),
			refocuser = createNewItem(Strings.refocuser, () -> new KKPotionItem(new Item.Properties().stacksTo(1), KKPotionItem.PotionType.FOCUS, 40, true, false)),
			hiRefocuser = createNewItem(Strings.hiRefocuser, () -> new KKPotionItem(new Item.Properties().stacksTo(1), KKPotionItem.PotionType.FOCUS, 100, true, false)),
			
    		powerBoost = createNewItem(Strings.powerBoost, () -> new StatUpgradeItem(new Item.Properties(), Strings.powerBoost)),
			magicBoost = createNewItem(Strings.magicBoost, () -> new StatUpgradeItem(new Item.Properties(), Strings.magicBoost)),
			defenseBoost = createNewItem(Strings.defenseBoost, () -> new StatUpgradeItem(new Item.Properties(), Strings.defenseBoost)),
			apBoost = createNewItem(Strings.apBoost, () -> new StatUpgradeItem(new Item.Properties(), Strings.apBoost)),
			
			abilityRing = createNewItem(Strings.abilityRing, () -> new KKAccessoryItem(new Item.Properties().stacksTo(1), 1, 0, 0, null)),
			engineersRing = createNewItem(Strings.engineersRing, () -> new KKAccessoryItem(new Item.Properties().stacksTo(1), 2, 0, 0, null)),
			techniciansRing = createNewItem(Strings.techniciansRing, () -> new KKAccessoryItem(new Item.Properties().stacksTo(1), 3, 0, 0, null)),
			skillRing = createNewItem(Strings.skillRing, () -> new KKAccessoryItem(new Item.Properties().stacksTo(1), 4, 0, 0, null)),
			skillfulRing = createNewItem(Strings.skillfulRing, () -> new KKAccessoryItem(new Item.Properties().stacksTo(1), 5, 0, 0, null)),
			expertsRing = createNewItem(Strings.expertsRing, () -> new KKAccessoryItem(new Item.Properties().stacksTo(1), 6, 0, 0, null)),
			mastersRing = createNewItem(Strings.mastersRing, () -> new KKAccessoryItem(new Item.Properties().stacksTo(1), 7, 0, 0, null)),
			cosmicRing = createNewItem(Strings.cosmicRing, () -> new KKAccessoryItem(new Item.Properties().stacksTo(1), 8, 0, 0, null)),
			aquamarineRing = createNewItem(Strings.aquamarineRing, () -> new KKAccessoryItem(new Item.Properties().stacksTo(1), 3, 1, 0, null)),
			executiveRing = createNewItem(Strings.executiveRing, () -> new KKAccessoryItem(new Item.Properties().stacksTo(1), 30, 0, 0, null)),
			moonAmulet = createNewItem(Strings.moonAmulet, () -> new KKAccessoryItem(new Item.Properties().stacksTo(1), 3, 2, 2, null)),
			starCharm = createNewItem(Strings.starCharm, () -> new KKAccessoryItem(new Item.Properties().stacksTo(1), 5, 2, 2, null)),
			cosmicArts = createNewItem(Strings.cosmicArts, () -> new KKAccessoryItem(new Item.Properties().stacksTo(1), 7, 2, 2, null)),
			fullBloom = createNewItem(Strings.fullBloom, () -> new KKAccessoryItem(new Item.Properties().stacksTo(1), 5, 3, 0, null)),
			fullBloomPlus = createNewItem(Strings.fullBloomPlus, () -> new KKAccessoryItem(new Item.Properties().stacksTo(1), 5, 3, 0, new String[] {Strings.mpHaste})),
			shadowArchive = createNewItem(Strings.shadowArchive, () -> new KKAccessoryItem(new Item.Properties().stacksTo(1), 5, 0, 3, null)),
			shadowArchivePlus = createNewItem(Strings.shadowArchivePlus, () -> new KKAccessoryItem(new Item.Properties().stacksTo(1), 5, 0, 3, new String[] {Strings.mpRage})),
    		drawRing = createNewItem(Strings.drawRing, () -> new KKAccessoryItem(new Item.Properties().stacksTo(1), 0, 0, 0, new String[] {Strings.treasureMagnet})),
    		luckyRing = createNewItem(Strings.luckyRing, () -> new KKAccessoryItem(new Item.Properties().stacksTo(1), 0, 0, 0, new String[] {Strings.luckyLucky})),

			sardonyxRing = createNewItem(Strings.sardonyxRing, () -> new KKAccessoryItem(new Item.Properties().stacksTo(1), 1, 1, 0, null)),
			garnetRing = createNewItem(Strings.garnetRing, () -> new KKAccessoryItem(new Item.Properties().stacksTo(1), 4, 1, 0, null)),
			diamondRing = createNewItem(Strings.diamondRing, () -> new KKAccessoryItem(new Item.Properties().stacksTo(1), 5, 1, 0, null)),
			tourmalineRing = createNewItem(Strings.tourmalineRing, () -> new KKAccessoryItem(new Item.Properties().stacksTo(1), 2, 0, 1, null)),
			silverRing = createNewItem(Strings.silverRing, () -> new KKAccessoryItem(new Item.Properties().stacksTo(1), 1, 0, 1, null)),		
			goldRing = createNewItem(Strings.goldRing, () -> new KKAccessoryItem(new Item.Properties().stacksTo(1), 2, 1, 0, null)),
			platinumRing = createNewItem(Strings.platinumRing, () -> new KKAccessoryItem(new Item.Properties().stacksTo(1), 3, 0, 1, null)),
			mythrilRing = createNewItem(Strings.mythrilRing, () -> new KKAccessoryItem(new Item.Properties().stacksTo(1), 4, 0, 1, null)),
			orichalcumRing = createNewItem(Strings.orichalcumRing, () -> new KKAccessoryItem(new Item.Properties().stacksTo(1), 5, 0, 1, null)),
			medal = createNewItem(Strings.medal, () -> new KKAccessoryItem(new Item.Properties().stacksTo(1), 0, 1, 0, null)),
			soldierEarring = createNewItem(Strings.soldierEarring, () -> new KKAccessoryItem(new Item.Properties().stacksTo(1), 4, 2, 0, null)),
			mageEarring = createNewItem(Strings.mageEarring, () -> new KKAccessoryItem(new Item.Properties().stacksTo(1), 4, 0, 2, null)),
			slayerEarring = createNewItem(Strings.slayerEarring, () -> new KKAccessoryItem(new Item.Properties().stacksTo(1), 5, 1, 2, null)),
			fencerEarring = createNewItem(Strings.fencerEarring, () -> new KKAccessoryItem(new Item.Properties().stacksTo(1), 5, 2, 1, null)),

			fireBangle = createNewItem(Strings.fireBangle, () -> new KKArmorItem(new Item.Properties().stacksTo(1), 1, ImmutableMap.of(KKResistanceType.fire, 20))),
			firaBangle = createNewItem(Strings.firaBangle, () -> new KKArmorItem(new Item.Properties().stacksTo(1),2, ImmutableMap.of(KKResistanceType.fire,20))),
			firagaBangle = createNewItem(Strings.firagaBangle, () -> new KKArmorItem(new Item.Properties().stacksTo(1),3, ImmutableMap.of(KKResistanceType.fire,20))),
			firagunBangle = createNewItem(Strings.firagunBangle, () -> new KKArmorItem(new Item.Properties().stacksTo(1),3, ImmutableMap.of(KKResistanceType.fire,25))),
			blizzardArmlet = createNewItem(Strings.blizzardArmlet, () -> new KKArmorItem(new Item.Properties().stacksTo(1), 1, ImmutableMap.of(KKResistanceType.ice, 20))),
			blizzaraArmlet = createNewItem(Strings.blizzaraArmlet, () -> new KKArmorItem(new Item.Properties().stacksTo(1),2, ImmutableMap.of(KKResistanceType.ice,20))),
			blizzagaArmlet = createNewItem(Strings.blizzagaArmlet, () -> new KKArmorItem(new Item.Properties().stacksTo(1),3, ImmutableMap.of(KKResistanceType.ice,20))),
			blizzagunArmlet = createNewItem(Strings.blizzagunArmlet, () -> new KKArmorItem(new Item.Properties().stacksTo(1),3, ImmutableMap.of(KKResistanceType.ice,25))),
			thunderTrinket = createNewItem(Strings.thunderTrinket, () -> new KKArmorItem(new Item.Properties().stacksTo(1), 1, ImmutableMap.of(KKResistanceType.lightning, 20))),
			thundaraTrinket = createNewItem(Strings.thundaraTrinket, () -> new KKArmorItem(new Item.Properties().stacksTo(1),2, ImmutableMap.of(KKResistanceType.lightning,20))),
			thundagaTrinket = createNewItem(Strings.thundagaTrinket, () -> new KKArmorItem(new Item.Properties().stacksTo(1),3, ImmutableMap.of(KKResistanceType.lightning,20))),
			thundagunTrinket = createNewItem(Strings.thundagunTrinket, () -> new KKArmorItem(new Item.Properties().stacksTo(1),3, ImmutableMap.of(KKResistanceType.lightning,25))),
			shockCharm = createNewItem(Strings.shockCharm, () -> new KKArmorItem(new Item.Properties().stacksTo(1),3, ImmutableMap.of(KKResistanceType.lightning,40))),
			shockCharmPlus = createNewItem(Strings.shockCharmPlus, () -> new KKArmorItem(new Item.Properties().stacksTo(1),4, ImmutableMap.of(KKResistanceType.lightning,50))),
			elvenBandanna = createNewItem(Strings.elvenBandanna, () -> new KKArmorItem(new Item.Properties().stacksTo(1),1, ImmutableMap.of())),
			divineBandanna = createNewItem(Strings.divineBandanna, () -> new KKArmorItem(new Item.Properties().stacksTo(1),2, ImmutableMap.of())),
			powerBand = createNewItem(Strings.powerBand, () -> new KKArmorItem(new Item.Properties().stacksTo(1),4, ImmutableMap.of())),
			busterBand = createNewItem(Strings.busterBand, () -> new KKArmorItem(new Item.Properties().stacksTo(1),5, ImmutableMap.of())),
			cosmicBelt = createNewItem(Strings.cosmicBelt, () -> new KKArmorItem(new Item.Properties().stacksTo(1),6, ImmutableMap.of())),
			cosmicChain = createNewItem(Strings.cosmicChain, () -> new KKArmorItem(new Item.Properties().stacksTo(1),3, ImmutableMap.of(KKResistanceType.fire, 25,KKResistanceType.ice,25,KKResistanceType.lightning,25))),
			petiteRibbon = createNewItem(Strings.petiteRibbon, () -> new KKArmorItem(new Item.Properties().stacksTo(1), 2, ImmutableMap.of(KKResistanceType.fire, 10, KKResistanceType.ice, 10, KKResistanceType.lightning, 10, KKResistanceType.darkness, 10))),
			ribbon = createNewItem(Strings.ribbon, () -> new KKArmorItem(new Item.Properties().stacksTo(1), 3, ImmutableMap.of(KKResistanceType.fire, 20, KKResistanceType.ice, 20, KKResistanceType.lightning, 20, KKResistanceType.darkness, 20))),
			grandRibbon = createNewItem(Strings.grandRibbon, () -> new KKArmorItem(new Item.Properties().stacksTo(1), 4, ImmutableMap.of(KKResistanceType.fire, 25, KKResistanceType.ice, 25, KKResistanceType.lightning, 25, KKResistanceType.darkness, 25))),
			abasChain = createNewItem(Strings.abasChain, () -> new KKArmorItem(new Item.Properties().stacksTo(1),0, ImmutableMap.of(KKResistanceType.fire, 20,KKResistanceType.ice,20,KKResistanceType.lightning,20))),
			acrisius = createNewItem(Strings.acrisius, () -> new KKArmorItem(new Item.Properties().stacksTo(1),3, ImmutableMap.of(KKResistanceType.fire, 20,KKResistanceType.ice,20,KKResistanceType.lightning,20))),
			acrisiusPlus = createNewItem(Strings.acrisiusPlus, () -> new KKArmorItem(new Item.Properties().stacksTo(1),3, ImmutableMap.of(KKResistanceType.fire, 25,KKResistanceType.ice,25,KKResistanceType.lightning,25))),
			aegisChain = createNewItem(Strings.aegisChain, () -> new KKArmorItem(new Item.Properties().stacksTo(1),2, ImmutableMap.of(KKResistanceType.fire, 20,KKResistanceType.ice,20,KKResistanceType.lightning,20))),
			championBelt = createNewItem(Strings.championBelt, () -> new KKArmorItem(new Item.Properties().stacksTo(1),0, ImmutableMap.of(KKResistanceType.fire, 20,KKResistanceType.ice,20,KKResistanceType.lightning,20))),
			shadowAnklet = createNewItem(Strings.shadowAnklet, () -> new KKArmorItem(new Item.Properties().stacksTo(1),1, ImmutableMap.of(KKResistanceType.darkness,20))),
			darkAnklet = createNewItem(Strings.darkAnklet, () -> new KKArmorItem(new Item.Properties().stacksTo(1),2, ImmutableMap.of(KKResistanceType.darkness, 20))),
			midnightAnklet = createNewItem(Strings.midnightAnklet, () -> new KKArmorItem(new Item.Properties().stacksTo(1),3, ImmutableMap.of(KKResistanceType.darkness,20))),
			chaosAnklet = createNewItem(Strings.chaosAnklet, () -> new KKArmorItem(new Item.Properties().stacksTo(1),3, ImmutableMap.of(KKResistanceType.darkness, 25))),
			protectBelt = createNewItem(Strings.protectBelt, () -> new KKArmorItem(new Item.Properties().stacksTo(1),3, ImmutableMap.of())),
			gaiaBelt = createNewItem(Strings.gaiaBelt, () -> new KKArmorItem(new Item.Properties().stacksTo(1),3, ImmutableMap.of(KKResistanceType.lightning,20,KKResistanceType.darkness,20))),
			//lightDefTest = createNewItem(Strings.lightDefTest, () -> new KKArmorItem(new Item.Properties().stacksTo(1),3, ImmutableMap.of(KKResistanceType.light,20,KKResistanceType.darkness,20))),

			
			wayfinder = createNewItem(Strings.wayfinder, () -> new WayfinderItem(new Item.Properties().stacksTo(1))),
    		//gummiShip = createNewItem(Strings.gummiShip, () -> new GummiShipItem(new Item.Properties().group(KingdomKeys.miscGroup).maxStackSize(1)));

			//map cards
			tranquilDarkness = createMapCard(Strings.TranquilDarkness, ModRoomTypes.TRANQUIL_DARKNESS),
			teemingDarkness = createMapCard(Strings.TeemingDarkness, ModRoomTypes.TEEMING_DARKNESS),
			feebleDarkness = createMapCard(Strings.FeebleDarkness, ModRoomTypes.FEEBLE_DARKNESS),
			almightyDarkness = createMapCard(Strings.AlmightyDarkness, ModRoomTypes.ALMIGHTY_DARKNESS),
			sleepingDarkness = createMapCard(Strings.SleepingDarkness, ModRoomTypes.SLEEPING_DARKNESS),
			loomingDarkness = createMapCard(Strings.LoomingDarkness, ModRoomTypes.LOOMING_DARKNESS),
			bottomlessDarkness = createMapCard(Strings.BottomlessDarkness, ModRoomTypes.BOTTOMLESS_DARKNESS),
			martialWaking = createMapCard(Strings.MartialWaking, ModRoomTypes.MARTIAL_WAKING),
			sorcerousWaking = createMapCard(Strings.SorcerousWaking, ModRoomTypes.SORCEROUS_WAKING),
			alchemicWaking = createMapCard(Strings.AlchemicWaking, ModRoomTypes.ALCHEMIC_WAKING),
			stagnantSpace = createMapCard(Strings.StagnantSpace, ModRoomTypes.STAGNANT_SPACE),
			weightlessSpace = createMapCard(Strings.WeightlessSpace, ModRoomTypes.WEIGHTLESS_SPACE),
			calmBounty = createMapCard(Strings.CalmBounty, ModRoomTypes.CALM_BOUNTY),
			guardedTrove = createMapCard(Strings.GuardedTrove, ModRoomTypes.GUARDED_TROVE),
			falseBounty = createMapCard(Strings.FalseBounty, ModRoomTypes.FALSE_BOUNTY),
			momentsReprieve = createMapCard(Strings.MomentsReprieve, ModRoomTypes.MOMENTS_REPRIEVE),
			moogleRoom = createMapCard(Strings.MoogleRoom, ModRoomTypes.MOOGLE_ROOM),
			prosperousRepository = createMapCard(Strings.ProsperousRepository, ModRoomTypes.PROSPEROUS_REPOSITORY),
			treacherousRepository = createMapCard(Strings.TreacherousRepository, ModRoomTypes.TREACHEROUS_RESPOITORY),
			reposefulGrove = createMapCard(Strings.ReposefulGrove, ModRoomTypes.REPOSEFUL_GROVE),
			minglingWorlds = ITEMS.register(Strings.MinglingWorlds, MinglingWorldsMapCardItem::new),

			//floor cards
			plainsCard = createWorldCard(Strings.PlainsCard, ModFloorTypes.PLAINS),
			netherCard = createWorldCard(Strings.NetherCard, ModFloorTypes.NETHER);



	//Helper method to create item with the properties and registry name
	public static Supplier<Item> createNewItem(String name, Item.Properties properties) {
		return ITEMS.register(name, () -> new Item(properties));
	}

	public static <T extends Item> Supplier<T> createNewItem(String name, Supplier<? extends T> item) {
		return ITEMS.register(name, item);
	}

	public static Supplier<Item> createKeybladeItem(String name) {
		return ITEMS.register(name, () -> new KeybladeItem(new Item.Properties().stacksTo(1)));
	}

	private static Supplier<Item> createArmorItem(String name, Holder<ArmorMaterial> material, ArmorItem.Type slot, String textureName) {
		return ITEMS.register(name, () -> new BaseArmorItem(material, slot, textureName));
	}

	private static Supplier<Item> createMapCard(String name, Supplier<RoomType> type) {
		return ITEMS.register(name, () -> new MapCardItem(type));
	}

	private static Supplier<Item> createWorldCard(String name, Supplier<FloorType> type) {
		return ITEMS.register(name, () -> new WorldCardItem(type));
	}
	
	private static Supplier<Item> createKeybladeArmorItem(String name, Holder<ArmorMaterial> material, ArmorItem.Type slot, String textureName) {
		return ITEMS.register(name, () -> new KeybladeArmorItem(material, slot, textureName));
	}

}
