/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.block.BaseBlock;
import online.kingdomkeys.kingdomkeys.block.INoDataGen;
import online.kingdomkeys.kingdomkeys.capability.CastleOblivionCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.entity.block.CardDoorTileEntity;
import online.kingdomkeys.kingdomkeys.item.card.WorldCardItem;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCOpenCODoorGui;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncCastleOblivionInteriorCapability;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.CastleOblivionHandler;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.CastleOblivionEvent;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.floor.Floor;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.DoorData;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.Room;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomData;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomDirection;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomGenerator;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomPos;

public class CardDoorBlock
extends BaseBlock
implements EntityBlock,
INoDataGen {
    private static final VoxelShape collisionShapeE = Block.m_49796_((double)0.0, (double)0.0, (double)-8.0, (double)6.0, (double)32.0, (double)24.0);
    private static final VoxelShape collisionShapeN = Block.m_49796_((double)-8.0, (double)0.0, (double)10.0, (double)24.0, (double)32.0, (double)16.0);
    private static final VoxelShape collisionShapeW = Block.m_49796_((double)10.0, (double)0.0, (double)-8.0, (double)16.0, (double)32.0, (double)24.0);
    private static final VoxelShape collisionShapeS = Block.m_49796_((double)-8.0, (double)0.0, (double)0.0, (double)24.0, (double)32.0, (double)6.0);
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final BooleanProperty GENERATED = BooleanProperty.m_61465_((String)"generated");
    public static final BooleanProperty OPEN = BooleanProperty.m_61465_((String)"open");

    public CardDoorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)GENERATED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)GENERATED, (Comparable)Boolean.valueOf(false));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING});
        builder.m_61104_(new Property[]{GENERATED});
        builder.m_61104_(new Property[]{OPEN});
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        CardDoorTileEntity te;
        CastleOblivionCapabilities.ICastleOblivionInteriorCapability cap;
        if (!level.f_46443_ && ((Boolean)state.m_61143_((Property)GENERATED)).booleanValue() && (cap = ModCapabilities.getCastleOblivionInterior(level)) != null && (te = (CardDoorTileEntity)level.m_7702_(pos)) != null && te.getParentRoom() != null) {
            switch (te.getData().getType()) {
                case NORMAL: {
                    if (te.getDestinationRoom() == null) break;
                    System.out.println("Size: " + te.getParentRoom().getParentFloor(level).getRooms().size());
                    System.out.println((level.f_46443_ ? "Client" : "Server") + ": Num:" + te.getDestinationRoom().getCardCost() + " Open? " + te.isOpen());
                    PacketHandler.sendTo(new SCOpenCODoorGui(te.m_58899_()), (ServerPlayer)player);
                    break;
                }
                case FIXED: {
                    if (te.isOpen()) break;
                    break;
                }
                case HALL: {
                    Item item;
                    if (te.isOpen() || !((item = player.m_21120_(hand).m_41720_()) instanceof WorldCardItem)) break;
                    WorldCardItem item2 = (WorldCardItem)item;
                    te.getParentRoom().getParentFloor(level).setWorldCard(item2);
                    te.openDoor(true);
                    CastleOblivionHandler.createFirstRoom(player, te);
                }
            }
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return ((BlockEntityType)ModEntities.TYPE_CARD_DOOR.get()).m_155264_(pPos, pState);
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (!level.f_46443_ && ((Boolean)state.m_61143_((Property)GENERATED)).booleanValue() && entity instanceof Player) {
            CardDoorTileEntity te;
            Player player = (Player)entity;
            CastleOblivionCapabilities.ICastleOblivionInteriorCapability cap = ModCapabilities.getCastleOblivionInterior(level);
            if (cap != null && (te = (CardDoorTileEntity)level.m_7702_(pos)) != null && te.getParentRoom() != null && te.isOpen()) {
                if (te.getDestinationRoom() != null) {
                    RoomData data = te.getDestinationRoom();
                    Room newRoom = data.getGenerated();
                    if (newRoom != null && !MinecraftForge.EVENT_BUS.post((Event)new CastleOblivionEvent.PlayerChangeRoomEvent(cap.getRoomAtPos(level, te.m_58899_()), newRoom, player))) {
                        BlockPos destination = newRoom.doors.get((Object)te.getDirection().opposite()).pos();
                        destination = destination.m_121955_(te.getDirection().toMCDirection().m_122436_().m_142393_(2));
                        player.m_6021_((double)destination.m_123341_(), (double)destination.m_123342_(), (double)destination.m_123343_());
                        PacketHandler.sendTo(new SCSyncCastleOblivionInteriorCapability(ModCapabilities.getCastleOblivionInterior(player.m_9236_())), (ServerPlayer)player);
                    }
                } else if (te.getData().getType() != DoorData.Type.EXIT && te.getData().getType() != DoorData.Type.ENTRANCE) {
                    KingdomKeys.LOGGER.error("Door [{}] missing destination room of type {}, something has gone wrong", (Object)te.m_58899_().m_123344_(), (Object)te.getData().getType());
                } else {
                    Floor currFloor = cap.getFloorByID(te.getParentRoom().getParentID());
                    if (te.getData().getType() == DoorData.Type.ENTRANCE) {
                        if (te.getParentRoom().getParentID() == 0) {
                            CastleOblivionHandler.exitCastleOblivion(currFloor, te.getParentRoom().getGenerated(), player);
                            currFloor.floorExited(player);
                        } else {
                            Floor prevFloor = cap.getFloorByID(te.getParentRoom().getParentID() - 1);
                            Room destRoom = prevFloor.getExitRoom().getGenerated();
                            BlockPos destination = destRoom.getExitDoor();
                            destination = destination.m_121955_(((Direction)level.m_8055_(destination).m_61143_((Property)FACING)).m_122436_().m_142393_(2));
                            player.m_6021_((double)destination.m_123341_(), (double)destination.m_123342_(), (double)destination.m_123343_());
                            MinecraftForge.EVENT_BUS.post((Event)new CastleOblivionEvent.PlayerChangeRoomEvent(te.getParentRoom().getGenerated(), destRoom, player));
                            MinecraftForge.EVENT_BUS.post((Event)new CastleOblivionEvent.PlayerChangeFloorEvent(currFloor, prevFloor, player));
                            currFloor.floorExited(player);
                            prevFloor.floorEntered(player);
                        }
                    } else if (te.getData().getType() == DoorData.Type.EXIT) {
                        Floor nextFloor;
                        Room destRoom;
                        if (cap.getFloors().size() == currFloor.getFloorID() + 1) {
                            destRoom = RoomGenerator.INSTANCE.generateNewFloor(level);
                            nextFloor = cap.getFloorByID(destRoom.parentFloor);
                        } else {
                            nextFloor = cap.getFloorByID(te.getParentRoom().getParentID() + 1);
                            destRoom = nextFloor.getRoom(RoomPos.ZERO).getGenerated();
                        }
                        BlockPos entranceDoor = destRoom.doors.get((Object)RoomDirection.SOUTH).pos();
                        entranceDoor = entranceDoor.m_121955_(((Direction)level.m_8055_(entranceDoor).m_61143_((Property)FACING)).m_122436_().m_142393_(2));
                        player.m_6021_((double)entranceDoor.m_123341_(), (double)entranceDoor.m_123342_(), (double)entranceDoor.m_123343_());
                        MinecraftForge.EVENT_BUS.post((Event)new CastleOblivionEvent.PlayerChangeRoomEvent(te.getParentRoom().getGenerated(), destRoom, player));
                        MinecraftForge.EVENT_BUS.post((Event)new CastleOblivionEvent.PlayerChangeFloorEvent(currFloor, nextFloor, player));
                        currFloor.floorExited(player);
                        nextFloor.floorEntered(player);
                    }
                }
            }
        }
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.m_5940_(state, world, pos, context);
    }

    @Deprecated
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.NORTH -> collisionShapeN;
            case Direction.EAST -> collisionShapeE;
            case Direction.SOUTH -> collisionShapeS;
            case Direction.WEST -> collisionShapeW;
            default -> collisionShapeS;
        };
    }
}

