/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.block;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkHooks;
import online.kingdomkeys.kingdomkeys.block.INoDataGen;
import online.kingdomkeys.kingdomkeys.block.ModBlocks;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.entity.block.MagicalChestTileEntity;
import online.kingdomkeys.kingdomkeys.item.KeybladeItem;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class MagicalChestBlock
extends BaseEntityBlock
implements INoDataGen {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final BooleanProperty BIG = BooleanProperty.m_61465_((String)"big");
    private static final VoxelShape collisionShapeEW = Block.m_49796_((double)2.0, (double)0.0, (double)1.0, (double)14.0, (double)12.0, (double)15.0);
    private static final VoxelShape collisionShapeNS = Block.m_49796_((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)12.0, (double)14.0);

    public MagicalChestBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)BIG, (Comparable)Boolean.valueOf(false)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack stack, @Nullable BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.m_237115_((String)"message.chest.can_be_locked"));
        super.m_5871_(stack, worldIn, tooltip, flagIn);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)BIG, (Comparable)Boolean.valueOf(false));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING, BIG});
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.m_5940_(state, world, pos, context);
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        MagicalChestTileEntity te;
        if (state.m_155947_() && worldIn.m_7702_(pos) instanceof MagicalChestTileEntity && (te = (MagicalChestTileEntity)worldIn.m_7702_(pos)) != null) {
            Player player = (Player)placer;
            te.setOwner(player.m_36316_().getId());
            player.m_5661_((Component)Component.m_237115_((String)"message.chest.lock"), true);
        }
        super.m_6402_(worldIn, pos, state, placer, stack);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (worldIn.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        MenuProvider namedContainerProvider = this.m_7246_(state, worldIn, pos);
        if (namedContainerProvider != null) {
            MagicalChestTileEntity te;
            if (!(player instanceof ServerPlayer)) {
                return InteractionResult.FAIL;
            }
            ServerPlayer serverPlayerEntity = (ServerPlayer)player;
            if (state.m_155947_() && worldIn.m_7702_(pos) instanceof MagicalChestTileEntity && (te = (MagicalChestTileEntity)worldIn.m_7702_(pos)) != null) {
                UUID keyblade = te.getKeyblade();
                ItemStack held = player.m_21120_(handIn);
                if (held.m_41720_() instanceof KeybladeItem) {
                    UUID heldID = Utils.getKeybladeID(held);
                    if (heldID != null) {
                        if (keyblade != null) {
                            if (heldID.equals(keyblade)) {
                                NetworkHooks.openScreen((ServerPlayer)serverPlayerEntity, (MenuProvider)namedContainerProvider, buf -> buf.m_130064_(pos));
                            } else {
                                player.m_5661_((Component)Component.m_237115_((String)"message.chest.locked"), true);
                            }
                        } else {
                            te.setKeyblade(heldID);
                            player.m_5661_((Component)Component.m_237115_((String)"message.chest.keyblade_set"), true);
                        }
                    } else if (keyblade == null) {
                        NetworkHooks.openScreen((ServerPlayer)serverPlayerEntity, (MenuProvider)namedContainerProvider, buf -> buf.m_130064_(pos));
                    }
                } else {
                    if (keyblade == null) {
                        NetworkHooks.openScreen((ServerPlayer)serverPlayerEntity, (MenuProvider)namedContainerProvider, buf -> buf.m_130064_(pos));
                        return InteractionResult.SUCCESS;
                    }
                    player.m_5661_((Component)Component.m_237115_((String)"message.chest.locked"), true);
                }
            }
        }
        return super.m_6227_(state, worldIn, pos, player, handIn, hit);
    }

    @Deprecated
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (state.m_61143_((Property)FACING) == Direction.NORTH || state.m_61143_((Property)FACING) == Direction.SOUTH) {
            return collisionShapeNS;
        }
        return collisionShapeEW;
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_155947_() && state.m_60734_() != newState.m_60734_()) {
            world.m_7702_(pos).getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(inv -> {
                for (int i = 0; i < inv.getSlots(); ++i) {
                    MagicalChestBlock.m_49840_((Level)world, (BlockPos)pos, (ItemStack)inv.getStackInSlot(i));
                }
            });
            world.m_46747_(pos);
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return ((BlockEntityType)ModEntities.TYPE_MAGICAL_CHEST.get()).m_155264_(pPos, pState);
    }

    @Mod.EventBusSubscriber
    public static class Events {
        @SubscribeEvent
        public static void onBlockBreak(BlockEvent.BreakEvent event) {
            MagicalChestTileEntity te;
            if (event.getState().m_60734_() == ModBlocks.magicalChest.get() && event.getState().m_155947_() && (te = (MagicalChestTileEntity)event.getLevel().m_7702_(event.getPos())) != null && te.getOwner() != null && !te.getOwner().equals(event.getPlayer().m_36316_().getId()) && te.getKeyblade() != null && event.getPlayer() != null && !event.getPlayer().m_7500_()) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onBlockRightClick(PlayerInteractEvent.RightClickBlock event) {
            ItemStack held;
            Player player = event.getEntity();
            if (player.m_6047_() && (held = player.m_21120_(event.getHand())).m_41720_() instanceof KeybladeItem) {
                UUID heldID;
                MagicalChestTileEntity te;
                BlockPos pos = event.getPos();
                Level world = event.getLevel();
                BlockState state = world.m_8055_(pos);
                if (state.m_60734_() == ModBlocks.magicalChest.get() && (te = (MagicalChestTileEntity)world.m_7702_(pos)) != null && te.getKeyblade() != null && (heldID = Utils.getKeybladeID(held)).equals(te.getKeyblade())) {
                    te.setKeyblade(null);
                    player.m_5661_((Component)Component.m_237115_((String)"message.chest.unlocked"), true);
                }
            }
        }
    }
}

