/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.elements;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuButton;
import online.kingdomkeys.kingdomkeys.util.Utils;
import org.jetbrains.annotations.NotNull;

public abstract class MenuPopup
extends Screen {
    MenuButton ok;
    MenuButton cancel;
    int[] alpha;
    int[] timer;
    int scaledWidth;
    int scaledHeight;
    int titleDisplayTime = 35;
    int titleFadeIn = 10;
    int currentTimer = 0;

    public boolean m_7043_() {
        return false;
    }

    public abstract void OK();

    public abstract void CANCEL();

    public abstract List<String> getTextToDisplay();

    @Nonnull
    public String OKString() {
        return "soa.menu.ok";
    }

    @Nonnull
    public String CANCELString() {
        return "soa.menu.cancel";
    }

    private void buttonAction(Action a) {
        switch (a) {
            case OK: {
                this.OK();
                break;
            }
            case CANCEL: {
                this.CANCEL();
            }
        }
    }

    public void m_7379_() {
        this.CANCEL();
        super.m_7379_();
    }

    public MenuPopup() {
        super((Component)Component.m_237115_((String)""));
    }

    protected void m_7856_() {
        super.m_7856_();
        this.scaledWidth = Minecraft.m_91087_().m_91268_().m_85445_();
        this.scaledHeight = Minecraft.m_91087_().m_91268_().m_85446_();
        int buttonWidth = 50;
        int buttonX = this.scaledWidth / 2 - buttonWidth * 2;
        int n = this.scaledHeight / 2 + -10;
        int n2 = this.getTextToDisplay().size();
        Objects.requireNonNull(this.f_96547_);
        int buttonY = n + n2 * (9 * 2 + 3);
        this.ok = new MenuButton(buttonX, buttonY, buttonWidth, Utils.translateToLocal(this.OKString(), new Object[0]), MenuButton.ButtonType.BUTTON, p -> this.buttonAction(Action.OK));
        this.m_142416_((GuiEventListener)this.ok);
        this.cancel = new MenuButton(buttonX + buttonWidth * 2, buttonY, buttonWidth, Utils.translateToLocal(this.CANCELString(), new Object[0]), MenuButton.ButtonType.BUTTON, p -> this.buttonAction(Action.CANCEL));
        this.m_142416_((GuiEventListener)this.cancel);
        this.ok.f_93624_ = false;
        this.ok.f_93623_ = false;
        this.cancel.f_93624_ = false;
        this.cancel.f_93623_ = false;
        this.alpha = new int[this.getTextToDisplay().size()];
        this.timer = new int[this.getTextToDisplay().size()];
        this.timer[0] = this.titleDisplayTime + this.titleFadeIn;
        Arrays.fill(this.alpha, 0);
    }

    protected void renderTextBackground(GuiGraphics gui, int yIn, int stringWidthIn) {
        int i = Minecraft.m_91087_().f_91066_.m_92170_(0.0f);
        if (i != 0) {
            int j = -stringWidthIn / 2;
            gui.m_280509_(j - 2, yIn - 2, j + stringWidthIn + 2, yIn + 9 + 2, i);
        }
    }

    public void m_88315_(@NotNull GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(gui, mouseX, mouseY, partialTicks);
        float startY = -10.0f;
        PoseStack matrixStack = gui.m_280168_();
        matrixStack.m_85836_();
        float f = this.scaledWidth / 2;
        float f2 = this.scaledHeight / 2;
        int n = this.getTextToDisplay().size() - 1;
        Objects.requireNonNull(this.f_96547_);
        matrixStack.m_252880_(f, f2 - (startY + (float)(n * (9 + 3))) / 2.0f, 0.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        matrixStack.m_85836_();
        matrixStack.m_85841_(2.0f, 2.0f, 2.0f);
        for (int i = 0; i < this.getTextToDisplay().size(); ++i) {
            float f4 = (float)this.timer[i] - partialTicks;
            if (this.timer[i] > this.titleDisplayTime) {
                float f5 = (float)(this.titleFadeIn + this.titleDisplayTime) - f4;
                this.alpha[i] = (int)(f5 * 255.0f / (float)this.titleFadeIn);
            }
            if (this.timer[i] == -1) {
                this.alpha[i] = 255;
            }
            this.alpha[i] = Mth.m_14045_((int)this.alpha[i], (int)0, (int)255);
            if (this.alpha[i] <= 8) continue;
            int l1 = this.alpha[i] << 24 & 0xFF000000;
            int i2 = this.f_96547_.m_92895_(Utils.translateToLocal(this.getTextToDisplay().get(i), new Object[0]));
            Objects.requireNonNull(this.f_96547_);
            this.renderTextBackground(gui, (int)(startY + (float)(i * (9 + 3))), i2);
            Font font = Minecraft.m_91087_().f_91062_;
            String string = Utils.translateToLocal(this.getTextToDisplay().get(i), new Object[0]);
            float f3 = -i2 / 2;
            Objects.requireNonNull(this.f_96547_);
            gui.drawString(font, string, f3, startY + (float)(i * (9 + 3)), 0xFFFFFF | l1, true);
        }
        matrixStack.m_85849_();
        RenderSystem.disableBlend();
        matrixStack.m_85849_();
    }

    public boolean m_7933_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (32 == p_keyPressed_1_) {
            this.timer[this.currentTimer] = -1;
            if (this.currentTimer + 1 == this.timer.length) {
                this.ok.f_93624_ = true;
                this.ok.f_93623_ = true;
                this.cancel.f_93624_ = true;
                this.cancel.f_93623_ = true;
            } else {
                this.timer[this.currentTimer + 1] = this.titleDisplayTime + this.titleFadeIn;
                ++this.currentTimer;
            }
        }
        return super.m_7933_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    public void m_86600_() {
        for (int i = 0; i < this.timer.length; ++i) {
            if (this.timer[i] <= 0) continue;
            int n = i;
            this.timer[n] = this.timer[n] - 1;
            if (this.timer[i] > 0) continue;
            if (i != this.timer.length - 1) {
                this.timer[i] = -1;
                this.timer[i + 1] = this.titleDisplayTime + this.titleFadeIn;
                this.currentTimer = i + 1;
                continue;
            }
            this.ok.f_93624_ = true;
            this.ok.f_93623_ = true;
            this.cancel.f_93624_ = true;
            this.cancel.f_93623_ = true;
        }
        super.m_86600_();
    }

    static enum Action {
        OK,
        CANCEL;

    }
}

