/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.menu;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.client.ClientUtils;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuBackground;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuButton;
import online.kingdomkeys.kingdomkeys.client.gui.menu.abilities.MenuAbilitiesScreen;
import online.kingdomkeys.kingdomkeys.client.gui.menu.config.MenuConfigScreen;
import online.kingdomkeys.kingdomkeys.client.gui.menu.customize.MenuCustomizeScreen;
import online.kingdomkeys.kingdomkeys.client.gui.menu.items.MenuItemsScreen;
import online.kingdomkeys.kingdomkeys.client.gui.menu.journal.MenuJournalScreen;
import online.kingdomkeys.kingdomkeys.client.gui.menu.party.GuiMenu_Party_Leader;
import online.kingdomkeys.kingdomkeys.client.gui.menu.party.GuiMenu_Party_Member;
import online.kingdomkeys.kingdomkeys.client.gui.menu.party.GuiMenu_Party_None;
import online.kingdomkeys.kingdomkeys.client.gui.menu.status.MenuStatusScreen;
import online.kingdomkeys.kingdomkeys.client.gui.menu.styles.StylesMenu;
import online.kingdomkeys.kingdomkeys.lib.Party;
import online.kingdomkeys.kingdomkeys.util.Utils;
import org.jetbrains.annotations.NotNull;

public class MenuScreen
extends MenuBackground {
    MenuButton items;
    MenuButton abilities;
    MenuButton customize;
    MenuButton party;
    MenuButton status;
    MenuButton journal;
    MenuButton config;
    MenuButton style;
    final ResourceLocation texture = new ResourceLocation("kingdomkeys", "textures/gui/menu/menu_button.png");

    public MenuScreen() {
        super("gui.menu.main.title", new Color(0, 0, 255));
        this.f_96541_ = Minecraft.m_91087_();
    }

    protected void action(buttons buttonID) {
        switch (buttonID) {
            case ITEMS: {
                this.f_96541_.m_91152_((Screen)new MenuItemsScreen());
                break;
            }
            case ABILITIES: {
                this.f_96541_.m_91152_((Screen)new MenuAbilitiesScreen());
                break;
            }
            case PARTY: {
                Party p = ModCapabilities.getWorld((Level)this.f_96541_.f_91073_).getPartyFromMember(this.f_96541_.f_91074_.m_20148_());
                if (p == null) {
                    this.f_96541_.m_91152_((Screen)new GuiMenu_Party_None());
                    break;
                }
                boolean isLeader = false;
                for (Party.Member leader : p.getLeaders()) {
                    if (!leader.getUUID().equals(this.f_96541_.f_91074_.m_20148_())) continue;
                    isLeader = true;
                    break;
                }
                if (isLeader) {
                    this.f_96541_.m_91152_((Screen)new GuiMenu_Party_Leader());
                    break;
                }
                this.f_96541_.m_91152_((Screen)new GuiMenu_Party_Member());
                break;
            }
            case STATUS: {
                this.f_96541_.m_91152_((Screen)new MenuStatusScreen());
                break;
            }
            case CUSTOMIZE: {
                this.f_96541_.m_91152_((Screen)new MenuCustomizeScreen());
                break;
            }
            case JOURNAL: {
                this.f_96541_.m_91152_((Screen)new MenuJournalScreen());
                break;
            }
            case CONFIG: {
                this.f_96541_.m_91152_((Screen)new MenuConfigScreen());
                break;
            }
            case STYLES: {
                this.f_96541_.m_91152_((Screen)new StylesMenu());
            }
        }
        this.updateButtons();
    }

    @Override
    public void m_7856_() {
        this.f_96543_ = this.f_96543_;
        this.f_96544_ = this.f_96544_;
        super.m_7856_();
        float topBarHeight = (float)this.f_96544_ * 0.17f;
        int start = (int)topBarHeight + 5;
        int pos = 0;
        float buttonPosX = (float)this.f_96543_ * 0.03f;
        float buttonWidth = (float)this.f_96543_ * 0.1744f - 22.0f;
        this.items = new MenuButton((int)buttonPosX, start, (int)buttonWidth, "gui.menu.main.button.items", MenuButton.ButtonType.BUTTON, true, e -> this.action(buttons.ITEMS));
        this.m_142416_((GuiEventListener)this.items);
        this.abilities = new MenuButton((int)buttonPosX, start + 18 * ++pos, (int)buttonWidth, "gui.menu.main.button.abilities", MenuButton.ButtonType.BUTTON, true, e -> this.action(buttons.ABILITIES));
        this.m_142416_((GuiEventListener)this.abilities);
        this.customize = new MenuButton((int)buttonPosX, start + 18 * ++pos, (int)buttonWidth, "gui.menu.main.button.customize", MenuButton.ButtonType.BUTTON, true, e -> this.action(buttons.CUSTOMIZE));
        this.m_142416_((GuiEventListener)this.customize);
        this.party = new MenuButton((int)buttonPosX, start + 18 * ++pos, (int)buttonWidth, "gui.menu.main.button.party", MenuButton.ButtonType.BUTTON, true, e -> this.action(buttons.PARTY));
        this.m_142416_((GuiEventListener)this.party);
        this.status = new MenuButton((int)buttonPosX, start + 18 * ++pos, (int)buttonWidth, "gui.menu.main.button.status", MenuButton.ButtonType.BUTTON, true, e -> this.action(buttons.STATUS));
        this.m_142416_((GuiEventListener)this.status);
        this.journal = new MenuButton((int)buttonPosX, start + 18 * ++pos, (int)buttonWidth, "gui.menu.main.button.journal", MenuButton.ButtonType.BUTTON, true, e -> this.action(buttons.JOURNAL));
        this.m_142416_((GuiEventListener)this.journal);
        if (KingdomKeys.efmLoaded) {
            this.style = new MenuButton((int)buttonPosX, start + 18 * ++pos, (int)buttonWidth, "gui.menu.main.button.style", MenuButton.ButtonType.BUTTON, true, e -> this.action(buttons.STYLES));
            this.m_142416_((GuiEventListener)this.style);
        }
        this.config = new MenuButton((int)buttonPosX, start + 18 * ++pos, (int)buttonWidth, "gui.menu.main.button.config", MenuButton.ButtonType.BUTTON, true, e -> this.action(buttons.CONFIG));
        this.m_142416_((GuiEventListener)this.config);
        this.updateButtons();
    }

    private void updateButtons() {
        this.items.f_93624_ = true;
        this.abilities.f_93624_ = true;
        this.customize.f_93624_ = true;
        this.party.f_93624_ = true;
        this.status.f_93624_ = true;
        this.journal.f_93624_ = true;
        this.config.f_93624_ = true;
        if (KingdomKeys.efmLoaded) {
            this.style.f_93624_ = true;
        }
        this.customize.f_93623_ = true;
        this.journal.f_93623_ = true;
    }

    @Override
    public void m_88315_(@NotNull GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(gui, mouseX, mouseY, partialTicks);
        this.drawPlayer(gui);
    }

    public void drawPlayer(GuiGraphics gui) {
        PoseStack matrixStack = gui.m_280168_();
        float playerHeight = (float)this.f_96544_ * 0.45f;
        float playerPosX = (float)this.f_96543_ * 0.5229f;
        float playerPosY = (float)this.f_96544_ * 0.7f;
        IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)this.f_96541_.f_91074_);
        if (playerData != null) {
            int i;
            matrixStack.m_85836_();
            LocalPlayer player = this.f_96541_.f_91074_;
            ClientUtils.renderPlayerNoAnims(matrixStack, (int)playerPosX, (int)playerPosY, (int)playerHeight / 2, 0.0f, 0.0f, (LivingEntity)player);
            matrixStack.m_85849_();
            matrixStack.m_85836_();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            matrixStack.m_252880_(1.0f, 1.0f, 100.0f);
            RenderSystem.enableBlend();
            int infoBoxWidth = (int)((float)this.f_96543_ * 0.1385f - 14.0f);
            int infoBoxPosX = (int)((float)this.f_96543_ * 0.4354f);
            int infoBoxPosY = (int)((float)this.f_96544_ * 0.54f);
            gui.m_280218_(this.texture, infoBoxPosX, infoBoxPosY, 123, 67, 11, 22);
            for (i = 0; i < infoBoxWidth; ++i) {
                gui.m_280218_(this.texture, infoBoxPosX + 11 + i, infoBoxPosY, 135, 67, 1, 22);
            }
            gui.m_280218_(this.texture, infoBoxPosX + 11 + infoBoxWidth, infoBoxPosY, 137, 67, 3, 22);
            gui.m_280218_(this.texture, infoBoxPosX, infoBoxPosY + 22, 123, 90, 3, 35);
            for (i = 0; i < infoBoxWidth + 8; ++i) {
                gui.m_280218_(this.texture, infoBoxPosX + 3 + i, infoBoxPosY + 22, 127, 90, 1, 35);
            }
            gui.m_280218_(this.texture, infoBoxPosX + 3 + infoBoxWidth + 8, infoBoxPosY + 22, 129, 90, 3, 35);
            RenderSystem.disableBlend();
            matrixStack.m_85849_();
            matrixStack.m_85836_();
            matrixStack.m_252880_(2.0f, 2.0f, 100.0f);
            matrixStack.m_85836_();
            float f = infoBoxPosX + 8;
            Objects.requireNonNull(this.f_96541_.f_91062_);
            matrixStack.m_252880_(f, (float)(infoBoxPosY + (11 - 9 / 2)), 1.0f);
            gui.m_280488_(this.f_96541_.f_91062_, this.f_96541_.f_91074_.m_5446_().getString(), 0, 0, 0xFFFFFF);
            matrixStack.m_85849_();
            gui.m_280488_(this.f_96541_.f_91062_, Utils.translateToLocal("gui.menu.status.level", new Object[0]) + ": " + playerData.getLevel(), infoBoxPosX + 4, infoBoxPosY + 26, 16767232);
            Font font = this.f_96541_.f_91062_;
            String string = Utils.translateToLocal("gui.menu.status.hp", new Object[0]) + ": " + (int)this.f_96541_.f_91074_.m_21223_() + "/" + (int)this.f_96541_.f_91074_.m_21233_();
            Objects.requireNonNull(this.f_96541_.f_91062_);
            gui.m_280488_(font, string, infoBoxPosX + 4, infoBoxPosY + 26 + 9, 65280);
            Font font2 = this.f_96541_.f_91062_;
            String string2 = Utils.translateToLocal("gui.menu.status.mp", new Object[0]) + ": " + (int)playerData.getMP() + "/" + (int)playerData.getMaxMP();
            Objects.requireNonNull(this.f_96541_.f_91062_);
            gui.m_280488_(font2, string2, infoBoxPosX + 4, infoBoxPosY + 26 + 9 * 2, 0x4444FF);
            matrixStack.m_85849_();
        }
    }

    public static enum buttons {
        ITEMS,
        ABILITIES,
        CUSTOMIZE,
        PARTY,
        STATUS,
        JOURNAL,
        CONFIG,
        STYLES;

    }
}

